/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.dto.kexiao;

import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DashboadrKexiaoDtoHelper {
    public static int DEFAULT_LESSON_TIMES = 1;
    static DecimalFormat df = new DecimalFormat("0.00");

    public static String getLessonTimeStr(Date lessonStartTime, Date lessonEndTime, Date quitClassTime) {
        SimpleDateFormat sdf = null;
        if (quitClassTime != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm\n    (\u9000\u73ed\u65f6\u95f4)");
            return sdf.format(quitClassTime);
        }
        if (lessonStartTime != null && lessonEndTime != null) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            StringBuilder builder = new StringBuilder();
            builder.append(sdf.format(lessonStartTime));
            sdf = new SimpleDateFormat("HH:mm");
            builder.append(" ~ ").append(sdf.format(lessonEndTime));
            return builder.toString();
        }
        return null;
    }

    public static String getSigninStatusStr(Integer signinStatus, Date quitClassTime) {
        SignStatus signStatusEnum;
        if (quitClassTime != null) {
            return "\u9000\u73ed\u624b\u7eed\u8d39";
        }
        if (signinStatus != null && (signStatusEnum = SignStatus.getSignStatusByCode((Integer)signinStatus)) != null) {
            return signStatusEnum.getMessage();
        }
        return "\u672a\u7b7e\u5230";
    }

    public static String getCourseTypeStr(Integer courseType) {
        CourseTypeEnum courseTypeEnum;
        if (courseType != null && (courseTypeEnum = CourseTypeEnum.getByCode((int)courseType)) != null) {
            return courseTypeEnum.getMsg();
        }
        return null;
    }

    public static String getChargeTypeStr(Integer chargeType) {
        ChargeType chargeTypeEnum;
        if (chargeType != null && (chargeTypeEnum = ChargeType.getByCode((int)chargeType)) != null) {
            return chargeTypeEnum.getLabel();
        }
        return null;
    }

    public static String getChargeUnitStr(Integer chargeUnit) {
        ChargeUnit chargeUnitEnum;
        if (chargeUnit != null && (chargeUnitEnum = ChargeUnit.getByCode((int)chargeUnit)) != null) {
            return chargeUnitEnum.getDesc();
        }
        return null;
    }

    public static String getKexiaoRuleStr(Integer kexiaoRule) {
        CourseConsumeRuleEnum courseConsumeRuleEnum;
        if (kexiaoRule != null && (courseConsumeRuleEnum = CourseConsumeRuleEnum.getRuleByValue((Integer)kexiaoRule)) != null) {
            return courseConsumeRuleEnum.getDesc();
        }
        return CourseConsumeRuleEnum.TIME_0.getDesc();
    }

    public static Double DoubleFormat(Double value) {
        if (value == null) {
            return null;
        }
        BigDecimal bValue = new BigDecimal(value);
        return bValue.setScale(2, 4).doubleValue();
    }

    public static Double durationM2H(Long value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.longValue();
        return DashboadrKexiaoDtoHelper.twoDecimal(doubleValue /= 60.0);
    }

    public static Double durationM2H(Integer value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.intValue();
        return DashboadrKexiaoDtoHelper.twoDecimal(doubleValue /= 60.0);
    }

    public static Double moneyDividedBy100(Long value) {
        if (value == null) {
            return null;
        }
        double doubleValue = value.longValue();
        BigDecimal bValue = new BigDecimal(doubleValue /= 100.0);
        return bValue.setScale(2, 4).doubleValue();
    }

    public static Double twoDecimal(Double value) {
        BigDecimal bValue = new BigDecimal(value);
        return bValue.setScale(2, 4).doubleValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboadrKexiaoDtoHelper)) {
            return false;
        }
        DashboadrKexiaoDtoHelper other = (DashboadrKexiaoDtoHelper)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DashboadrKexiaoDtoHelper;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "DashboadrKexiaoDtoHelper()";
    }
}

