/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.classdetail.ClassDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.classdetail.ClassDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel.ClassDataDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel.StudentDataDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.excel.TeacherDataDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.ClassDetailParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.SignInStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.TeacherDetailParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.TeacherListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.param.TeacherSearchParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherdetail.TeacherDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherdetail.TeacherDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist.TeacherListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist.TeacherListStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiaov1.teacherlist.TeacherSearchDto;
import com.baijia.tianxiao.biz.dashboard.service.DashboardKeXiaoV1Service;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.storage.StorageUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardKeXiaoV1ServiceImpl
implements DashboardKeXiaoV1Service {
    private static final Logger log = LoggerFactory.getLogger(DashboardKeXiaoV1ServiceImpl.class);
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private StorageDao storageDao;

    static <T> List<T> getArrayList(T obj) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(obj);
        return list;
    }

    SignInStatisticsDto getSignInStatisticsDto(List<Long> lessonIds) {
        Integer originalSigninCount = this.orgStudentLessonDao.countLessonStudent(lessonIds);
        SignInStatisticsDto dto = new SignInStatisticsDto();
        if (originalSigninCount > 0) {
            Map signInStatusMap = this.orgLessonSignDao.mapKeyStatusValueCount(lessonIds, null);
            dto.setOriginalSigninCount(originalSigninCount);
            dto.setSigninCount(MapUtils.getInteger((Map)signInStatusMap, (Object)1, (Integer)0));
            dto.setAskForLeaveCount(MapUtils.getInteger((Map)signInStatusMap, (Object)2, (Integer)0));
            dto.setAbsenteeismcCount(MapUtils.getInteger((Map)signInStatusMap, (Object)3, (Integer)0));
            dto.setNotSigninCount(dto.getOriginalSigninCount() - dto.getSigninCount() - dto.getAskForLeaveCount() - dto.getAbsenteeismcCount());
        }
        return dto;
    }

    public List<Long> getOrgIds(Long loginerOrgId, Long selectedOrgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (selectedOrgId != null) {
            orgIds.add(selectedOrgId);
        } else {
            orgIds.add(loginerOrgId);
            List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(loginerOrgId.intValue()), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    orgIds.add(account.getOrgId().longValue());
                }
            }
        }
        return orgIds;
    }

    @Override
    public List<TeacherSearchDto> teacherSearch(TeacherSearchParamDto param) {
        Long orgId = param.getOrgId();
        Long selectedOrgId = param.getSelectedOrgId();
        String teacherName = param.getTeacherName();
        Integer size = param.getSize();
        ArrayList<TeacherSearchDto> result = new ArrayList<TeacherSearchDto>();
        if (StringUtils.isBlank((CharSequence)teacherName)) {
            return result;
        }
        List<Long> orgIds = this.getOrgIds(orgId, selectedOrgId);
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(size);
        List teacherIds = this.orgTeacherDao.listTeacherUserIds(orgIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds)) {
            List teachers = this.teacherDao.listTeacher(null, (Collection)teacherIds, teacherName, pageDto);
            TeacherSearchDto dto = null;
            if (CollectionUtils.isNotEmpty((Collection)teachers)) {
                for (Teacher teacher : teachers) {
                    dto = new TeacherSearchDto();
                    dto.setTeacherId(teacher.getUserId());
                    dto.setTeacherName(teacher.getRealName());
                    result.add(dto);
                }
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public TeacherListStatisticsDto getTeacherListStatisticsDto(TeacherListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Long selectedOrgId = param.getSelectedOrgId();
        String teacherName = param.getTeacherName();
        List<Long> orgIds = this.getOrgIds(orgId, selectedOrgId);
        Long kexiaoTotalMoney = 0L;
        Integer teacherCount = 0;
        ArrayList<Long> teacherIds = this.orgTeacherDao.listTeacherUserIds(orgIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds)) {
            if (StringUtils.isNotBlank((CharSequence)teacherName)) {
                List teachers = this.teacherDao.listTeacher(null, (Collection)teacherIds, teacherName, null);
                teacherIds = new ArrayList<Long>();
                for (Teacher teacher : teachers) {
                    teacherIds.add(teacher.getUserId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)teacherIds)) {
                Map teacherLessonsMap = this.orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime, (Collection)teacherIds);
                ArrayList lessonIds = new ArrayList();
                if (MapUtils.isNotEmpty((Map)teacherLessonsMap)) {
                    for (List values : teacherLessonsMap.values()) {
                        lessonIds.addAll(values);
                    }
                    kexiaoTotalMoney = this.orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds);
                }
            }
        }
        teacherCount = teacherIds.size();
        TeacherListStatisticsDto dto = new TeacherListStatisticsDto();
        dto.setKexiaoTotalMoney(kexiaoTotalMoney);
        if ((long)teacherCount.intValue() != 0L) {
            dto.setKexiaoTeacherAverageMoney(kexiaoTotalMoney / (long)teacherCount.intValue());
        } else {
            dto.setKexiaoTeacherAverageMoney(0L);
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeacherListDto> listTeacherListDto(TeacherListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Long selectedOrgId = param.getSelectedOrgId();
        String teacherName = param.getTeacherName();
        List<Long> orgIds = this.getOrgIds(orgId, selectedOrgId);
        ArrayList<Integer> orgIdsInt = new ArrayList<Integer>();
        for (Long obj : orgIds) {
            orgIdsInt.add(obj.intValue());
        }
        Integer count = 0;
        Map teacherMap = this.orgTeacherDao.mapKeyUserIdVauleTeacher(orgIds);
        Set teacherIds = teacherMap.keySet();
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            count = this.teacherDao.countTeacher(null, teacherIds, teacherName);
        }
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listTeacherListDto - return - teacherUserIds is empty");
            return new ArrayList<TeacherListDto>();
        }
        ArrayList<TeacherListDto> result = new ArrayList<TeacherListDto>();
        List teachers = this.teacherDao.listTeacher(null, teacherIds, teacherName, pageDto);
        HashMap<Long, Object> orgInfoMap = new HashMap<Long, Object>();
        List orgs = this.orgInfoDao.getOrgInfos(orgIdsInt, new String[0]);
        for (Object orgInfo : orgs) {
            orgInfoMap.put(orgInfo.getOrgId().longValue(), orgInfo);
        }
        ArrayList<Long> teacherUserIds = new ArrayList<Long>();
        for (Teacher teacher : teachers) {
            teacherUserIds.add(teacher.getUserId());
        }
        Map teacherLessonsMap = this.orgTeacherLessonDao.getTeacherLessonByStartTime(startTime, endTime, teacherUserIds);
        Map lessonIdVsSignCountMap = new HashMap();
        Map lessonMap = new HashMap();
        ArrayList allLessonIds = new ArrayList();
        for (List obj : teacherLessonsMap.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)obj)) continue;
            allLessonIds.addAll(obj);
        }
        if (CollectionUtils.isNotEmpty(allLessonIds)) {
            lessonIdVsSignCountMap = this.orgLessonSignDao.mapKeyLessonIdValueCount(allLessonIds);
            lessonMap = this.orgClassLessonDao.mapOrgClassLesson(allLessonIds);
        }
        for (Teacher teacher : teachers) {
            List lessonIds = (List)teacherLessonsMap.get(teacher.getUserId());
            Long teacherOrgId = ((OrgTeacher)teacherMap.get(teacher.getUserId())).getOrgId();
            TeacherListDto dto = new TeacherListDto();
            dto.setTeacherId(teacher.getUserId());
            dto.setTeacherName(teacher.getRealName());
            dto.setOrgName(((OrgInfo)orgInfoMap.get(teacherOrgId)).getShortName());
            dto.setMobile(((OrgTeacher)teacherMap.get(teacher.getUserId())).getMobile());
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                dto.setKexiaoMoney(0L);
                dto.setClassCount(0);
                dto.setLessonTimes(0);
                dto.setLessonMinute(0L);
                dto.setOriginalSigninCount(0);
                dto.setSigninCount(0);
                dto.setAskForLeaveCount(0);
                dto.setAbsenteeismcCount(0);
                dto.setNotSigninCount(0);
            } else {
                HashSet<Long> classIds = new HashSet<Long>();
                Long lessonMinute = 0L;
                Integer lessonTimes = 0;
                OrgClassLesson lesson = null;
                for (Long lessonId : lessonIds) {
                    lesson = (OrgClassLesson)lessonMap.get(lessonId);
                    classIds.add(lesson.getCourseId());
                    if (lessonIdVsSignCountMap.get((long)lesson.getId()) == null) continue;
                    lessonMinute = lessonMinute + lesson.getDurationMinute();
                    Integer n = lessonTimes;
                    Integer n2 = lessonTimes = Integer.valueOf(lessonTimes + 1);
                }
                dto.setKexiaoMoney(this.orgStudentKexiaoRecordDao.sumAmountByLesson((Collection)lessonIds));
                dto.setClassCount(classIds.size());
                dto.setLessonTimes(lessonTimes);
                dto.setLessonMinute(lessonMinute);
                SignInStatisticsDto signInStatisticsDto = this.getSignInStatisticsDto(lessonIds);
                dto.setOriginalSigninCount(signInStatisticsDto.getOriginalSigninCount());
                dto.setSigninCount(signInStatisticsDto.getSigninCount());
                dto.setAskForLeaveCount(signInStatisticsDto.getAskForLeaveCount());
                dto.setAbsenteeismcCount(signInStatisticsDto.getAbsenteeismcCount());
                dto.setNotSigninCount(signInStatisticsDto.getNotSigninCount());
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public TeacherDetailStatisticsDto getTeacherDetailStatisticsDto(TeacherDetailParamDto param) {
        Long teacherId = param.getTeacherId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Teacher teacher = this.teacherDao.getByUserId(teacherId, new String[0]);
        OrgTeacher orgTeacher = this.orgTeacherDao.getByUserId(teacherId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgTeacher.getOrgId().intValue()), new String[0]);
        Long kexiaoTotalMoney = 0L;
        Long lessonMinute = 0L;
        Integer lessonTimes = 0;
        List lessonIds = this.orgTeacherLessonDao.getTeacherLessonIdsByStartTime(startTime, endTime, teacher.getUserId());
        ArrayList<Long> lessonIdsFiltrate = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            Map lessonIdVsSignInCountMap = this.orgLessonSignDao.mapKeyLessonIdValueCount((Collection)lessonIds);
            for (Long lessonId : lessonIds) {
                if (lessonIdVsSignInCountMap.get(lessonId) == null) continue;
                lessonIdsFiltrate.add(lessonId);
            }
        }
        if (CollectionUtils.isNotEmpty(lessonIdsFiltrate)) {
            kexiaoTotalMoney = this.orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIdsFiltrate);
            lessonMinute = this.orgClassLessonDao.sumLessonDuration(lessonIdsFiltrate) / 60L;
            lessonTimes = lessonIdsFiltrate.size();
        }
        Storage storage = (Storage)this.storageDao.getById((Serializable)teacher.getAvatar(), new String[0]);
        String avatarUrl = null;
        if (storage != null) {
            avatarUrl = StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn());
        }
        TeacherDetailStatisticsDto result = new TeacherDetailStatisticsDto();
        result.setHeadImgUrl(avatarUrl);
        result.setTeacherName(teacher.getRealName());
        result.setGender(teacher.getSex());
        result.setOrgName(orgInfo.getShortName());
        result.setKexiaoTotalMoney(kexiaoTotalMoney);
        result.setLessonTimes(lessonTimes);
        result.setLessonMinute(lessonMinute);
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeacherDetailListDto> listTeacherDetailListDto(TeacherDetailParamDto param, PageDto pageDto) {
        Long teacherId = param.getTeacherId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Integer count = this.orgTeacherLessonDao.countClassId(startTime, endTime, teacherId);
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listTeacherDetailListDto - return - classIds is empty");
            return new ArrayList<TeacherDetailListDto>();
        }
        ArrayList<TeacherDetailListDto> result = new ArrayList<TeacherDetailListDto>();
        List classIds = this.orgTeacherLessonDao.listClassId(startTime, endTime, teacherId, pageDto);
        List allLessonIds = this.orgTeacherLessonDao.getTeacherLessonIdsByStartTime(startTime, endTime, teacherId);
        Map classMap = this.orgCourseDao.getOrgCourseMap((Collection)classIds, new String[0]);
        for (Long classId : classIds) {
            TeacherDetailListDto dto = new TeacherDetailListDto();
            dto.setClassId(classId);
            dto.setClassName(((OrgCourse)classMap.get(classId)).getName());
            List lessons = null;
            if (CollectionUtils.isNotEmpty((Collection)allLessonIds)) {
                lessons = this.orgClassLessonDao.queryBy(startTime, endTime, classId, (Collection)allLessonIds);
            }
            if (CollectionUtils.isEmpty(lessons)) {
                dto.setKexiaoMoney(0L);
                dto.setLessonTimes(0);
                dto.setLessonMinute(0L);
                dto.setOriginalSigninCount(0);
                dto.setSigninCount(0);
                dto.setAskForLeaveCount(0);
                dto.setAbsenteeismcCount(0);
                dto.setNotSigninCount(0);
                continue;
            }
            ArrayList<Long> lessonIds = new ArrayList<Long>();
            for (OrgClassLesson lesson : lessons) {
                lessonIds.add(lesson.getId());
            }
            Map lessonIdVsSignCountMap = this.orgLessonSignDao.mapKeyLessonIdValueCount(lessonIds);
            Long lessonMinute = 0L;
            Integer lessonTimes = 0;
            for (OrgClassLesson lesson : lessons) {
                if (lessonIdVsSignCountMap.get(lesson.getId()) == null) continue;
                lessonMinute = lessonMinute + lesson.getDurationMinute();
                Integer n = lessonTimes;
                Integer n2 = lessonTimes = Integer.valueOf(lessonTimes + 1);
            }
            dto.setKexiaoMoney(this.orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds));
            dto.setLessonTimes(lessonTimes);
            dto.setLessonMinute(lessonMinute);
            SignInStatisticsDto signInStatisticsDto = this.getSignInStatisticsDto(lessonIds);
            dto.setOriginalSigninCount(signInStatisticsDto.getOriginalSigninCount());
            dto.setSigninCount(signInStatisticsDto.getSigninCount());
            dto.setAskForLeaveCount(signInStatisticsDto.getAskForLeaveCount());
            dto.setAbsenteeismcCount(signInStatisticsDto.getAbsenteeismcCount());
            dto.setNotSigninCount(signInStatisticsDto.getNotSigninCount());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public ClassDetailStatisticsDto getClassDetailStatisticsDto(ClassDetailParamDto param) {
        Long classId = param.getClassId();
        Long teacherId = param.getTeacherId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        List<Long> lessonIds = new ArrayList<Long>();
        List lessons = this.orgClassLessonDao.queryBy(startTime, endTime, classId, null);
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            for (OrgClassLesson lesson : lessons) {
                lessonIds.add(lesson.getId());
            }
            lessonIds = this.orgTeacherLessonDao.listLessonId(lessonIds, teacherId);
        }
        Long kexiaoTotalMoney = 0L;
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            kexiaoTotalMoney = this.orgStudentKexiaoRecordDao.sumAmountByLesson(lessonIds);
        }
        ClassDetailStatisticsDto result = new ClassDetailStatisticsDto();
        result.setKexiaoTotalMoney(kexiaoTotalMoney);
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<ClassDetailListDto> listCLassDetailListDto(ClassDetailParamDto param, PageDto pageDto) {
        Long classId = param.getClassId();
        Long teacherId = param.getTeacherId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Integer count = this.orgStudentCourseDao.countStudents(null, classId, null);
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listCLassDetailListDto - return - students is empty");
            return new ArrayList<ClassDetailListDto>();
        }
        ArrayList<ClassDetailListDto> result = new ArrayList<ClassDetailListDto>();
        log.info("#######################0   classId:" + classId);
        List studentsUserIds = this.orgStudentCourseDao.listStudentUserIdsByCourseIds(null, classId);
        log.info("#######################1   studentsUserIds:" + studentsUserIds);
        if (CollectionUtils.isEmpty((Collection)studentsUserIds)) {
            log.info("listCLassDetailListDto - return - students is empty");
            return new ArrayList<ClassDetailListDto>();
        }
        List studentCourseList = this.orgStudentCourseDao.listOrderByName(classId, (Collection)studentsUserIds, pageDto);
        log.info(studentCourseList.size() + " #######################2   studentCourseList:" + studentCourseList);
        ArrayList teacherLessons = new ArrayList();
        List classLessons = this.orgClassLessonDao.queryBy(startTime, endTime, classId, null);
        HashMap<Long, OrgClassLesson> classLessonMap = new HashMap<Long, OrgClassLesson>();
        List lessonIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)classLessons)) {
            for (OrgClassLesson classLesson : classLessons) {
                lessonIds.add(classLesson.getId());
                classLessonMap.put(classLesson.getId(), classLesson);
            }
            if (CollectionUtils.isNotEmpty(lessonIds = this.orgTeacherLessonDao.listLessonId(lessonIds, teacherId))) {
                for (Object lessonId : lessonIds) {
                    teacherLessons.add(classLessonMap.get(lessonId));
                }
            }
        }
        ArrayList<Long> studentUserIds = new ArrayList<Long>();
        for (OrgStudentCourse studentCourse : studentCourseList) {
            studentUserIds.add(studentCourse.getUserId());
        }
        Map stuLessonCountMap = this.orgStudentLessonDao.mapStuLessonCount(lessonIds, studentUserIds);
        Map kexiaoAmountMap = this.orgStudentKexiaoRecordDao.sumAmountBy(lessonIds, studentUserIds);
        Map courseStuSignStatusMap = this.orgLessonSignDao.mapStudentSignStatus(lessonIds);
        Map stuSignStatusMap = (Map)courseStuSignStatusMap.get(classId);
        for (OrgStudentCourse studentCourse : studentCourseList) {
            Map signInStatusMap = MapUtils.getMap((Map)stuSignStatusMap, (Object)studentCourse.getUserId());
            Long kexiaoMoney = (Long)kexiaoAmountMap.get(studentCourse.getUserId());
            if (kexiaoMoney == null) {
                kexiaoMoney = 0L;
            }
            ClassDetailListDto dto = new ClassDetailListDto();
            dto.setStudentId(studentCourse.getUserId());
            dto.setStudentName(studentCourse.getStudentName());
            dto.setKexiaoMoney(kexiaoMoney);
            dto.setOriginalSigninCount(MapUtils.getInteger((Map)stuLessonCountMap, (Object)studentCourse.getUserId(), (Integer)0));
            dto.setSigninCount(MapUtils.getInteger((Map)signInStatusMap, (Object)1, (Integer)0));
            dto.setAskForLeaveCount(MapUtils.getInteger((Map)signInStatusMap, (Object)2, (Integer)0));
            dto.setAbsenteeismcCount(MapUtils.getInteger((Map)signInStatusMap, (Object)3, (Integer)0));
            dto.setNotSigninCount(dto.getOriginalSigninCount() - dto.getSigninCount() - dto.getAskForLeaveCount() - dto.getAbsenteeismcCount());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public void downloadExcel(TeacherListParamDto param, OutputStream os) {
        List<TeacherDataDto> teacherDataDtoList = this.getExcelData(param);
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("excel/dashboard_kexiao_v1.xlsx");
        try {
            Integer rowStartIndex;
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);
            int rowIndex = 1;
            XSSFCellStyle cellStyle = sheet.getRow(rowIndex).getCell(0).getCellStyle();
            for (TeacherDataDto teacherDataDto : teacherDataDtoList) {
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowIndex, (int)0, (CellStyle)cellStyle, (String)teacherDataDto.getTeacherName());
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowIndex, (int)1, (CellStyle)cellStyle, (String)teacherDataDto.getMobile());
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowIndex, (int)2, (CellStyle)cellStyle, (String)teacherDataDto.getOrgName());
                ExcelUtils.fillTheXSSFCellWithDoubleValue((XSSFSheet)sheet, (int)rowIndex, (int)3, (CellStyle)cellStyle, (Double)teacherDataDto.getKexiaoMoney());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)4, (CellStyle)cellStyle, (Integer)teacherDataDto.getClassCount());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)5, (CellStyle)cellStyle, (Integer)teacherDataDto.getLessonTimes());
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowIndex, (int)6, (CellStyle)cellStyle, (String)teacherDataDto.getLessonDurationStr());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)7, (CellStyle)cellStyle, (Integer)teacherDataDto.getOriginalSigninCount());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)8, (CellStyle)cellStyle, (Integer)teacherDataDto.getSigninCount());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)9, (CellStyle)cellStyle, (Integer)teacherDataDto.getAskForLeaveCount());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)10, (CellStyle)cellStyle, (Integer)teacherDataDto.getAbsenteeismcCount());
                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)rowIndex, (int)11, (CellStyle)cellStyle, (Integer)teacherDataDto.getNotSigninCount());
                ++rowIndex;
            }
            sheet = workbook.getSheetAt(1);
            Integer rowEndIndex = rowStartIndex = Integer.valueOf(1);
            Integer classDataRowStartIndex = rowStartIndex;
            Integer classDataRowEndIndex = rowStartIndex;
            Integer studentDataRowStartIndex = rowStartIndex;
            for (TeacherDataDto teacherDataDto : teacherDataDtoList) {
                rowEndIndex = rowStartIndex + (teacherDataDto.getRowSize() > 0 ? teacherDataDto.getRowSize() - 1 : 0);
                if (teacherDataDto.getRowSize() > 1) {
                    sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(rowStartIndex.intValue(), rowEndIndex.intValue(), 0, 0));
                    sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(rowStartIndex.intValue(), rowEndIndex.intValue(), 1, 1));
                    sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(rowStartIndex.intValue(), rowEndIndex.intValue(), 2, 2));
                    sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(rowStartIndex.intValue(), rowEndIndex.intValue(), 3, 3));
                }
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowStartIndex, (int)0, (CellStyle)cellStyle, (String)teacherDataDto.getTeacherName());
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowStartIndex, (int)1, (CellStyle)cellStyle, (String)teacherDataDto.getMobile());
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowStartIndex, (int)2, (CellStyle)cellStyle, (String)teacherDataDto.getOrgName());
                ExcelUtils.fillTheXSSFCellWithDoubleValue((XSSFSheet)sheet, (int)rowStartIndex, (int)3, (CellStyle)cellStyle, (Double)teacherDataDto.getKexiaoMoney());
                List<ClassDataDto> classDataDtoList = teacherDataDto.getClassDataDtoList();
                if (CollectionUtils.isNotEmpty(classDataDtoList)) {
                    for (ClassDataDto classDataDto : classDataDtoList) {
                        classDataRowEndIndex = classDataRowStartIndex + (classDataDto.getRowSize() > 0 ? classDataDto.getRowSize() - 1 : 0);
                        if (classDataDto.getRowSize() > 1) {
                            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(classDataRowStartIndex.intValue(), classDataRowEndIndex.intValue(), 4, 4));
                            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(classDataRowStartIndex.intValue(), classDataRowEndIndex.intValue(), 5, 5));
                            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(classDataRowStartIndex.intValue(), classDataRowEndIndex.intValue(), 6, 6));
                            sheet.addMergedRegion((org.apache.poi.ss.util.CellRangeAddress)new CellRangeAddress(classDataRowStartIndex.intValue(), classDataRowEndIndex.intValue(), 7, 7));
                        }
                        ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)classDataRowStartIndex, (int)4, (CellStyle)cellStyle, (String)classDataDto.getClassName());
                        ExcelUtils.fillTheXSSFCellWithDoubleValue((XSSFSheet)sheet, (int)classDataRowStartIndex, (int)5, (CellStyle)cellStyle, (Double)classDataDto.getKexiaoMoney());
                        ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)classDataRowStartIndex, (int)6, (CellStyle)cellStyle, (Integer)classDataDto.getLessonTimes());
                        ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)classDataRowStartIndex, (int)7, (CellStyle)cellStyle, (String)classDataDto.getLessonDurationStr());
                        List<StudentDataDto> studentDataDtoList = classDataDto.getStudentDataDtoList();
                        if (CollectionUtils.isNotEmpty(studentDataDtoList)) {
                            for (StudentDataDto studentDataDto : studentDataDtoList) {
                                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)8, (CellStyle)cellStyle, (String)studentDataDto.getStudentName());
                                ExcelUtils.fillTheXSSFCellWithDoubleValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)9, (CellStyle)cellStyle, (Double)studentDataDto.getKexiaoMoney());
                                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)10, (CellStyle)cellStyle, (Integer)studentDataDto.getOriginalSigninCount());
                                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)11, (CellStyle)cellStyle, (Integer)studentDataDto.getSigninCount());
                                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)12, (CellStyle)cellStyle, (Integer)studentDataDto.getAskForLeaveCount());
                                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)13, (CellStyle)cellStyle, (Integer)studentDataDto.getAbsenteeismcCount());
                                ExcelUtils.fillTheXSSFCellWithIntValue((XSSFSheet)sheet, (int)studentDataRowStartIndex, (int)14, (CellStyle)cellStyle, (Integer)studentDataDto.getNotSigninCount());
                                studentDataRowStartIndex = studentDataRowStartIndex + 1;
                            }
                        }
                        classDataRowStartIndex = classDataRowEndIndex + 1;
                    }
                }
                classDataRowStartIndex = rowStartIndex = Integer.valueOf(rowEndIndex + 1);
                studentDataRowStartIndex = rowStartIndex;
            }
            workbook.write(os);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    List<TeacherDataDto> getExcelData(TeacherListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Long selectedOrgId = param.getSelectedOrgId();
        Long teacherId = param.getTeacherId();
        String teacherName = param.getTeacherName();
        ArrayList<TeacherDataDto> teacherDataDtoList = new ArrayList<TeacherDataDto>();
        List<Long> orgIds = this.getOrgIds(orgId, selectedOrgId);
        List<Long> teacherIds = new ArrayList<Long>();
        List teachers = null;
        if (teacherId != null) {
            teacherIds.add(teacherId);
        } else {
            teacherIds = this.orgTeacherDao.listTeacherUserIds(orgIds);
            if (CollectionUtils.isNotEmpty(teacherIds) && StringUtils.isNotBlank((CharSequence)teacherName)) {
                teachers = this.teacherDao.listTeacher(null, teacherIds, teacherName, null);
                teacherIds = new ArrayList();
                for (Teacher teacher : teachers) {
                    teacherIds.add(teacher.getUserId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            Map teacherCourseMap = this.orgTeacherLessonDao.getTeacherCourseLessonBy(startTime, endTime, teacherIds);
            Map courseTeacherCountMap = this.orgTeacherLessonDao.mapDisticntTeacherCountByCourse(startTime, endTime, teacherIds);
            Map orgTeacherMap = this.orgTeacherDao.mapKeyUserIdVauleTeacher(orgIds);
            if (teacherCourseMap.size() > 0) {
                if (teachers == null) {
                    teachers = this.teacherDao.listTeacher(null, teacherIds, null, null);
                }
                ArrayList<Integer> orgIdsInt = new ArrayList<Integer>();
                for (Long orgIdLong : orgIds) {
                    orgIdsInt.add(orgIdLong.intValue());
                }
                Map orgInfoMap = this.orgInfoDao.getOrgInfoMap(orgIdsInt, new String[0]);
                ArrayList courseIds = new ArrayList();
                ArrayList lessonIds = new ArrayList();
                Map courseLessonMap = null;
                for (Long teacherUserId : teacherCourseMap.keySet()) {
                    courseLessonMap = (Map)teacherCourseMap.get(teacherUserId);
                    courseIds.addAll(courseLessonMap.keySet());
                    for (List courseLessonIds : courseLessonMap.values()) {
                        lessonIds.addAll(courseLessonIds);
                    }
                }
                Map orgCourses = this.orgCourseDao.getOrgCourseMap(courseIds, new String[0]);
                Map courseStuUserIdMap = this.orgStudentCourseDao.mapCourseIdStuList(courseIds);
                Map studentMap = new HashMap();
                if (MapUtils.isNotEmpty((Map)courseStuUserIdMap)) {
                    ArrayList studentIdsList = new ArrayList();
                    for (List list : courseStuUserIdMap.values()) {
                        if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                        studentIdsList.addAll(list);
                    }
                    if (CollectionUtils.isNotEmpty(studentIdsList)) {
                        studentMap = this.orgStudentDao.getStudentMap(studentIdsList, null, new String[0]);
                    }
                }
                Map courseStuLessonCountMap = this.orgStudentLessonDao.mapCourseStuLessonCount(lessonIds);
                Map lessonIdVsSignCountMap = this.orgLessonSignDao.mapKeyLessonIdValueCount(lessonIds);
                Map courseStuKexiao = this.orgStudentKexiaoRecordDao.mapCourseStudentAmountBy(lessonIds);
                Map courseStuSignStatusMap = this.orgLessonSignDao.mapStudentSignStatus(lessonIds);
                Map lessonMap = this.orgClassLessonDao.mapOrgClassLesson(lessonIds);
                for (Teacher teacher : teachers) {
                    OrgTeacher orgTeacher = (OrgTeacher)orgTeacherMap.get(teacher.getUserId());
                    TeacherDataDto teacherDataDto = new TeacherDataDto();
                    teacherDataDto.setTeacherId(teacher.getUserId());
                    teacherDataDto.setTeacherName(teacher.getRealName());
                    teacherDataDto.setMobile(orgTeacher.getMobile());
                    teacherDataDto.setOrgName(((OrgInfo)orgInfoMap.get(orgTeacher.getOrgId().intValue())).getShortName());
                    teacherDataDto.setKexiaoMoney(0L);
                    teacherDataDto.setLessonTimes(0);
                    teacherDataDto.setLessonMinute(0L);
                    teacherDataDto.setClassCount(0);
                    teacherDataDto.setOriginalSigninCount(0);
                    teacherDataDto.setSigninCount(0);
                    teacherDataDto.setAskForLeaveCount(0);
                    teacherDataDto.setAbsenteeismcCount(0);
                    teacherDataDto.setNotSigninCount(0);
                    teacherDataDtoList.add(teacherDataDto);
                    courseLessonMap = (Map)teacherCourseMap.get(teacher.getUserId());
                    if (!MapUtils.isNotEmpty((Map)courseLessonMap)) continue;
                    teacherDataDto.setClassCount(courseLessonMap.size());
                    ArrayList<ClassDataDto> classDataDtoList = new ArrayList<ClassDataDto>();
                    for (Long courseId : courseLessonMap.keySet()) {
                        Long lessonMinute = 0L;
                        Integer lessonTimes = 0;
                        courseLessonMap = (Map)teacherCourseMap.get(teacher.getUserId());
                        List courseLessonIds = (List)courseLessonMap.get(courseId);
                        Map courseStuSignStatusMapTemp = courseStuSignStatusMap;
                        Map courseStuLessonCountMapTemp = courseStuLessonCountMap;
                        Map lessonIdVsSignCountMapTemp = lessonIdVsSignCountMap;
                        Map courseStuKexiaoTemp = courseStuKexiao;
                        if ((Integer)courseTeacherCountMap.get((long)courseId) > 1) {
                            courseStuSignStatusMapTemp = this.orgLessonSignDao.mapStudentSignStatus((Collection)courseLessonIds);
                            courseStuLessonCountMapTemp = this.orgStudentLessonDao.mapCourseStuLessonCount((Collection)courseLessonIds);
                            lessonIdVsSignCountMapTemp = this.orgLessonSignDao.mapKeyLessonIdValueCount((Collection)courseLessonIds);
                            courseStuKexiaoTemp = this.orgStudentKexiaoRecordDao.mapCourseStudentAmountBy((Collection)courseLessonIds);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)courseLessonIds)) {
                            for (Long lessonId : courseLessonIds) {
                                OrgClassLesson lesson = (OrgClassLesson)lessonMap.get((long)lessonId);
                                if (lessonIdVsSignCountMapTemp.get((long)lesson.getId()) == null) continue;
                                lessonMinute = lessonMinute + lesson.getDurationMinute();
                                Integer n = lessonTimes;
                                Integer n2 = lessonTimes = Integer.valueOf(lessonTimes + 1);
                            }
                        }
                        ClassDataDto classDataDto = new ClassDataDto();
                        classDataDto.setClassId(courseId);
                        classDataDto.setClassName(((OrgCourse)orgCourses.get(courseId)).getName());
                        classDataDto.setKexiaoMoney(0L);
                        classDataDto.setLessonTimes(lessonTimes);
                        classDataDto.setLessonMinute(lessonMinute);
                        teacherDataDto.setLessonTimes(teacherDataDto.getLessonTimes() + classDataDto.getLessonTimes());
                        teacherDataDto.setLessonMinute(teacherDataDto.getLessonMinute() + classDataDto.getLessonMinute());
                        List courseStudentList = (List)courseStuUserIdMap.get(courseId);
                        ArrayList<StudentDataDto> studentDataDtoList = new ArrayList<StudentDataDto>();
                        if (CollectionUtils.isNotEmpty((Collection)courseStudentList)) {
                            for (Long courseStuUserId : courseStudentList) {
                                Map stuKexiaoMap = (Map)courseStuKexiaoTemp.get(courseId);
                                Map stuLessonCountMap = (Map)courseStuLessonCountMapTemp.get(courseId);
                                Map signStatusMap = null;
                                if (courseStuSignStatusMapTemp.get(courseId) != null) {
                                    signStatusMap = (Map)((Map)courseStuSignStatusMapTemp.get(courseId)).get(courseStuUserId);
                                }
                                StudentDataDto studentDataDto = new StudentDataDto();
                                studentDataDto.setStudentId(courseStuUserId);
                                studentDataDto.setStudentName(((OrgStudent)studentMap.get((long)courseStuUserId)).getName());
                                studentDataDto.setKexiaoMoney(MapUtils.getLong((Map)stuKexiaoMap, (Object)courseStuUserId, (Long)0L));
                                studentDataDto.setOriginalSigninCount(MapUtils.getInteger((Map)stuLessonCountMap, (Object)courseStuUserId, (Integer)0));
                                studentDataDto.setSigninCount(MapUtils.getInteger((Map)signStatusMap, (Object)1, (Integer)0));
                                studentDataDto.setAskForLeaveCount(MapUtils.getInteger((Map)signStatusMap, (Object)2, (Integer)0));
                                studentDataDto.setAbsenteeismcCount(MapUtils.getInteger((Map)signStatusMap, (Object)3, (Integer)0));
                                studentDataDto.setNotSigninCount(studentDataDto.getOriginalSigninCount() - studentDataDto.getSigninCount() - studentDataDto.getAskForLeaveCount() - studentDataDto.getAbsenteeismcCount());
                                studentDataDtoList.add(studentDataDto);
                                classDataDto.setKexiaoMoney(classDataDto.getKexiaoMoneyLong() + studentDataDto.getKexiaoMoneyLong());
                                classDataDto.setRowSize(classDataDto.getRowSize() + 1);
                                teacherDataDto.setKexiaoMoney(teacherDataDto.getKexiaoMoneyLong() + studentDataDto.getKexiaoMoneyLong());
                                teacherDataDto.setOriginalSigninCount(teacherDataDto.getOriginalSigninCount() + studentDataDto.getOriginalSigninCount());
                                teacherDataDto.setSigninCount(teacherDataDto.getSigninCount() + studentDataDto.getSigninCount());
                                teacherDataDto.setAskForLeaveCount(teacherDataDto.getAskForLeaveCount() + studentDataDto.getAskForLeaveCount());
                                teacherDataDto.setAbsenteeismcCount(teacherDataDto.getAbsenteeismcCount() + studentDataDto.getAbsenteeismcCount());
                                teacherDataDto.setNotSigninCount(teacherDataDto.getNotSigninCount() + studentDataDto.getNotSigninCount());
                                teacherDataDto.setRowSize(teacherDataDto.getRowSize() + 1);
                            }
                        }
                        classDataDto.setStudentDataDtoList(studentDataDtoList);
                        classDataDtoList.add(classDataDto);
                    }
                    teacherDataDto.setClassDataDtoList(classDataDtoList);
                }
            }
        }
        return teacherDataDtoList;
    }
}

