/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.dto.kexiao.DashboadrKexiaoDtoHelper;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.AllOrgStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.allorg.MainStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.classdetail.ClassDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailClassListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailKexiaoListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.orgdetail.OrgDetailStudentListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.AllOrgListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.ClassDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailClassListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailKexiaoListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.OrgDetailStudentListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.param.StudentDetailListParamDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailListDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.studentdetail.StudentDetailStatisticsDto;
import com.baijia.tianxiao.biz.dashboard.dto.kexiao.temp.RemainingDataDto;
import com.baijia.tianxiao.biz.dashboard.service.DashboardKeXiaoService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dto.ChargeUnitStatisticDto;
import com.baijia.tianxiao.dal.org.dto.KexiaoSumDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentKexiaoRecord;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DashboardKeXiaoServiceImpl
implements DashboardKeXiaoService {
    private static final Logger log = LoggerFactory.getLogger(DashboardKeXiaoServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCourseConsumeRuleDao courseConsumeRuleDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgSignupRefundDao orgSignupRefundDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private OrgSignupCourseLessonDao orgSignupCourseLessonDao;

    static <T> List<T> getArrayList(T obj) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(obj);
        return list;
    }

    @Override
    public MainStatisticsDto getMainStatisticsDto(Long mainOrgId) {
        MainStatisticsDto dto = new MainStatisticsDto();
        Date weekStart = DateUtil.getStartOfWeek();
        Date weekEnd = DateUtil.getEndOfWeek();
        Date monthStart = DateUtil.getStartOfMonth();
        Date monthEnd = DateUtil.getEndOfMonth();
        AllOrgListParamDto weekParam = new AllOrgListParamDto();
        weekParam.setMainOrgId(mainOrgId);
        weekParam.setStartDate(weekStart.getTime());
        weekParam.setEndDate(weekEnd.getTime());
        AllOrgListParamDto monthParam = new AllOrgListParamDto();
        monthParam.setMainOrgId(mainOrgId);
        monthParam.setStartDate(monthStart.getTime());
        monthParam.setEndDate(monthEnd.getTime());
        AllOrgListDto weekDto = this.getAllOrgListTotal(weekParam);
        AllOrgListDto monthDto = this.getAllOrgListTotal(monthParam);
        if (weekDto != null && weekDto.getTotalKexiaoMoney() != null) {
            dto.setWeekKexiaoMoney(weekDto.getTotalKexiaoMoneyLong());
        } else {
            dto.setWeekKexiaoMoney(0L);
        }
        if (monthDto != null && monthDto.getTotalKexiaoMoney() != null) {
            dto.setMonthKexiaoMoney(monthDto.getTotalKexiaoMoneyLong());
        } else {
            dto.setMonthKexiaoMoney(0L);
        }
        return dto;
    }

    @Override
    public AllOrgStatisticsDto getAllOrgStatisticsDto(Long mainOrgId) {
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime((Date)startTime, (int)1);
        AllOrgStatisticsDto dto = new AllOrgStatisticsDto();
        Double todayKexiaoHour = 0.0;
        Long todayKexiaoHourMoney = 0L;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long todayQuitClassMoney = 0L;
        AllOrgListParamDto param = new AllOrgListParamDto();
        param.setMainOrgId(mainOrgId);
        Map<Long, OrgInfo> orgMapKeyOrgId = this.orgListSearch(param, false);
        Set<Long> orgIds = orgMapKeyOrgId.keySet();
        todayQuitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
        Map kexiaoDataMapKeyChargeUnit = this.orgStudentKexiaoRecordDao.mapOrgKexiaoListDtoData(orgIds, startTime, endTime);
        ChargeUnitStatisticDto data = null;
        data = (ChargeUnitStatisticDto)kexiaoDataMapKeyChargeUnit.get(ChargeUnit.BY_TIMES.getCode());
        if (data != null) {
            todayKexiaoTimes = data.getLineCount();
            todayKexiaoTimesMoney = data.getAmount();
        }
        if ((data = (ChargeUnitStatisticDto)kexiaoDataMapKeyChargeUnit.get(ChargeUnit.BY_HOUR.getCode())) != null) {
            todayKexiaoHour = data.getLessonDurationHour();
            todayKexiaoHourMoney = data.getAmount();
        }
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + (todayKexiaoTimesMoney + todayKexiaoHourMoney + todayQuitClassMoney);
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(todayQuitClassMoney);
        return dto;
    }

    @Override
    public List<AllOrgListDto> listAllOrgListDto(AllOrgListParamDto param, PageDto pageDto) {
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Map<Long, OrgInfo> orgMap = this.orgListSearch(param, true);
        Integer count = orgMap.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listAllOrgListDto - return - orgmap is empty");
            return new ArrayList<AllOrgListDto>();
        }
        Set<Long> orgIds = orgMap.keySet();
        if (pageDto != null) {
            HashSet<Long> orgIdsTemp = new HashSet<Long>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize();
            for (Long orgId : orgIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    orgIdsTemp.add(orgId);
                }
                ++cursor;
            }
            orgIds = orgIdsTemp;
        }
        ArrayList<AllOrgListDto> list = new ArrayList<AllOrgListDto>();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            Map refundFeeMap = this.orgSignupRefundDao.mapRefundFeeByOrgIds(orgIds, startTime, endTime);
            Map kexiaoListMap = this.orgStudentKexiaoRecordDao.mapOrgChargeUnitStatisticDto(orgIds, startTime, endTime);
            Map dataMap = null;
            ChargeUnitStatisticDto timesStatisticDto = null;
            ChargeUnitStatisticDto durationStatisticDto = null;
            OrgInfo orgInfo = null;
            AllOrgListDto dto = null;
            Long refundFee = null;
            for (Long oid : orgIds) {
                orgInfo = orgMap.get(oid);
                dataMap = (Map)kexiaoListMap.get(oid);
                refundFee = (Long)refundFeeMap.get(oid);
                timesStatisticDto = null;
                durationStatisticDto = null;
                dto = new AllOrgListDto();
                dto.setOrgId(orgInfo.getOrgId().longValue());
                dto.setOrgName(orgInfo.getShortName());
                if (dataMap != null) {
                    timesStatisticDto = (ChargeUnitStatisticDto)dataMap.get(ChargeUnit.BY_TIMES.getCode());
                    durationStatisticDto = (ChargeUnitStatisticDto)dataMap.get(ChargeUnit.BY_HOUR.getCode());
                }
                if (timesStatisticDto != null) {
                    dto.setKexiaoTimes(timesStatisticDto.getLineCount());
                    dto.setKexiaoTimesMoney(timesStatisticDto.getAmount());
                } else {
                    dto.setKexiaoTimes(0);
                    dto.setKexiaoTimesMoney(0L);
                }
                if (durationStatisticDto != null) {
                    dto.setKexiaoHour(durationStatisticDto.getLessonDurationHour());
                    dto.setKexiaoHourMoney(durationStatisticDto.getAmount());
                } else {
                    dto.setKexiaoMinute(0);
                    dto.setKexiaoHourMoney(0L);
                }
                if (refundFee != null) {
                    dto.setQuitClassMoney(refundFee);
                } else {
                    dto.setQuitClassMoney(0L);
                }
                dto.setTotalKexiaoMoney(dto.getKexiaoTimesMoneyLong() + dto.getKexiaoHourMoneyLong() + dto.getQuitClassMoneyLong());
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    public AllOrgListDto getAllOrgListTotal(AllOrgListParamDto param) {
        Long mainOrgId = param.getMainOrgId();
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        AllOrgListDto dto = new AllOrgListDto();
        Double kexiaoHour = 0.0;
        Long kexiaoHourMoney = 0L;
        Integer kexiaoTimes = 0;
        Long kexiaoTimesMoney = 0L;
        Long kexiaoTotalMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (param.getOrgId() != null) {
            orgIds.add(orgId);
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
        } else {
            orgIds.add(mainOrgId);
            List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(mainOrgId.intValue()), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    orgIds.add(account.getOrgId().longValue());
                }
            }
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
        }
        if (durationDto != null) {
            kexiaoHour = durationDto.getSumKexiaoHour();
            kexiaoHourMoney = kexiaoHourMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoTimesMoney = kexiaoTimesMoney + timesDto.getSumKexiaoMoney();
        }
        kexiaoTotalMoney = kexiaoTotalMoney + (kexiaoTimesMoney + kexiaoHourMoney + quitClassMoney);
        dto.setKexiaoHour(kexiaoHour);
        dto.setKexiaoHourMoney(kexiaoHourMoney);
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoTimesMoney(kexiaoTimesMoney);
        dto.setTotalKexiaoMoney(kexiaoTotalMoney);
        dto.setQuitClassMoney(quitClassMoney);
        return dto;
    }

    Map<Long, OrgInfo> orgListSearch(AllOrgListParamDto param, boolean containsJoinType) {
        Long mainOrgId = param.getMainOrgId();
        Long orgId = param.getOrgId();
        HashMap<Long, OrgInfo> result = new HashMap<Long, OrgInfo>();
        if (orgId != null) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            result.put(orgId, orgInfo);
        } else {
            List<Integer> orgIds = DashboardKeXiaoServiceImpl.getArrayList(mainOrgId.intValue());
            List subAccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(mainOrgId.intValue()), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount account : subAccounts) {
                    if (!containsJoinType && account.getAccountType() == 3) continue;
                    orgIds.add(account.getOrgId());
                }
            }
            List orgs = this.orgInfoDao.getOrgInfos(orgIds, new String[0]);
            for (OrgInfo orgInfo : orgs) {
                result.put(orgInfo.getOrgId().longValue(), orgInfo);
            }
        }
        return result;
    }

    @Override
    public OrgDetailStatisticsDto getOrgDetailStatisticsDto(Long orgId) {
        OrgDetailStatisticsDto dto = new OrgDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime((Date)startTime, (int)1);
        Double todayKexiaoHour = 0.0;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoHourMoney = 0L;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long todayQuitClassMoney = 0L;
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByOrgId(orgId, null, null, startTime, endTime);
        List signupRefunRecords = this.orgSignupRefundDao.listByUserId(orgId, null, null, startTime, endTime);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                todayKexiaoTotalMoney = todayKexiaoTotalMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    todayKexiaoTimes = todayKexiaoTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    todayKexiaoTimesMoney = todayKexiaoTimesMoney + record.getAmount();
                    continue;
                }
                todayKexiaoHour = todayKexiaoHour + record.getLessonDurationHour();
                todayKexiaoHourMoney = todayKexiaoHourMoney + record.getAmount();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                todayKexiaoTotalMoney = todayKexiaoTotalMoney + record.getRefundFee();
                todayQuitClassMoney = todayQuitClassMoney + record.getRefundFee();
            }
        }
        dto.setOrgId(orgInfo.getId().longValue());
        dto.setOrgName(orgInfo.getShortName());
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(todayQuitClassMoney);
        return dto;
    }

    @Override
    public List<OrgDetailClassListDto> listOrgDetailClassListDto(OrgDetailClassListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();
        List<Integer> courseTypes = param.getCourseTypeList();
        Integer chargeType = param.getChargeType();
        Integer chargeUnit = param.getChargeUnit();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        ArrayList<Long> orgClassIds = null;
        ArrayList<Long> kexiaoClassIds = this.orgStudentKexiaoRecordDao.pageDistinctClassId(orgId, null, startTime, endTime, null);
        List refundClassIds = this.orgSignupRefundDao.pageDistinctClassId(orgId, null, startTime, endTime, null);
        kexiaoClassIds.removeAll(refundClassIds);
        kexiaoClassIds.addAll(refundClassIds);
        if (param.conditionQuery()) {
            orgClassIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), keyword, courseTypes, chargeType, chargeUnit);
            orgClassIds.retainAll(kexiaoClassIds);
        } else {
            orgClassIds = kexiaoClassIds;
        }
        Integer count = orgClassIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listOrgDetailClassListDto - return - kexiao record is empty");
            return new ArrayList<OrgDetailClassListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> orgClassIdsTemp = new ArrayList<Long>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long ocid : orgClassIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    orgClassIdsTemp.add(ocid);
                }
                ++cursor;
            }
            orgClassIds = orgClassIdsTemp;
        }
        ArrayList<OrgDetailClassListDto> result = new ArrayList<OrgDetailClassListDto>();
        Map orgClassMap = this.orgCourseDao.getOrgCourseMap((Collection)orgClassIds, new String[0]);
        Map chargeUnitStatisticDtoMap = this.orgStudentKexiaoRecordDao.mapClassChargeUnitStatisticDto((Collection)orgClassIds, startTime, endTime);
        Map refundFeeMap = this.orgSignupRefundDao.mapRefundFeeByClassIds((Collection)orgClassIds, startTime, endTime);
        OrgDetailClassListDto dto = null;
        OrgCourse orgClass = null;
        Map chargeUnitStatisticDtoData = null;
        ChargeUnitStatisticDto timesStatisticDto = null;
        ChargeUnitStatisticDto durationStatisticDto = null;
        Long kexiaoMoney = null;
        Long refundFee = null;
        for (Long classId : orgClassIds) {
            chargeUnitStatisticDtoData = (Map)chargeUnitStatisticDtoMap.get(classId);
            timesStatisticDto = null;
            durationStatisticDto = null;
            kexiaoMoney = 0L;
            refundFee = 0L;
            orgClass = (OrgCourse)orgClassMap.get(classId);
            if (chargeUnitStatisticDtoData != null) {
                timesStatisticDto = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(ChargeUnit.BY_TIMES.getCode());
                durationStatisticDto = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(ChargeUnit.BY_HOUR.getCode());
            }
            if (refundFeeMap.get(classId) != null) {
                refundFee = (Long)refundFeeMap.get(classId);
            }
            dto = new OrgDetailClassListDto();
            dto.setChargeType(orgClass.getChargeType());
            dto.setChargeUnit(orgClass.getChargeUnit());
            dto.setClassId(orgClass.getId());
            dto.setClassName(orgClass.getName());
            dto.setCourseType(orgClass.getCourseType());
            if (timesStatisticDto != null) {
                dto.setKexiaoTimes(timesStatisticDto.getLineCount());
                kexiaoMoney = kexiaoMoney + timesStatisticDto.getAmount();
            } else {
                dto.setKexiaoTimes(0);
            }
            if (durationStatisticDto != null) {
                dto.setKexiaoHour(durationStatisticDto.getLessonDurationHour());
                kexiaoMoney = kexiaoMoney + durationStatisticDto.getAmount();
            } else {
                dto.setKexiaoHour(0.0);
            }
            dto.setKexiaoMoney(kexiaoMoney);
            dto.setQuitClassMoney(refundFee);
            dto.setTotalKexiaoMoney(kexiaoMoney + refundFee);
            if (orgClass.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                dto.setKexiaoHour(null);
            } else {
                dto.setKexiaoTimes(null);
            }
            result.add(dto);
        }
        log.info("listOrgDetailClassListDto - return");
        return result;
    }

    @Override
    public OrgDetailClassListDto getOrgDetailClassListTotal(OrgDetailClassListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();
        List<Integer> courseTypes = param.getCourseTypeList();
        Integer chargeType = param.getChargeType();
        Integer chargeUnit = param.getChargeUnit();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        OrgDetailClassListDto dto = new OrgDetailClassListDto();
        Integer kexiaoTimes = 0;
        Double kexiaoHour = 0.0;
        Long kexiaoMoney = 0L;
        Long totalKexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List<Long> orgIds = DashboardKeXiaoServiceImpl.getArrayList(orgId);
        if (param.conditionQuery()) {
            List classIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), keyword, courseTypes, chargeType, chargeUnit);
            if (CollectionUtils.isNotEmpty((Collection)classIds)) {
                quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByClassIds((Collection)classIds, startTime, endTime);
                durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
                timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
            }
        } else {
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgId(Long.valueOf(org.getId().longValue()), startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
        }
        if (durationDto != null) {
            kexiaoHour = durationDto.getSumKexiaoHour();
            kexiaoMoney = kexiaoMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoMoney = kexiaoMoney + timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoMoney + quitClassMoney;
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoHour(kexiaoHour);
        dto.setKexiaoMoney(kexiaoMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        return dto;
    }

    @Override
    public List<OrgDetailStudentListDto> listOrgDetailStudentListDto(OrgDetailStudentListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();
        ArrayList<Long> studentUserIds = null;
        ArrayList<Long> kexiaoUserIds = this.orgStudentKexiaoRecordDao.pageDistinctUserId(orgId, null, startTime, endTime, null);
        List refundUserIds = this.orgSignupRefundDao.pageDistinctUserId(orgId, null, startTime, endTime, null);
        kexiaoUserIds.removeAll(refundUserIds);
        kexiaoUserIds.addAll(refundUserIds);
        if (param.conditionQuery()) {
            studentUserIds = this.orgStudentDao.listUserId(orgId, keyword);
            studentUserIds.retainAll(kexiaoUserIds);
        } else {
            studentUserIds = kexiaoUserIds;
        }
        Integer count = studentUserIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listOrgDetailStudentListDto - return - record is empty");
            return new ArrayList<OrgDetailStudentListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> studentUserIdsTemp = new ArrayList<Long>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long suid : studentUserIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    studentUserIdsTemp.add(suid);
                }
                ++cursor;
            }
            studentUserIds = studentUserIdsTemp;
        }
        ArrayList<OrgDetailStudentListDto> result = new ArrayList<OrgDetailStudentListDto>();
        Map orgStudentMap = this.orgStudentDao.getOrgStudentMapByUserIds((Collection)studentUserIds);
        Map chargeUnitStatisticDtoMap = this.orgStudentKexiaoRecordDao.mapUserChargeUnitStatisticDto(orgId, (Collection)studentUserIds, startTime, endTime);
        Map refundFeeMap = this.orgSignupRefundDao.mapRefundFeeByUserIds(orgId, (Collection)studentUserIds, startTime, endTime);
        OrgDetailStudentListDto dto = null;
        OrgStudent student = null;
        Map chargeUnitStatisticDtoData = null;
        ChargeUnitStatisticDto timesStatisticDto = null;
        ChargeUnitStatisticDto durationStatisticDto = null;
        Long kexiaoMoney = null;
        Long refundFee = null;
        for (Long studentUserId : studentUserIds) {
            chargeUnitStatisticDtoData = (Map)chargeUnitStatisticDtoMap.get(studentUserId);
            timesStatisticDto = null;
            durationStatisticDto = null;
            kexiaoMoney = 0L;
            refundFee = 0L;
            student = (OrgStudent)orgStudentMap.get(studentUserId);
            if (chargeUnitStatisticDtoData != null) {
                timesStatisticDto = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(ChargeUnit.BY_TIMES.getCode());
                durationStatisticDto = (ChargeUnitStatisticDto)chargeUnitStatisticDtoData.get(ChargeUnit.BY_HOUR.getCode());
            }
            if (refundFeeMap.get(studentUserId) != null) {
                refundFee = (Long)refundFeeMap.get(studentUserId);
            }
            dto = new OrgDetailStudentListDto();
            dto.setStudentUserId(student.getUserId());
            dto.setStudentName(student.getName());
            if (timesStatisticDto != null) {
                dto.setKexiaoTimes(timesStatisticDto.getLineCount());
                dto.setKexiaoTimesMoney(timesStatisticDto.getAmount());
                kexiaoMoney = kexiaoMoney + timesStatisticDto.getAmount();
            } else {
                dto.setKexiaoTimes(0);
                dto.setKexiaoTimesMoney(0L);
            }
            if (durationStatisticDto != null) {
                dto.setKexiaoHour(durationStatisticDto.getLessonDurationHour());
                dto.setKexiaoHourMoney(durationStatisticDto.getAmount());
                kexiaoMoney = kexiaoMoney + durationStatisticDto.getAmount();
            } else {
                dto.setKexiaoHour(0.0);
                dto.setKexiaoHourMoney(0L);
            }
            dto.setQuitClassMoney(refundFee);
            dto.setTotalKexiaoMoney(kexiaoMoney + refundFee);
            result.add(dto);
        }
        log.info("listOrgDetailStudentListDto - return");
        return result;
    }

    @Override
    public OrgDetailStudentListDto getOrgDetailStudentListTotal(OrgDetailStudentListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        String keyword = param.getKeyword();
        OrgDetailStudentListDto dto = new OrgDetailStudentListDto();
        Integer kexiaoTimes = 0;
        Double kexiaoHour = 0.0;
        Long kexiaoTimesMoney = 0L;
        Long kexiaoHourMoney = 0L;
        Long totalKexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List<Long> orgIds = DashboardKeXiaoServiceImpl.getArrayList(orgId);
        if (param.conditionQuery()) {
            List studentUserIds = this.orgStudentDao.listUserId(orgId, keyword);
            if (CollectionUtils.isNotEmpty((Collection)studentUserIds)) {
                quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByUserIds(orgId, (Collection)studentUserIds, startTime, endTime);
                durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, (Collection)studentUserIds, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
                timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, (Collection)studentUserIds, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
            }
        } else {
            quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgId(orgId, startTime, endTime);
            durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
            timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, null, null, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
        }
        if (durationDto != null) {
            kexiaoHour = durationDto.getSumKexiaoHour();
            kexiaoHourMoney = kexiaoHourMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            kexiaoTimes = timesDto.getSumKexiaoTimes();
            kexiaoTimesMoney = kexiaoTimesMoney + timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoTimesMoney + kexiaoHourMoney + quitClassMoney;
        dto.setKexiaoTimes(kexiaoTimes);
        dto.setKexiaoHour(kexiaoHour);
        dto.setKexiaoTimesMoney(kexiaoTimesMoney);
        dto.setKexiaoHourMoney(kexiaoHourMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        return dto;
    }

    @Override
    public List<OrgDetailKexiaoListDto> listOrgDetailKexiaoListDto(OrgDetailKexiaoListParamDto param, PageDto pageDto) {
        OrgCourse orgClass;
        OrgStudent student;
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        List classIds = null;
        if (param.conditionQuery() && CollectionUtils.isEmpty((Collection)(classIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), param.getKeyword(), null, null, null)))) {
            log.info("listOrgDetailKexiaoListDto - return - search is empty");
            pageDto.setCount(Integer.valueOf(0));
            return new ArrayList<OrgDetailKexiaoListDto>();
        }
        Integer count = 0;
        List kexiaoRecords = null;
        List signupRefunRecords = null;
        count = this.orgStudentKexiaoRecordDao.countByClassIds(orgId, (Collection)classIds, startTime, endTime);
        count = count + this.orgSignupRefundDao.countByClassIds(orgId, (Collection)classIds, startTime, endTime);
        kexiaoRecords = this.orgStudentKexiaoRecordDao.pageByClassIds(orgId, (Collection)classIds, startTime, endTime, pageDto);
        if (pageDto != null) {
            pageDto.setCount(count);
            if (kexiaoRecords.size() < pageDto.getPageSize()) {
                PageDto pageDtoTemp = new PageDto();
                pageDtoTemp.setPageNum(Integer.valueOf(1));
                pageDtoTemp.setPageSize(Integer.valueOf(pageDto.getPageSize() - kexiaoRecords.size()));
                signupRefunRecords = this.orgSignupRefundDao.pageByClassIds(orgId, (Collection)classIds, startTime, endTime, pageDtoTemp);
            }
        } else {
            signupRefunRecords = this.orgSignupRefundDao.pageByClassIds(orgId, (Collection)classIds, startTime, endTime, null);
        }
        if (CollectionUtils.isEmpty((Collection)kexiaoRecords) && CollectionUtils.isEmpty((Collection)signupRefunRecords)) {
            log.info("listOrgDetailKexiaoListDto - return - record is empty");
            pageDto.setCount(Integer.valueOf(0));
            return new ArrayList<OrgDetailKexiaoListDto>();
        }
        ArrayList<OrgDetailKexiaoListDto> result = new ArrayList<OrgDetailKexiaoListDto>();
        Map studentMapKeyUserId = null;
        Map classMapKeyCourseId = null;
        OrgDetailKexiaoListDto dto = null;
        HashSet<Long> studentUserIdsInPage = new HashSet<Long>();
        HashSet<Long> classIdsInPage = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                studentUserIdsInPage.add(record.getUserId());
                classIdsInPage.add(record.getClassId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                studentUserIdsInPage.add(record.getUserId());
                classIdsInPage.add(record.getClassId());
            }
        }
        if (CollectionUtils.isNotEmpty(studentUserIdsInPage)) {
            studentMapKeyUserId = this.orgStudentDao.getStudentMap(studentUserIdsInPage, orgId, new String[0]);
        }
        if (CollectionUtils.isNotEmpty(classIdsInPage)) {
            classMapKeyCourseId = this.orgCourseDao.getOrgCourseMap(classIdsInPage, new String[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            student = null;
            orgClass = null;
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                orgClass = (OrgCourse)classMapKeyCourseId.get(record.getClassId());
                student = (OrgStudent)studentMapKeyUserId.get(record.getUserId());
                dto = new OrgDetailKexiaoListDto();
                dto.setStudentName(student.getName());
                dto.setStudentUserId(student.getUserId());
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setCourseType(orgClass.getCourseType());
                dto.setChargeUnit(orgClass.getChargeUnit());
                dto.setChargeType(orgClass.getChargeType());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute((Date)record.getStartTime(), (int)record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                dto.setQuitClassMoney(0L);
                dto.setTotalKexiaoMoney(dto.getKexiaoMoneyLong());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }
                result.add(dto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            student = null;
            orgClass = null;
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                orgClass = (OrgCourse)classMapKeyCourseId.get(record.getClassId());
                student = (OrgStudent)studentMapKeyUserId.get(record.getUserId());
                dto = new OrgDetailKexiaoListDto();
                dto.setStudentName(student.getName());
                dto.setStudentUserId(student.getUserId());
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setCourseType(orgClass.getChargeType());
                dto.setChargeUnit(orgClass.getChargeUnit());
                dto.setChargeType(orgClass.getChargeType());
                dto.setKexiaoMoney(0L);
                dto.setQuitClassMoney(record.getRefundFee());
                dto.setTotalKexiaoMoney(dto.getQuitClassMoneyLong());
                dto.setQuitClassTime(record.getCreateTime());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public OrgDetailKexiaoListDto getOrgDetailKexiaoListTotal(OrgDetailKexiaoListParamDto param) {
        Long orgId = param.getOrgId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        OrgAccount org = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        OrgDetailKexiaoListDto dto = new OrgDetailKexiaoListDto();
        Double lessonHour = 0.0;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        Long quitClassMoney = 0L;
        Long totalKexiaoMoney = 0L;
        KexiaoSumDto durationDto = null;
        KexiaoSumDto timesDto = null;
        List classIds = null;
        if (param.conditionQuery() && CollectionUtils.isEmpty((Collection)(classIds = this.orgCourseDao.listCourseId(Long.valueOf(org.getNumber().longValue()), param.getKeyword(), null, null, null)))) {
            dto.setKexiaoMoney(kexiaoMoney);
            dto.setQuitClassMoney(quitClassMoney);
            dto.setTotalKexiaoMoney(totalKexiaoMoney);
            dto.setLessonTimes(lessonTimes);
            dto.setLessonHour(lessonHour);
            log.info("listOrgDetailKexiaoListDto - return - search is empty");
            return dto;
        }
        List<Long> orgIds = DashboardKeXiaoServiceImpl.getArrayList(orgId);
        durationDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, Integer.valueOf(ChargeUnit.BY_HOUR.getCode()), startTime, endTime);
        timesDto = this.orgStudentKexiaoRecordDao.getKexiaoKexiaoSumDto(orgIds, (Collection)classIds, null, Integer.valueOf(ChargeUnit.BY_TIMES.getCode()), startTime, endTime);
        quitClassMoney = this.orgSignupRefundDao.sumRefundFeeByOrgIds(orgIds, startTime, endTime);
        if (durationDto != null) {
            lessonHour = durationDto.getSumKexiaoHour();
            kexiaoMoney = kexiaoMoney + durationDto.getSumKexiaoMoney();
        }
        if (timesDto != null) {
            lessonTimes = timesDto.getSumKexiaoTimes();
            kexiaoMoney = kexiaoMoney + timesDto.getSumKexiaoMoney();
        }
        totalKexiaoMoney = kexiaoMoney + quitClassMoney;
        dto.setKexiaoMoney(kexiaoMoney);
        dto.setQuitClassMoney(quitClassMoney);
        dto.setTotalKexiaoMoney(totalKexiaoMoney);
        dto.setLessonTimes(lessonTimes);
        dto.setLessonHour(lessonHour);
        return dto;
    }

    @Override
    public ClassDetailStatisticsDto getClassDetailStatisticsDto(Long orgId, Long classId) {
        ClassDetailStatisticsDto dto = new ClassDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime((Date)startTime, (int)1);
        OrgCourse orgClass = this.orgCourseDao.getByCourseId(classId, new String[0]);
        long courseId = classId;
        if (orgClass.getParentId() != null && orgClass.getParentId() > 0L) {
            courseId = orgClass.getParentId();
        }
        OrgCourseConsumeRule kexiaoRule = this.courseConsumeRuleDao.getRuleByCourseId(orgId, Long.valueOf(courseId));
        Integer studentCount = this.orgStudentCourseDao.countStudents(orgId, classId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        Long todayKexiaoMoney = 0L;
        Long todayQuitClassMoney = 0L;
        Double todayKexiaoHour = 0.0;
        Integer todayKexiaoTimes = 0;
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByClassId(orgId, classId, null, startTime, endTime);
        List signupRefunRecords = this.orgSignupRefundDao.listByClassId(orgId, classId, null, startTime, endTime);
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                todayKexiaoMoney = todayKexiaoMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    todayKexiaoTimes = todayKexiaoTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    continue;
                }
                todayKexiaoHour = todayKexiaoHour + record.getLessonDurationHour();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunRecords)) {
            for (OrgStudentKexiaoRecord record : signupRefunRecords) {
                todayKexiaoMoney = todayKexiaoMoney + record.getRefundFee();
                todayQuitClassMoney = todayQuitClassMoney + record.getRefundFee();
            }
        }
        dto.setClassId(orgClass.getId());
        dto.setClassName(orgClass.getName());
        dto.setTodayQuitClassMoney(todayQuitClassMoney);
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoMoney(todayKexiaoMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setStudentCount(studentCount);
        dto.setChargeType(orgClass.getChargeType());
        dto.setChargeUnit(orgClass.getChargeUnit());
        if (kexiaoRule != null) {
            dto.setKexiaoRule(kexiaoRule.getRuleValue());
        }
        return dto;
    }

    @Override
    public List<ClassDetailListDto> listClassDetailListDto(ClassDetailListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Map<Long, OrgStudent> orgStudentMap = this.classDetailListSearch(param);
        if (MapUtils.isEmpty(orgStudentMap)) {
            log.info("listClassDetailListDto - return - studentCourses is empty");
            return new ArrayList<ClassDetailListDto>();
        }
        Set<Long> studentUserIds = orgStudentMap.keySet();
        ArrayList<Long> kexiaoRecordIds = this.orgStudentKexiaoRecordDao.listIdsByClassId(orgId, classId, studentUserIds, startTime, endTime);
        ArrayList<Integer> signupRefunIds = this.orgSignupRefundDao.listIdsByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List kexiaoRecords = null;
        List signupRefunRecords = null;
        Integer count = kexiaoRecordIds.size() + signupRefunIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listClassDetailListDto - return - kexiao record is empty");
            return new ArrayList<ClassDetailListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> kexiaoRecordIdsTemp = new ArrayList<Long>();
            ArrayList<Integer> signupRefunIdsTemp = new ArrayList<Integer>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long kxid : kexiaoRecordIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    kexiaoRecordIdsTemp.add(kxid);
                }
                ++cursor;
            }
            for (Integer srid : signupRefunIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    signupRefunIdsTemp.add(srid);
                }
                ++cursor;
            }
            kexiaoRecordIds = kexiaoRecordIdsTemp;
            signupRefunIds = signupRefunIdsTemp;
        }
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecordIds)) {
            kexiaoRecords = this.orgStudentKexiaoRecordDao.listOrderByStartTime((List)kexiaoRecordIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            signupRefunRecords = this.orgSignupRefundDao.listOrderByCreateTime((List)signupRefunIds);
        }
        ArrayList<ClassDetailListDto> result = new ArrayList<ClassDetailListDto>();
        ClassDetailListDto dto = null;
        OrgStudent student = null;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            Map<Long, LinkedHashMap<Long, RemainingDataDto>> courseRemainingDataMap = this.getRemainingDataByClassId(orgId, classId);
            LinkedHashMap<Long, RemainingDataDto> lessonRemainingDataMap = null;
            RemainingDataDto lessonRemainingData = null;
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                student = orgStudentMap.get(record.getUserId());
                lessonRemainingDataMap = courseRemainingDataMap.get(record.getUserId());
                lessonRemainingData = lessonRemainingDataMap.get(record.getLessonId());
                dto = new ClassDetailListDto();
                dto.setStudentUserId(student.getUserId());
                dto.setStudentName(student.getName());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute((Date)record.getStartTime(), (int)record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }
                dto.setRemainingHour(lessonRemainingData.getRemainingHour());
                dto.setRemainingMoney(lessonRemainingData.getRemainingMoney());
                dto.setRemainingTimes(lessonRemainingData.getRemainingTimes());
                OrgLessonSign signData = this.orgLessonSignDao.getStudentLessonSign(orgId, classId, record.getLessonId(), student.getUserId(), Integer.valueOf(UserRole.STUDENT.getRole()));
                if (signData != null) {
                    dto.setSigninStatus(signData.getStatus());
                }
                result.add(dto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                student = orgStudentMap.get(record.getUserId());
                dto = new ClassDetailListDto();
                dto.setStudentUserId(student.getUserId());
                dto.setStudentName(student.getName());
                dto.setLessonStartTime(record.getCreateTime());
                dto.setKexiaoMoney(record.getRefundFee());
                dto.setRemainingMinute(0);
                dto.setRemainingMoney(0L);
                dto.setRemainingTimes(0);
                dto.setQuitClassTime(record.getCreateTime());
                dto.setLessonMinute(null);
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public ClassDetailListDto getClassDetailListTotal(ClassDetailListParamDto param) {
        ClassDetailListDto result = new ClassDetailListDto();
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Map<Long, OrgStudent> orgStudentMap = this.classDetailListSearch(param);
        if (MapUtils.isEmpty(orgStudentMap)) {
            log.info("getClassDetailListTotal - return - studentCourses is empty");
            result.setLessonMinute(null);
            result.setLessonTimes(null);
            result.setKexiaoMoney(0L);
            result.setRemainingMoney(0L);
            return result;
        }
        Set<Long> studentUserIds = orgStudentMap.keySet();
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByClassId(orgId, classId, studentUserIds, startTime, endTime);
        List signupRefuns = this.orgSignupRefundDao.listByClassId(orgId, classId, studentUserIds, startTime, endTime);
        Double lessonHour = 0.0;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                kexiaoMoney = kexiaoMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    lessonTimes = lessonTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    continue;
                }
                lessonHour = lessonHour + record.getLessonDurationHour();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefuns)) {
            for (OrgStudentKexiaoRecord record : signupRefuns) {
                kexiaoMoney = kexiaoMoney + record.getRefundFee();
            }
        }
        result.setLessonHour(lessonHour);
        result.setLessonTimes(lessonTimes);
        result.setKexiaoMoney(kexiaoMoney);
        return result;
    }

    Map<Long, OrgStudent> classDetailListSearch(ClassDetailListParamDto param) {
        Long orgId = param.getOrgId();
        Long classId = param.getClassId();
        String keyword = param.getKeyword();
        List studentClass = this.orgStudentCourseDao.listByCourseId(orgId, classId, null, null);
        HashSet<Long> studentUserIds = null;
        if (CollectionUtils.isNotEmpty((Collection)studentClass)) {
            studentUserIds = new HashSet<Long>();
            for (OrgStudentCourse osc : studentClass) {
                studentUserIds.add(osc.getUserId());
            }
        } else {
            log.info("classDetailListSearch - return - studentCourses is empty");
            return null;
        }
        HashMap<Long, OrgStudent> orgStudentMap = this.orgStudentDao.getStudentMap(studentUserIds, orgId, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            HashMap<Long, OrgStudent> orgStudentMapTemp = new HashMap<Long, OrgStudent>();
            OrgStudent student = null;
            for (Long key : orgStudentMap.keySet()) {
                student = (OrgStudent)orgStudentMap.get(key);
                if (!student.getName().contains(keyword)) continue;
                orgStudentMapTemp.put(key, student);
            }
            orgStudentMap = orgStudentMapTemp;
        }
        return orgStudentMap;
    }

    @Override
    public StudentDetailStatisticsDto getStudentDetailStatisticsDto(Long orgId, Long studentUserId) {
        List stuClassList;
        StudentDetailStatisticsDto dto = new StudentDetailStatisticsDto();
        Date startTime = DateUtil.getCurrentDate();
        Date endTime = DateUtil.getDiffDateTime((Date)startTime, (int)1);
        OrgStudent student = this.orgStudentDao.getStudentByUserId(orgId, studentUserId, new String[0]);
        Integer classCount = this.orgStudentCourseDao.getStudentSignupCourseCount(orgId, studentUserId, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()));
        Long payMoney = 0L;
        Long remainingMoney = 0L;
        Double todayKexiaoHour = 0.0;
        Long todayKexiaoHourMoney = 0L;
        Integer todayKexiaoTimes = 0;
        Long todayKexiaoTimesMoney = 0L;
        Long todayKexiaoTotalMoney = 0L;
        Long quitClassMoney = 0L;
        List signupCourseList = this.orgSignupCourseDao.listByUserId(orgId, null, studentUserId);
        if (CollectionUtils.isNotEmpty((Collection)signupCourseList)) {
            for (OrgSignupCourse osc : signupCourseList) {
                payMoney = payMoney + osc.getTotalPayPrice();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(stuClassList = this.orgStudentCourseDao.listByUserId(orgId, studentUserId, null, Integer.valueOf(StudentCourseStatus.NORMAL.getCode()))))) {
            HashSet<Long> normalStatusClassIds = new HashSet<Long>();
            for (OrgStudentCourse osc : stuClassList) {
                normalStatusClassIds.add(osc.getCourseId());
            }
            List normalStatusSignupCourseList = this.orgSignupCourseDao.listByUserId(orgId, normalStatusClassIds, studentUserId);
            List normalStatuskexiaoRecords = this.orgStudentKexiaoRecordDao.listByUserId(orgId, normalStatusClassIds, studentUserId, null, null);
            if (CollectionUtils.isNotEmpty((Collection)normalStatusSignupCourseList)) {
                for (OrgSignupCourse osc : normalStatusSignupCourseList) {
                    remainingMoney = remainingMoney + osc.getTotalPayPrice();
                }
            }
            for (OrgStudentKexiaoRecord record : normalStatuskexiaoRecords) {
                remainingMoney = remainingMoney - record.getAmount();
            }
        }
        List todayKexiaoRecords = this.orgStudentKexiaoRecordDao.listByUserId(orgId, null, studentUserId, startTime, endTime);
        List todaySignupRefunRecords = this.orgSignupRefundDao.listByUserId(orgId, null, studentUserId, startTime, endTime);
        for (OrgStudentKexiaoRecord record : todayKexiaoRecords) {
            if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                todayKexiaoTimes = todayKexiaoTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                todayKexiaoTimesMoney = todayKexiaoTimesMoney + record.getAmount();
                continue;
            }
            todayKexiaoHour = todayKexiaoHour + record.getLessonDurationHour();
            todayKexiaoHourMoney = todayKexiaoHourMoney + record.getAmount();
        }
        for (OrgStudentKexiaoRecord record : todaySignupRefunRecords) {
            quitClassMoney = quitClassMoney + record.getRefundFee();
        }
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + todayKexiaoTimesMoney;
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + todayKexiaoHourMoney;
        todayKexiaoTotalMoney = todayKexiaoTotalMoney + quitClassMoney;
        dto.setStudentUserId(student.getUserId());
        dto.setStudentName(student.getName());
        dto.setClassCount(classCount);
        dto.setPayMoney(payMoney);
        dto.setRemainingMoney(remainingMoney);
        dto.setTodayKexiaoHour(todayKexiaoHour);
        dto.setTodayKexiaoHourMoney(todayKexiaoHourMoney);
        dto.setTodayKexiaoTimes(todayKexiaoTimes);
        dto.setTodayKexiaoTimesMoney(todayKexiaoTimesMoney);
        dto.setTodayKexiaoTotalMoney(todayKexiaoTotalMoney);
        dto.setTodayQuitClassMoney(quitClassMoney);
        return dto;
    }

    @Override
    public List<StudentDetailListDto> listStudentDetailListDto(StudentDetailListParamDto param, PageDto pageDto) {
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Map<Long, OrgCourse> orgClassMap = this.studentDetailListSearch(param);
        if (MapUtils.isEmpty(orgClassMap)) {
            log.info("listStudentDetailListDto - return - studentCourses is empty");
            return new ArrayList<StudentDetailListDto>();
        }
        Set<Long> classIds = orgClassMap.keySet();
        ArrayList<Long> kexiaoRecordIds = this.orgStudentKexiaoRecordDao.listIdsByUserId(orgId, classIds, userId, startTime, endTime);
        ArrayList<Integer> signupRefunIds = this.orgSignupRefundDao.listIdsByUserId(orgId, classIds, userId, startTime, endTime);
        List kexiaoRecords = null;
        List signupRefunRecords = null;
        Integer count = kexiaoRecordIds.size() + signupRefunIds.size();
        if (pageDto != null) {
            pageDto.setCount(count);
        }
        if (count == 0) {
            log.info("listStudentDetailListDto - return - kexiao record is empty");
            return new ArrayList<StudentDetailListDto>();
        }
        if (pageDto != null) {
            ArrayList<Long> kexiaoRecordIdsTemp = new ArrayList<Long>();
            ArrayList<Integer> signupRefunIdsTemp = new ArrayList<Integer>();
            int cursor = 0;
            int limitFrom = pageDto.firstNum();
            int limitTo = pageDto.firstNum() + pageDto.getPageSize() - 1;
            for (Long kxid : kexiaoRecordIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    kexiaoRecordIdsTemp.add(kxid);
                }
                ++cursor;
            }
            for (Integer srid : signupRefunIds) {
                if (cursor > limitTo) break;
                if (cursor >= limitFrom) {
                    signupRefunIdsTemp.add(srid);
                }
                ++cursor;
            }
            kexiaoRecordIds = kexiaoRecordIdsTemp;
            signupRefunIds = signupRefunIdsTemp;
        }
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecordIds)) {
            kexiaoRecords = this.orgStudentKexiaoRecordDao.listOrderByStartTime((List)kexiaoRecordIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            signupRefunRecords = this.orgSignupRefundDao.listOrderByCreateTime((List)signupRefunIds);
        }
        ArrayList<StudentDetailListDto> result = new ArrayList<StudentDetailListDto>();
        StudentDetailListDto dto = null;
        OrgCourse orgClass = null;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            Map lessonIdVsSigninStatusMap = this.orgLessonSignDao.mapKeyLessonIdValueStatus(orgId, userId);
            Map<Long, LinkedHashMap<Long, RemainingDataDto>> courseRemainingDataMap = this.getRemainingDataByUserId(orgId, userId);
            LinkedHashMap<Long, RemainingDataDto> lessonRemainingDataMap = null;
            RemainingDataDto lessonRemainingData = null;
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                orgClass = orgClassMap.get(record.getClassId());
                lessonRemainingDataMap = courseRemainingDataMap.get(record.getClassId());
                lessonRemainingData = lessonRemainingDataMap.get(record.getLessonId());
                dto = new StudentDetailListDto();
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setLessonStartTime(record.getStartTime());
                dto.setLessonEndTime(DateUtil.getDiffMinute((Date)record.getStartTime(), (int)record.getLessonDuration()));
                dto.setKexiaoMoney(record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    dto.setLessonTimes(DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES);
                } else {
                    dto.setLessonMinute(record.getLessonDuration());
                }
                dto.setRemainingHour(lessonRemainingData.getRemainingHour());
                dto.setRemainingMoney(lessonRemainingData.getRemainingMoney());
                dto.setRemainingTimes(lessonRemainingData.getRemainingTimes());
                dto.setSigninStatus((Integer)lessonIdVsSigninStatusMap.get(record.getLessonId()));
                result.add(dto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefunIds)) {
            for (OrgSignupRefund record : signupRefunRecords) {
                orgClass = orgClassMap.get(record.getClassId());
                dto = new StudentDetailListDto();
                dto.setClassId(orgClass.getId());
                dto.setClassName(orgClass.getName());
                dto.setLessonStartTime(record.getCreateTime());
                dto.setKexiaoMoney(record.getRefundFee());
                dto.setRemainingMinute(0);
                dto.setRemainingMoney(0L);
                dto.setRemainingTimes(0);
                dto.setQuitClassTime(record.getCreateTime());
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public StudentDetailListDto getStudentDetailListTotal(StudentDetailListParamDto param) {
        StudentDetailListDto result = new StudentDetailListDto();
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        Date startTime = param.getStartTimeDate();
        Date endTime = param.getEndTimeDate();
        Map<Long, OrgCourse> orgClassMap = this.studentDetailListSearch(param);
        if (MapUtils.isEmpty(orgClassMap)) {
            log.info("getStudentDetailListDtoTotal - return - studentCourses is empty");
            result.setLessonHour(null);
            result.setLessonTimes(null);
            result.setKexiaoMoney(0L);
            result.setRemainingMoney(0L);
            return result;
        }
        Set<Long> classIds = orgClassMap.keySet();
        List kexiaoRecords = this.orgStudentKexiaoRecordDao.listByUserId(orgId, classIds, userId, startTime, endTime);
        List signupRefuns = this.orgSignupRefundDao.listByUserId(orgId, classIds, userId, startTime, endTime);
        Double lessonHour = 0.0;
        Integer lessonTimes = 0;
        Long kexiaoMoney = 0L;
        if (CollectionUtils.isNotEmpty((Collection)kexiaoRecords)) {
            for (OrgStudentKexiaoRecord record : kexiaoRecords) {
                kexiaoMoney = kexiaoMoney + record.getAmount();
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    lessonTimes = lessonTimes + DashboadrKexiaoDtoHelper.DEFAULT_LESSON_TIMES;
                    continue;
                }
                lessonHour = lessonHour + record.getLessonDurationHour();
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)signupRefuns)) {
            for (OrgStudentKexiaoRecord record : signupRefuns) {
                kexiaoMoney = kexiaoMoney + record.getRefundFee();
            }
        }
        result.setLessonHour(lessonHour);
        result.setLessonTimes(lessonTimes);
        result.setKexiaoMoney(kexiaoMoney);
        return result;
    }

    Map<Long, OrgCourse> studentDetailListSearch(StudentDetailListParamDto param) {
        Long orgId = param.getOrgId();
        Long userId = param.getStudentUserId();
        String keyword = param.getKeyword();
        List studentClass = this.orgStudentCourseDao.listByUserId(orgId, userId, null, null);
        HashSet<Long> classIds = null;
        if (CollectionUtils.isNotEmpty((Collection)studentClass)) {
            classIds = new HashSet<Long>();
            for (OrgStudentCourse osc : studentClass) {
                classIds.add(osc.getCourseId());
            }
        } else {
            log.info("StudentDetailListDtoSearch - return - studentCourses is empty");
            return null;
        }
        HashMap<Long, OrgCourse> orgClassMap = this.orgCourseDao.getOrgCourseMap(classIds, new String[0]);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            HashMap<Long, OrgCourse> orgClassMapTemp = new HashMap<Long, OrgCourse>();
            OrgCourse orgClass = null;
            for (Long key : orgClassMap.keySet()) {
                orgClass = (OrgCourse)orgClassMap.get(key);
                if (!orgClass.getName().contains(keyword)) continue;
                orgClassMapTemp.put(key, orgClass);
            }
            orgClassMap = orgClassMapTemp;
        }
        return orgClassMap;
    }

    Map<Long, LinkedHashMap<Long, RemainingDataDto>> getRemainingDataByUserId(Long orgId, Long userId) {
        HashMap<Long, LinkedHashMap<Long, RemainingDataDto>> result = new HashMap<Long, LinkedHashMap<Long, RemainingDataDto>>();
        Map signupCourseMap = this.orgSignupCourseDao.mapKeyClassId(orgId, userId);
        List records = this.orgStudentKexiaoRecordDao.listByUserId(orgId, null, userId, null, null);
        LinkedHashMap<Long, RemainingDataDto> remainingDataMap = null;
        RemainingDataDto remainingData = null;
        RemainingDataDto preRemainingData = null;
        OrgSignupCourse orgSignupCourse = null;
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            for (OrgStudentKexiaoRecord record : records) {
                remainingDataMap = (LinkedHashMap<Long, RemainingDataDto>)result.get(record.getClassId());
                orgSignupCourse = (OrgSignupCourse)signupCourseMap.get(record.getClassId());
                if (orgSignupCourse == null) {
                    orgSignupCourse = new OrgSignupCourse();
                    orgSignupCourse.setPayPrice(Long.valueOf(0L));
                    orgSignupCourse.setStudentPayPrice(Long.valueOf(0L));
                    orgSignupCourse.setLessonCount(Integer.valueOf(0));
                }
                if (remainingDataMap == null) {
                    remainingDataMap = new LinkedHashMap<Long, RemainingDataDto>();
                    result.put(record.getClassId(), remainingDataMap);
                    preRemainingData = new RemainingDataDto();
                    preRemainingData.setRemainingMoney(orgSignupCourse.getTotalPayPrice());
                    if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                        preRemainingData.setRemainingTimes(orgSignupCourse.getLessonCount());
                    } else {
                        preRemainingData.setRemainingHour(orgSignupCourse.getLessonCount().doubleValue());
                    }
                } else {
                    Iterator iterator = remainingDataMap.values().iterator();
                    while (iterator.hasNext()) {
                        RemainingDataDto dto;
                        preRemainingData = dto = (RemainingDataDto)iterator.next();
                    }
                }
                remainingData = new RemainingDataDto();
                remainingDataMap.put(record.getLessonId(), remainingData);
                remainingData.setRemainingMoney(preRemainingData.getRemainingMoney() - record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    remainingData.setRemainingTimes(preRemainingData.getRemainingTimes() - 1);
                    continue;
                }
                remainingData.setRemainingHour(preRemainingData.getRemainingHour() - record.getLessonDurationHour());
            }
        }
        return result;
    }

    Map<Long, LinkedHashMap<Long, RemainingDataDto>> getRemainingDataByClassId(Long orgId, Long classId) {
        HashMap<Long, LinkedHashMap<Long, RemainingDataDto>> result = new HashMap<Long, LinkedHashMap<Long, RemainingDataDto>>();
        Map signupCourseMap = this.orgSignupCourseDao.mapKeyUserId(orgId, classId);
        List records = this.orgStudentKexiaoRecordDao.listByClassId(orgId, classId, null, null, null);
        LinkedHashMap<Long, RemainingDataDto> remainingDataMap = null;
        RemainingDataDto remainingData = null;
        RemainingDataDto preRemainingData = null;
        OrgSignupCourse orgSignupCourse = null;
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            for (OrgStudentKexiaoRecord record : records) {
                remainingDataMap = (LinkedHashMap<Long, RemainingDataDto>)result.get(record.getUserId());
                orgSignupCourse = (OrgSignupCourse)signupCourseMap.get(record.getUserId());
                if (orgSignupCourse == null) {
                    orgSignupCourse = new OrgSignupCourse();
                    orgSignupCourse.setPayPrice(Long.valueOf(0L));
                    orgSignupCourse.setStudentPayPrice(Long.valueOf(0L));
                    orgSignupCourse.setLessonCount(Integer.valueOf(0));
                }
                if (remainingDataMap == null) {
                    remainingDataMap = new LinkedHashMap<Long, RemainingDataDto>();
                    result.put(record.getUserId(), remainingDataMap);
                    preRemainingData = new RemainingDataDto();
                    preRemainingData.setRemainingMoney(orgSignupCourse.getTotalPayPrice());
                    if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                        preRemainingData.setRemainingTimes(orgSignupCourse.getLessonCount());
                    } else {
                        preRemainingData.setRemainingHour(orgSignupCourse.getLessonCount().doubleValue());
                    }
                } else {
                    Iterator iterator = remainingDataMap.values().iterator();
                    while (iterator.hasNext()) {
                        RemainingDataDto dto;
                        preRemainingData = dto = (RemainingDataDto)iterator.next();
                    }
                }
                remainingData = new RemainingDataDto();
                remainingDataMap.put(record.getLessonId(), remainingData);
                remainingData.setRemainingMoney(preRemainingData.getRemainingMoney() - record.getAmount());
                if (record.getChargeUnit().intValue() == ChargeUnit.BY_TIMES.getCode()) {
                    remainingData.setRemainingTimes(preRemainingData.getRemainingTimes() - 1);
                    continue;
                }
                remainingData.setRemainingHour(preRemainingData.getRemainingHour() - record.getLessonDurationHour());
            }
        }
        return result;
    }
}

