/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.service.ConsultStatRedisService;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class ConsultStatRedisServiceImpl
extends AbstractBaseRedisDao<String, Object>
implements ConsultStatRedisService {
    private static final Logger log = LoggerFactory.getLogger(ConsultStatRedisServiceImpl.class);
    public static final String CONSULT_USER_ID_KEY = "TX#CONSULT#ID";

    @Override
    public void setConsultUserId(long orgId, long studentId, long userId, final long consultUserId) {
        String key = CONSULT_USER_ID_KEY;
        final String fieldStr = this.getField(orgId, studentId, userId);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = ConsultStatRedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)ConsultStatRedisServiceImpl.CONSULT_USER_ID_KEY);
                byte[] field = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = ConsultStatRedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize((Object)consultUserId);
                connection.hSet(keyBytes, field, value);
                log.info("[SysnSignupInfo] success to save consultId for for field : {} with consultId : {}  ", (Object)fieldStr, (Object)consultUserId);
                return null;
            }
        });
    }

    private String getField(long orgId, long studentId, long userId) {
        String format = "%s_%s_%s";
        String fieldStr = String.format(format, orgId, studentId, userId);
        return fieldStr;
    }

    @Override
    public Long getConsultIdFromRedis(long orgId, long studentId, long userId) {
        final String fieldStr = this.getField(orgId, studentId, userId);
        return (Long)this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = ConsultStatRedisServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)ConsultStatRedisServiceImpl.CONSULT_USER_ID_KEY);
                byte[] field = serializer.serialize((Object)fieldStr);
                RedisSerializer redisSerializer = ConsultStatRedisServiceImpl.this.redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(keyBytes, field);
                log.info("[SysnSignupInfo] getValue:{}", redisSerializer.deserialize(value));
                return (Long)redisSerializer.deserialize(value);
            }
        });
    }
}

