/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.constants.StatPageType;
import com.baijia.tianxiao.biz.dashboard.service.MarkingMsgService;
import com.baijia.tianxiao.biz.dashboard.service.MonitorService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTodayMinDao;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessageReceiveService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceImpl
extends AbstractBaseRedisDao<String, Object>
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    @Resource
    private TxMonitorTodayMinDao txMonitorTodayMinDao;
    @Resource
    private MarkingMsgService markingMsgService;
    @Resource
    private OrgInfoService orgInfoService;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private MessageReceiveService messageReceiveService;

    @Override
    public synchronized boolean setPV(final Map<String, String> params) {
        final int pageType = Integer.parseInt(params.get("pageType"));
        final long orgNumber = Long.parseLong(params.get("orgNumber"));
        long userNumber = Long.parseLong(params.get("userNumber"));
        String uuid = params.get("uuid");
        String pvKey = "TX#MONITOR#PV#";
        final String pvField = this.getPvField(params.get("orgNumber"), params.get("userNumber"), uuid, params.get("pageType"), params.get("typeNumber"));
        final String msgKey = this.getMsgKey(DateUtil.getToday());
        final String msgField = this.getMsgField(params.get("orgNumber"), params.get("userNumber"), uuid);
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                int pageCount;
                byte[] msgValue;
                connection.select(6);
                RedisSerializer serializer = MonitorServiceImpl.this.redisTemplate.getStringSerializer();
                byte[] key = serializer.serialize((Object)"TX#MONITOR#PV#");
                byte[] field = serializer.serialize((Object)pvField);
                byte[] value = connection.hGet(key, field);
                int count = 1;
                if (value != null) {
                    count = Integer.parseInt((String)serializer.deserialize(value));
                    ++count;
                }
                if (StatPageType.getSendMsgList().contains(pageType) && MonitorServiceImpl.this.checkMarkdingStatus(orgNumber)) {
                    msgValue = connection.hGet(serializer.serialize((Object)msgKey), serializer.serialize((Object)msgField));
                    log.debug("get tianxiao pv=== msgKey:{},msgField:{},value:{}", new Object[]{msgKey, msgField, msgValue == null ? Integer.valueOf(0) : (Serializable)serializer.deserialize(msgValue)});
                    if (msgValue == null) {
                        connection.hSet(serializer.serialize((Object)msgKey), serializer.serialize((Object)msgField), serializer.serialize((Object)String.valueOf(1)));
                    } else {
                        pageCount = Integer.parseInt((String)serializer.deserialize(msgValue));
                        if (pageCount == 1) {
                            long typeNumber = Long.parseLong((String)params.get("typeNumber"));
                            log.debug("set tianxiao pv=== msgKey:{},msgField:{},value:{}", new Object[]{msgKey, msgField, 2});
                            connection.hSet(serializer.serialize((Object)msgKey), serializer.serialize((Object)msgField), serializer.serialize((Object)String.valueOf(2)));
                        }
                    }
                }
                if (StatPageType.getWechatMsgList().contains(pageType)) {
                    msgValue = connection.hGet(serializer.serialize((Object)msgKey), serializer.serialize((Object)msgField));
                    if (msgValue == null) {
                        connection.hSet(serializer.serialize((Object)msgKey), serializer.serialize((Object)msgField), serializer.serialize((Object)String.valueOf(1)));
                    } else {
                        pageCount = Integer.parseInt((String)serializer.deserialize(msgValue));
                        if (pageCount == 1) {
                            connection.hSet(serializer.serialize((Object)msgKey), serializer.serialize((Object)msgField), serializer.serialize((Object)String.valueOf(2)));
                        }
                    }
                }
                log.debug("set tianxiao pv=== key:{},field:{},value:{}", new Object[]{"TX#MONITOR#PV#", pvField, count});
                return connection.hSet(key, field, serializer.serialize((Object)String.valueOf(count)));
            }
        });
        return result;
    }

    @Override
    public Integer getPV(Map<String, String> params) {
        String pvKey = "TX#MONITOR#PV#";
        final String pvField = this.getPvField(params.get("orgNumber"), params.get("userNumber"), params.get("uuid"), params.get("pageType"), params.get("typeNumber"));
        Integer pv = (Integer)this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = MonitorServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)"TX#MONITOR#PV#");
                byte[] field = serializer.serialize((Object)pvField);
                byte[] value = connection.hGet(key, field);
                if (value == null) {
                    return 0;
                }
                return Integer.parseInt((String)serializer.deserialize(value));
            }
        });
        log.info("set tianxiao pvKey:{}, pvField:{},value:{}", new Object[]{"TX#MONITOR#PV#", pvField, pv});
        return pv == null ? 0 : pv;
    }

    @Override
    public void cleanRedisMsg() {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = MonitorServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)MonitorServiceImpl.this.getMsgKey(DateUtil.getYesterday()));
                return connection.del((byte[][])new byte[][]{key});
            }
        });
    }

    @Override
    public synchronized Map<String, Integer> getFromRedisByMin() {
        String pvKey = "TX#MONITOR#PV#";
        Map result = (Map)this.redisTemplate.execute((RedisCallback)new RedisCallback<Map<String, Integer>>(){

            public Map<String, Integer> doInRedis(RedisConnection redisConnection) throws DataAccessException {
                redisConnection.select(6);
                RedisSerializer serializer = MonitorServiceImpl.this.getRedisSerializer();
                byte[] key = serializer.serialize((Object)"TX#MONITOR#PV#");
                HashMap result = Maps.newHashMap();
                Map map = redisConnection.hGetAll(key);
                log.info("yesterday pv number from redis is {}", (Object)map.size());
                for (byte[] oneKey : map.keySet()) {
                    byte[] oneValue = (byte[])map.get(oneKey);
                    result.put(serializer.deserialize(oneKey), Integer.parseInt((String)serializer.deserialize(oneValue)));
                }
                redisConnection.del((byte[][])new byte[][]{key});
                return result;
            }
        });
        log.debug("yesterday result  is {}", (Object)result);
        return result;
    }

    private String getMsgKey(String date) {
        StringBuilder sb = new StringBuilder();
        sb.append("TX#MESSAGE#PV#");
        sb.append("#");
        sb.append(date);
        return sb.toString();
    }

    private String getMsgField(String orgNumber, String userNumber, String uuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgNumber);
        sb.append("#");
        sb.append(userNumber);
        sb.append("#");
        sb.append(uuid);
        return sb.toString();
    }

    private String getPvField(String orgNumber, String userNumber, String uuid, String pageType, String typeNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgNumber);
        sb.append("#");
        sb.append(pageType);
        sb.append("#");
        sb.append(userNumber);
        sb.append("#");
        sb.append(uuid);
        sb.append("#");
        sb.append(typeNumber == null ? Integer.valueOf(0) : typeNumber);
        return sb.toString();
    }

    private boolean checkMarkdingStatus(long orgNumber) {
        boolean result = true;
        OrgAccount orgAccount = this.orgAccountDao.getAccountByNumber(Integer.valueOf((int)orgNumber), new String[0]);
        if (orgAccount != null) {
            try {
                OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(orgAccount.getId().intValue()));
                if (orgInfo.getMarkingStatus() == 1) {
                    result = false;
                }
            }
            catch (Exception e) {
                log.error("checkMarkdingStatus erreer ", (Throwable)e);
            }
        }
        log.debug("checkMarkdingStatus success orgAccount:{},result={}", (Object)orgAccount, (Object)result);
        return result;
    }
}

