package com.baijia.tianxiao.biz.dashboard.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.dashboard.constants.StatPageType;
import com.baijia.tianxiao.biz.dashboard.dto.MarkingOrg;
import com.baijia.tianxiao.biz.dashboard.dto.MarkingUser;
import com.baijia.tianxiao.biz.dashboard.service.MarkingMsgService;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.dao.TeacherCourseDao;
import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.course.po.TeacherCourse;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;

import lombok.extern.slf4j.Slf4j;

/**
 * 营销推送发消息  根据访问页面类型发送不同的消息内容
 * <p/>
 * Created by wengshengli on 16/1/4.
 */
@Service
@Slf4j
public class MarkingMsgServiceImpl implements MarkingMsgService {

    @Resource
    private ConsultMessageService consultMessageService;

    @Resource
    private OrgAccountService orgAccountService;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private VideoCourseDao videoCourseDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private TxConsultUserDao consultUserDao;

    @Resource
    private UserDao userDao;

    @Resource
    private StudentDao studentDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TeacherClassCourseDao teacherClassCourseDao;

    @Resource
    private TeacherCourseDao teacherCourseDao;
    
    @Autowired
	private ConsulterAPIService consulterAPIService;

    @Override
    public boolean sendMessage(Long orgNumber, long userNumber, int pageType, long typeNumber) {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(orgNumber.intValue());
        if (orgAccount == null) {
            return false;
        }
        MsgUser sender = builderSender(orgAccount.getId().longValue(), userNumber);
        MsgUser receiver = buildReceiver(orgAccount.getId().longValue(), orgNumber);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip marking  msg:{}", sender, receiver);
            return false;
        }
        ConsultMessage msgContent = buildPushMessageContent(sender, pageType, typeNumber);
        log.info("send marking msg sender:{},receiver:{},msgContent:{}", sender.getName(), receiver, msgContent);
        boolean result = consultMessageService.sendConsultMessage(sender, receiver, msgContent);
        log.info("send marking msg msg:{},sender:{},receiver:{},result:{}", msgContent, sender, receiver, result);

        return true;
    }

    private MsgUser builderSender(Long orgId, Long userNumber) {
        User user = userDao.getByNumber(userNumber);
        if (user == null) {
            return null;
        }

        String userName = "";
        long consultId = -1;//默认系统发送的消息,不需要consult_user

        Student student = studentDao.getByUserId(user.getId());
        if (student != null) {
            userName = student.getRealName();
        }

        List<TxConsultUser> consultUsers = consultUserDao.lookByUserId(orgId, student.getUserId());

        log.info("txbug== builderSender look orgId ={},userId = {}, txConsutUser ==={}", orgId, student.getUserId(), consultUsers);
        if (CollectionUtils.isNotEmpty(consultUsers)) {
            userName = consultUsers.get(0).getName();
            consultId = consultUsers.get(0).getId();
        } else {
            TxConsultUser txConsultUser = new TxConsultUser();
            txConsultUser.setName(student.getRealName());
            txConsultUser.setMobile(user.getMobile());
            txConsultUser.setDelStatus(DataStatus.NORMAL.getValue());
            txConsultUser.setConsultSource(MessageSource.MARKING.getValue());
            txConsultUser.setIntensionLevel(IntentionLevel.LEVEL_2.getValue());
            txConsultUser.setCascadeId(-1l);
            //consultUserDao.save(txConsultUser);
            consulterAPIService.saveConsultUser(txConsultUser);
            userName = txConsultUser.getName();
            consultId = txConsultUser.getId();
        }

        if (StringUtils.isBlank(userName)) {
            userName = "匿名用户";
        }

        return buildToMsgUser(consultId, userName, userNumber);
    }

    private MsgUser buildReceiver(final Long orgId, final Long orgNumber) {

        return new MarkingOrg(orgId, orgNumber);
    }

    private ConsultMessage buildPushMessageContent(MsgUser sender, int pageType, long typeNumber) {

        StringBuilder desc = new StringBuilder();
        desc.append("[").append(sender.getName()).append("]");
        desc.append("查看了");

        if (pageType == StatPageType.WEI_COURSE.getCode()) {
            OrgCourse orgCourse = orgCourseDao.getByCourseNumber(typeNumber);
            if (orgCourse == null) {
                return null;
            } else {
                desc.append(StatPageType.WEI_COURSE.getName());
                desc.append("【");
                desc.append(orgCourse.getName());
                desc.append("】");
            }
        } else if (pageType == StatPageType.VIDEO_COURSE.getCode()) {
            VideoCourse videoCourse = videoCourseDao.getByNumber(typeNumber);
            if (videoCourse == null) {
                return null;
            } else {
                desc.append(StatPageType.VIDEO_COURSE.getName());
                desc.append("【");
                desc.append(videoCourse.getName());
                desc.append("】");
            }
        } else if (pageType == StatPageType.ORG_TEACHER_DETAIL.getCode()) {
            Teacher teacher = teacherDao.getByNumber(typeNumber);
            if (teacher == null) {
                return null;
            } else {
                desc.append(StatPageType.ORG_TEACHER.getName());
                desc.append("【");
                desc.append(teacher.getRealName());
                desc.append("】");
            }
        } else if (pageType == StatPageType.CLASS_COURSE.getCode()) {
            TeacherClassCourse teacherClassCourse = teacherClassCourseDao.getByCouseNumber(typeNumber);
            if (teacherClassCourse == null) {
                return null;
            } else {
                desc.append(StatPageType.CLASS_COURSE.getName());
                desc.append("【");
                desc.append(teacherClassCourse.getName());
                desc.append("】");
            }
        } else if (pageType == StatPageType.ONEONE_COURSE.getCode()) {
            TeacherCourse teacherCourse = teacherCourseDao.getByCouseNumber(typeNumber);
            if (teacherCourse == null) {
                return null;
            } else {
                desc.append(StatPageType.ONEONE_COURSE.getName());
                desc.append("【");
                desc.append(teacherCourse.getName());
                desc.append("】");
            }
        }


        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(MessageSource.MARKING.getValue());
        pushMsg.setCreateTime(new Date());
        pushMsg.setMsgType(MsgType.TEXT.getValue());
        pushMsg.setContent(desc.toString());

        return pushMsg;
    }

    private MsgUser buildToMsgUser(long consultId, String userName, long userNumber) {
        MarkingUser user = new MarkingUser();
        user.setUserId(consultId);
        user.setUserNumber(userNumber);
        user.setName(userName);
        return user;
    }
}
