/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.dashboard.service.impl;

import com.baijia.tianxiao.biz.dashboard.service.ConsultStatRedisService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;

import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年10月24日
 * @desc
 */
@Service
@Slf4j
public class ConsultStatRedisServiceImpl extends AbstractBaseRedisDao<String, Object> implements ConsultStatRedisService{
    public final static String CONSULT_USER_ID_KEY = "TX#CONSULT#ID";

    @Override
    public void setConsultUserId(long orgId, long studentId, long userId, final long consultUserId) {
        final String key = CONSULT_USER_ID_KEY;
        final String fieldStr = getField(orgId, studentId, userId);
        redisTemplate.execute(new RedisCallback<Integer>() {
            @Override
            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] keyBytes = serializer.serialize(key);
                byte[] field = serializer.serialize(fieldStr);
                RedisSerializer redisSerializer = redisTemplate.getDefaultSerializer();
                byte[] value = redisSerializer.serialize(consultUserId);
                connection.hSet(keyBytes, field, value);
                log.info("[SysnSignupInfo] success to save consultId for for field : {} with consultId : {}  ", fieldStr, consultUserId);
                return null;
            }
        });
        
    }
    
    private String getField(long orgId, long studentId, long userId){
        String format = "%s_%s_%s";
        final String fieldStr = String.format(format, orgId, studentId, userId);
        return fieldStr;
    }

    @Override
    public Long getConsultIdFromRedis(long orgId, long studentId, long userId) {
        final String fieldStr = getField(orgId, studentId, userId);
        return redisTemplate.execute(new RedisCallback<Long>() {
            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = getRedisSerializer();
                byte[] keyBytes = serializer.serialize(CONSULT_USER_ID_KEY);
                byte[] field = serializer.serialize(fieldStr);
                RedisSerializer<?> redisSerializer = redisTemplate.getDefaultSerializer();
                byte[] value = connection.hGet(keyBytes, field);
                log.info("[SysnSignupInfo] getValue:{}", redisSerializer.deserialize(value));
                return (Long) redisSerializer.deserialize(value);
            }
        });
    }

}
