package com.baijia.tianxiao.biz.dashboard.constants;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by wengshengli on 15/12/25.
 */
public enum StatPageType {
    UNKONW(0, "UNKONW", "未知页"), ORG_INDEX(1, "ORG_INDEX", "首页"),
    // BLACKBOARD(2, "WX_INDEX", "黑板报"),
    ORG_COURSE(3, "BLACKBOARD", "课程"), ONEONE_COURSE(31, "ONEONE_COURSE", "一对一课程"), CLASS_COURSE(32, "CLASS_COURSE",
        "班课"), VIDEO_COURSE(33, "VIDEO_COURSE", "视频课"), WEI_COURSE(34, "WEI_COURSE", "微课"),
    // TRIAL_COURSE(35, "TRIAL_COURSE", "试听课"),
    ORG_TEACHER(4, "ORG_TEACHER", "老师"), ORG_TEACHER_DETAIL(41, "ORG_TEACHER_DETAIL", "老师详情"),
    // VIDEO(5, "VIDEO", "视频"),
    PHOTO(6, "PHOTO", "相册"), SCHOOL(7, "SCHOOL", "校区"),
    // COMMENT(8, "COMMENT", "评价"),
    // SUMMARY(9, "SUMMARY", "简介"),
    WE_SIGNUP(10, "WECHAT", "预约留单");

    private int code;
    private String key;
    private String name;

    StatPageType(int code, String key, String name) {
        this.code = code;
        this.key = key;
        this.name = name;
    }

    public static List<Integer> getSendMsgList() {
        List list = new ArrayList();
        list.addAll(getCourseList());
        list.add(ORG_TEACHER_DETAIL.getCode());
        return list;
    }

    public static List<Integer> getWechatMsgList() {
        List list = new ArrayList();
        list.add(10);// 微信不展示
        return list;
    }

    public static List<Integer> getAllTeacherList() {
        List list = new ArrayList();
        list.add(ORG_TEACHER.getCode());
        list.add(ORG_TEACHER_DETAIL.getCode());
        return list;
    }

    public static List<Integer> getAllCourseList() {
        List list = new ArrayList();
        list.add(ORG_COURSE.getCode());
        list.addAll(getCourseList());
        return list;
    }

    public static List<Integer> getCourseList() {
        List list = new ArrayList();
        list.add(ONEONE_COURSE.getCode());
        list.add(CLASS_COURSE.getCode());
        list.add(WEI_COURSE.getCode());
        list.add(VIDEO_COURSE.getCode());
        // list.add(TRIAL_COURSE.getCode());
        return list;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
