/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.service.MonitorService;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTodayMinDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTodayMin;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncMonitorMinService")
public class SyncMonitorMinServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncMonitorMinServiceImpl.class);
    @Resource
    private MonitorService monitorService;
    @Resource
    private TxMonitorTodayMinDao txMonitorTodayMinDao;

    @Override
    public void sync() {
        try {
            Map<String, Integer> map = this.monitorService.getFromRedisByMin();
            ArrayList<TxMonitorTodayMin> list = new ArrayList<TxMonitorTodayMin>();
            for (String key : map.keySet()) {
                log.debug("sync key is key {}", (Object)key);
                TxMonitorTodayMin one = TxMonitorTodayMin.build((String)key);
                if (one == null) continue;
                one.setMdate(new Date());
                one.setPv(map.get(key));
                TxMonitorTodayMin forUpdate = this.txMonitorTodayMinDao.getByKey(one.getOrgNumber(), one.getPageType().intValue(), one.getUserNumber(), one.getTypeNumber(), new String[0]);
                log.debug("sync forupdate is {}", (Object)forUpdate);
                if (forUpdate != null) {
                    forUpdate.setPv(Integer.valueOf(forUpdate.getPv() + one.getPv()));
                    forUpdate.setMdate(new Date());
                    this.txMonitorTodayMinDao.saveOrUpdate((Object)forUpdate, new String[0]);
                    continue;
                }
                list.add(one);
            }
            this.txMonitorTodayMinDao.saveAll(list, new String[0]);
        }
        catch (Exception e) {
            log.error("sync redis data errer {}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.UNKNOW);
        }
    }
}

