/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="syncConsultStatService")
public class SyncConsultStatServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncConsultStatServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private MessageDao messageDao;
    @Resource
    private ImMessageInfoDao imMessageInfoDao;
    @Resource
    private TxConsultStatMonthService txConsultStatMonthService;
    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;
    @Resource
    private OrgSignupInfoDao orgSingupInfoDao;
    @Resource
    private TxConsultUserDao txConsultUserDao;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private UserDao userDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    private AtomicBoolean msgFlag = new AtomicBoolean(false);
    private AtomicBoolean imFlag = new AtomicBoolean(false);
    private AtomicBoolean consultUserFlag = new AtomicBoolean(false);
    private AtomicBoolean signFlag = new AtomicBoolean(false);
    private AtomicBoolean purchase3810Flag = new AtomicBoolean(false);

    @Override
    @Transactional
    public void sync() {
        this.syncTask(MsgSyncType.CONSULT_MSG_STAT, this.msgFlag);
        this.syncTask(MsgSyncType.CONSULT_USER_STAT, this.consultUserFlag);
        this.syncTask(MsgSyncType.CONSULT_SIGNUP_STAT, this.signFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(syncType);
        try {
            if (!flag.get()) {
                log.info("sync consult stat info :{}", (Object)syncInfo);
                flag.set(true);
                switch (syncType) {
                    case CONSULT_MSG_STAT: {
                        this.syncConsultMessage(syncInfo);
                        break;
                    }
                    case CONSULT_IM_STAT: {
                        this.syncImMessageInfo(syncInfo);
                        break;
                    }
                    case CONSULT_USER_STAT: {
                        this.syncConsultUserInfo(syncInfo);
                        this.syncConsultUserByUpdate(syncInfo);
                        break;
                    }
                    case CONSULT_SIGNUP_STAT: {
                        this.syncSignupInfoByUpdate(syncInfo);
                        break;
                    }
                    case CONSULT_3810_PURCHASE_STAT: {
                        this.syncPurchase3810Info(syncInfo);
                        break;
                    }
                }
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            flag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncConsultMessage(TxMsgSyncTimestamp syncInfo) {
        List consultMessages = this.messageDao.getOrgStudentMessageListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[]{"senderId", "receiverId", "receiverRole", "consultType"});
        log.info("save consultMessages:{} success", (Object)consultMessages.size());
        if (CollectionUtils.isNotEmpty((Collection)consultMessages)) {
            for (ConsultMessage consultMessage : consultMessages) {
                log.info("\u83b7\u53d6\u7684\u65b0\u7684 consultMessage param:{}", (Object)consultMessage);
                Long receiverId = consultMessage.getReceiverId();
                log.info("consultMessage.getReceiverRole() param:{}", (Object)consultMessage.getReceiverRole());
                boolean isSubOrg = MsgUserRole.isSubOrg((int)consultMessage.getReceiverRole());
                if (isSubOrg) {
                    TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)receiverId, new String[0]);
                    log.info("cascadeAccount param:{}", (Object)cascadeAccount);
                    Long orgId = cascadeAccount.getOrgId().longValue();
                    consultMessage.setReceiverId(orgId.longValue());
                } else {
                    OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf((int)consultMessage.getReceiverId()));
                    if (GenericsUtils.notNullAndEmpty((Object)orgAccount)) {
                        consultMessage.setReceiverId((long)orgAccount.getId().intValue());
                    }
                }
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultMessage.getReceiverId(), consultMessage.getSenderId(), 0L, Integer.valueOf(consultMessage.getConsultType()), DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                log.info("txConsultUserStatMonth param:{}, consultMessage.getReceiverId() param:{}, consultMessage.getSenderId() param:{}", new Object[]{txConsultUserStatMonth, consultMessage.getReceiverId(), consultMessage.getSenderId()});
                TxConsultUserStatMonth txConsultUserBySenderId = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultMessage.getReceiverId(), consultMessage.getSenderId(), 0L, null, DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                Integer status = null;
                if (GenericsUtils.notNullAndEmpty((Object)txConsultUserBySenderId)) {
                    status = txConsultUserBySenderId.getStatus();
                }
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(Long.valueOf(consultMessage.getId()));
                }
                TxConsultUser txConsultUser = new TxConsultUser();
                if (consultMessage.getSenderId() == 0L) {
                    txConsultUser.setOrgId(Long.valueOf(consultMessage.getReceiverId()));
                    txConsultUser.setConsultSource(Integer.valueOf(consultMessage.getConsultType()));
                    this.txConsultUserDao.save((Object)txConsultUser, new String[0]);
                } else {
                    txConsultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)Long.valueOf(consultMessage.getSenderId()), new String[0]);
                }
                OrgStudent orgStudent = null;
                if (GenericsUtils.notNullAndEmpty((Object)txConsultUser)) {
                    Long userId = txConsultUser.getUserId();
                    Long orgId = txConsultUser.getOrgId();
                    Long studentId = txConsultUser.getStudentId();
                    orgStudent = studentId != null && studentId > 0L ? (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]) : this.orgStudentDao.getStudentByUserId(orgId, userId, new String[0]);
                }
                if (txConsultUserStatMonth == null) {
                    long userId;
                    long l = userId = txConsultUser == null ? 0L : txConsultUser.getUserId();
                    if (GenericsUtils.isNullOrEmpty((Object)status)) {
                        status = EncrollmentTypeEnum.WULEIXING.getValue();
                        if (orgStudent == null && ConsulterStatus.NOT.getValue() == txConsultUser.getIsConsulter().intValue()) {
                            status = EncrollmentTypeEnum.ZIXUN.getValue();
                        }
                    }
                    this.txConsultStatMonthService.saveStat(consultMessage.getReceiverId(), consultMessage.getSenderId(), userId, status.intValue(), consultMessage.getConsultType(), 1);
                    log.info("orgId() param:{}, consultUserId param:{}, consultUserId param:{}, status param:{}", new Object[]{txConsultUser.getOrgId(), txConsultUser.getId(), status});
                    continue;
                }
                log.info("not consultMessage consultId param:{}", (Object)consultMessage.getSenderId());
                if (GenericsUtils.isNullOrEmpty((Object)status)) {
                    status = EncrollmentTypeEnum.WULEIXING.getValue();
                    if (orgStudent == null && ConsulterStatus.NOT.getValue() == txConsultUser.getIsConsulter().intValue()) {
                        status = EncrollmentTypeEnum.ZIXUN.getValue();
                    }
                }
                txConsultUserStatMonth.setStatus(status);
                txConsultUserStatMonth.setSourceType(Integer.valueOf(consultMessage.getConsultType()));
                if (consultMessage.getConsultType() != MessageSource.WECHAT.getValue() && consultMessage.getConsultType() != MessageSource.ONLINE_IM.getValue() || !DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) {
                    txConsultUserStatMonth.setUserId(Long.valueOf(txConsultUser == null ? 0L : txConsultUser.getUserId()));
                    txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                    txConsultUserStatMonth.setUpdateTime(new Date());
                }
                log.debug("syncConsultMessage update:{}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncImMessageInfo(TxMsgSyncTimestamp syncInfo) {
        List messageInfos = this.imMessageInfoDao.getOrgStudentInfoListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save messageInfos:{} success", (Object)messageInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)messageInfos)) {
            for (ImMessageInfo msgInfo : messageInfos) {
                User user;
                OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(msgInfo.getReceiver().intValue()));
                if (orgAccount == null || (user = this.userDao.getByNumber(msgInfo.getSender(), new String[0])) == null) continue;
                msgInfo.setReceiver(Long.valueOf(orgAccount.getId().intValue()));
                msgInfo.setSender(user.getId());
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(msgInfo.getReceiver().longValue(), 0L, msgInfo.getSender().longValue(), Integer.valueOf(MessageSource.ONLINE_IM.getValue()), startDate, endDate);
                if (msgInfo.getMsgId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(msgInfo.getMsgId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(msgInfo.getReceiver(), msgInfo.getSender(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(msgInfo.getReceiver().longValue(), consultUserId, msgInfo.getSender().longValue(), EncrollmentTypeEnum.ZIXUN.getValue(), MessageSource.ONLINE_IM.getValue(), 1);
                    continue;
                }
                if (DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) continue;
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(msgInfo.getSender());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncImMessageInfo update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncConsultUserByUpdate(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByUpdateTime(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("====save signupInfos updateTime:{} success, consultUsers param:{}", (Object)consultUsers.size(), (Object)consultUsers);
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Integer status;
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), 0L, consultUser.getConsultSource(), startDate, endDate);
                log.info("update TxConsultUserStatMonth param:{}", (Object)txConsultUserStatMonth);
                if (consultUser.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(consultUser.getUpdateTime());
                }
                OrgStudent orgStudent = this.getOrgStudentByConsultUser(consultUser);
                if (txConsultUserStatMonth != null) {
                    status = txConsultUserStatMonth.getStatus();
                    status = this.getStatusByConsultUser(status, consultUser, orgStudent, startDate);
                    txConsultUserStatMonth.setStatus(status);
                    txConsultUserStatMonth.setUpdateTime(new Date());
                    this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
                    log.info("orgId() param:{}, txConsultUserStatMonth param:{}, consultUserId param:{}, status param:{},", new Object[]{consultUser.getOrgId(), txConsultUserStatMonth, consultUser.getUserId(), status});
                    continue;
                }
                status = EncrollmentTypeEnum.WULEIXING.getValue();
                status = this.getStatusByConsultUser(status, consultUser, orgStudent, startDate);
                this.insertTXConsultUserStatMonth(consultUser, status);
                log.info("orgId() param:{}, txConsultUserStatMonth param:{}, consultUserId param:{}, status param:{}", new Object[]{consultUser.getOrgId(), txConsultUserStatMonth, consultUser.getUserId(), status});
            }
        }
    }

    private void syncConsultUserInfo(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save consultUserInfo:{} success", (Object)consultUsers.size());
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), 0L, consultUser.getConsultSource(), startDate, endDate);
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }
                if (txConsultUserStatMonth == null) {
                    Integer status = EncrollmentTypeEnum.WULEIXING.getValue();
                    OrgStudent orgStudent = this.getOrgStudentByConsultUser(consultUser);
                    status = this.getStatusByConsultUser(status, consultUser, orgStudent, startDate);
                    this.insertTXConsultUserStatMonth(consultUser, status);
                    log.info("orgId() param:{}, consultUserId param:{}, consultUserId param:{}, status param:{}", new Object[]{consultUser.getOrgId(), consultUser.getId(), status});
                    continue;
                }
                if ((consultUser.getConsultSource().intValue() == MessageSource.WECHAT.getValue() || consultUser.getConsultSource().intValue() == MessageSource.ONLINE_IM.getValue() || ConsulterStatus.IS.getValue() != consultUser.getIsConsulter().intValue()) && DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) continue;
                txConsultUserStatMonth.setConsultUserId(consultUser.getId());
                txConsultUserStatMonth.setUserId(consultUser.getUserId());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncConsultUserInfo update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncSignupInfo(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSingupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info(" \u62a5\u540d save signupInfos:{} success", (Object)signupInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                log.info("signupInfo =============== param:{}", (Object)signupInfo);
                if (signupInfo.getUserId() == 0L) continue;
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(signupInfo.getOrgId().longValue(), 0L, signupInfo.getUserId().longValue(), null, startDate, endDate);
                if (signupInfo.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(signupInfo.getId());
                }
                this.setSyncTxConsultUserStatMonthByOrgSignupInfo(signupInfo, txConsultUserStatMonth);
            }
        }
    }

    private void syncSignupInfoByUpdate(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSingupInfoDao.getOrgSignupListByUpdate(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save signupInfos by updateTime:{} success, consultUsers param:{}", (Object)signupInfos.size(), (Object)signupInfos);
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                log.info("signupInfo =============== param:{}", (Object)signupInfo);
                if (signupInfo.getUserId() == 0L) continue;
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(signupInfo.getOrgId().longValue(), 0L, signupInfo.getUserId().longValue(), null, startDate, endDate);
                if (signupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(signupInfo.getUpdateTime());
                }
                this.setSyncTxConsultUserStatMonthByOrgSignupInfo(signupInfo, txConsultUserStatMonth);
            }
        }
    }

    private void setSyncTxConsultUserStatMonthByOrgSignupInfo(OrgSignupInfo signupInfo, TxConsultUserStatMonth txConsultUserStatMonth) {
        List txConsultUserList = this.txConsultUserDao.lookByUserId(signupInfo.getOrgId(), signupInfo.getUserId(), new String[0]);
        log.info("\u83b7\u53d6 txConsultUserList param:{}", (Object)txConsultUserList);
        long consultUserId = 0L;
        if (txConsultUserList != null && txConsultUserList.size() > 0) {
            consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
        } else {
            TxConsultUser txConsultUser = this.getTxConsultUser(signupInfo);
            this.txConsultUserDao.save((Object)txConsultUser, new String[0]);
            consultUserId = txConsultUser.getId();
            log.info("\u65b0\u63d2txConsultUser param:{}", (Object)txConsultUser);
        }
        if (txConsultUserStatMonth == null) {
            int status = EncrollmentTypeEnum.WULEIXING.getValue();
            List SPLIT_CODES_FINISHED = Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.FAIL.getCode(), SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode()});
            int del = signupInfo.getIsDel().intValue();
            int purchaseStatus = signupInfo.getPurchaseStatus().intValue();
            if (del == 0 && SPLIT_CODES_FINISHED.contains(signupInfo.getSplitResult()) && purchaseStatus == PayResult.SUCCESS.getCode()) {
                status = EncrollmentTypeEnum.BAOMING.getValue();
            }
            this.txConsultStatMonthService.saveStat(signupInfo.getOrgId().longValue(), consultUserId, signupInfo.getUserId().longValue(), status, MessageSource.APPOINTMENT.getValue(), 1);
        } else {
            int status = txConsultUserStatMonth.getStatus();
            List SPLIT_CODES_FINISHED = Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.FAIL.getCode(), SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode()});
            int del = signupInfo.getIsDel().intValue();
            int purchaseStatus = signupInfo.getPurchaseStatus().intValue();
            if (del == 0 && SPLIT_CODES_FINISHED.contains(signupInfo.getSplitResult()) && purchaseStatus == PayResult.SUCCESS.getCode()) {
                status = EncrollmentTypeEnum.BAOMING.getValue();
            }
            txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
            txConsultUserStatMonth.setUserId(signupInfo.getUserId());
            txConsultUserStatMonth.setUpdateTime(new Date());
            txConsultUserStatMonth.setStatus(Integer.valueOf(status));
            log.debug("syncSignupInfo update :{}", (Object)txConsultUserStatMonth);
            this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
        }
    }

    private TxConsultUser getTxConsultUser(OrgSignupInfo signupInfo) {
        Long userId = signupInfo.getUserId();
        Long orgId = signupInfo.getOrgId();
        TxConsultUser txConsultUser = new TxConsultUser();
        txConsultUser.setUserId(userId);
        txConsultUser.setOrgId(orgId);
        txConsultUser.setName(signupInfo.getStudentName());
        txConsultUser.setConsultSource(Integer.valueOf(MessageSource.APPOINTMENT.getValue()));
        txConsultUser.setIntensionLevel(Integer.valueOf(IntentionLevel.LEVEL_2.getValue()));
        txConsultUser.setIsConsulter(Integer.valueOf(ConsulterStatus.NOT.getValue()));
        txConsultUser.setConsultStatus(Integer.valueOf(ConsultUserStatus.HAS.getValue()));
        txConsultUser.setMobile(signupInfo.getMobile());
        return txConsultUser;
    }

    private void syncPurchase3810Info(TxMsgSyncTimestamp syncInfo) {
        List coursePurchases = this.coursePurchaseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, Integer.valueOf(CourseType.ORG_COURSE.getCode()), null, Integer.valueOf(1), new String[0]);
        log.info("save coursePurchases:{} success", (Object)coursePurchases.size());
        if (CollectionUtils.isNotEmpty((Collection)coursePurchases)) {
            for (CoursePurchase coursePurchase : coursePurchases) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(coursePurchase.getOrgId().longValue(), 0L, coursePurchase.getUserId().longValue(), Integer.valueOf(0), startDate, endDate);
                if (coursePurchase.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(coursePurchase.getId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(coursePurchase.getOrgId(), coursePurchase.getUserId(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(coursePurchase.getOrgId().longValue(), consultUserId, coursePurchase.getUserId().longValue(), EncrollmentTypeEnum.BAOMING.getValue(), MessageSource.APPOINTMENT.getValue(), 1);
                    continue;
                }
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(coursePurchase.getUserId());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncPurchase3810Info update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }

    private OrgStudent getOrgStudentByConsultUser(TxConsultUser consultUser) {
        Long userId = consultUser.getUserId();
        Long orgId = consultUser.getOrgId();
        Long studentId = consultUser.getStudentId();
        OrgStudent orgStudent = null;
        orgStudent = studentId != null && studentId > 0L ? (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]) : this.orgStudentDao.getStudentByUserId(orgId, userId, new String[0]);
        return orgStudent;
    }

    private void insertTXConsultUserStatMonth(TxConsultUser consultUser, int status) {
        log.info("@@@@@@@@ A ");
        if (ConsulterStatus.IS.getValue() == consultUser.getIsConsulter().intValue()) {
            log.info("@@@@@@@@ B1 ");
            this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status, consultUser.getConsultSource().intValue(), 1);
            log.info("@@@@@@@@ B2 ");
        } else {
            log.info("@@@@@@@@ C1 ");
            this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status, consultUser.getConsultSource().intValue(), 0);
            log.info("@@@@@@@@ 1 ");
        }
    }

    private Integer getStatusByConsultUser(Integer status, TxConsultUser consultUser, OrgStudent orgStudent, Date startDate) {
        Date lastRemindTime = consultUser.getLastRemindTime();
        if (GenericsUtils.isNullOrEmpty((Object)orgStudent)) {
            if (ConsulterStatus.IS.getValue() == consultUser.getIsConsulter().intValue()) {
                List<Integer> intentionLevelZGs;
                if (lastRemindTime != null && lastRemindTime.after(startDate)) {
                    status = EncrollmentTypeEnum.GOUTONG.getValue();
                }
                if ((intentionLevelZGs = Arrays.asList(IntentionLevel.LEVEL_2.getValue(), IntentionLevel.LEVEL_3.getValue())).contains(consultUser.getIntensionLevel())) {
                    status = EncrollmentTypeEnum.YIXIANG.getValue();
                }
            } else {
                status = EncrollmentTypeEnum.ZIXUN.getValue();
            }
        } else if (status.intValue() != EncrollmentTypeEnum.BAOMING.getValue()) {
            status = EncrollmentTypeEnum.WULEIXING.getValue();
        }
        return status;
    }
}

