/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.constants.EncrollmentTypeEnum;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncConsultStatService")
public class SyncConsultStatServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncConsultStatServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private MessageDao messageDao;
    @Resource
    private ImMessageInfoDao imMessageInfoDao;
    @Resource
    private TxConsultStatMonthService txConsultStatMonthService;
    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;
    @Resource
    private OrgSignupInfoDao orgSingupInfoDao;
    @Resource
    private TxConsultUserDao txConsultUserDao;
    @Resource
    private OrgAccountService orgAccountService;
    @Resource
    private CoursePurchaseDao coursePurchaseDao;
    @Resource
    private UserDao userDao;
    private AtomicBoolean msgFlag = new AtomicBoolean(false);
    private AtomicBoolean imFlag = new AtomicBoolean(false);
    private AtomicBoolean consultUserFlag = new AtomicBoolean(false);
    private AtomicBoolean signFlag = new AtomicBoolean(false);
    private AtomicBoolean purchase3810Flag = new AtomicBoolean(false);

    @Override
    public void sync() {
        this.syncTask(MsgSyncType.CONSULT_MSG_STAT, this.msgFlag);
        this.syncTask(MsgSyncType.CONSULT_IM_STAT, this.imFlag);
        this.syncTask(MsgSyncType.CONSULT_USER_STAT, this.consultUserFlag);
        this.syncTask(MsgSyncType.CONSULT_SIGNUP_STAT, this.signFlag);
        this.syncTask(MsgSyncType.CONSULT_3810_PURCHASE_STAT, this.purchase3810Flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(syncType);
        try {
            if (!flag.get()) {
                log.info("sync consult stat info :{}", (Object)syncInfo);
                flag.set(true);
                switch (syncType) {
                    case CONSULT_MSG_STAT: {
                        this.syncConsultMessage(syncInfo);
                        break;
                    }
                    case CONSULT_IM_STAT: {
                        this.syncImMessageInfo(syncInfo);
                        break;
                    }
                    case CONSULT_USER_STAT: {
                        this.syncConsultUserInfo(syncInfo);
                        this.syncConsultUserByUpdate(syncInfo);
                        break;
                    }
                    case CONSULT_SIGNUP_STAT: {
                        this.syncSignupInfo(syncInfo);
                        break;
                    }
                    case CONSULT_3810_PURCHASE_STAT: {
                        this.syncPurchase3810Info(syncInfo);
                        break;
                    }
                }
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            flag.set(false);
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncConsultMessage(TxMsgSyncTimestamp syncInfo) {
        List consultMessages = this.messageDao.getOrgStudentMessageListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save consultMessages:{} success", (Object)consultMessages.size());
        if (CollectionUtils.isNotEmpty((Collection)consultMessages)) {
            for (ConsultMessage consultMessage : consultMessages) {
                OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf((int)consultMessage.getReceiverId()));
                if (orgAccount == null) continue;
                consultMessage.setReceiverId((long)orgAccount.getId().intValue());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultMessage.getReceiverId(), consultMessage.getSenderId(), 0L, consultMessage.getConsultType(), DateUtil.getFirstDate((Date)new Date()), DateUtil.getNextMonthFirstDate((Date)new Date()));
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(Long.valueOf(consultMessage.getId()));
                }
                TxConsultUser txConsultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)Long.valueOf(consultMessage.getSenderId()), new String[0]);
                if (txConsultUserStatMonth == null) {
                    long userId = txConsultUser == null ? 0L : txConsultUser.getUserId();
                    int status = EncrollmentTypeEnum.ZIXUN.getValue();
                    if (consultMessage.getConsultType() == ConsultType.APPOINTMENT.getValue()) {
                        status = EncrollmentTypeEnum.YIXIANG.getValue();
                    }
                    this.txConsultStatMonthService.saveStat(consultMessage.getReceiverId(), consultMessage.getSenderId(), userId, status, consultMessage.getConsultType(), 1);
                    continue;
                }
                if ((consultMessage.getConsultType() == ConsultType.WECHAT.getValue() || consultMessage.getConsultType() == ConsultType.ONLINE_IM.getValue()) && DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) continue;
                txConsultUserStatMonth.setUserId(Long.valueOf(txConsultUser == null ? 0L : txConsultUser.getUserId()));
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncConsultMessage update:{}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncImMessageInfo(TxMsgSyncTimestamp syncInfo) {
        List messageInfos = this.imMessageInfoDao.getOrgStudentInfoListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save messageInfos:{} success", (Object)messageInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)messageInfos)) {
            for (ImMessageInfo msgInfo : messageInfos) {
                User user;
                OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(Integer.valueOf(msgInfo.getReceiver().intValue()));
                if (orgAccount == null || (user = this.userDao.getByNumber(msgInfo.getSender(), new String[0])) == null) continue;
                msgInfo.setReceiver(Long.valueOf(orgAccount.getId().intValue()));
                msgInfo.setSender(user.getId());
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(msgInfo.getReceiver().longValue(), 0L, msgInfo.getSender().longValue(), ConsultType.ONLINE_IM.getValue(), startDate, endDate);
                if (msgInfo.getMsgId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(msgInfo.getMsgId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(msgInfo.getReceiver(), msgInfo.getSender(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(msgInfo.getReceiver().longValue(), consultUserId, msgInfo.getSender().longValue(), EncrollmentTypeEnum.ZIXUN.getValue(), ConsultType.ONLINE_IM.getValue(), 1);
                    continue;
                }
                if (DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) continue;
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(msgInfo.getSender());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncImMessageInfo update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncConsultUserByUpdate(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByUpdateTime(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save signupInfos updateTime:{} success", (Object)consultUsers.size());
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), 0L, 0, startDate, endDate);
                if (consultUser.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(consultUser.getUpdateTime());
                }
                if (txConsultUserStatMonth == null) continue;
                int status = EncrollmentTypeEnum.ZIXUN.getValue();
                if (consultUser.getIntensionLevel() > 0) {
                    status = EncrollmentTypeEnum.YIXIANG.getValue();
                } else if (consultUser.getConsultStatus() == ConsultUserStatus.HAS.getValue()) {
                    status = EncrollmentTypeEnum.GOUTONG.getValue();
                }
                txConsultUserStatMonth.setStatus(Integer.valueOf(status));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncConsultUserByUpdate  update :{}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncConsultUserInfo(TxMsgSyncTimestamp syncInfo) {
        List consultUsers = this.txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save signupInfos:{} success", (Object)consultUsers.size());
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), 0L, 0, startDate, endDate);
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }
                if (txConsultUserStatMonth == null) {
                    int status = EncrollmentTypeEnum.ZIXUN.getValue();
                    if (consultUser.getIntensionLevel() > 0) {
                        status = EncrollmentTypeEnum.YIXIANG.getValue();
                    } else if (consultUser.getConsultStatus() == ConsultUserStatus.HAS.getValue()) {
                        status = EncrollmentTypeEnum.GOUTONG.getValue();
                    }
                    this.txConsultStatMonthService.saveStat(consultUser.getOrgId().longValue(), consultUser.getId().longValue(), consultUser.getUserId().longValue(), status, consultUser.getConsultSource().intValue(), 1);
                    continue;
                }
                if ((consultUser.getConsultSource().intValue() == ConsultType.WECHAT.getValue() || consultUser.getConsultSource().intValue() == ConsultType.ONLINE_IM.getValue()) && DateUtil.isToday((Date)txConsultUserStatMonth.getUpdateTime())) continue;
                txConsultUserStatMonth.setConsultUserId(consultUser.getId());
                txConsultUserStatMonth.setUserId(consultUser.getUserId());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncConsultUserInfo update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncSignupInfo(TxMsgSyncTimestamp syncInfo) {
        List signupInfos = this.orgSingupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        log.info("save signupInfos:{} success", (Object)signupInfos.size());
        if (CollectionUtils.isNotEmpty((Collection)signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(signupInfo.getOrgId().longValue(), 0L, signupInfo.getUserId().longValue(), 0, startDate, endDate);
                if (signupInfo.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(signupInfo.getId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(signupInfo.getOrgId(), signupInfo.getUserId(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(signupInfo.getOrgId().longValue(), consultUserId, signupInfo.getUserId().longValue(), EncrollmentTypeEnum.BAOMING.getValue(), ConsultType.APPOINTMENT.getValue(), 1);
                    continue;
                }
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(signupInfo.getUserId());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncSignupInfo update :{}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private void syncPurchase3810Info(TxMsgSyncTimestamp syncInfo) {
        List coursePurchases = this.coursePurchaseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, Integer.valueOf(CourseType.ORG_COURSE.getCode()), Integer.valueOf(1), new String[0]);
        log.info("save coursePurchases:{} success", (Object)coursePurchases.size());
        if (CollectionUtils.isNotEmpty((Collection)coursePurchases)) {
            for (CoursePurchase coursePurchase : coursePurchases) {
                Date startDate = DateUtil.getFirstDate((Date)new Date());
                Date endDate = DateUtil.getNextMonthFirstDate((Date)new Date());
                TxConsultUserStatMonth txConsultUserStatMonth = this.txConsultUserStatMonthDao.getTxConsultStatByQuery(coursePurchase.getOrgId().longValue(), 0L, coursePurchase.getUserId().longValue(), 0, startDate, endDate);
                if (coursePurchase.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(coursePurchase.getId());
                }
                List txConsultUserList = this.txConsultUserDao.lookByUserId(coursePurchase.getOrgId(), coursePurchase.getUserId(), new String[0]);
                long consultUserId = 0L;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = ((TxConsultUser)txConsultUserList.get(0)).getId();
                }
                if (txConsultUserStatMonth == null) {
                    this.txConsultStatMonthService.saveStat(coursePurchase.getOrgId().longValue(), consultUserId, coursePurchase.getUserId().longValue(), EncrollmentTypeEnum.BAOMING.getValue(), ConsultType.APPOINTMENT.getValue(), 1);
                    continue;
                }
                txConsultUserStatMonth.setConsultUserId(Long.valueOf(consultUserId));
                txConsultUserStatMonth.setUserId(coursePurchase.getUserId());
                txConsultUserStatMonth.setNumber(Integer.valueOf(txConsultUserStatMonth.getNumber() + 1));
                txConsultUserStatMonth.setUpdateTime(new Date());
                log.debug("syncPurchase3810Info update {}", (Object)txConsultUserStatMonth);
                this.txConsultUserStatMonthDao.update((Object)txConsultUserStatMonth, new String[0]);
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

