package com.baijia.tianxiao.biz.dashboard.sync.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.dashboard.service.MonitorService;
import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.dal.sync.dao.TxMonitorTodayMinDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTodayMin;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;

import lombok.extern.slf4j.Slf4j;

/**
 * 每分钟从redis中下载数据入库
 * <p/>
 * 所以报表中的统计数据,会延时一分钟
 * Created by wengshengli on 15/12/26.
 */
@Service("syncMonitorMinService")
@Slf4j
public class SyncMonitorMinServiceImpl implements SyncDataService {

    @Resource
    private MonitorService monitorService;

    @Resource
    private TxMonitorTodayMinDao txMonitorTodayMinDao;


    @Override
    public void sync() {
        try {

            Map<String, Integer> map = monitorService.getFromRedisByMin();

            List<TxMonitorTodayMin> list = new ArrayList<TxMonitorTodayMin>();

            Iterator<String> iterator = map.keySet().iterator();

            while (iterator.hasNext()) {

                String key = iterator.next();
                log.debug("sync key is key {}", key);
                TxMonitorTodayMin one = TxMonitorTodayMin.build(key);
                if (one == null) {
                    continue;
                }
                one.setMdate(new Date());
                one.setPv(map.get(key));
                TxMonitorTodayMin forUpdate = txMonitorTodayMinDao.getByKey(one.getOrgNumber(), one.getPageType(), one.getUserNumber(), one.getUuid(), one.getTypeNumber());

                log.debug("sync forupdate is {}", forUpdate);
                if (forUpdate != null) {
                    forUpdate.setPv(forUpdate.getPv() + one.getPv());
                    forUpdate.setMdate(new Date());
                    txMonitorTodayMinDao.saveOrUpdate(forUpdate);
                    continue;
                }
                list.add(one);
            }

            txMonitorTodayMinDao.saveAll(list);
        } catch (Exception e) {
            log.error("sync redis data errer {}", e);
            throw new BussinessException(CommonErrorCode.UNKNOW);
        }
    }

}
