/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.dashboard.sync.impl;

import com.baijia.tianxiao.biz.dashboard.sync.SyncDataService;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterStatus;
import com.baijia.tianxiao.dal.roster.constant.EncrollmentTypeEnum;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxConsultSourceStatisticMonthDao;
import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultSourceStatisticMonth;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.statistics.TxConsultSourceStatisticMonthService;
import com.baijia.tianxiao.sal.statistics.TxConsultStatMonthService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author gaodan
 * @createdate 2016年8月26日
 * @desc
 */
@Slf4j
@Service("syncConsultStatService")
public class SyncConsultStatServiceImpl implements SyncDataService {
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private MessageDao messageDao;

    @Resource
    private ImMessageInfoDao imMessageInfoDao;

    @Resource
    private TxConsultStatMonthService txConsultStatMonthService;

    @Resource
    private TxConsultUserStatMonthDao txConsultUserStatMonthDao;

    @Resource
    private OrgSignupInfoDao orgSingupInfoDao;

    @Resource
    private TxConsultUserDao txConsultUserDao;

    @Resource
    private OrgAccountService orgAccountService;

    @Resource
    private CoursePurchaseDao coursePurchaseDao;

    @Resource
    private UserDao userDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Autowired
    private TxConsultSourceStatisticMonthDao txConsultSourceStatisticMonthDao;
    @Autowired
    private TxConsultSourceStatisticMonthService txConsultSourceStatisticMonthService;

    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;

    private AtomicBoolean msgFlag = new AtomicBoolean(false);
    private AtomicBoolean imFlag = new AtomicBoolean(false);
    private AtomicBoolean consultUserFlag = new AtomicBoolean(false);
    private AtomicBoolean signFlag = new AtomicBoolean(false);
    private AtomicBoolean purchase3810Flag = new AtomicBoolean(false);

    @Transactional
    @Override
    public void sync() {

        /**
         * 从运营的消息内容体中同步
         */
        syncTask(MsgSyncType.CONSULT_MSG_STAT, msgFlag);

        /**
         * 按照tx_message_record同步消息来源
         */
        syncTask(MsgSyncType.MESSAGE_RECORD_SOURCE, msgFlag);

        /**
         * 按照tx_consult_user同步消息来源
         */
        syncTask(MsgSyncType.CONSULT_USER_SOURCE, consultUserFlag);

        /**
         * 从hermes的IM消息中同步(主站的消息去掉)
         */
        // syncTask(MsgSyncType.CONSULT_IM_STAT, imFlag);

        /**
         * 从咨询用户中同步
         */
        syncTask(MsgSyncType.CONSULT_USER_STAT, consultUserFlag);

        /**
         * 从报名系统中同步
         */
        syncTask(MsgSyncType.CONSULT_SIGNUP_STAT, signFlag);

        /**
         * 3810课程成单同步(去掉主站的订单会同步过来成报名信息的)
         */
        // syncTask(MsgSyncType.CONSULT_3810_PURCHASE_STAT, purchase3810Flag);

    }

    private void syncTask(MsgSyncType syncType, AtomicBoolean flag) {
        TxMsgSyncTimestamp syncInfo = getSyncInfo(syncType);
        try {
            if (!flag.get()) {
                log.info("sync consult stat info :{}", syncInfo);
                flag.set(true);
                switch (syncType) {
                    case CONSULT_MSG_STAT:
                        syncConsultMessage(syncInfo);
                        break;
                    case CONSULT_IM_STAT:
                        syncImMessageInfo(syncInfo);
                        break;
                    case CONSULT_USER_STAT:
                        syncConsultUserInfo(syncInfo);// 按id新增
                        syncConsultUserByUpdate(syncInfo);// 按更新时间同步
                        break;
                    case CONSULT_SIGNUP_STAT:
                        // syncSignupInfo(syncInfo); //按id新增
                        syncSignupInfoByUpdate(syncInfo); // 按更新时间同步
                        break;
                    case CONSULT_3810_PURCHASE_STAT:
                        syncPurchase3810Info(syncInfo);
                        break;
                    case MESSAGE_RECORD_SOURCE:
                        syncSouceByConsultMessage(syncInfo);
                        break;
                    case CONSULT_USER_SOURCE:
                        syncSouceByConsultUser(syncInfo);
                        break;
                    default:
                        break;
                }
                flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            flag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    // tx_message_record统计咨询来源
    private void syncSouceByConsultMessage(TxMsgSyncTimestamp syncInfo) {
        List<ConsultMessage> consultMessages = messageDao.getOrgStudentMessageListByMinId(syncInfo.getSyncId(),
            syncInfo.getSyncTime(), 100, "senderId", "receiverId", "receiverRole", "consultType");
        log.info("[SysConsultMessage] save consultMessages:{} success", consultMessages.size());
        if (CollectionUtils.isNotEmpty(consultMessages)) {
            for (ConsultMessage consultMessage : consultMessages) {
                // 按照consultId和orgId判断本月状态监控表
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultMessage.getId());
                }

                // 查询用户咨询来源统计
                TxConsultSourceStatisticMonth txConsultSourceStatisticMonth =
                    txConsultSourceStatisticMonthDao.getTxConsultSourceStatisticMonthBySource(consultMessage.getOrgId(),
                        consultMessage.getSenderId(), consultMessage.getConsultType(),
                        DateUtil.getFirstDate(new Date()), DateUtil.getNextMonthFirstDate(new Date()));
                log.info("[SysConsultMessage] txConsultSourceStatisticMonth param:{}", txConsultSourceStatisticMonth);

                TxConsultUser txConsultUser = new TxConsultUser();
                if (consultMessage.getSenderId() == 0) {
                    txConsultUser.setOrgId(consultMessage.getReceiverId());
                    txConsultUser.setConsultSource(consultMessage.getConsultType());
                    txConsultUserDao.save(txConsultUser);
                } else {
                    txConsultUser = txConsultUserDao.getById(consultMessage.getSenderId());
                }
                // 统计用户咨询来源
                if (txConsultSourceStatisticMonth == null) {
                    Long id = txConsultSourceStatisticMonthService.saveTxConsultSourceStatisticMonth(
                        consultMessage.getOrgId(), consultMessage.getSenderId(), consultMessage.getConsultType(), 1);
                    log.info(
                        "[SysConsultMessage] save souceStatistic txConsultSourceStatisticMonthId param:{}, orgId param:{}, consultId param:{}",
                        id, consultMessage.getOrgId(), consultMessage.getSenderId(), consultMessage.getConsultType());
                } else {
                    /**
                     * 微信和IM 当天有更新 不更新记录更新次数
                     */
                    log.info("[SysConsultMessage] update souceStatistic txConsultSourceStatisticMonth param:{}",
                        txConsultSourceStatisticMonth);
                    if (consultMessage.getConsultType() != MessageSource.WECHAT.getValue()
                        && consultMessage.getConsultType() != MessageSource.ONLINE_IM.getValue()
                        || !DateUtil.isToday(txConsultSourceStatisticMonth.getUpdateTime())) {
                        txConsultSourceStatisticMonth.setNumber(txConsultSourceStatisticMonth.getNumber() + 1);
                        txConsultSourceStatisticMonth.setUpdateTime(new Date());
                        txConsultSourceStatisticMonthDao.update(txConsultSourceStatisticMonth);
                        log.info("[SysConsultMessage] update souceStatistic param:{}", txConsultSourceStatisticMonth);
                    }
                }
            }
        }

    }

    // tx_consult_user统计咨询来源
    private void syncSouceByConsultUser(TxMsgSyncTimestamp syncInfo) {
        List<TxConsultUser> consultUsers =
            txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);
        log.info("[SysnConsultUser] save consultUser size:{} success", consultUsers.size());

        if (CollectionUtils.isNotEmpty(consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }

                // 查询用户咨询来源统计
                TxConsultSourceStatisticMonth txConsultSourceStatisticMonth =
                    txConsultSourceStatisticMonthDao.getTxConsultSourceStatisticMonthBySource(consultUser.getOrgId(),
                        consultUser.getId(), consultUser.getConsultSource(), DateUtil.getFirstDate(new Date()),
                        DateUtil.getNextMonthFirstDate(new Date()));
                // 当不是线索的时候不需要统计咨询来源，因为在message_record里已经统计了
                if (txConsultSourceStatisticMonth == null
                    && consultUser.getIsConsulter() == ConsulterStatus.IS.getValue()) {
                    txConsultSourceStatisticMonthService.saveTxConsultSourceStatisticMonth(consultUser.getOrgId(),
                        consultUser.getId(), consultUser.getConsultSource(), 1);
                }
            }
        }

    }

    // 轮回统计 监控consultMessageRecord
    private void syncConsultMessage(TxMsgSyncTimestamp syncInfo) {
        List<ConsultMessage> consultMessages = messageDao.getOrgStudentMessageListByMinId(syncInfo.getSyncId(),
            syncInfo.getSyncTime(), 100, "senderId", "receiverId", "receiverRole", "consultType");
        log.info("[SysConsultMessage] save consultMessages:{} success", consultMessages.size());
        if (CollectionUtils.isNotEmpty(consultMessages)) {
            for (ConsultMessage consultMessage : consultMessages) {
                // 按照consultId和orgId判断本月状态监控表
                log.info("[SysConsultMessage] messageId:{}", consultMessage.getId());
                if (consultMessage.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultMessage.getId());
                }

                // 查询用户用户状态
                log.info("[SysConsultMessage] consultMessages param:{}", consultMessage);
                TxConsultUserStatMonth txConsultUserStatMonth = txConsultUserStatMonthDao.getTxConsultStatByQuery(
                    consultMessage.getOrgId(), consultMessage.getSenderId(), 0, null, DateUtil.getFirstDate(new Date()),
                    DateUtil.getNextMonthFirstDate(new Date()));
                log.info("[SysConsultMessage] txConsultUserStatMonth param:{}, consultMessage param:{}",
                    txConsultUserStatMonth, consultMessage);

                TxConsultUser txConsultUser = new TxConsultUser();
                if (consultMessage.getSenderId() == 0) {
                    log.info("[SysConsultMessage] 访问者的senderId=0, txConsultUserStatMonth param:{}",
                        txConsultUserStatMonth);
                    txConsultUser.setOrgId(consultMessage.getReceiverId());
                    txConsultUser.setConsultSource(consultMessage.getConsultType());
                    txConsultUserDao.save(txConsultUser);
                } else {
                    txConsultUser = txConsultUserDao.getById(consultMessage.getSenderId());
                }
                // 判断是不是学生
                OrgStudent orgStudent = getOrgStudentByConsultUser(txConsultUser);

                // 统计用户状态 访客，跟进，意向，报名 可以参考EncrollmentTypeEnum
                if (txConsultUserStatMonth == null) {
                    long userId = txConsultUser == null ? 0l : txConsultUser.getUserId();
                    // messageRecord表里只需要统计访客信息
                    Integer status = EncrollmentTypeEnum.WULEIXING.getValue();
                    if (orgStudent == null) {
                        if (ConsulterStatus.NOT.getValue() == txConsultUser.getIsConsulter()) {
                            status = EncrollmentTypeEnum.ZIXUN.getValue();
                        }
                    }
                    txConsultStatMonthService.saveStat(txConsultUser.getOrgId(), txConsultUser.getId(), userId, status,
                        null, null);
                }
            }
        }
    }

    private void syncImMessageInfo(TxMsgSyncTimestamp syncInfo) {
        List<ImMessageInfo> messageInfos =
            imMessageInfoDao.getOrgStudentInfoListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);

        log.info("save messageInfos:{} success", messageInfos.size());

        if (CollectionUtils.isNotEmpty(messageInfos)) {
            for (ImMessageInfo msgInfo : messageInfos) {

                OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(msgInfo.getReceiver().intValue());
                if (orgAccount == null) {
                    continue;
                }
                User user = userDao.getByNumber(msgInfo.getSender());
                if (user == null) {
                    continue;
                }

                msgInfo.setReceiver(Long.valueOf(orgAccount.getId()));
                msgInfo.setSender(user.getId());

                Date startDate = DateUtil.getFirstDate(new Date());
                Date endDate = DateUtil.getNextMonthFirstDate(new Date());

                TxConsultUserStatMonth txConsultUserStatMonth =
                    txConsultUserStatMonthDao.getTxConsultStatByQuery(msgInfo.getReceiver(), 0, msgInfo.getSender(),
                        MessageSource.ONLINE_IM.getValue(), startDate, endDate);

                if (msgInfo.getMsgId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(msgInfo.getMsgId());
                }
                List<TxConsultUser> txConsultUserList =
                    txConsultUserDao.lookByUserId(msgInfo.getReceiver(), msgInfo.getSender());

                long consultUserId = 0l;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = txConsultUserList.get(0).getId();
                }

                if (txConsultUserStatMonth == null) {
                    txConsultStatMonthService.saveStat(msgInfo.getReceiver(), consultUserId, msgInfo.getSender(),
                        EncrollmentTypeEnum.ZIXUN.getValue(), MessageSource.ONLINE_IM.getValue(), 1);
                } else {
                    if (!DateUtil.isToday(txConsultUserStatMonth.getUpdateTime())) {
                        txConsultUserStatMonth.setConsultUserId(consultUserId);
                        txConsultUserStatMonth.setUserId(msgInfo.getSender());
                        txConsultUserStatMonth.setNumber(txConsultUserStatMonth.getNumber() + 1);
                        txConsultUserStatMonth.setUpdateTime(new Date());
                        log.debug("syncImMessageInfo update {}", txConsultUserStatMonth);
                        txConsultUserStatMonthDao.update(txConsultUserStatMonth);
                    }
                }
            }
        }
    }

    private void syncConsultUserByUpdate(TxMsgSyncTimestamp syncInfo) {
        List<TxConsultUser> consultUsers =
            txConsultUserDao.getOrgConsultUserListByUpdateTime(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);

        if (CollectionUtils.isNotEmpty(consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                TxConsultUserStatMonth txConsultUserStatMonth =
                    txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId(), consultUser.getId(), 0,
                        null, DateUtil.getFirstDate(new Date()), DateUtil.getNextMonthFirstDate(new Date()));
                log.info("[SysnConsultUser] txConsultUserStatMonth param:{}, consultUser param:{}",
                    txConsultUserStatMonth, consultUser);

                if (consultUser.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(consultUser.getUpdateTime());
                }

                // 判断是不是学生, orgStudent 为null不是学生
                OrgStudent orgStudent = getOrgStudentByConsultUser(consultUser);
                if (txConsultUserStatMonth != null) {
                    Integer status = txConsultUserStatMonth.getStatus();
                    // 根据条件设置用户状态
                    status = getStatusByConsultUser(status, consultUser, orgStudent, DateUtil.getFirstDate(new Date()));
                    txConsultUserStatMonth.setStatus(status);
                    txConsultUserStatMonth.setUpdateTime(new Date());
                    txConsultUserStatMonthDao.update(txConsultUserStatMonth);
                    log.info(
                        "[SysnConsultUser] txConsultUserStatMonth param:{}, consultUserId param:{}, status param:{}",
                        txConsultUserStatMonth, consultUser);
                } else {// txConsultUserStatMonth 为null时代表是本月新访问用户
                    Integer status = EncrollmentTypeEnum.WULEIXING.getValue(); // 初始化一个status
                    // 根据条件设置用户状态
                    status =
                        getStatusByConsultUser(status, consultUser, orgStudent, DateUtil.getStartOfDay(new Date()));
                    // 插入TXConsultUserStatMonth新数据
                    txConsultStatMonthService.saveStat(consultUser.getOrgId(), consultUser.getId(),
                        consultUser.getUserId(), status, null, null);
                    log.info(
                        "[SysnConsultUser] save  txConsultStatMonthService,orgId param:{}, consultUserId param:{}, status param:{}",
                        consultUser.getOrgId(), consultUser.getId(), status);
                }
            }
        }
    }

    // 按照id新增来统计
    private void syncConsultUserInfo(TxMsgSyncTimestamp syncInfo) {
        List<TxConsultUser> consultUsers =
            txConsultUserDao.getOrgConsultUserListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);
        log.info("[SysnConsultUser] save consultUser size:{} success", consultUsers.size());

        if (CollectionUtils.isNotEmpty(consultUsers)) {
            for (TxConsultUser consultUser : consultUsers) {
                Date startDate = DateUtil.getFirstDate(new Date());
                TxConsultUserStatMonth txConsultUserStatMonth =
                    txConsultUserStatMonthDao.getTxConsultStatByQuery(consultUser.getOrgId(), consultUser.getId(), 0,
                        null, DateUtil.getFirstDate(new Date()), DateUtil.getNextMonthFirstDate(new Date()));
                if (consultUser.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(consultUser.getId());
                }

                // 判断是不是不是学生
                OrgStudent orgStudent = getOrgStudentByConsultUser(consultUser);
                if (txConsultUserStatMonth == null) {
                    Integer status = EncrollmentTypeEnum.WULEIXING.getValue();
                    // 根据条件设置用户状态
                    status = getStatusByConsultUser(status, consultUser, orgStudent, startDate);
                    // 插入TXConsultUserStatMonth新数据
                    txConsultStatMonthService.saveStat(consultUser.getOrgId(), consultUser.getId(),
                        consultUser.getUserId(), status, null, null);
                    log.info(
                        "[SysnConsultUser] save  txConsultStatMonthService, consultUserId param:{}, status param:{}",
                        consultUser.getId(), status);
                } else {
                    Integer status = txConsultUserStatMonth.getStatus();
                    // 根据条件设置用户状态
                    status = getStatusByConsultUser(status, consultUser, orgStudent, DateUtil.getFirstDate(new Date()));
                    txConsultUserStatMonth.setStatus(status);
                    txConsultUserStatMonth.setUpdateTime(new Date());
                    txConsultUserStatMonthDao.update(txConsultUserStatMonth);
                }
            }
        }
    }

    private void syncSignupInfo(TxMsgSyncTimestamp syncInfo) {
        List<OrgSignupInfo> signupInfos =
            orgSingupInfoDao.getOrgSignupListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);
        log.info(" 报名 save signupInfos:{} success", signupInfos.size());

        if (CollectionUtils.isNotEmpty(signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                log.info("signupInfo =============== param:{}", signupInfo);
                if (signupInfo.getUserId() == 0) {
                    continue;
                }
                Date startDate = DateUtil.getFirstDate(new Date());
                Date endDate = DateUtil.getNextMonthFirstDate(new Date());

                TxConsultUserStatMonth txConsultUserStatMonth = txConsultUserStatMonthDao.getTxConsultStatByQuery(
                    signupInfo.getOrgId(), 0, signupInfo.getUserId(), null, startDate, endDate);

                if (signupInfo.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(signupInfo.getId());
                }

                setSyncTxConsultUserStatMonthByOrgSignupInfo(signupInfo, txConsultUserStatMonth);

            }
        }
    }

    // 按照更新时间获取
    private void syncSignupInfoByUpdate(TxMsgSyncTimestamp syncInfo) {

        List<OrgSignupInfo> signupInfos =
            orgSingupInfoDao.getOrgSignupListByUpdate(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100);
        log.info("[SysnSignupInfo] signupInfos by updateTime:{} success", signupInfos.size());

        if (CollectionUtils.isNotEmpty(signupInfos)) {
            for (OrgSignupInfo signupInfo : signupInfos) {
                // 过滤userId为0
                if (signupInfo.getUserId() == 0) {
                    continue;
                }
                TxConsultUserStatMonth txConsultUserStatMonth =
                    txConsultUserStatMonthDao.getTxConsultStatByQuery(signupInfo.getOrgId(), 0, signupInfo.getUserId(),
                        null, DateUtil.getFirstDate(new Date()), DateUtil.getNextMonthFirstDate(new Date()));
                log.info("[SysnSignupInfo] signupInfo param:{}, txConsultUserStatMonth param:{}", signupInfo,
                    txConsultUserStatMonth);

                if (signupInfo.getUpdateTime().after(syncInfo.getSyncTime())) {
                    syncInfo.setSyncTime(signupInfo.getUpdateTime());
                }

                setSyncTxConsultUserStatMonthByOrgSignupInfo(signupInfo, txConsultUserStatMonth);
            }

        }
    }

    private void setSyncTxConsultUserStatMonthByOrgSignupInfo(OrgSignupInfo signupInfo,
        TxConsultUserStatMonth txConsultUserStatMonth) {
        //获取学员信息
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(signupInfo.getOrgId(), signupInfo.getUserId());
        if(orgStudent != null && orgStudent.getDelStatus() == DeleteStatus.NORMAL.getValue()){
            long consultUserId = getConsultId(signupInfo, orgStudent);
            if (txConsultUserStatMonth == null) {
                int status = EncrollmentTypeEnum.WULEIXING.getValue();
                // 报名成功 收款成功
                List<Integer> SPLIT_CODES_FINISHED = Lists.newArrayList(SplitCourseResult.FAIL.getCode(),
                    SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode());
                int del = signupInfo.getIsDel().intValue();
                int purchaseStatus = signupInfo.getPurchaseStatus().intValue();
                if (del == 0 && SPLIT_CODES_FINISHED.contains(signupInfo.getSplitResult())
                    && purchaseStatus == PayResult.SUCCESS.getCode()) {
                    status = EncrollmentTypeEnum.BAOMING.getValue();
                }
                txConsultStatMonthService.saveStat(signupInfo.getOrgId(), consultUserId, signupInfo.getUserId(), status,
                    null, null);
            } else {
                int status = txConsultUserStatMonth.getStatus();
                // 报名成功 收款成功
                List<Integer> SPLIT_CODES_FINISHED = Lists.newArrayList(SplitCourseResult.FAIL.getCode(),
                    SplitCourseResult.PENDING.getCode(), SplitCourseResult.SUCCESS.getCode());
                int del = signupInfo.getIsDel().intValue();
                int purchaseStatus = signupInfo.getPurchaseStatus().intValue();
                if (del == 0 && SPLIT_CODES_FINISHED.contains(signupInfo.getSplitResult())
                    && purchaseStatus == PayResult.SUCCESS.getCode()) {
                    status = EncrollmentTypeEnum.BAOMING.getValue();
                }
                txConsultUserStatMonth.setConsultUserId(consultUserId);
                txConsultUserStatMonth.setUserId(signupInfo.getUserId());
                txConsultUserStatMonth.setUpdateTime(new Date());
                txConsultUserStatMonth.setStatus(status);
                log.debug("syncSignupInfo update :{}", txConsultUserStatMonth);
                txConsultUserStatMonthDao.update(txConsultUserStatMonth);
            }
        }else{
            log.info("[SysnSignupInfo] 学员不存在 orgStudent:{}", orgStudent);
            return;
        }

    }
    
    //获取consultId
    private long getConsultId(OrgSignupInfo signupInfo, OrgStudent orgStudent){
        long consultUserId = 0l;
        List<TxConsultUser> txConsultUserList =
            txConsultUserDao.lookByMobile(signupInfo.getOrgId(), signupInfo.getMobile());
        
        OrgStudent student = orgStudentDao.getStudentByMobileAndOrgId(signupInfo.getOrgId(), signupInfo.getMobile(), "id","name", "delStatus","weixin");
        if(CollectionUtils.isEmpty(txConsultUserList) && student!=null && StringUtils.isNotEmpty(student.getWeixin())){
        	txConsultUserList = txConsultUserDao.lookByParams(signupInfo.getOrgId(), student.getWeixin());
        }
        
        log.info("[SysnSignupInfo] txConsultUserList param:{}", txConsultUserList);
        if (txConsultUserList != null && txConsultUserList.size() > 0) {
            TxConsultUser consultUser = txConsultUserList.get(0);
            //这里如果consultUser.getStudentId不存在，需要修复数据，学员和线索是通过studentId来关联
            if(consultUser.getStudentId() <= 0){
                consultUser.setStudentId(orgStudent.getId());
                consultUser.setUpdateTime(new Date());
                log.info("[SysnSignupInfo] 线索consultId:{} sysn studentId:{}", consultUser.getId(),orgStudent.getId());
                txConsultUserDao.update(consultUser, "studentId", "updateTime");
            }
            consultUserId = consultUser.getId();
        } else {
            TxConsultUser txConsultUser = getTxConsultUser(signupInfo, orgStudent.getId());
            this.txConsultUserDao.save(txConsultUser);
            consultUserId = txConsultUser.getId();
            log.info("[SysnSignupInfo] 新插txConsultUser param:{}", txConsultUser);
        }
        
        return consultUserId;
        
    }
    
    private TxConsultUser getTxConsultUser(OrgSignupInfo signupInfo, Long studentId) {
        Long userId = signupInfo.getUserId();
        Long orgId = signupInfo.getOrgId();
        TxConsultUser txConsultUser = new TxConsultUser();
        txConsultUser.setUserId(userId);
        txConsultUser.setOrgId(orgId);
        txConsultUser.setStudentId(studentId);
        txConsultUser.setName(signupInfo.getStudentName());
        txConsultUser.setConsultSource(MessageSource.APPOINTMENT.getValue());
        txConsultUser.setIntensionLevel(IntentionLevel.LEVEL_2.getValue());
        txConsultUser.setIsConsulter(ConsulterStatus.NOT.getValue());
        txConsultUser.setConsultStatus(ConsultUserStatus.HAS.getValue());
        txConsultUser.setMobile(signupInfo.getMobile());
        return txConsultUser;
    }

    private void syncPurchase3810Info(TxMsgSyncTimestamp syncInfo) {
        List<CoursePurchase> coursePurchases = coursePurchaseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(),
            syncInfo.getSyncTime(), 100, CourseType.ORG_COURSE.getCode(), null, 1);

        log.info("save coursePurchases:{} success", coursePurchases.size());

        if (CollectionUtils.isNotEmpty(coursePurchases)) {
            for (CoursePurchase coursePurchase : coursePurchases) {

                Date startDate = DateUtil.getFirstDate(new Date());
                Date endDate = DateUtil.getNextMonthFirstDate(new Date());

                TxConsultUserStatMonth txConsultUserStatMonth = txConsultUserStatMonthDao.getTxConsultStatByQuery(
                    coursePurchase.getOrgId(), 0, coursePurchase.getUserId(), 0, startDate, endDate);

                if (coursePurchase.getId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(coursePurchase.getId());
                }

                List<TxConsultUser> txConsultUserList =
                    txConsultUserDao.lookByUserId(coursePurchase.getOrgId(), coursePurchase.getUserId());

                long consultUserId = 0l;
                if (txConsultUserList != null && txConsultUserList.size() > 0) {
                    consultUserId = txConsultUserList.get(0).getId();
                }

                if (txConsultUserStatMonth == null) {
                    txConsultStatMonthService.saveStat(coursePurchase.getOrgId(), consultUserId,
                        coursePurchase.getUserId(), EncrollmentTypeEnum.BAOMING.getValue(),
                        MessageSource.APPOINTMENT.getValue(), 1);
                } else {
                    txConsultUserStatMonth.setConsultUserId(consultUserId);
                    txConsultUserStatMonth.setUserId(coursePurchase.getUserId());
                    txConsultUserStatMonth.setNumber(txConsultUserStatMonth.getNumber() + 1);
                    txConsultUserStatMonth.setUpdateTime(new Date());

                    log.debug("syncPurchase3810Info update {}", txConsultUserStatMonth);
                    txConsultUserStatMonthDao.update(txConsultUserStatMonth);
                }
            }
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

    private OrgStudent getOrgStudentByConsultUser(TxConsultUser consultUser) {
        Long userId = consultUser.getUserId();
        Long orgId = consultUser.getOrgId();
        Long studentId = consultUser.getStudentId();
        OrgStudent orgStudent = null;
        if (studentId != null && studentId > 0) {
            orgStudent = this.orgStudentDao.getById(studentId);
        } else {
            orgStudent = this.orgStudentDao.getStudentByUserId(orgId, userId);
        }

        return orgStudent;
    }

    private void insertTXConsultUserStatMonth(TxConsultUser consultUser, int status) {
        log.info("@@@@@@@@ A ");
        if (ConsulterStatus.IS.getValue() == consultUser.getIsConsulter()) {
            log.info("@@@@@@@@ B1 ");
            txConsultStatMonthService.saveStat(consultUser.getOrgId(), consultUser.getId(), consultUser.getUserId(),
                status, consultUser.getConsultSource(), 1);
            log.info("@@@@@@@@ B2 ");
        } else {// 非线索时不统计他的次数number 因为他可能会因为 message_record 同步两次
            log.info("@@@@@@@@ C1 ");
            txConsultStatMonthService.saveStat(consultUser.getOrgId(), consultUser.getId(), consultUser.getUserId(),
                status, consultUser.getConsultSource(), 0);
            log.info("@@@@@@@@ 1 ");
        }
    }

    private Integer getStatusByConsultUser(Integer status, TxConsultUser consultUser, OrgStudent orgStudent,
        Date startDate) {
        Date lastRemindTime = consultUser.getLastRemindTime();
        // 跟进和意向不能是学生
        if (GenericsUtils.isNullOrEmpty(orgStudent)) {
            if (ConsulterStatus.IS.getValue() == consultUser.getIsConsulter()) {
                // 已跟进
                if (lastRemindTime != null && lastRemindTime.after(startDate)) {
                    status = EncrollmentTypeEnum.GOUTONG.getValue();
                }
                // 有意向 创建在本月，意向级别为高
                List<Integer> intentionLevelZGs =
                    Arrays.asList(IntentionLevel.LEVEL_2.getValue(), IntentionLevel.LEVEL_3.getValue());
                if (intentionLevelZGs.contains(consultUser.getIntensionLevel())) {
                    status = EncrollmentTypeEnum.YIXIANG.getValue();
                }
            } else {
                status = EncrollmentTypeEnum.ZIXUN.getValue();
            }
        } else {
            // 有可能是学员
            if (status != EncrollmentTypeEnum.BAOMING.getValue()) {
                status = EncrollmentTypeEnum.WULEIXING.getValue();
            }
        }

        return status;
    }

}
