/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXKefuRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivitySignUpDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated
public class OrgActivitySignUpServiceImpl
extends AbstractConsultService<ActivitySignUpDto> {
    private static final Logger log = LoggerFactory.getLogger(OrgActivitySignUpServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TXKefuRuleDao kefuRuleDao;

    @Override
    public MessageSource getConsultType() {
        return MessageSource.SIGNUP;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(ActivitySignUpDto msg, Long consultUserId) {
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(MessageSource.SIGNUP.getValue());
        pushMsg.setCreateTime((Date)new Timestamp(msg.getCreateTime()));
        pushMsg.setMsgType(MsgType.CARD.getValue());
        CardMsgContent content = CardContentFactory.createActivityCard((String)msg.getUserName(), (String)msg.getMobile(), (String)msg.getName());
        content.setAction(ActionUtil.getTelephoneAction((long)consultUserId, (String)msg.getMobile()));
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson((Object)content));
        return pushMsg;
    }

    @Override
    public boolean consume(ActivitySignUpDto message) {
        if (message == null || message.getId() < 0L || message.getOrgId() == null) {
            throw new IllegalArgumentException(" activity sign up record is illegal");
        }
        boolean result = false;
        TXKefuRule rule = this.kefuRuleDao.getByOrgId(Integer.valueOf(message.getOrgId().intValue()));
        if (rule != null && rule.getBespeakRule() != null && rule.getBespeakRule() == 1) {
            log.info("[Notice] Sign up notice!");
            MsgUser user = this.builderSender(message, 1);
            String content = NoticeType.getTips((String)message.getUserName());
            NoticeMsgContent notice = NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)user.getUserId()), (String)content);
            result = this.consultMessageService.sendNotice(message.getOrgId(), Integer.valueOf(-1), notice);
        } else {
            MsgUser receiver = this.buildOrgMsgUser(message);
            MsgUser sender = this.builderSender(message, 0);
            if (sender == null || receiver == null) {
                log.warn("sender :{} or receiver:{} is null,skip activity sign up  msg:{},skip", new Object[]{sender, receiver, message});
                return false;
            }
            ConsultMessage msgContent = this.buildPushMessageContent(message, sender.getUserId());
            log.info("consume activity sign up msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
            result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
            log.info("push student activity sign up msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        }
        return result;
    }

    private MsgUser builderSender(ActivitySignUpDto msg, int isClue) {
        List consultUsers = this.consultUserDao.lookByMobile(msg.getOrgId(), msg.getMobile(), new String[0]);
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndOrgId(msg.getOrgId(), msg.getMobile(), new String[]{"id", "name", "delStatus", "weixin"});
        if (CollectionUtils.isEmpty((Collection)consultUsers) && student != null && StringUtils.isNotEmpty((CharSequence)student.getWeixin())) {
            consultUsers = this.consultUserDao.lookByParams(msg.getOrgId(), student.getWeixin(), new String[0]);
        }
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            TxConsultUser consultUser = (TxConsultUser)consultUsers.get(0);
            boolean isNeedToUpdate = false;
            if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
                if (!student.getName().equals(consultUser.getName())) {
                    isNeedToUpdate = true;
                    consultUser.setName(student.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)student.getWeixin()) && !student.getWeixin().equals(consultUser.getWeixinOpenId())) {
                    isNeedToUpdate = true;
                    consultUser.setWeixinOpenId(student.getWeixin());
                }
                if (student.getId().equals(consultUser.getStudentId())) {
                    isNeedToUpdate = true;
                    consultUser.setStudentId(consultUser.getStudentId());
                }
            }
            if (isClue == 1 && consultUser.getIsConsulter() != isClue) {
                log.info("[Advisory] update consult user status.");
                isNeedToUpdate = true;
                consultUser.setIsConsulter(Integer.valueOf(isClue));
            }
            if (isNeedToUpdate) {
                this.consultUserDao.update((Object)consultUser, new String[]{"isConsulter"});
            }
            this.buildComment(consultUser, msg);
            return ConsulterDto.convertToDto(consultUser);
        }
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(msg.getOrgId());
        consultUser.setMobile(msg.getMobile());
        consultUser.setName(msg.getUserName());
        consultUser.setUserId(Long.valueOf(0L));
        if (student != null) {
            consultUser.setStudentId(student.getId());
            consultUser.setWeixinOpenId(student.getWeixin());
        }
        consultUser.setConsultSource(Integer.valueOf(MessageSource.SIGNUP.getValue()));
        consultUser.setIsConsulter(Integer.valueOf(isClue));
        this.consultUserDao.save((Object)consultUser, new String[0]);
        this.buildComment(consultUser, msg);
        return ConsulterDto.convertToDto(consultUser);
    }

    private MsgUser buildOrgMsgUser(ActivitySignUpDto message) {
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setOrgId(Integer.valueOf(message.getOrgId().intValue()));
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)message.getOrgId(), new String[0]);
        Integer orgNumber = null;
        if (account == null) {
            return null;
        }
        orgNumber = account.getNumber();
        message.setOrgNumber(Long.valueOf(orgNumber.longValue()));
        return this.buildReceiver(orgInfo, orgNumber.longValue());
    }

    private void buildComment(TxConsultUser consultUser, ActivitySignUpDto message) {
        log.info("buildComment--------consultUser={}", (Object)consultUser.toString());
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(consultUser.getId());
        comment.setContent(this.getContent(message));
        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setOrigin(this.getConsultType().getValue());
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
    }

    private String getContent(ActivitySignUpDto message) {
        StringBuffer sb = new StringBuffer("\u6d3b\u52a8\u540d\u79f0\uff1a");
        sb.append(message.getName()).append("\n");
        sb.append("\u59d3\u540d\uff1a").append(message.getUserName()).append("\n");
        sb.append("\u6765\u7535\u53f7\u7801\uff1a").append(message.getMobile());
        return sb.toString();
    }

    @Override
    public ActivitySignUpDto transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (ActivitySignUpDto)JacksonUtil.str2Obj((String)body, ActivitySignUpDto.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }
}

