/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.consult.dto.response.ConsultCallRecordDto;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserCallRecordService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.callservice.constant.ConsultCallRecordManner;
import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.callservice.po.ConsultCallRecord;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * @author cxm
 * @version 1.0
 * @title ConsultUserServiceImpl
 * @desc TODO
 * @date 2015年12月8日
 */
@Service
@Slf4j
public class ConsultUserCallRecordServiceImpl implements ConsultUserCallRecordService {

	@Autowired
    private OrgStorageDao orgStorageDao;

	@Autowired
    private ConsultCallRecordDao consultCallRecordDao;
  
	
    @Override
    public List<ConsultCallRecordDto> listConsultCallRecord(Long orgId, Long cascadeId, Long studentId,
        Long consulterId) {
        List<ConsultCallRecordDto> dtoList = new ArrayList<ConsultCallRecordDto>();
        List<ConsultCallRecord> list = consultCallRecordDao.listBy(orgId, studentId, consulterId);
        
        if (!CollectionUtils.isEmpty(list)) {
            ConsultCallRecordDto dto = null;
            for (ConsultCallRecord record : list) {
                dto = new ConsultCallRecordDto();
                dto.setCallStatus(record.getCallStatus());
                dto.setCreateTime(record.getCreateTime().getTime());
                dto.setId(record.getId());
                dto.setSeconds(record.getDuringTime());

                if (record.getIsCallByOrg().intValue() == Flag.TRUE.getInt()) {
                    dto.setCallManner(ConsultCallRecordManner.CALL.getCode());
                } else {
                    dto.setCallManner(ConsultCallRecordManner.ANSWER.getCode());
                }

                if (record.getStorageId() != null && record.getStorageId() > 0) {
                    dto.setSoundId(record.getStorageId());
                    OrgStorage orgStorage = orgStorageDao.getById(record.getStorageId());
                    dto.setSoundUrl(StorageUtil.constructUrl(orgStorage));
                }

                dtoList.add(dto);
            }
        }
        return dtoList;
    }


	@Override
	@Transactional(rollbackFor = { Exception.class, BussinessException.class })
	public void saveOrUpdate(ConsultCallRecord record) {
		consultCallRecordDao.saveOrUpdate(record);
	}

}
