

/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import com.baijia.tianxiao.biz.consult.enums.GenderStatus;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultImportModel;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.baidu.Location;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldService;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customChoiceField.OptionDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldResponse;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.baidu.BaiduMapUtils;
import com.baijia.tianxiao.util.bean.BizDateThreadLocalUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @author zhangbing
 * @version 1.0
 * @title UploadServiceImpl
 * @desc TODO
 * @date 2016年3月18日
 */
@Service
@Slf4j
public class ImportClueServiceImpl implements ImportDataProcessService {

	public static final String CLUE_IMPORT_TEMPLATE_PATH = "/excel/consult_import_2.xlsx";
	public static final String CLUE_RESULT_TEMPLATE_PATH = "/excel/consult_result_2.xlsx";

    @Autowired
    private AreaDao areaDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
	private ConsultSourceService consultSourceService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Resource
    private CustomFieldService customFieldService;

    @Resource
    private CustomFieldValueDao customFieldValueDao;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired
    private ClueService clueService;

    public final static String org_customfield_map_Key = "orgCustomfieldMap";

    public final static String org_cascade_map_Key = "orgCascadeMap";

    // 表头配置映射关系
    private static final Map<String, Map<String, Object>> cache = Maps.newHashMap();
    private final static SingleSaveErrorResult IMPORT_SUCCESS = SingleSaveErrorResult.createSuccessResult("导入成功");
    private final static SingleSaveErrorResult IMPORT_PUBLIC_CLUE_SUCCESS = SingleSaveErrorResult.createSuccessResult("导入成功",true);
    private final static SingleSaveErrorResult IMPORT_FAIL = SingleSaveErrorResult.createFailResult("导入失败");


    static {
        // ResourceBundle rs = ResourceBundle.getBundle("upload");
        // String header = rs.getString("upload.clue.header");
        String header = "姓名:name:true,手机号:mobile:true,性别:sexStr:false,跟进状态:consultStatusStr:false,来源:consultSourceStr:true,意向级别:intensionLevelStr:false,课程顾问:cascadeIdStr:false,标签:tagsStr:false,亲属关系:relativesStr:false,家长姓名:parentName:false,家长手机号:parentMobile:false,生日:birthday:false,公立学校:school:false,年级:degreeClass:false,详细地址:address:false,QQ:qq:false,邮箱:mail:false";
        //String header =
        //    "学员姓名:name:true,学员手机:mobile:true,家长姓名:parentName:false,家长手机:parentMobile:false,生日:birthday:false,意向级别:intensionLevel:false,咨询状态:consultStatus:false,学校:school:false,班级:degreeClass:false,省:province:false,市:city:false,区:county:false,详细地址:address:false,父亲职业:fatherOccupation:false,母亲职业:matherOccupation:false";
        if (StringUtils.isNotBlank(header) && header.contains(":")) {
            String[] cells = header.split(",");

            int index = 0;// 顺序
            Map<String, Object> subMap = null;
            for (String cell : cells) {
                subMap = new LinkedHashMap<String, Object>();
                String column[] = cell.split(":");
                String name = column[0].trim();
                String propName = column[1];
                boolean empty = Boolean.parseBoolean(column[2]);
                subMap.put("propName", propName);
                subMap.put("index", index);
                subMap.put("empty", empty);
                cache.put(name, subMap);
                index++;
            }
        }
    }



    @Override
    public DataProcType getProcessType() {
        return DataProcType.CONSULT;
    }

    /**
     * 上传文件格式校验 必须保证上传文件的表头与upload.properties中配置的 表头名称和顺序一致
     *
     * @param headers 用户上传文件的表头
     */
    @Override
    public boolean validateHeader(List<String> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }
        int index = 0;

        for (String header : headers) {
            if (!cache.containsKey(header.trim())) {
                log.debug("validateHeader = {},{}", index, header.trim());
                return false;
            } else {
                Map<String, Object> item = cache.get(header);
                int sequence = (int) item.get("index");
                if (index != sequence) {
                    log.debug("validateHeader = {},{}", index, sequence);
                    return false;
                }
            }
            index++;
        }
        return true;
    }


    @Override
    public SingleSaveErrorResult saveSingleData(Long orgId, Long cascadeId, List<String> headers, Object[] lineData,
                                                boolean updateRepeat) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "illegal orgId.");
        Preconditions.checkArgument(lineData != null && lineData.length > 0, "lineData 为空");
        // 保存一行数据
        ConsultImportModel model = new ConsultImportModel();
        ConsultListResponseDto consultUser = model.getConsultListResponseDto();
		boolean isPublicClue = false;
        try {

            buildConsultDtoNew(cascadeId, model, lineData, headers, updateRepeat, orgId);

//            Date nextRemindTime = new Date(); // 见 http://bug.baijiahulian.com/issues/42923
//            nextRemindTime = new Date(nextRemindTime.getTime()-5*60*1000);
//            consultUser.setNextRemindTimeStr(nextRemindTime);
//            consultUser.setNextRemindTime(nextRemindTime.getTime());

            if(StringUtils.isNotBlank(consultUser.getTagsStr())){
            	String[] tags = consultUser.getTagsStr().replaceAll("，", ",").split(",");
            	Map<String,String> map = new LinkedHashMap<String,String>();
            	for(String t:tags){
            		if(StringUtils.isNotBlank(t)){
            			map.put(t, "");
            		}
            	}

            	List<TagInfoDto> list = new ArrayList<TagInfoDto>();
            	for(String t:map.keySet()){
            		TagInfoDto dto = new TagInfoDto();
            		dto.setContent(t);
            		list.add(dto);
            	}
            	consultUser.setTagsStr( JacksonUtil.obj2Str(list) );
            }

            Long consultUserId = clueService.addClueInfo(orgId, consultUser,model.getFieldsValue(), updateRepeat,false);
            if(consultUser.getCascadeId()<0){
                isPublicClue = true;
            }

        } catch (BussinessException ex) {
            if (ex.getErrorCode().getSubsystemErrorCode() == CrmErrorCode.CUSTOM_HAS_EXISTS.getSubsystemErrorCode()) {
            	if(consultUser.getMobile()!=null){
		        	List<TxConsultUser> targets = this.txConsultUserDao.lookByMobile(orgId, consultUser.getMobile());
		            if(!updateRepeat){
		            	if (targets != null && !targets.isEmpty()) {
		                	return new SingleSaveErrorResult(true, "【手机号】该手机号已对应其他线索");
		                }
		            }else{
		                if (targets.size()>1) {
		                	return new SingleSaveErrorResult(true, "【手机号】该手机号已对应多条线索,无法处理");
		                }else if (targets.size() == 1 && targets.get(0).getDelStatus().intValue()==0 && !targets.get(0).getCascadeId().equals(-1)){
		                	if(consultUser.getCascadeId() != targets.get(0).getCascadeId().longValue()){
		                		String name = "";
		                		if(targets.get(0).getCascadeId().longValue() == -1){
		                			name = "公海";
		                		}else if(targets.get(0).getCascadeId().longValue() == 0){
		                			OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
		                			name = orgInfo.getShowName();
		                		}else{
		                			TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(targets.get(0).getCascadeId());
		                            TXCascadeCredential txCascadeCredential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
		                            name = txCascadeCredential.getName();
		                		}
		                		return new SingleSaveErrorResult(true, "该线索已存在，所属人为:"+name);
		                	}
		                }
		            }
            	}
                return new SingleSaveErrorResult(true, "线索已存在");
            } else {
                log.warn("save clue error:{}", ex);
//                throw ex;
            	return SingleSaveErrorResult.createFailResult(ex.getMessage());
            }
        } catch (Exception ex) {
            log.warn("save clue error:{}", ex);
            //throw new BussinessException(CrmErrorCode.HANDLER_FAILED);
            return IMPORT_FAIL;
        }
		log.debug("[Upload] upload clue.isPublicClue={}",isPublicClue);
		if(isPublicClue){
			return IMPORT_PUBLIC_CLUE_SUCCESS;//导入公海线索
		}else {
			return IMPORT_SUCCESS;
		}
    }


    private long getAreaId(String region, int level) {
        if (StringUtils.isBlank(region) || level == 0) {
            return 0;
        }
        List<Area> areas = this.areaDao.getAreaByBname(region, level);
        if (CollectionUtils.isNotEmpty(areas)) {
            return areas.get(0).getId();
        }
        return 0;
    }

    private void buildConsultDtoNew(Long cascadeId, ConsultImportModel model, Object[] lineData, List<String> headers,boolean updateRepeat, Long orgId) {

        Preconditions.checkArgument(lineData.length == headers.size(), "数据数目和表头不匹配");
        Preconditions.checkArgument(validateHeader(headers,orgId), "表头格式错误:" + headers.toString());

        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy-MM-dd");

        Map<String,CustomFieldResponse> customMap = getOrgRealCutomFieldMapFromThreadLocal(orgId);

        Map<String,TxCascadeCredentialDto> cascadeMap = getOrgCascadeMapFromThreadLocal(orgId);

        ConsultListResponseDto dto = model.getConsultListResponseDto();

        for(int i = 0; i < lineData.length; i++){
            String head = headers.get(i);
            if(cache.containsKey(head)){
                String fieldName = cache.get(head).get("propName").toString();
                boolean empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
                String name = headers.get(i);
                Object value = lineData[i];
                if (fieldName != null) {
                    if(fieldName.equals("birthday") && lineData[i]!=null && !lineData[i].equals("")){
                    	try {
                            Date date = null;
                            if(value instanceof Date){
                                date = (Date)value;
                            }else if(value instanceof String){
                            	if (((String) value).contains("/")) {
                                    date = dateFormat2.parse(value.toString());
                                } else if (((String) value).contains("-")) {
                                    date = dateFormat3.parse(value.toString());
                                } else {
                                    throw new BussinessException(CommonErrorCode.PARAM_ERROR);
                                }
                            }else if(value instanceof Long){
                                date = new Date((Long)value);
                            }

                            dto.setBirthdayStr( date );
                            dto.setBirthday(date.getTime());
                            lineData[i] = date.getTime();
                            continue;

                        } catch (Exception e) {
                            log.warn("CustomField date type format  bussion exception",e);
                            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【生日】格式有误，需为2001/1/1或者2001-1-1样式");
                        }
                    }

                    if (empty && (value == null || "".equals(value))) {
                        throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + name + "】不能为空");
                    }
                    try {
                        if (value != null && !(value instanceof String && StringUtils.isBlank((String) value))) {
                            if(value instanceof String){
                                value = value.toString().trim();
                            }
                            BeanUtils.setProperty(dto, fieldName, value);
                        }
                    } catch (IllegalAccessException | InvocationTargetException e) {
                        log.warn("set StudentListResponseDto.{} = {} failed!", fieldName, value);
                        throw new BussinessException(CrmErrorCode.FORMAT_ERROR);
                    }
                }
            }
            else if(customMap.containsKey(head)){
                CustomFieldResponse customField = customMap.get(head);
                boolean empty = customField.getIsRequired() == 1;
                int type = customField.getType();
                Object value = lineData[i];
                String strValue = value.toString();
                if (empty && (value == null || "".equals(value))) {
                    throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + head + "】不能为空");
                }
                Map<String,Object> map = Maps.newHashMap();
                if(type ==1 ){
                    if (strValue != null) {
                        int maxLength = 30;
                        // 优选老师业务的几个机构特殊处理
                        if (orgInfoService.isOptimal(orgId)) {
                            maxLength = 500;
                        }
                        if (strValue.length() > maxLength) {
                            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【" + head + "】文本不能超过" + maxLength + "个字符");
                        }
                    }
                    map.put("content", strValue);
                }else if(type==2){
                    if(strValue!=null && !strValue.equals("")){
                        List<OptionDto>  optionList = customField.getOptionList();
                        for(OptionDto option:optionList){
                            if(option.getIsPaused() == 0 && StringUtils.equals(option.getLabel(), strValue)){
                                map.put("id", option.getId());
                                map.put("value", option.getLabel());
                            }
                        }
                        if(map.isEmpty()){
                            throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + head + "】所填内容和系统选项不匹配");
                        }
                    }

                }else if(type==3){

                    List<String> result = Splitter.onPattern("[,|，]").trimResults().splitToList(strValue);

                    List<Map<String,Object>> options = Lists.newArrayList();
                    List<OptionDto>  optionList = customField.getOptionList();
                    if (StringUtils.isNotBlank(strValue) &&CollectionUtils.isNotEmpty(result)) {
                        for (OptionDto optionDto : optionList) {
                            if (optionDto.getIsPaused() == 0 && result.contains(optionDto.getLabel())) {
                                Map<String, Object> option = Maps.newHashMap();
                                option.put("id", optionDto.getId());
                                option.put("value", optionDto.getLabel());
                                options.add(option);
                            }

                        }

                        if (options.isEmpty()) {
                            throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + head + "】所填内容和系统选项不匹配");
                        }
                        if(options.size()!=result.size()){
                            throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + head + "】所填内容和系统选项不匹配");
                        }
                    }
                    if(options.size()>0){
                        map.put("options", options);
                    }

                }else if(type==4){
                    if(value != null && StringUtils.isNotBlank(String.valueOf(value))){
                        log.info("CustomField date type format strValue:{}",value);

                        try {
                            Date date = null;

                            if(value instanceof Date){
                                date = (Date)value;
                            }else if(value instanceof String){
                                if (((String) value).contains("/")) {
                                    date = dateFormat2.parse(strValue);
                                } else if (((String) value).contains("-")) {
                                    date = dateFormat3.parse(strValue);
                                } else {
                                    throw new BussinessException(CommonErrorCode.PARAM_ERROR);
                                }
                            }else if(value instanceof Long){
                                date = new Date((Long)value);
                            }

                            if(date!=null){
                                map.put("content", date.getTime());
                            }

                        } catch (Exception e) {
                            log.error("CustomField date type format error",e);
                            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【" + head + "】日期格式不正确");
                        }
                    }
                }
                else{
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【" + head + "】不支持的自定义数据类型");
                }

                if(empty && MapUtils.isEmpty(map)){
                    throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + head + "】所填内容和系统选项不匹配");
                }

                //if(MapUtils.isNotEmpty(map)){
                    CustomFieldValue cfvalue = new CustomFieldValue();
                    log.debug("customField = {}",customField);
                    log.debug("customField id = {}",customField.getId());
                    log.debug("customField key = {}",customField.getKey());
                    cfvalue.setFieldId(Long.valueOf(customField.getId()));
                    cfvalue.setFieldType(customField.getType());
                    cfvalue.setOrgId(orgId);
                    Gson gson = new Gson();
                    cfvalue.setValue(gson.toJson(map));
                    model.getFieldsValue().add(cfvalue);
                //}
            }

        }

        // 线索来源
        if( StringUtils.isBlank(dto.getConsultSourceStr()) ){
            //dto.setConsultSource(MessageSource.IMPORT.getValue());
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】不能为空");
        }else{
            if( dto.getConsultSourceStr().length()>30 ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】最多输入30个字符");
            }
            ConsultCustomSourceDto sourceDto = consultSourceService.getByLabel(orgId, dto.getConsultSourceStr());
            if(sourceDto==null){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】所填内容与系统选项不匹配");
            }else{
                if(Flag.getBoolean(sourceDto.getIsPaused())){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】该来源类型已被停用");
                }else{
                    dto.setConsultSource(sourceDto.getId().intValue());
                }
            }
        }

        //1 姓名
        if( StringUtils.isBlank(dto.getName()) ){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【姓名】不能为空");
        }
        if( dto.getName().length()>30 ){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【姓名】最多输入30个字符");
        }
//        if( !TxConsultUser.validateStr(dto.getName())){
//          throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【姓名】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//        }


        //2 手机号
        if( StringUtils.isBlank(dto.getMobile()) ){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】不能为空");
        }
        if( dto.getMobile().length()!=11 ){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】需为11位数字");
        }
        if( !dto.getMobile().startsWith("1")){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】必须以1开头");
        }
        if( !ParamValidateUtils.validateMobile(dto.getMobile())){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】不能包含特殊字符或空格");
        }

        //3 性别
        if(StringUtils.isNotBlank(dto.getSexStr())){
            if ( dto.getSexStr().equals(GenderStatus.FEMAN.getName())) {
                dto.setSex(GenderStatus.FEMAN.getCode());
            } else if ( dto.getSexStr().equals(GenderStatus.MAN.getName())) {
                dto.setSex(GenderStatus.MAN.getCode());
            }else{
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【性别】所填内容与系统选项不匹配");
            }
        }else{
            dto.setSex(GenderStatus.NONE.getCode());
        }

        //4 跟进状态
        if(StringUtils.isNotBlank(dto.getConsultStatusStr())){
            if( ConsultUserStatus.getValue(dto.getConsultStatusStr()) == null){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【跟进状态】所填内容与系统选项不匹配");
            }else{
                dto.setConsultStatus(ConsultUserStatus.getValue(dto.getConsultStatusStr()));
            }
        }

        //5 意向级别
        if(StringUtils.isNotBlank(dto.getIntensionLevelStr())){
            if( IntentionLevel.getValue(dto.getIntensionLevelStr()) == null){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【意向级别】所填内容与系统选项不匹配");
            }else{
                dto.setIntensionLevel(IntentionLevel.getValue(dto.getIntensionLevelStr()));
            }
        }

        //6 所属人
        /*if(StringUtils.isBlank(dto.getCascadeIdStr())){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【所属人】不能为空");
        }else{
            if( "自己".equals(dto.getCascadeIdStr()) ){
                dto.setCascadeId(TianxiaoPCContext.getTXCascadeId() == null ? 0 : TianxiaoPCContext.getTXCascadeId());
            }else if( "公海".equals(dto.getCascadeIdStr()) ){
                dto.setCascadeId(-1);
            }else{
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【所属人】所填内容与系统选项不匹配");
            }
        }*/
      //课程顾问
        if(StringUtils.isBlank(dto.getCascadeIdStr())){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【课程顾问】不能为空");
        }
        else{
            if("公海".equals(dto.getCascadeIdStr()) ){
                dto.setCascadeId(-1);
            }else{
                TxCascadeCredentialDto cascadeDto = cascadeMap.get(dto.getCascadeIdStr());
                if(cascadeDto==null){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【课程顾问】所填内容不是天校员工");
                }else{
                    dto.setCascadeId(cascadeDto.getCascadeId());
                }
            }

        }

        //7 标签
        if(StringUtils.isNotBlank(dto.getTagsStr())){
            String[] tags = dto.getTagsStr().split("[,|，]");
            Map<String,String> map = new LinkedHashMap<String,String>();
            for(String t:tags){
                if(StringUtils.isNotBlank(t)){
                    map.put(t, "");
                }
            }
            if(map.keySet().size() > 30){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【标签】最多输入30个标签");
            }
            for(String tag:map.keySet()){
//              if(!TxConsultUser.validateStr(tag)){
//                  throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【标签】多个标签用逗号进行间隔，不能包含其他特殊字符或空格");
//              }else 
                if(tag.length()>15){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【标签】单个标签最多输入15个字符");
                }
            }
        }

        //8 亲属关系
        if(StringUtils.isNotBlank(dto.getRelativesStr())){
            if( Relatives.getValue(dto.getRelativesStr()) == null){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【亲属关系】所填内容与系统选项不匹配");
            }else{
                dto.setRelatives(Relatives.getValue(dto.getRelativesStr()));
            }
        }

        //9 家长姓名
        if( StringUtils.isNotBlank(dto.getParentName()) ){
            if( dto.getParentName().length()>30 ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长姓名】最多输入30个字符");
            }
//            if( !TxConsultUser.validateStr(dto.getParentName())){
//              throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长姓名】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//            }
        }

        //10 家长手机号
        if( StringUtils.isNotBlank(dto.getParentMobile()) ){
            if( StringUtils.isBlank(dto.getParentMobile()) ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】不能为空");
            }
            if( dto.getParentMobile().length()!=11 ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】需为11位数字");
            }
            if( !dto.getParentMobile().startsWith("1")){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】必须以1开头");
            }
            if( !ParamValidateUtils.validateMobile(dto.getParentMobile())){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】不能包含特殊字符或空格");
            }
        }

        //11 生日


        //12 学校
        if( StringUtils.isNotBlank(dto.getSchool()) ){
            if( dto.getSchool().length()>30 ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【公立学校】最多输入30个字符");
            }
//            if( !TxConsultUser.validateStr(dto.getSchool())){
//              throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【公立学校】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//            }
        }

        //13 年级
        if( StringUtils.isNotBlank(dto.getDegreeClass()) ){
            if( dto.getDegreeClass().length()>30 ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【年级】最多输入30个字符");
            }
//            if( !TxConsultUser.validateStr(dto.getDegreeClass())){
//              throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【年级】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//            }
        }

        //14 qq
        if( StringUtils.isNotBlank(dto.getQq()) ){
            if( dto.getQq().length()>30 ){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【QQ】最多输入30个字符");
            }
            if( !Pattern.matches("^[0-9]*$", dto.getQq())){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【QQ】需填写数字");
            }
        }

        //15 邮箱
        if( StringUtils.isNotBlank(dto.getMail()) ){
            if(dto.getMail().length()>50){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【邮箱】最多输入50个字符");
            }
            if( !Pattern.matches("^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$", dto.getMail())){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【邮箱】格式不正确");
            }
        }
        
        /*//16 省、市、区
        String province = dto.getProvince();
        String city = dto.getCity();
        String county = dto.getCounty();

        String address = dto.getAddress();
        String region = "";
        int level = 0;
        if (StringUtils.isNotBlank(county)) {
            region = county;
            //level = AreaUtils.AreaLevel.COUNTY.ordinal();
            level = 3;
        } else if (StringUtils.isNotBlank(city)) {
            region = city;
            //level = AreaUtils.AreaLevel.CITY.ordinal();
            level = 2;
        } else if (StringUtils.isNotBlank(province)) {
            region = province;
            //level = AreaUtils.AreaLevel.PROVINCE.ordinal();
            level = 1;
        }

        int areaId = this.getAreaId(region, level);

        Location location;
        try {
            location = BaiduMapUtils.getLngAndLat(address, region);
            if (location != null) {
                dto.setLatitude(location.getLat());
                dto.setLongitude(location.getLng());
            }
            dto.setAreaId(areaId);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }*/



        List<TxConsultUser> targets = this.txConsultUserDao.lookByMobile(orgId, dto.getMobile());
        if(!updateRepeat){
            if (targets != null && !targets.isEmpty()) {
                throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "【手机号】该手机号已对应其他线索");
            }
        }else{
            if (targets.size()>1) {
                throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "【手机号】该手机号已对应多条线索,无法处理");
            }else if (targets.size() == 1 && targets.get(0).getDelStatus().intValue()==0 && !targets.get(0).getCascadeId().equals(-1)){
                if(dto.getCascadeId() != targets.get(0).getCascadeId().longValue()){
                    String name = "";
                    if(targets.get(0).getCascadeId().longValue() == -1){
                        name = "公海";
                    }else if(targets.get(0).getCascadeId().longValue() == 0){
                        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
                        name = orgInfo.getShowName();
                    }else{
                        TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(targets.get(0).getCascadeId());
                        TXCascadeCredential txCascadeCredential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
                        name = txCascadeCredential.getName();
                    }
                    throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "该线索已存在，课程顾问为:"+name);
                }
            }
        }

    }

    private void buildConsultDtoOld(Long cascadeId, ConsultListResponseDto dto, Object[] lineData, List<String> headers,boolean updateRepeat, Long orgId) {

        Preconditions.checkArgument(lineData.length == headers.size(), "数据数目和表头不匹配");
        Preconditions.checkArgument(validateHeader(headers), "表头格式错误:" + headers.toString());

        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);

        for (int i = 0; i < lineData.length; i++) {
            String fieldName = cache.get(headers.get(i)).get("propName").toString();

            if (fieldName != null && fieldName.equals("birthday") && lineData[i]!=null && !lineData[i].equals("")){
        		try{
        			Date date = dateFormat.parse(lineData[i].toString());
        			dto.setBirthdayStr( dateFormat.parse(lineData[i].toString()) );
        			dto.setBirthday(date.getTime());
        			lineData[i] = lineData[i].toString();
        			break;
        		}catch(Exception e){
        		}
            }
        }

        for (int i = 0; i < lineData.length; i++) {
            String fieldName = cache.get(headers.get(i)).get("propName").toString();

            boolean empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
            String name = headers.get(i);
            Object value = lineData[i];
            if (fieldName != null) {
            	if(fieldName.equals("birthday") && lineData[i]!=null && !lineData[i].equals("")){
            		try{
            			Date date = dateFormat.parse(lineData[i].toString());
            			dto.setBirthdayStr( dateFormat.parse(lineData[i].toString()) );
            			dto.setBirthday(date.getTime());
            			lineData[i] = lineData[i].toString();
            			continue;
            		}catch(Exception e){
            			throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【生日】格式有误，需为2001/1/1或者2001-1-1样式");
            		}
            	}
                if (empty && (value == null || "".equals(value))) {
                    throw new BussinessException(CrmErrorCode.FORMAT_ERROR, "【" + name + "】不能为空");
                }
                try {
                    if (value != null && !(value instanceof String && StringUtils.isBlank((String) value))) {
                    	if(value instanceof String){
                    		value = value.toString().trim();
                    	}
                        BeanUtils.setProperty(dto, fieldName, value);
                    }
                } catch (IllegalAccessException | InvocationTargetException e) {
                    log.warn("set ConsultInfoResponseDto.{} = {} failed!", fieldName, value);
                    throw new BussinessException(CrmErrorCode.FORMAT_ERROR);
                }
            }
        }

        // 线索来源
    	if( StringUtils.isBlank(dto.getConsultSourceStr()) ){
    		//dto.setConsultSource(MessageSource.IMPORT.getValue());
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】不能为空");
    	}else{
	    	if( dto.getConsultSourceStr().length()>30 ){
	    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】最多输入30个字符");
	    	}
	    	ConsultCustomSourceDto sourceDto = consultSourceService.getByLabel(orgId, dto.getConsultSourceStr());
	    	if(sourceDto==null){
	    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】所填内容与系统选项不匹配");
	    	}else{
	    		if(Flag.getBoolean(sourceDto.getIsPaused())){
	    			throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【线索来源】该来源类型已被停用");
	    		}else{
	    			dto.setConsultSource(sourceDto.getId().intValue());
	    		}
	    	}
    	}

        //1 姓名
        if( StringUtils.isBlank(dto.getName()) ){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【姓名】不能为空");
    	}
        if( dto.getName().length()>30 ){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【姓名】最多输入30个字符");
    	}
//        if( !TxConsultUser.validateStr(dto.getName())){
//        	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【姓名】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//        }


    	//2 手机号
    	if( StringUtils.isBlank(dto.getMobile()) ){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】不能为空");
    	}
    	if( dto.getMobile().length()!=11 ){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】需为11位数字");
    	}
    	if( !dto.getMobile().startsWith("1")){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】必须以1开头");
    	}
    	if( !ParamValidateUtils.validateMobile(dto.getMobile())){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【手机号】不能包含特殊字符或空格");
    	}

    	//3 性别
    	if(StringUtils.isNotBlank(dto.getSexStr())){
    		if ( dto.getSexStr().equals(GenderStatus.FEMAN.getName())) {
            	dto.setSex(GenderStatus.FEMAN.getCode());
            } else if ( dto.getSexStr().equals(GenderStatus.MAN.getName())) {
            	dto.setSex(GenderStatus.MAN.getCode());
            }else{
            	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【性别】所填内容与系统选项不匹配");
            }
    	}else{
    		dto.setSex(GenderStatus.NONE.getCode());
    	}

    	//4 跟进状态
    	if(StringUtils.isNotBlank(dto.getConsultStatusStr())){
	    	if( ConsultUserStatus.getValue(dto.getConsultStatusStr()) == null){
	    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【跟进状态】所填内容与系统选项不匹配");
	    	}else{
	    		dto.setConsultStatus(ConsultUserStatus.getValue(dto.getConsultStatusStr()));
	    	}
    	}

    	//5 意向级别
    	if(StringUtils.isNotBlank(dto.getIntensionLevelStr())){
	    	if( IntentionLevel.getValue(dto.getIntensionLevelStr()) == null){
	    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【意向级别】所填内容与系统选项不匹配");
	    	}else{
	    		dto.setIntensionLevel(IntentionLevel.getValue(dto.getIntensionLevelStr()));
	    	}
    	}

    	//6 所属人
    	if(StringUtils.isBlank(dto.getCascadeIdStr())){
    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【所属人】不能为空");
    	}else{
	    	if( "自己".equals(dto.getCascadeIdStr()) ){
	    		dto.setCascadeId(TianxiaoPCContext.getTXCascadeId() == null ? 0 : TianxiaoPCContext.getTXCascadeId());
	    	}else if( "公海".equals(dto.getCascadeIdStr()) ){
	    		dto.setCascadeId(-1);
	    	}else{
	    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【所属人】所填内容与系统选项不匹配");
	    	}
    	}

    	//7 标签
    	if(StringUtils.isNotBlank(dto.getTagsStr())){
    		String[] tags = dto.getTagsStr().split("[,|，]");
    		Map<String,String> map = new LinkedHashMap<String,String>();
        	for(String t:tags){
        		if(StringUtils.isNotBlank(t)){
        			map.put(t, "");
        		}
        	}
    		if(map.keySet().size() > 30){
    			throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【标签】最多输入30个标签");
    		}
    		for(String tag:map.keySet()){
//    			if(!TxConsultUser.validateStr(tag)){
//    				throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【标签】多个标签用逗号进行间隔，不能包含其他特殊字符或空格");
//    			}else 
    			if(tag.length()>15){
    				throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【标签】单个标签最多输入15个字符");
    			}
    		}
    	}

    	//8 亲属关系
    	if(StringUtils.isNotBlank(dto.getRelativesStr())){
	    	if( Relatives.getValue(dto.getRelativesStr()) == null){
	    		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【亲属关系】所填内容与系统选项不匹配");
	    	}else{
	    		dto.setRelatives(Relatives.getValue(dto.getRelativesStr()));
	    	}
    	}

    	//9 家长姓名
    	if( StringUtils.isNotBlank(dto.getParentName()) ){
    		if( dto.getParentName().length()>30 ){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长姓名】最多输入30个字符");
        	}
//            if( !TxConsultUser.validateStr(dto.getParentName())){
//            	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长姓名】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//            }
    	}

    	//10 家长手机号
    	if( StringUtils.isNotBlank(dto.getParentMobile()) ){
    		if( StringUtils.isBlank(dto.getParentMobile()) ){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】不能为空");
        	}
        	if( dto.getParentMobile().length()!=11 ){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】需为11位数字");
        	}
        	if( !dto.getParentMobile().startsWith("1")){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】必须以1开头");
        	}
        	if( !ParamValidateUtils.validateMobile(dto.getParentMobile())){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【家长手机号】不能包含特殊字符或空格");
        	}
    	}

    	//11 生日


    	//12 学校
    	if( StringUtils.isNotBlank(dto.getSchool()) ){
    		if( dto.getSchool().length()>30 ){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【公立学校】最多输入30个字符");
        	}
//            if( !TxConsultUser.validateStr(dto.getSchool())){
//            	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【公立学校】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//            }
    	}

    	//13 年级
    	if( StringUtils.isNotBlank(dto.getDegreeClass()) ){
    		if( dto.getDegreeClass().length()>30 ){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【年级】最多输入30个字符");
        	}
//            if( !TxConsultUser.validateStr(dto.getDegreeClass())){
//            	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【年级】文本包含特殊字符，请输入中英文、数字、括号、下划线、中划线");
//            }
    	}

    	//14 qq
    	if( StringUtils.isNotBlank(dto.getQq()) ){
    		if( dto.getQq().length()>30 ){
        		throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【QQ】最多输入30个字符");
        	}
            if( !Pattern.matches("^[0-9]*$", dto.getQq())){
            	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【QQ】需填写数字");
            }
    	}

    	//15 邮箱
    	if( StringUtils.isNotBlank(dto.getMail()) ){
    		if(dto.getMail().length()>50){
    			throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【邮箱】最多输入50个字符");
    		}
    		if( !Pattern.matches("^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$", dto.getMail())){
            	throw new BussinessException(CommonErrorCode.PARAM_ERROR, "【邮箱】格式不正确");
            }
    	}

        //16 省、市、区
        String province = dto.getProvince();
        String city = dto.getCity();
        String county = dto.getCounty();

        String address = dto.getAddress();
        String region = "";
        int level = 0;
        if (StringUtils.isNotBlank(county)) {
            region = county;
            //level = AreaUtils.AreaLevel.COUNTY.ordinal();
            level = 3;
        } else if (StringUtils.isNotBlank(city)) {
            region = city;
            //level = AreaUtils.AreaLevel.CITY.ordinal();
            level = 2;
        } else if (StringUtils.isNotBlank(province)) {
            region = province;
            //level = AreaUtils.AreaLevel.PROVINCE.ordinal();
            level = 1;
        }

        long areaId = this.getAreaId(region, level);

        Location location;
		try {
			location = BaiduMapUtils.getLngAndLat(address, region);
			if (location != null) {
	        	dto.setLatitude(location.getLat());
	        	dto.setLongitude(location.getLng());
	        }
	        dto.setAreaId(areaId);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}



        List<TxConsultUser> targets = this.txConsultUserDao.lookByMobile(orgId, dto.getMobile());
        if(!updateRepeat){
        	if (targets != null && !targets.isEmpty()) {
            	throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "【手机号】该手机号已对应其他线索");
            }
        }else{
            if (targets.size()>1) {
            	throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "【手机号】该手机号已对应多条线索,无法处理");
            }else if (targets.size() == 1 && targets.get(0).getDelStatus().intValue()==0 && !targets.get(0).getCascadeId().equals(-1)){
            	if(dto.getCascadeId() != targets.get(0).getCascadeId().longValue()){
            		String name = "";
            		if(targets.get(0).getCascadeId().longValue() == -1){
            			name = "公海";
            		}else if(targets.get(0).getCascadeId().longValue() == 0){
            			OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            			name = orgInfo.getShowName();
            		}else{
            			TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(targets.get(0).getCascadeId());
                        TXCascadeCredential txCascadeCredential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
                        name = txCascadeCredential.getName();
            		}
            		throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "该线索已存在，课程顾问为:"+name);
            	}
            }
        }

    }


    @Override
    public BatchSaveResult batchImportDatas(Long orgId, Long cascadeId, List<String> headers, List<Object[]> datas,
                                            boolean updateRepeat) {
        BatchSaveResult batchSaveResult = new BatchSaveResult();
        for (int i = 0; i < datas.size(); i++) {
            Object[] data = datas.get(i);
            try {
                SingleSaveErrorResult singleSaveErrorResult = saveSingleData(orgId, cascadeId, headers, data, updateRepeat);
                if (singleSaveErrorResult.isRepeat()) {
                    batchSaveResult.getRepeatIndexs().add(i);
                }
            } catch (Throwable ex) {
                batchSaveResult.getFailIndexs().add(i);
            }
        }

        return batchSaveResult;
    }

    @Override
    public void afterComplete(int successNumber) {
        log.info("[Notice] Batch notice");
        Map<String, Object> param = new HashMap<>();
        param.put("clue_category", 2);
		NoticeMsgContent content = NoticeMsgContent.createNoticeContent(NoticeType.BATCH_IMPORT,
				ActionUtil.getAction(ActionUtil.ACTION_TO_CRM_CLUE_LIST, param));
        content.setTip(PushTipFactory.getBatchImportTip(successNumber));
        content.setPushTitle(PushTipFactory.IMPORT_CLUE_TITEL);
		messageService.sendNotice(TianxiaoPCContext.getOrgId().longValue(), -1, content);
    }

    @Override
    public int[] getUniqueIndex() {
        return new int[]{1};
    }

	@Override
	public SingleSaveErrorResult validate(Long orgId, Long cascadeId, List<String> headers,
										  SingleSaveErrorResult result,
										  List<SingleSaveErrorResult> dataList, boolean updateRepeat) {

		result.setSuccess(true);
		try{
		    ConsultImportModel model = new ConsultImportModel();
			buildConsultDtoNew(cascadeId, model, result.getLineData(), headers, updateRepeat, orgId);

		}catch(BussinessException e){
			result.setSuccess(false);
			result.setErrorMsg(e.getMessage());

		}catch(Exception e){
			log.error("",e);
			result.setSuccess(false);
			result.setErrorMsg(CommonErrorCode.SYSTEM_ERROR.getMessage());
		}

		return result;
	}

	@Override
	public void downloadValidateResult(OutputStream os, Long orgId, String taskId, Collection<SingleSaveErrorResult> data) {
		InputStream in = null;

		try{
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLUE_RESULT_TEMPLATE_PATH);
	        XSSFWorkbook workbook = new XSSFWorkbook(in);
	        XSSFSheet sheet = workbook.getSheetAt(1);
	        XSSFRow row = null;
	        int demoRowNo = 2;
	        int rowNo = demoRowNo;
	        int cellNo = 0;

	        XSSFRow titleRow = sheet.getRow(1);
            XSSFCell defualtTitlecell = titleRow.getCell(titleRow.getFirstCellNum());
            XSSFCellStyle defaultTitleCellStype = defualtTitlecell.getCellStyle();
            int lasterCellNum = titleRow.getLastCellNum();
            int tempColumnNum = lasterCellNum;
            List<CustomFieldResponse> fields = customFieldService.getCustomFieldList(orgId.longValue());
            Map<String,CustomFieldResponse>  fieldMap = Maps.newHashMap();
            for(CustomFieldResponse field: fields){
                if(field.getIsSystem()==0 && field.getIsPaused()==0){
                    fieldMap.put(field.getLabel(), field);
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet, 1, tempColumnNum, defaultTitleCellStype, field.getLabel());
                    buildFieldPrompt(field,sheet,tempColumnNum);
                    tempColumnNum++;
                }
            }

	        Map<Integer,ExcelUtils.CellInfo> demoFormatMap = ExcelUtils.getCellInfoMap(sheet, demoRowNo, 0, tempColumnNum-1);
	        Object value = null;
	        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);
	        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");

	        sheet.getRow(demoRowNo).createCell(0);
	        XSSFCellStyle rightCellStyle = sheet.getRow(demoRowNo).getCell(0).getCellStyle();
	        rightCellStyle.setWrapText(true);
	        rightCellStyle.setLocked(false);
	        rightCellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	        ExcelUtils.fillCellStyleWithBGColor(rightCellStyle, new XSSFColor(Color.WHITE) ,CellStyle.SOLID_FOREGROUND);
			ExcelUtils.fillCellStyleWithFullBorder(rightCellStyle, CellStyle.BORDER_THIN, IndexedColors.GREY_25_PERCENT.getIndex());

			XSSFCellStyle errorCellStyle = (XSSFCellStyle)rightCellStyle.clone();
			ExcelUtils.fillCellStyleWithBGColor(errorCellStyle, new XSSFColor(Color.YELLOW) ,CellStyle.SOLID_FOREGROUND);

			XSSFRow newtitleRow = sheet.getRow(1);
	        //1. 填充 错误数据
	        for(SingleSaveErrorResult result:data){
	        	if(result.isSuccess() == false){
	        		if(sheet.getRow(rowNo) == null){
		    			row = sheet.createRow(rowNo);
		    		}
	        		cellNo = 0;
	        		for(int i=0;i<=result.getLineData().length;i++){
	        			if(i==0){
	        				value = result.getErrorMsg();
	        			}else{
	        				value = result.getLineData()[i-1];
	        			}
	        			if(sheet.getRow(demoRowNo).getCell(cellNo) == null){
	        				sheet.getRow(demoRowNo).createCell(cellNo);
	        			}


	        			if(i==12 && result.getLineData()[i-1]!=null && !result.getLineData()[i-1].toString().equals("")){
	        				try{
	        					Date date = new Date(Long.parseLong(result.getLineData()[i-1].toString()));
		        				ExcelUtils.fillTheXSSFCellWithDateValue(sheet, rowNo,cellNo, ExcelUtils.decorateStyleWithDataFormatMap(cellNo,errorCellStyle,demoFormatMap), date);
		        				cellNo++;
		        				continue;
	        				}catch(Exception e){
	        				}
	        			}

	        			String title = newtitleRow.getCell(i).getStringCellValue();

                        String valueStr = this.excelValue2Str(value, title, fieldMap);

                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, errorCellStyle, valueStr);
	        			cellNo++;
	        		}
	        		rowNo++;
	        	}
	        }

	        //2. 填充 正确数据
	        Object rightValue = null;
	        for(SingleSaveErrorResult result:data){
	        	if(result.isSuccess() == true){
	        		if(sheet.getRow(rowNo) == null){
		    			row = sheet.createRow(rowNo);
		    		}
	        		cellNo = 0;
	        		for(int i=0;i<=result.getLineData().length;i++){

	        			if(i==0){
	        				rightValue = "";
	        			}else{
	        				rightValue = result.getLineData()[i-1];
	        			}
	        			if(sheet.getRow(demoRowNo).getCell(cellNo) == null){
	        				sheet.getRow(demoRowNo).createCell(cellNo);
	        			}

	        			if(i==12 && result.getLineData()[i-1]!=null && !result.getLineData()[i-1].toString().equals("")){
	        				try{
	        					Date date = new Date(Long.parseLong(result.getLineData()[i-1].toString()));
		        				ExcelUtils.fillTheXSSFCellWithDateValue(sheet, rowNo,cellNo, ExcelUtils.decorateStyleWithDataFormatMap(cellNo,rightCellStyle,demoFormatMap), date);
		        				cellNo++;
		        				continue;
	        				}catch(Exception e){}
	        			}

                        String title = newtitleRow.getCell(i).getStringCellValue();

                        String valueStr = this.excelValue2Str(rightValue, title, fieldMap);

                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, rightCellStyle, valueStr);
	        			cellNo++;
	        		}
	        		rowNo++;
	        	}
	        }

	        workbook.write(os);
		}catch(Exception e){
			e.printStackTrace();
			log.error("",e);
		}finally{
			try {
				if(os!=null){
					os.close();
				}
				if(in!=null){
					in.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

	}

	@Override
	public void downloadImportResult(OutputStream os, Long orgId, String taskId, Collection<SingleSaveErrorResult> data) {
		InputStream in = null;

		try{
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLUE_RESULT_TEMPLATE_PATH);
	        XSSFWorkbook workbook = new XSSFWorkbook(in);
	        XSSFSheet sheet = workbook.getSheetAt(1);

	        XSSFRow row = null;
	        int demoRowNo = 2;
	        int rowNo = demoRowNo;
	        int cellNo = 0;
	        XSSFRow titleRow = sheet.getRow(1);
            XSSFCell defualtTitlecell = titleRow.getCell(titleRow.getFirstCellNum());
            XSSFCellStyle defaultTitleCellStype = defualtTitlecell.getCellStyle();
            int lasterCellNum = titleRow.getLastCellNum();
            int tempColumnNum = lasterCellNum;
            List<CustomFieldResponse> fields = customFieldService.getCustomFieldList(orgId.longValue());
            Map<String,CustomFieldResponse>  fieldMap = Maps.newHashMap();
            for(CustomFieldResponse field: fields){
                if(field.getIsSystem()==0 && field.getIsPaused()==0){
                    fieldMap.put(field.getLabel(), field);
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet, 1, tempColumnNum, defaultTitleCellStype, field.getLabel());
                    buildFieldPrompt(field,sheet,tempColumnNum);
                    tempColumnNum++;
                }
            }

	        Map<Integer,ExcelUtils.CellInfo> demoFormatMap = ExcelUtils.getCellInfoMap(sheet, demoRowNo, 0, tempColumnNum-1);
	        Object value = null;
	        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);
	        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");

	        sheet.getRow(demoRowNo).createCell(0);
	        XSSFCellStyle errorCellStyle = sheet.getRow(demoRowNo).getCell(0).getCellStyle();
	        errorCellStyle.setWrapText(true);
	        errorCellStyle.setLocked(false);
	        errorCellStyle.setAlignment(HSSFCellStyle.ALIGN_LEFT);
	        ExcelUtils.fillCellStyleWithFullBorder(errorCellStyle, CellStyle.BORDER_THIN, IndexedColors.GREY_25_PERCENT.getIndex());
	        ExcelUtils.fillCellStyleWithBGColor(errorCellStyle, new XSSFColor(Color.YELLOW) ,CellStyle.SOLID_FOREGROUND);

	        XSSFRow newtitleRow = sheet.getRow(1);
	        //1. 填充 错误数据
	        for(SingleSaveErrorResult result:data){
	        	if(result.isSuccess() == false){
	        		if(sheet.getRow(demoRowNo).getCell(cellNo) == null){
        				sheet.getRow(demoRowNo).createCell(cellNo);
        			}
	        		cellNo = 0;
	        		for(int i=0;i<=result.getLineData().length;i++){
	        			if(i==0){
	        				value = result.getErrorMsg();
	        			}else{
	        				value = result.getLineData()[i-1];
	        			}
	        			if(sheet.getRow(demoRowNo).getCell(cellNo) == null){
	        				sheet.getRow(demoRowNo).createCell(cellNo);
	        			}


	        			if(i==12 && result.getLineData()[i-1]!=null && !result.getLineData()[i-1].toString().equals("")){
	        				try{
		        				Date date = dateFormat.parse(result.getLineData()[i-1].toString());
		        				ExcelUtils.fillTheXSSFCellWithDateValue(sheet, rowNo,cellNo, ExcelUtils.decorateStyleWithDataFormatMap(cellNo,errorCellStyle,demoFormatMap), date);
		        				cellNo++;
		        				continue;
	        				}catch(Exception e){}
	        			}


                        String title = newtitleRow.getCell(i).getStringCellValue();

                        String valueStr = this.excelValue2Str(value, title, fieldMap);

                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, errorCellStyle, valueStr);
	        			cellNo++;
	        		}
	        		rowNo++;
	        	}
	        }

	        workbook.write(os);
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			try {
				if(os!=null){
					os.close();
				}
				if(in!=null){
					in.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public void downloadImportTemplate(OutputStream os) {
		InputStream in = null;

		try{
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLUE_IMPORT_TEMPLATE_PATH);
	        XSSFWorkbook workbook = new XSSFWorkbook(in);

	        Long orgId = TianxiaoPCContext.getOrgId().longValue();
            if (orgId == null || orgId == 0) {
                throw new BussinessException(CommonErrorCode.TOKEN_ERROR, "TOKEN不正确");
            }
            List<CustomFieldResponse> fields = customFieldService.getCustomFieldList(orgId.longValue());
            Map<String,TxCascadeCredentialDto> cascadeMap = this.getOrgCascadeMapFieldMap(orgId);

            this.buildStudentTemplate(workbook, fields, true);
            //this.buildCascadeColumnPrompts(workbook, cascadeMap.values(), 5);
	        workbook.write(os);
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			if(os!=null){
				try {
					os.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if(in!=null){
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

	}

	private void buildCascadeColumnPrompts(XSSFWorkbook workbook,Collection<TxCascadeCredentialDto> cascades,int cellNum){
        XSSFSheet sheet = workbook.getSheetAt(1);

        XSSFRow titleRow = sheet.getRow(1);
        int lasterCellNum = titleRow.getLastCellNum();

        String promptTitle ="";
        String promptContent = "输入员范围:";

        List<String> cascadeNameList = Lists.newArrayList();
        for(TxCascadeCredentialDto dto:cascades){
            cascadeNameList.add(dto.getName());
        }
        String cascadeStr = StringUtils.join(cascadeNameList,",");
        promptContent+=cascadeStr;
        ExcelUtils.setHSSFStringPrompt(sheet,promptTitle,cascadeStr,2,1000,cellNum,cellNum);

    }

	private void buildStudentTemplate(XSSFWorkbook workbook,List<CustomFieldResponse> fields,boolean needPrompts){
        XSSFSheet sheet = workbook.getSheetAt(1);

        XSSFRow titleRow = sheet.getRow(1);
        //int firstCellNum = titleRow.getFirstCellNum();
        int lasterCellNum = titleRow.getLastCellNum();

        XSSFCell defualtTitlecell = titleRow.getCell(titleRow.getFirstCellNum());
        XSSFCellStyle defaultTitleCellStype = defualtTitlecell.getCellStyle();

        //Map<Integer,CellInfo> cellInfoTitleMap = ExcelUtils.getCellInfoMap(sheet, 1, firstCellNum, firstCellNum);


        int tempColumnNum = lasterCellNum;

        for(CustomFieldResponse field: fields){
            if(field.getIsSystem()==0 && field.getIsPaused()==0){
                ExcelUtils.fillTheXSSFCellWithStringValue(sheet, 1, tempColumnNum, defaultTitleCellStype, field.getLabel());

                buildFieldPrompt(field,sheet,tempColumnNum);

                tempColumnNum++;
               // ExcelUtils.f
            }
        }


    }

	private void buildFieldPrompt(CustomFieldResponse field,XSSFSheet sheet,int tempColumnNum){
        String promptTitle ="";
        String promptContent = "";
        int type = field.getType();
        boolean required = field.getIsRequired()==1;


        promptContent+=required?"必填,":"非必填,";

        if(type==1){
            promptContent += "请输入不超过30个字符;";
        }
        else if(type==4){
            promptContent += "日期需为2000/1/1或者2000-1-1格式;";
        }
        else if(type==2||type==3){

            List<String> options = Lists.newArrayList();
            for(OptionDto optionDto:field.getOptionList()){
                if(optionDto.getIsPaused()==0){
                    options.add(optionDto.getLabel());
                }
            }
            String optionStr = StringUtils.join(options,",");
            if(StringUtils.isNotBlank(optionStr)){
                promptContent += "请在\""+optionStr+"\"中选择输入;";
            }

            if(type==3){
                promptContent+="不同选项用逗号分隔;";
            }
        }
        ExcelUtils.setHSSFStringPrompt(sheet,promptTitle,promptContent,2,1000,tempColumnNum,tempColumnNum);
    }

	@Override
	public String validateResult(List<SingleSaveErrorResult> list) {
		if(CollectionUtils.isNotEmpty(list)){
			Map<String,SingleSaveErrorResult> map = new HashMap<String,SingleSaveErrorResult>();
			String key = null;
			for(SingleSaveErrorResult s:list){
				key = s.getLineData()[1]==null? "":s.getLineData()[1].toString();
				if(s.isSuccess() && map.get(key)!=null){
					s.setSuccess(false);
					s.setErrorMsg("【手机号】该手机号已对应其他线索");
				}
				map.put(key, s);
			}
		}
		return null;
	}


    public boolean validateHeader(List<String> headers,Long orgId) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }

        Map<String,CustomFieldResponse> realCustomFields = getOrgRealCutomFieldMap(orgId);
        log.info("cache info ={},header={}",cache,headers);
        log.info("headers size={},cache size={},realCustomFields size={}",headers.size(),cache.size(),realCustomFields.size());
        if((realCustomFields.size()+cache.size())!=headers.size()){
            return false;
        }
        for (String header : headers) {
            if(!cache.containsKey(header)){
                if(!realCustomFields.containsKey(header)){
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkisDateType(String title,Map<String,CustomFieldResponse> realCustomFields){
        if(realCustomFields.containsKey(title)){
            CustomFieldResponse field = realCustomFields.get(title);
            return field.getType()==4;
        }
        return false;
    }

    private String excelValue2Str(Object value,String title,Map<String,CustomFieldResponse> realCustomFields){
        boolean isDateType = this.checkisDateType(title, realCustomFields);
        String valueStr = "";
        if(value !=null){
            if(isDateType){
                if(value instanceof Long){
                    Date date = new Date((Long)value);
                    SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
                    valueStr = dateFormat2.format(date);
                }
                else{
                    valueStr = value.toString();
                }
            }else{
                valueStr = value.toString();
            }

        }
        return valueStr;
    }
    private  Map<String,CustomFieldResponse>  getOrgRealCutomFieldMap(Long orgId){
        List<CustomFieldResponse> fields = customFieldService.getCustomFieldList(orgId.longValue());
        Map<String,CustomFieldResponse> realCustomFields = Maps.newHashMap();
        for(CustomFieldResponse field :fields){
            if(field.getIsSystem()==0 && field.getIsPaused()==0){
                realCustomFields.put(field.getLabel(),field);
            }
        }
        return realCustomFields;
    }

    private  Map<String,TxCascadeCredentialDto>  getOrgCascadeMapFieldMap(Long orgId){

        List<TxCascadeCredentialDto> list = txCascadeCredentialService.getTxCascadeCredentialList(orgId.longValue());
        Map<String,TxCascadeCredentialDto> cascadeMap = Maps.newHashMap();
        for(TxCascadeCredentialDto cascade :list){
            cascadeMap.put(cascade.getName(), cascade);
        }
        return cascadeMap;
    }

    private Map<String,CustomFieldResponse> getOrgRealCutomFieldMapFromThreadLocal(Long orgId){
        Map<String,CustomFieldResponse> customMap;
        if(BizDateThreadLocalUtil.get(org_customfield_map_Key) == null){
            customMap = getOrgRealCutomFieldMap(orgId);
            BizDateThreadLocalUtil.set(org_customfield_map_Key, customMap);

        }else{
            customMap = (Map<String,CustomFieldResponse>)BizDateThreadLocalUtil.get(org_customfield_map_Key);
        }
        return customMap;
    }

    private Map<String,TxCascadeCredentialDto> getOrgCascadeMapFromThreadLocal(Long orgId){
        Map<String,TxCascadeCredentialDto> cascadeMap;
        if(BizDateThreadLocalUtil.get(org_cascade_map_Key) == null){
            cascadeMap = getOrgCascadeMapFieldMap(orgId);
            BizDateThreadLocalUtil.set(org_cascade_map_Key, cascadeMap);

        }else{
            cascadeMap = (Map<String,TxCascadeCredentialDto>)BizDateThreadLocalUtil.get(org_cascade_map_Key);
        }
        return cascadeMap;
    }


    public static void main(String[] args) throws Exception{
        String strValue = "中文";
        List<String> result = Splitter.onPattern("[,|，]").trimResults().splitToList(strValue);
        System.out.println(result);
    }
}
