package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.consult.enums.ConsulterOutLineType;
import com.baijia.tianxiao.biz.consult.enums.GenderStatus;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.query.ConsultUserQuery;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.field.FieldOption;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.display.dto.response.crm.DefaultClueField;
import com.baijia.tianxiao.sal.display.service.FieldShowInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wangsixia
 * @version 1.0
 * @title ClueServiceImpl
 * @desc 招生线索
 * @date 2016年3月16日
 */

@Service
@Slf4j
public class ClueServiceImpl implements ClueService {
    // 课程顾问
    private static final String CASCADE_ID_STR = "cascadeIdStr";
    // 来源
    private static final String CONSULT_SOURCES_TR = "consultSourceStr";
    // 标签
    private static final String TAGS_STR = "tagsStr";

    @Resource
    private TxConsultUserDao txConsultUserDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private ConsultUserService consultUserService;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;
    @Autowired
    private OrgStudentTagService orgStudentTagService;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private ConsultUserQuery consultUserQuery;
    @Autowired
    private ConsultMessageService consultMessageService;
    @Autowired
    private FieldShowInfoService fieldShowInfoService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    
    @Autowired
    private StudentUserService studentUserService;

    @Autowired
    private TXStudentCommentAPIService commentAPIService;
    
    @Override
    public ConsultInfoResponseDto getBaseInfo(Long orgId, Long consulterId) throws Exception {
        if (null == orgId || orgId <= 0 || null == consulterId || consulterId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, consulterId);
        if (null == consulter) {
            throw new BussinessException(CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        ConsultInfoResponseDto baseInfoDto = new ConsultInfoResponseDto();
        this.cluePo2Dto(consulter, baseInfoDto);

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile(baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile(baseInfoDto.getParentMobile()));
        }
        log.info("getBaseInfo---------baseInfoDto={}", baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        return addClueInfo(orgId, clueInfo, false, true);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, boolean updateRepeat, boolean sendNotice) throws Exception {
        if (null == orgId || orgId <= 0 || null == clueInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        TxConsultUser consulter = null;
        Long preOnwerCascadeId = null;
        if (updateRepeat) {
            List<TxConsultUser> consulters = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile());
            if (CollectionUtils.isNotEmpty(consulters)) {
                consulter = consulters.get(0);
                preOnwerCascadeId = consulter.getCascadeId();
                clueInfo.setId(consulter.getId());
            } else {
                consulter = new TxConsultUser();
            }
        } else {
            this.vaildateConsult(orgId, clueInfo);
            consulter = new TxConsultUser();
        }

        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
        log.debug("txSaleClueRule={}", txSaleClueRule);

        consulter.setIsConsulter(Flag.TRUE.getInt());// 默认是线索
        this.clueDto2Po(clueInfo, consulter, orgId);
        if (consulter.getId() != null && consulter.getId() > 0) {
            this.txConsultUserDao.updateWithDefaultVal(consulter);
        } else {
            this.txConsultUserDao.save(consulter, false);
            log.info("addClueInfo---------consulter={}", consulter.toString());
            commentAPIService.saveByConsultUserManualAdd(consulter);
        }

        // 领取线索
        Date now = new Date();
        if (clueInfo.getCascadeId() >= 0 && (preOnwerCascadeId == null || preOnwerCascadeId.equals(-1L))) {
            consulter.setFinallyHoldTime(DateUtil.getDiffDateTime(now, txSaleClueRule.getMaxClueDelay()));
            consulter.setLastPullTime(now);
            consulter.setLastRemindTime(now);
            consulter.setUpdateTime(now);
            this.txConsultUserDao.update(consulter);

            // 添加 操作记录-领取线索
            TxConsulterOperationLog colog = new TxConsulterOperationLog(consulter.getId(), consulter.getCascadeId(),
                consulter.getCascadeId(), ConsulterOperation.PULL);
            txConsulterOperationLogDao.save(colog);

            // 添加跟进记录
            commentAPIService.saveByConsultUserPull(consulter,getAccountName(orgId, consulter.getCascadeId()));
        }

        // 保存标签
        setUserTags(orgId, consulter.getId(), clueInfo.getTagsStr());

        // solr更新
        updateSolr(consulter);
        
        //发送通知
        if(sendNotice){
	        if(consulter.getCascadeId().intValue() == Flag.NULL.getInt()){
	        	String content = NoticeType.getTips(consulter.getName());
	    		consultMessageService.sendNotice(orgId, -1, NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE, ActionUtil.getClueDetailAction(consulter.getId()), content));
	        }
        }
        
        return consulter.getId();
    }

    private void setUserTags(Long orgId, Long consulterId, String tags) {
        if (StringUtils.isNotBlank(tags)) {
            log.debug("save tags :{} into db", tags);
            try {
                orgStudentTagService.delTagsByConsulterId(consulterId, orgId);
                List<TagInfoDto> tagDtos = JacksonUtil.str2List(tags, TagInfoDto.class);
                if (!CollectionUtils.isEmpty(tagDtos)) {
                    orgStudentTagService.addStudentTag(tagDtos, StudentType.CONSULT_USER.getCode(), consulterId, orgId);
                }
            } catch (Exception e) {
                log.error("save tags:{} catch error:{}", tags, e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void editClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == clueInfo || null == clueInfo.getId() || clueInfo.getId() <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, clueInfo.getId());
        if (null == consulter) {
            throw new BussinessException(CrmErrorCode.CONSULTER_NOT_EXISTS);
        }

        this.vaildateConsult(orgId, clueInfo);

        if (clueInfo.getMobile().contains("****")) {
            clueInfo.setMobile(consulter.getMobile());
        }
        if (clueInfo.getParentMobile().contains("****")) {
            clueInfo.setParentMobile(consulter.getParentMobile());
        }

        this.clueDto2Po(clueInfo, consulter, orgId);
        this.txConsultUserDao.updateWithDefaultVal(consulter);
        log.info("editClueInfo---------consulter={}", consulter.toString());
        commentAPIService.saveByConsultUserUpdate(consulter);

        // solr更新
        updateSolr(consulter);

    }

    /**
     * 招生线索对象转换(不包含标签和跟进记录)
     *
     * @param po 咨询用户
     * @param dto 招生线索对象
     * @return
     */
    private void cluePo2Dto(TxConsultUser po, ConsultInfoResponseDto dto)
        throws IllegalAccessException, InvocationTargetException {
        log.info("cluePo2Dto---------po={}", po);

        BeanUtils.copyProperties(dto, po);

        dto.setConsultSourceStr(MessageSource.getByType(po.getConsultSource()).getDesc());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }

        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }

        dto.setConsultSourceStr(consultSourceService.getConsultSourceStr(Long.parseLong(dto.getConsultSource() + "")));
        dto.setConsultStatusStr(ConsultUserStatus.getLabel(dto.getConsultStatus()));
        dto.setRelativesStr(Relatives.getLabel(dto.getRelatives()));
        dto.setId(dto.getId());
        dto.setCascadeIdStr(dto.getCascadeId() + "");
        dto.setSexStr(GenderStatus.getGenderStr(dto.getSex()));
        dto.setIntensionLevelStr(IntentionLevel.getLabel(dto.getIntensionLevel()));

        if (null != dto.getAreaId() && dto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(dto.getAreaId());
            dto.setProvince(areaMap.get("province"));
            dto.setCity(areaMap.get("city"));
            dto.setCounty(areaMap.get("county"));
        }

        if (dto.getCascadeId() == -1) {
            dto.setCascadeIdStr("公共池");
        } else {
            Map<Long, String> casCadeMaps = txCascadeCredentialService.getByTxCasCadeIds(po.getOrgId());
            log.debug("cluePo2Dto casCadeMaps={},caid={}", casCadeMaps, dto.getCascadeId());
            dto.setCascadeIdStr(casCadeMaps.get(dto.getCascadeId()));
        }
    }

    /**
     * 招生线索对象转换(不包含标签和跟进记录)
     *
     * @param dto 招生线索对象
     * @param po 咨询用户
     * @return
     */
    private void clueDto2Po(ConsultListResponseDto dto, TxConsultUser po, Long orgId)
        throws IllegalAccessException, InvocationTargetException {
        log.info("clueDto2Po---------dto={}", dto);

        BeanUtils.copyProperties(po, dto);

        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }

        if (null == po.getId() || 0 == po.getId()) {
            // 新增
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
        }

        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }

        if (dto.getCascadeId() == 0) {
            //如果线索的课程顾问是0 主账号，也需要正常导入,这里强制替换为登陆人的id，好大一个坑,
            //经过排查，这个路径貌似已经没有被其他功能使用，目前只发现是批导线索在使用，注释
            /*po.setCascadeId(
                TianxiaoPCContext.getTXCascadeId() == null ? 0 : TianxiaoPCContext.getTXCascadeId().longValue());*/
        } else {
            po.setCascadeId(dto.getCascadeId());
        }
        po.setUpdateTime(new Date());
        // 修改最后操作时间
        if (po.getCascadeId() != null && po.getCascadeId() >= 0) {
            po.setLastRemindTime(new Date());
        }
    }

    /**
     * 前置条件检查
     *
     * @param orgId 机构id
     * @param clueInfo 招生线索信息
     * @return
     */
    public void vaildateConsult(Long orgId, ConsultListResponseDto clueInfo) {

        // if (clueInfo.getNextRemindTime() != null) {
        // if (clueInfo.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
        // throw new BussinessException(CommonErrorCode.PARAM_ERROR, "下次提醒时间超过最大范围(2037-1-1)了");
        // }
        // }
        //
        // if (clueInfo.getBirthday() != null && clueInfo.getBirthday() > System.currentTimeMillis()) {
        // throw new BussinessException(CommonErrorCode.PARAM_ERROR, "未来的您还未出生吧");
        // }

        if (StringUtils.isNoneBlank(clueInfo.getMobile()) && !clueInfo.getMobile().contains("****")) {
            List<TxConsultUser> targets = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile());
            log.info("doSaveBefore---------clueInfo={},targets={}", clueInfo, targets);
            if (targets != null && !targets.isEmpty()) {
                if (clueInfo.getId() != null && clueInfo.getId() > 0) {
                    // 编辑
                    if (targets.size() > 1 || targets.get(0).getId().longValue() != clueInfo.getId().longValue()) {
                        throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "该手机号已对应其他线索");
                    }
                } else {
                    // 新增
                    throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS, "该手机号已对应其他线索");
                }
            }
        }
    }

    /**
     * 获取线索列表
     */
    @Override
    public List<ConsultListResponseDto> getClueList(long orgId, CommonSearchRequestDto request, PageDto pageDto)
        throws Exception {
        Integer cascadeId = request.getCascadeId();
        ConsulterListQueryParam consulterListQueryParam = new ConsulterListQueryParam();
        consulterListQueryParam.setKeyFieldName(request.getName());
        consulterListQueryParam.setKeyword(request.getQuery());
        consulterListQueryParam.setConsulterType(request.getStatus());
        consulterListQueryParam.setOrgId(orgId);
        // 设置排序字段
        consulterListQueryParam.setPropName(request.getOrderName());
        // 设置排序的方向
        consulterListQueryParam.setSortType(request.getOrderType());
        Long cascadeId_ = (cascadeId == null ? 0L : cascadeId.longValue());
        // from solr
        List<ConsulterListDto> solrList =
            consultUserService.listConsulter(orgId, cascadeId_, consulterListQueryParam, pageDto);

        Map<Long, String> casCadeMaps = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        log.info("needShowMobile : {} ", isShowMobile);

        List<ConsultListResponseDto> result = Lists.newArrayList();

        Map<Long, ConsultCustomSourceDto> sourceMap = consultSourceService.mapConsultSourceDto(orgId, null);
        ConsultCustomSourceDto sourceDto = null;
        log.info("[Consult] solrList:{}", solrList);
        for (ConsulterListDto consultUser : solrList) {
            sourceDto = sourceMap.get(Long.parseLong(consultUser.getConsultSource() + ""));
            ConsultListResponseDto dto =
                ConsultListResponseDto.convertToDto(consultUser, sourceDto != null ? sourceDto.getLabel() : "");

            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }
            if (consultUser.getCascadeId() == -1) {
                dto.setCascadeIdStr("公共池");
            } else {
                dto.setCascadeIdStr(casCadeMaps.get(consultUser.getCascadeId().longValue()));
            }
            if (request.getStatus() == ConsulterOutLineType.INVALID.getValue()) {
                dto.setCascadeIdStr("");
            }

            result.add(dto);
        }
        return result;
    }

    @Override
    public void delClueInfo(Long clueInfoId) throws Exception {
        TxConsultUser consultUser = txConsultUserDao.getById(clueInfoId);
        consultUser.setDelStatus(DataStatus.DELETE.getValue());
        txConsultUserDao.update(consultUser);

        String contentFmt = "删除线索 %s";
        contentFmt = String.format(contentFmt, consultUser.getName());
        commentAPIService.saveByConsultUserDel(consultUser);

        // solr更新
        updateSolr(consultUser);

    }

    @Override
    public void delClueInfo(List<Long> clueInfoIds) throws Exception {
        List<TxConsultUser> consultUsers = txConsultUserDao.getByIds(clueInfoIds);
        for (TxConsultUser txConsultUser : consultUsers) {
            txConsultUser.setDelStatus(DataStatus.DELETE.getValue());
            txConsultUserDao.update(txConsultUser);

            String contentFmt = "删除线索 %s";
            contentFmt = String.format(contentFmt, txConsultUser.getName());
            commentAPIService.saveByConsultUserManualAdd(txConsultUser);

            // solr更新
            updateSolr(txConsultUser);
        }
    }

    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "未知";
        if (cascadeId > 0) {// 子账号
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            TXCascadeCredential credential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
            shortName = credential.getName();
        } else {// 主账号
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    public static void main(String[] args) {
        Date startOfDay = DateUtil.getStartOfDay(DateUtil.getDayDiff(-6));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(format.format(startOfDay));
    }

    void updateSolr(TxConsultUser txConsultUser) {
        try {
            txConsultUser.toSolrMap();
            //consultUserQuery.updateOldRow(txConsultUser.toSolrMap());
            log.info("solr - consult user - update - end - txConsultUser:{}", txConsultUser);
        } catch (Exception e) {
            log.error("solr - consult user - update - exception", e);
        }
    }

    @Override
    public Map<String, Object> getPcClueList(Long orgId,Integer cascadeId, CommonSearchRequestDto request, PageDto pageDto) {
        if (orgId == null || orgId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "机构id错误");
        }

        List<FieldOption> header = this.fieldShowInfoService.getHeader(orgId, DataProcType.CONSULT, null);
        if (CollectionUtils.isEmpty(header)) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取列表显示属性失败");
        }

        ConsulterListQueryParam consulterListQueryParam = new ConsulterListQueryParam();
        consulterListQueryParam.setKeyFieldName(request.getName());
        consulterListQueryParam.setKeyword(request.getQuery());
        consulterListQueryParam.setConsulterType(request.getStatus());
        consulterListQueryParam.setOrgId(orgId);
        consulterListQueryParam.setConsultStatus(request.getConsultStatus());
        consulterListQueryParam.setDateFieldKey(request.getDateFieldKey());
        consulterListQueryParam.setIntentLevel(request.getIntensionLevel());
        consulterListQueryParam.setSourse(request.getSource());
        consulterListQueryParam.setBirthDayOfMonth(request.getBirthDayOfMonth());
        consulterListQueryParam.setBirthMonth(request.getBirthMonth());
        consulterListQueryParam.setBirthYear(request.getBirthYear());
        consulterListQueryParam.setCascadeForSearch(request.getCascadeId());
        if(request.getCascadeId()!=null) {
            consulterListQueryParam.setCascadeIds(String.valueOf(request.getCascadeId()));
        }
        consulterListQueryParam.setConsultSource(request.getSource());
        consulterListQueryParam.setSelectFieldKey(request.getSelectFieldKey());
        consulterListQueryParam.setSelectFieldValue(request.getSelectFieldValue());

        if(request.getStart()!=null){
            consulterListQueryParam.setStart(new Date(request.getStart()));
        }
        if(request.getEnd()!=null){
            consulterListQueryParam.setEnd(new Date(request.getEnd()));
        }

        // 设置排序字段
        consulterListQueryParam.setPropName(request.getOrderName());
        // 设置排序的方向
        consulterListQueryParam.setSortType(request.getOrderType());
        if(request.getStatus()==null || request.getStatus()==0){
            consulterListQueryParam.setIsInvalid(null);//全部线索包含无效线索
        }

        Long cascadeId_ = (cascadeId == null ? 0L : cascadeId.longValue());

        // from solr or es
        List<ConsulterListDto> solrList = consultUserService.listConsulter(orgId, cascadeId_, consulterListQueryParam, pageDto);

        List<Map<String, Object>> result = new ArrayList<>();
        Map<String, Object> data = new HashMap<>();
        data.put("header", header);
        data.put("result", result);
        if (CollectionUtils.isEmpty(solrList)) {
            return data;
        }

        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());

        Set<Long> clueIds = BaseUtils.getPropertiesList(solrList, "id");
        Map<Long, String> casCadeMaps = new HashMap<>();    // map<课程顾问id, 课程顾问姓名>
        Map<Long, ConsultCustomSourceDto> sourceMap = new HashMap<>();  // map<来源id, 来源信息>
        Map<Long, String> tagsMap = new HashMap<>();    // map<线索id, "标签1,标签2...">
        Map<Long, Map<Long, String>> clueFieldsMap = new HashMap<>();    // map <线索id, <自定义id, 自定义值>> : 自定义值为文本、单选值、多选值等类型

        // 系统字段属性名
        Set<String> sysNames = new HashSet<>();
        // 自定义字段id
        Set<Long> customIds = new HashSet<>();
        for (FieldOption option : header) {
            if (option.getCustomId() != null && option.getCustomId() > 0) {
                customIds.add(option.getCustomId());
            } else {
                sysNames.add(option.getName());
            }
        }

        // 如果需要展示课程顾问,则缓存课程顾问信息
        if (sysNames.contains(CASCADE_ID_STR)) {
            casCadeMaps = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        }
        // 如果需要展示来源,则缓存来源信息
        if (sysNames.contains(CONSULT_SOURCES_TR)) {
            sourceMap = consultSourceService.mapConsultSourceDto(orgId, null);
        }
        // 如果需要展示标签,则缓存标签信息
        if (sysNames.contains(TAGS_STR)) {
            tagsMap = this.orgStudentTagService.getTagsMap(orgId, clueIds, StudentType.CONSULT_USER);
        }
        // 如果需要展示自定义字段,则缓存自定义字段信息
        if (CollectionUtils.isNotEmpty(customIds)) {
            clueFieldsMap = this.customFieldValueService.batchGetFieldValue(orgId, false, clueIds, customIds);
        }

        for (ConsulterListDto consultUser : solrList) {
            DefaultClueField dto = this.getFromConsultUser(consultUser);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }

            if (consultUser.getCascadeId() == -1) {
                dto.setCascadeIdStr("公共池");
            } else {
                dto.setCascadeIdStr(casCadeMaps.get(consultUser.getCascadeId().longValue()));
            }
            if (consultUser.getIsInvalid() == 1) {
                dto.setCascadeIdStr("");
            }
            if (tagsMap.containsKey(dto.getId())) {
                dto.setTagsStr(tagsMap.get(dto.getId()));
            } else {
                dto.setTagsStr("");
            }
            if (sourceMap.containsKey(consultUser.getConsultSource().longValue())) {
                ConsultCustomSourceDto sourceDto = sourceMap.get(consultUser.getConsultSource().longValue());
                dto.setConsultSourceStr(sourceDto != null ? sourceDto.getLabel() : "");
            }

            Map<String, Object> item = this.getItemMap(header, dto, clueFieldsMap.get(dto.getId()));
            item.put("isValid",consultUser.getIsInvalid());
            if(consultUser.getIsInvalid() == 1){
                item.put("status",ConsulterOutLineType.INVALID.getValue());
            }else {
                item.put("status",getStatus(cascadeId_.intValue(),consultUser.getCascadeId()));
            }

            result.add(item);
        }
        return data;
    }

    private int getStatus(int loginCascadeId,int clueCascadeId){
        if(clueCascadeId==-1){
           return ConsulterOutLineType.PUBLISH.getValue();
        }

        if(clueCascadeId==loginCascadeId){
            return ConsulterOutLineType.MINE.getValue();
        }

        return ConsulterOutLineType.SUBORDINATE.getValue();
    }

    private DefaultClueField getFromConsultUser(ConsulterListDto consultUser) {
        DefaultClueField dto = new DefaultClueField();
        try {
            BeanUtils.copyProperties(dto, consultUser);
        } catch (Exception e) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "copy properties failed!");
        }

        if (consultUser.getBirthday() != null) {
            dto.setBirthdayStr(DateUtil.getStrByDate(consultUser.getBirthday()));
        }
        dto.setConsultStatusStr(ConsultUserStatus.getLabel(consultUser.getConsultStatus()));
        dto.setRelativesStr(Relatives.getLabel(consultUser.getRelatives()));
        dto.setSexStr(GenderStatus.getGenderStr(consultUser.getSex()));
        dto.setIntensionLevelStr(IntentionLevel.getLabel(consultUser.getIntensionLevel()));
        dto.setCreateTimeStr(DateUtil.getStrByDate(consultUser.getCreateTime()));
        if(consultUser.getLastRemindTime()!=null){
            dto.setLastRemindTimeStr(DateUtil.getStrByDate(consultUser.getLastRemindTime()));
        }
        if(consultUser.getLastFollowTime()!=null){
            dto.setLastFollowTimeStr(DateUtil.getStrByDate(consultUser.getLastFollowTime()));
        }
        return dto;
    }

    private<T> Map<String, Object> getItemMap(List<FieldOption> header, T t, Map<Long, String> customMap) {
        Map<String, Object> map = new HashMap<>();
        // 系统字段
        Field[] fields = t.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Map<String, Field> sysFieldMap = BaseUtils.listToMap(Lists.newArrayList(fields), "name");
            for (FieldOption option : header) {
                if (option.getCustomId() != null && option.getCustomId() > 0) {
                    if (customMap != null && customMap.containsKey(option.getCustomId())) {
                        map.put(option.getName(), customMap.get(option.getCustomId()));
                    }
                } else {
                    Field field = sysFieldMap.get(option.getName());
                    if (field != null) {
                        Object ret = null;
                        try {
                            field.setAccessible(true);
                            ret = field.get(t);
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                        }
                        map.put(option.getName(), ret);
                    }
                }
            }
        }
        return map;
    }

    @Override
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, List<CustomFieldValue> valueList,
        boolean updateRepeat, boolean sendNotice) throws Exception {
        
        if (null == orgId || orgId <= 0 || null == clueInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        TxConsultUser consulter = null;
        Long preOnwerCascadeId = null;
        if (updateRepeat) {
            List<TxConsultUser> consulters = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile());
            if (CollectionUtils.isNotEmpty(consulters)) {
                consulter = consulters.get(0);
                preOnwerCascadeId = consulter.getCascadeId();
                clueInfo.setId(consulter.getId());
            } else {
                consulter = new TxConsultUser();
            }
        } else {
            this.vaildateConsult(orgId, clueInfo);
            consulter = new TxConsultUser();
        }

        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
        log.debug("txSaleClueRule={}", txSaleClueRule);

        consulter.setIsConsulter(Flag.TRUE.getInt());// 默认是线索
        this.clueDto2Po(clueInfo, consulter, orgId);
        if (consulter.getId() != null && consulter.getId() > 0) {
            this.txConsultUserDao.updateWithDefaultVal(consulter);
        } else {
            this.txConsultUserDao.save(consulter, false);
            log.info("addClueInfo---------consulter={}", consulter.toString());
            commentAPIService.saveByConsultUserManualAdd(consulter);
        }

        // 领取线索
        Date now = new Date();
        if (clueInfo.getCascadeId() >= 0 && (preOnwerCascadeId == null || preOnwerCascadeId.equals(-1L))) {
            consulter.setFinallyHoldTime(DateUtil.getDiffDateTime(now, txSaleClueRule.getMaxClueDelay()));
            consulter.setLastPullTime(now);
            consulter.setLastRemindTime(now);
            consulter.setUpdateTime(now);
            this.txConsultUserDao.update(consulter);

            // 添加 操作记录-领取线索
            TxConsulterOperationLog colog = new TxConsulterOperationLog(consulter.getId(), consulter.getCascadeId(),
                consulter.getCascadeId(), ConsulterOperation.PULL);
            txConsulterOperationLogDao.save(colog);

            // 添加跟进记录
            commentAPIService.saveByConsultUserPull(consulter,getAccountName(orgId, consulter.getCascadeId()));
        }

        // 保存标签
        setUserTags(orgId, consulter.getId(), clueInfo.getTagsStr());

        Long consulterId =  consulter.getId();

        String customSearchValue = studentUserService.buildCustomSearchValue(valueList, true, true, orgId, consulterId, false);
        TxConsultUser user = new TxConsultUser();
        user.setId(consulterId);
        if(StringUtils.isBlank(customSearchValue)){
            customSearchValue = null;
        }
        user.setCustomSearchValue(customSearchValue);
        this.txConsultUserDao.update(user, true,"customSearchValue");
        //发送通知
        if(sendNotice){
            if(consulter.getCascadeId().intValue() == Flag.NULL.getInt()){
                String content = NoticeType.getTips(consulter.getName());
                NoticeMsgContent notice = NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE, ActionUtil.getClueDetailAction(consulter.getId()),content);
                notice.setTip(PushTipFactory.getNewClueTip(consulter.getName(),consulter.getMobile()));
                notice.setPushTitle(PushTipFactory.CLUE_TO_GET_TITEL);
                consultMessageService.sendNotice(orgId, -1, notice);
            }
        }
        return consulterId;
            
    }
}
