package com.baijia.tianxiao.biz.consult.push.service.impl;

import com.baijia.tianxiao.biz.consult.push.service.WechatService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.TextMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import com.baijia.tianxiao.util.ListUtil;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 15/12/5.
 */
@Slf4j
@Service
public class WechatServiceImpl implements WechatService {

    @Autowired
    private MessagePushService messagePushService;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private UserCacheService userCacheService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private CustomActivityService customActivityService;

    @Override
    @Transactional(noRollbackFor = BussinessException.class)
    public boolean sendMsgToWechat(Long orgId, Integer cascadeId, ConsultMessage message) throws CustomException {
        log.info("[Wechat] Message = {},orgId={},cascadeId={}", ToStringBuilder.reflectionToString(message), orgId,
                cascadeId);
        OrgAccount account = orgAccountDao.getAccountById(orgId.intValue());

        message.setOrgId(orgId);
        TxConsultUser user = consultUserDao.getById(message.getReceiverId());
        String openId = user.getWeixinOpenId();
        if (cascadeId == null) {
            cascadeId = 0;
        }

        int kefuId = user.getKefuId().intValue();
        int role = userCacheService.getUserRole(user);
        boolean isNeedUpdate = false;

        if (role == MsgUserRole.STUDENT.getValue()) {
            OrgStudent orgStudent = studentDao.getById(user.getStudentId());
            if (orgStudent != null && StringUtils.isNotBlank(orgStudent.getWeixin())) {
                openId = orgStudent.getWeixin();
                if(!openId.equals(user.getWeixinOpenId())){
                    user.setWeixinOpenId(openId);
                    isNeedUpdate = true;
                    log.info("[Message] sync weixin openId,orgId={},consultUserId={}",openId,user.getId());
                }
            }

            Set<Integer> set = getHeadTeachers(orgId, user.getUserId());
            log.info("[Message] HeadTeachers={},kefuId={}", set, kefuId);
            if (!set.isEmpty()) {// 如果有班主任，只能班主任跟进

                // 已有其他班主任联系
                if (set.contains(kefuId) && kefuId != cascadeId) {
                    String name = getAccountName(orgId, kefuId);
                    if (name != null) {
                        throw new BussinessException(CrmErrorCode.NOT_OWNER, getMessage(name));
                    } else {
                        set.remove(kefuId);
                    }
                }

                // 有班主任
                if (!set.contains(cascadeId)) {
                    throw new BussinessException(CrmErrorCode.NOT_OWNER, "您的消息无法送达，该学员已有班主任老师跟进");
                } else {
                    kefuId = cascadeId;
                }
            }
        } else if (role == MsgUserRole.CLUE.getValue()) {
            kefuId = user.getCascadeId().intValue();
        }

        if (kefuId > 0) {
            TXCascadeAccount cascadeAccount = cascadeAccountDao.getById(kefuId);
            // 如果账号已删除或停用，则将当前用户设置为客服
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Message] KefuId is invalid.CascadeId=" + cascadeId);
                kefuId = -1;
            }
        } else if (kefuId == 0) {
            OrgSubAccount subAccount = orgSubAccountDao.getByOrgId(orgId.intValue());
            if (subAccount != null && subAccount.getIsdel() == 1) {
                log.warn("[Message] KefuId is invalid.OrgId=" + orgId);
                kefuId = -1;
            }
        }

        // 已分配客服
        if (kefuId >= 0 && cascadeId.intValue() != kefuId) {
            if (role == MsgUserRole.CLUE.getValue()) {
                String name = getAccountName(orgId, kefuId);
                throw new BussinessException(CrmErrorCode.NOT_OWNER, getMessage(name));
            } else {
                throw new BussinessException(CrmErrorCode.NOT_OWNER, "您的消息无法送达，该用户已有老师跟进");
            }
        }

        if(!user.getKefuId().equals((long)kefuId)){
            user.setKefuId(new Long(kefuId));
            isNeedUpdate = true;
            log.info("[Message] KefuId from {} to {}",user.getKefuId(),kefuId);
        }

        if(kefuId==-1){
            user.setKefuId(cascadeId.longValue());
            isNeedUpdate = true;
            log.info("[Message] Set kefuId={}",user.getKefuId());
        }

        if(isNeedUpdate){
            consultUserDao.update(user);
        }

        MessageDto dto = toMessageDto(account, message, message.getReceiverId());

        log.info("[Message] Message = " + dto.toString());
        WebResponse<?> response = messagePushService.handle(dto);
        log.info("[Message] Response = " + response.toString());
        if (response.getCode() == 0) {
            try {
                // 修改最后操作时间
                Date now = new Date();
                user.setLastRemindTime(now);
                user.setUpdateTime(now);
                Integer userRole = userCacheService.getUserRole(user);
                user.setCascadeId(cascadeId.longValue());
                message.setReceiverRole(userRole);
                user.setWeixinOpenId(openId);
                consultUserDao.update(user);
            } catch (Exception e) {
                log.error("sendMsgToWechat - update LastRemindTime - error:{}", e);
            }
        }
        MsgUserRole userRole = getOrgAccountType(orgId, cascadeId);
        message.setSenderRole(userRole.getValue());
        message.setContent(message.getContent());
        messageService.addMessage(message);
        return true;
    }


    private String getAccountName(long orgId, int cascadeId) {
        if (cascadeId > 0) {
            TXCascadeAccount cascadeAccount = cascadeAccountDao.getById(cascadeId);
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Message] Message TXCascadeAccount is invalidate.cascadeAccount={}", cascadeAccount);
            } else {
                TXCascadeCredential credential =
                        credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                if (credential != null) {
                    return credential.getName() == null ? credential.getMobile() : credential.getName();
                } else {
                    log.error("[Message] Message TXCascadeCredential is invalidate.credentialId="
                            + cascadeAccount.getCredentialId());
                }
            }
        }
        if (cascadeId == 0) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo((int) orgId, "contacts", "name");
            if (orgInfo != null) {
                if (StringUtils.isNotBlank(orgInfo.getContacts())) {
                    return orgInfo.getContacts();
                } else {
                    return orgInfo.getName();
                }
            }
        }

        return "匿名用户";
    }

    private MessageDto toMessageDto(OrgAccount account, ConsultMessage msg, Long consultUserId) {
        MessageDto pushDto = new MessageDto();
        pushDto.setMsgId((int) msg.getId());
        pushDto.setMsgT(msg.getMsgType());
        pushDto.setConsultUserId(consultUserId);
        pushDto.setOrgId(account.getId());

        MessageContentDto content = new MessageContentDto();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        if (msg.getMsgType() == MsgType.TEXT.getValue()) {
            TextMsgContent msgContent = gson.fromJson(msg.getContent(), TextMsgContent.class);
            content.setText(msgContent.getText());
        } else if (msg.getMsgType() == MsgType.PICTURE.getValue()) {
            ImageMsgContent imageMsgContent = gson.fromJson(msg.getContent(), ImageMsgContent.class);
            content.setUrl(imageMsgContent.getUrl());
            content.setWidth(imageMsgContent.getWidth());
            content.setStorageId(imageMsgContent.getStorageId());
            content.setHeight(imageMsgContent.getHeight());
        } else if (msg.getMsgType() == MsgType.VOICE.getValue()) {
            AudioMsgContent msgContent = gson.fromJson(msg.getContent(), AudioMsgContent.class);
            content.setLength(msgContent.getLen());
            content.setUrl(msgContent.getUrl());
            content.setStorageId((int) msgContent.getStorageId());
        } else {
            OrgInfo info = orgInfoDao.getOrgInfo(account.getId().intValue(), "name","shortName");
            String title = info.getShortName();
            if(StringUtils.isBlank(title)){
                title = info.getName();
            }

            CardMsgContent card = gson.fromJson(msg.getContent(), CardMsgContent.class);
            content.setText(getActivityOrCourseContent(title, card));
        }
        pushDto.setContent(content);
        return pushDto;
    }

    private MsgUserRole getOrgAccountType(long orgId, Integer cascadeId) {
        if (cascadeId == null || cascadeId == 0) {
            OrgSubAccount subAccount = orgSubAccountDao.getMasterByOrgId((int) orgId);
            log.info("OrgId=" + orgId + ";OrgSubAccount=" + subAccount);
            if (subAccount != null) {
                return MsgUserRole.HEADER;
            } else {
                return MsgUserRole.BRANCH_HEADER;
            }
        } else {
            TXCascadeAccount cascadeAccount = cascadeAccountDao.getById(cascadeId);
            if (cascadeAccount.getAccountType() == 3) {
                return MsgUserRole.MANAGER;
            } else {
                return MsgUserRole.STAFF;
            }
        }
    }

    private Set<Integer> getHeadTeachers(Long orgId, Long userId) {
        List<OrgStudentCourse> orgCourseIds = this.studentCourseDao.getOrgCourseIds(orgId, userId, null);
        List<Long> courseIds = ListUtil.toKeyList(orgCourseIds, "courseId", OrgStudentCourse.class);
        List<OrgCourse> courses = this.orgCourseDao.getByIds(courseIds, "cascadeId");
        Set<Integer> set = new HashSet<>();
        if (courses != null && courses.size() > 0) {
            for (OrgCourse course : courses) {
                if (course.getCascadeId() != null && course.getCascadeId() >= 0) {
                    set.add(course.getCascadeId());
                }
            }
        }
        return set;
    }

    private String getMessage(String name) {
        return "您的消息无法送达，" + name + "为对方的联系人，仅" + name + "可与对方联系";
    }

    private String getActivityOrCourseContent(String orgName,CardMsgContent card){
        StringBuilder sb = new StringBuilder();
        String url = null;
        if(card.getType()==CardType.ACTIVITY.getValue()){
            url = getWechatUrl(card.getAction());
        }else {
            url = card.getAction();
        }
        sb.append(orgName).append("给您发送了").append(getCardDesc(card.getType())).append("\n")
                .append("【").append(card.getTitle()).append("】")
                .append("\n\n")
                .append(getHrefLink(url,"点击此处查看"));
        return sb.toString();
    }

    private String getWechatUrl(String action){
        Map<String,String> map = parseParams(action);
        int activityId = Integer.parseInt(map.get("activityId"));
        int templateId = Integer.parseInt(map.get("templateId"));
        CustomActivityDto dto = customActivityService.getCustomActivity(activityId,templateId);
        if(dto!=null) {
            return dto.getWebAuthUrl();
        }else {
            //去掉templateId，要不前端会认为访问的模板
            return removeParam("templateId",action);
        }
    }

    private Map<String,String> parseParams(String action){
        log.info("[Wechat] Activity URL=", action);
        Map<String,String> map = new HashMap<>();
        try {
            List<NameValuePair> params = URLEncodedUtils.parse(new URI(action), "UTF-8");
            if(params!=null){
                for (NameValuePair pair:params){
                    map.put(pair.getName(),pair.getValue());
                }
            }
        } catch (URISyntaxException e) {
            log.error("URISyntaxException",e);
        }

        return map;
    }

    public String removeParam(String param,String action){
        action = action.replaceAll("#!/","");
        String url = action.split("\\?")[0];
        try {
            List<NameValuePair> params = URLEncodedUtils.parse(new URI(action), "UTF-8");
            if(params!=null){
                for (NameValuePair pair:params){
                    if(param.equals(pair.getName())){
                        params.remove(pair);
                        break;
                    }
                }
            }
            String paramsStr = URLEncodedUtils.format(params,"UTF-8");
            url = url+"?"+paramsStr + "#!/";
        } catch (URISyntaxException e) {
            log.error("URISyntaxException",e);
        }
        return url;
    }

    private String getHrefLink(String href, String content) {
        String link = "<a href=\"%s\">%s</a>";
        return String.format(link, href, content);
    }

    private String getCardDesc(int type){
        CardType cardType = CardType.getTypeByValue(type);
        switch (cardType){
            case ACTIVITY:
                return "活动";
            case COURSE:
                return "课程";
            default:
                throw new RuntimeException("CardType exception.CardType="+cardType);
        }
    }
}