/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.util.json.JacksonUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

/**
 * @title WechatMsgServiceImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
@Service("wechatMsgConsumeService")
@Slf4j
public class WechatMsgServiceImpl extends AbstractConsultService<MessageDto> {

    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;

    @Autowired
    private ConsulterAPIService consulterAPIService;
    
    @Override
    public MessageSource getConsultType() {
        return MessageSource.WECHAT;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(MessageDto msg,Long consultUserId) {
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(getConsultType().getValue());
        pushMsg.setCreateTime(new Date(msg.getTime()));
        pushMsg.setMsgType(msg.getMsgT());
        pushMsg.setHeight(msg.getContent().getHeight());
        pushMsg.setLength(msg.getContent().getLength());
        pushMsg.setContent(msg.getContent().getText());
        pushMsg.setUrl(msg.getContent().getUrl());
        pushMsg.setWidth(msg.getContent().getWidth());
        pushMsg.setTip(PushTipFactory.getWeichatMsgTip(msg.getContent().getText(),msg.getNick()));
        pushMsg.setPushTitle(PushTipFactory.WEICHAT_MSG_TITEL);
        return pushMsg;
    }

    private MsgUser builderSender(MessageDto dto) {

        //线索
        TxConsultUser txConsultUser = new TxConsultUser();
        txConsultUser = new TxConsultUser();
        txConsultUser.setName(dto.getNick());
        txConsultUser.setOrgId(new Long(dto.getOrgId()));
        txConsultUser.setWeixinOpenId(dto.getWechatOpenId());
        txConsultUser.setWeixinNickName(dto.getNick());
        txConsultUser.setConsultSource(MessageSource.WECHAT.getValue());
        
        if(StringUtils.isNotBlank(dto.getWechatAppid())){
        	txConsultUser.setWeixinAppId(dto.getWechatAppid());
        	
        }else {
            Fans fans = fansDao.getByOpenId(dto.getWechatOpenId());
        	if(fans!=null){
        		txConsultUser.setWeixinAppId(fans.getAuthorizerAppId());
        	}
        }
        
        TxConsultUser result = consulterAPIService.saveOrUpdateByWechatOpenId(txConsultUser).getData();
        log.info("[Wechat Message] result : {} " , result);
        return ConsulterDto.convertToDto(result);
    }

    private MsgUser buildOrgMsgUser(@NonNull Long orgId) {
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue(), "orgId", "shortName");
        if (orgInfo == null) {
            log.warn("can not get org info by orgId:{}", orgId);
            return null;
        }
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue(), "number");
        return buildReceiver(orgInfo, orgAccount.getNumber().longValue());
    }

    @Override
    public boolean consume(MessageDto message) {
        if (message == null || StringUtils.isBlank(message.getWechatOpenId())) {
            throw new IllegalArgumentException(" no weixin open id .");
        }

        MsgUser receiver = buildOrgMsgUser(new Long(message.getOrgId()));
        MsgUser sender = builderSender(message);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip wechat  msg:{}", sender, receiver, message);
            return false;
        }
        ConsultMessage msgContent = buildPushMessageContent(message,sender.getUserId());
        log.info("consume wechat msg sender:{},receiver:{},msgContent:{}", sender.getName(), receiver, msgContent);
        boolean result = consultMessageService.sendConsultMessage(sender, receiver, msgContent);
        log.info("push wechat msg:{},sender:{},receiver:{},result:{}", msgContent, sender, receiver, result);

        return result;
    }

    @Override
    public MessageDto transfer(String body) {
        if (StringUtils.isBlank(body)) {
            return null;
        }
        try {
            return JacksonUtil.str2Obj(body, MessageDto.class);
        } catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", body, e);
            return null;
        }

    }

}
