/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXKefuRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.DBOperation;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.gson.Gson;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title StudentAdvisoryMsgServiceImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
@Slf4j
@Service("advisoryMsgConsumeService")
public class StudentAdvisoryMsgServiceImpl extends AbstractConsultService<AdvisoryInfoDto> {

    @Resource
    private OrgStudentDao orgStudentDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Autowired
    private TXKefuRuleDao kefuRuleDao;
    
    @Autowired 
    private ConsulterAPIService consulterAPIService;
    @Autowired
	private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    public MessageSource getConsultType() {
        return MessageSource.APPOINTMENT;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(AdvisoryInfoDto msg,Long consultUserId) {

        CardMsgContent content = CardContentFactory.createAppointCard(msg.getStudentName(),
                msg.getStudentMobile(), msg.getWords());
        content.setAction(ActionUtil.getTelephoneAction(consultUserId,msg.getStudentMobile()));
        ConsultMessage pushMsg = new ConsultMessage();
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson(content));
        pushMsg.setConsultType(MessageSource.APPOINTMENT.getValue());
        pushMsg.setCreateTime(msg.getCreateTime());
        pushMsg.setMsgType(MsgType.CARD.getValue());
        return pushMsg;
    }

    /**
     * 预约咨询
     * @param msg
     * @return
     */
    private MsgUser builderSender(AdvisoryInfoDto msg,int isClue) {
        log.info("AdvisoryInfoDto.msg:{},isClue={}", msg,isClue);
        //线索
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(msg.getOrgId());
        consultUser.setMobile(msg.getStudentMobile());
        consultUser.setName(msg.getStudentName());
        consultUser.setConsultSource(MessageSource.APPOINTMENT.getValue());
        consultUser.setIsConsulter(isClue);
        
        if (msg.getUserNumber() != null) {
            consultUser.setUserNumber(msg.getUserNumber());
        }
        if (msg.getStudentId() == null) {
            consultUser.setUserId(0l);
        } else {
        	consultUser.setUserId(msg.getStudentId());
        }
        
        DBResultDto<TxConsultUser> dto = consulterAPIService.saveOrUpdateByMobile(consultUser);
        TxConsultUser result = dto.getData(); 
        
        //跟进记录
        txStudentCommentAPIService.saveByAdvisory(result, consultUser.getUserId(), msg.getWords(), dto.getOperation()==DBOperation.INSERT ? true:false);
        
        return ConsulterDto.convertToDto(result);
    }

    private MsgUser buildOrgMsgUser(AdvisoryInfoDto msg) {
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setOrgId(msg.getOrgId().intValue());
        return buildReceiver(orgInfo, msg.getOrgNumber());
    }

    @Override
    public boolean consume(AdvisoryInfoDto message) {
    	log.info("consume advisory get msg:{}", message);
        if (message == null || message.getOrgId() == null) {
            throw new IllegalArgumentException(" advisory record is illegal");
        }
        String tip = PushTipFactory.getNewAppointmentTep(message.getStudentName(),message.getStudentMobile());
        boolean result = false;
        TXKefuRule rule = kefuRuleDao.getByOrgId(message.getOrgId().intValue());
        if (rule!=null && rule.getBespeakRule() != null && rule.getBespeakRule() == 1){
            log.info("[Notice] Appointment notice!");
            MsgUser user = builderSender(message, 1);
            String content = NoticeType.getTips(message.getStudentName());
            
            OrgStudent orgStudent = null;
            if(message.getOrgId()!=null && message.getStudentMobile()!=null){
            	orgStudent = orgStudentDao.getStudentByMobileAndOrgId(message.getOrgId(), message.getStudentMobile());
            }
            if(orgStudent==null){
	            NoticeMsgContent notice = NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE,
	                    ActionUtil.getClueDetailAction(user.getUserId()),content);
                notice.setTip(tip);
                notice.setPushTitle(PushTipFactory.APPOINTMENT_TITEL);
	            result = consultMessageService.sendNotice(message.getOrgId(),-1, notice);
            }else{
            	result = true;
            }
        }else {
            MsgUser receiver = buildOrgMsgUser(message);
            MsgUser sender = builderSender(message,0);
            if (sender == null || receiver == null) {
                log.warn("sender :{} or receiver:{} is null,skip advisory  msg:{},skip", sender, receiver, message);
                return false;
            }
            ConsultMessage msgContent = buildPushMessageContent(message,sender.getUserId());
            msgContent.setTip(tip);
            msgContent.setPushTitle(PushTipFactory.APPOINTMENT_TITEL);
            log.info("consume advisory msg sender:{},receiver:{},msgContent:{}", sender.getName(), receiver, msgContent);
            result = consultMessageService.sendConsultMessage(sender, receiver, msgContent);
            log.info("push student advisory msg:{},sender:{},receiver:{},result:{}", msgContent, sender, receiver, result);

        }

        return result;
    }

    @Override
    public AdvisoryInfoDto transfer(String body) {
        if (StringUtils.isBlank(body)) {
            return null;
        }
        try {
            return JacksonUtil.str2Obj(body, AdvisoryInfoDto.class);
        } catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", body, e);
            return null;

        }
    }

    private void buildComment(TxConsultUser consultUser, AdvisoryInfoDto msg, boolean isNewStudent) {
        log.info("buildComment--------consultUser={}",consultUser.toString());
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(consultUser.getId());
        User user = null;
        if(msg.getStudentId()!=null) {
            user = this.userDao.getById(msg.getStudentId());
        }
        if (user != null && msg.getStudentMobile().equals(user.getMobile())) {
            comment.setUserId(consultUser.getUserId());
        } else {
            comment.setUserId(0l);
        }
//        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setIsSystem(AddType.SYSTEM.getCode());

        StringBuffer content = new StringBuffer();
        if(isNewStudent) {
            content.append("系统添加了客户: " + (StringUtils.isNotBlank(consultUser.getName()) ? consultUser.getName() : TianXiaoConstant.APPOINTMENT_STUDENT_NAME) + "\n");
        }
        content.append("留单内容: " + (StringUtils.isNotBlank(msg.getWords()) ? msg.getWords() : "无"));
        comment.setContent(content.toString());
        comment.setOrigin(this.getConsultType().getValue());

        log.info("buildComment.comment:{}", comment);
        this.txStudentCommentDao.save(comment,false);
    }
}