
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.consult.msg.service.impl;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.baijia.tianxiao.dal.org.dao.TXKefuRuleDao;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.google.gson.Gson;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.marketing.activity.dto.ActivitySignUpDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.json.JacksonUtil;

/**
 * 活动报名消息消费处理类
 * @title OrgActivitySignUpServiceImpl
 * @desc TODO
 * @author zhangbing
 * @date 2016年3月1日
 * @version 1.0
 */
@Deprecated
//@Service
@Slf4j
public class OrgActivitySignUpServiceImpl extends AbstractConsultService<ActivitySignUpDto>{

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Autowired
    private TXKefuRuleDao kefuRuleDao;
    
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;


    //报名、抽奖复用ConsultType.APPOINTMENT咨询类型
    @Override
    public MessageSource getConsultType() {
        return MessageSource.SIGNUP;
    }
    
    @Override
    protected ConsultMessage buildPushMessageContent(ActivitySignUpDto msg,Long consultUserId) {
        ConsultMessage pushMsg = new ConsultMessage();
        //抽奖和活动报名都显示为6——活动-刘晓鹏
        pushMsg.setConsultType(MessageSource.SIGNUP.getValue());
        pushMsg.setCreateTime(new Timestamp(msg.getCreateTime()));
        pushMsg.setMsgType(MsgType.CARD.getValue());
        CardMsgContent content = CardContentFactory.createActivityCard(msg.getUserName(), msg.getMobile(), msg.getName());
        content.setAction(ActionUtil.getTelephoneAction(consultUserId, msg.getMobile()));
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson(content));
        return pushMsg;
    }
    

    @Override
    public boolean consume(ActivitySignUpDto message) {
        if (message == null || message.getId() < 0 || message.getOrgId() == null) {
            throw new IllegalArgumentException(" activity sign up record is illegal");
        }
        boolean result = false;
        String tip = PushTipFactory.getNewActivitySignTip(message.getUserName(),message.getMobile());
        String pushTitle = PushTipFactory.ACTIVITY_SIGN_TITEL;
        TXKefuRule rule = kefuRuleDao.getByOrgId(message.getOrgId().intValue());
        if (rule!=null && rule.getBespeakRule() != null && rule.getBespeakRule() == 1) {//直接进入公海，发送公海通知
            log.info("[Notice] Sign up notice!");
            MsgUser user = builderSender(message, 1);
            String content = NoticeType.getTips(message.getUserName());
            NoticeMsgContent notice = NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE,
                    ActionUtil.getClueDetailAction(user.getUserId()),content);
            notice.setTip(tip);
            notice.setPushTitle(pushTitle);
            result = consultMessageService.sendNotice(message.getOrgId(),-1, notice);
        } else {
            MsgUser receiver = buildOrgMsgUser(message);
            MsgUser sender = builderSender(message,0);
            if (sender == null || receiver == null) {
                log.warn("sender :{} or receiver:{} is null,skip activity sign up  msg:{},skip", sender, receiver, message);
                return false;
            }
            ConsultMessage msgContent = buildPushMessageContent(message,sender.getUserId());
            msgContent.setTip(tip);
            msgContent.setPushTitle(pushTitle);
            log.info("consume activity sign up msg sender:{},receiver:{},msgContent:{}", sender.getName(), receiver, msgContent);
            result = consultMessageService.sendConsultMessage(sender, receiver, msgContent);
            log.info("push student activity sign up msg:{},sender:{},receiver:{},result:{}", msgContent, sender, receiver, result);
        }
        return result;
    }

    /**
     * 活动报名消息
     * @param msg
     * @return
     */
    private MsgUser builderSender(ActivitySignUpDto msg,int isClue) {

//        List<TxConsultUser> consultUsers = consultUserDao.lookByMobile(msg.getOrgId(), msg.getMobile());
//        OrgStudent student = orgStudentDao.getStudentByMobileAndOrgId(msg.getOrgId(), msg.getMobile(), "id","name", "delStatus","weixin");
//        if(CollectionUtils.isEmpty(consultUsers) && student!=null && StringUtils.isNotEmpty(student.getWeixin())){
//            consultUsers = consultUserDao.lookByParams(msg.getOrgId(), student.getWeixin());
//        }
//
//        if (CollectionUtils.isNotEmpty(consultUsers)) {
//            TxConsultUser consultUser = consultUsers.get(0);
//            boolean isNeedToUpdate = false;
//            if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
//                if(!student.getName().equals(consultUser.getName())) {
//                    isNeedToUpdate = true;
//                    consultUser.setName(student.getName());
//                }
//                if(StringUtils.isNotEmpty(student.getWeixin()) && !student.getWeixin().equals(consultUser.getWeixinOpenId())){
//                    isNeedToUpdate = true;
//                    consultUser.setWeixinOpenId(student.getWeixin());
//                }
//                if(student.getId().equals(consultUser.getStudentId())) {
//                    isNeedToUpdate = true;
//                    consultUser.setStudentId(consultUser.getStudentId());
//                }
//            }
//            //如果该咨询之前不是线索，就跟新为线索
//            if(isClue==1 && consultUser.getIsConsulter()!=isClue){
//                log.info("[Advisory] update consult user status.");
//                isNeedToUpdate = true;
//                consultUser.setIsConsulter(isClue);
//            }
//            if(isNeedToUpdate) {
//                consultUserDao.update(consultUser, "isConsulter");
//            }
//            buildComment(consultUser, msg);
//            return ConsulterDto.convertToDto(consultUser);
//        }else {
//            TxConsultUser consultUser = new TxConsultUser();
//            consultUser.setOrgId(msg.getOrgId());
//            consultUser.setMobile(msg.getMobile());
//            consultUser.setName(msg.getUserName());
//            consultUser.setUserId(0l);
//            if (student != null) {
//                consultUser.setStudentId(student.getId());
//                consultUser.setWeixinOpenId(student.getWeixin());
//            }
//            consultUser.setConsultSource(MessageSource.SIGNUP.getValue());
//            consultUser.setIsConsulter(isClue);
//            consultUserDao.save(consultUser);
//            buildComment(consultUser, msg);
//            return ConsulterDto.convertToDto(consultUser);
//        }
       
        
        //线索
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(msg.getOrgId());
        consultUser.setMobile(msg.getMobile());
        consultUser.setName(msg.getUserName());
        consultUser.setConsultSource(MessageSource.SIGNUP.getValue());
        consultUser.setIsConsulter(isClue);
        TxConsultUser result = consulterAPIService.saveOrUpdateByMobile(consultUser).getData();
        
        //跟进记录
        txStudentCommentAPIService.saveByOrgActivitySignUp(result, msg.getName(), msg.getUserName(), msg.getMobile(), null);
        
        return ConsulterDto.convertToDto(result);
    }

    private MsgUser buildOrgMsgUser(ActivitySignUpDto message) {
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setOrgId(message.getOrgId().intValue());
        OrgAccount account = this.orgAccountDao.getById(message.getOrgId());

        Integer orgNumber = null;
        if (account != null) {
            orgNumber = account.getNumber();
            message.setOrgNumber(orgNumber.longValue());
        } else {
            return null;
        }
        return buildReceiver(orgInfo, orgNumber.longValue());
    }

    /**
     * 添加跟进记录
     * @param consultUser
     * @param message
     */
    private void buildComment(TxConsultUser consultUser, ActivitySignUpDto message) {
        log.info("buildComment--------consultUser={}",consultUser.toString());
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(consultUser.getId());
        comment.setContent(getContent(message));
        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setIsSystem(AddType.SYSTEM.getCode());
        comment.setOrigin(getConsultType().getValue());
        this.txStudentCommentDao.save(comment,false);
    }

    private String getContent(ActivitySignUpDto message) {
        StringBuffer sb = new StringBuffer("活动名称：");
        sb.append(message.getName()).append("\n");
        sb.append("姓名：").append(message.getUserName()).append("\n");
        sb.append("来电号码：").append(message.getMobile());
        return sb.toString();
    }

    /**
     * 将消息体中的body转换为ActivitySignUpDto对象
     */
    @Override
    public ActivitySignUpDto transfer(String body) {
        if (StringUtils.isBlank(body)) {
            return null;
        }
        try {
            return JacksonUtil.str2Obj(body, ActivitySignUpDto.class);
        } catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", body, e);
            return null;
        }
    }
}