/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.biz.consult.msg.service.ConsultMessageConsumeService;
import com.baijia.tianxiao.biz.consult.msg.service.MessageConsumeService;

import lombok.extern.slf4j.Slf4j;

/**
 * @title PullMsgFromQueue
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
@Slf4j
@Service
public class MessageConsumeServiceImp implements InitializingBean, ApplicationContextAware, MessageConsumeService {

    private ApplicationContext context;

    private Map<Integer, ConsultMessageConsumeService> messageConsumeServiceMap;

    public static final String CONSULT_MSG_QUEUE = "consult.msg.queue";

    @Override
    public void consumeMessage(final CloudQueue queue) {
        // final CloudQueue queue =
        // cloudAccount.getMNSClient().getQueueRef(queuePropties.getProperty(CONSULT_MSG_QUEUE));
        int i = 1;
        log.info("start pop msg from queue:{}", queue.getQueueURL());
        while (true) {
            try {
                Message message = queue.popMessage(12);
                if (message != null) {
                    log.info("get msg:{},body:{}", message.getMessageId(), message.getMessageBodyAsString());
                    if (consumeMessage(message)) {
                        log.info("msg:{} is success consume", message.getMessageId());
                        queue.deleteMessage(message.getReceiptHandle());
                    }
                } else {
                    log.info("no message sleep 10 s");
                    try {
                        Thread.sleep(10 * 1000l);
                    } catch (InterruptedException e) {
                    }
                }

                i = 1;
            } catch (ClientException e) {
                log.error("catch msn client exception:", e);
                try {
                    // 遇到服务器一次,就休息20s,
                    Thread.sleep(20 * i * 1000);
                    i++;
                } catch (InterruptedException e1) {
                } catch (Exception e2) {
                    log.error("catch exception:", e);
                }
            } catch (Exception e) {
                log.error("pop msg from consult msg queue catch  exception:", e);
            }
        }
    }

    private boolean consumeMessage(Message message) {
        try {
            Integer msgType = getConsultMsgTypeFromMsgBody(message);
            ConsultMessageConsumeService service = messageConsumeServiceMap.get(msgType);
            return service.consume(message.getMessageBodyAsString().substring(2));
        } catch (IllegalArgumentException e) {
            log.error("illegal message:", e);
        } catch (Exception e) {
            log.error("consume message catch error:", e);
        }
        return false;
    }

    /**
     * 从消息体中解析消息类型,现在的消息体格式: 类型(1位) + "$" + 都是JSON字符串,
     * 
     * @param message
     * @return
     */
    private Integer getConsultMsgTypeFromMsgBody(Message message) {
        String messageBody = message.getMessageBodyAsString();
        if (StringUtils.isNoneBlank(messageBody) && messageBody.length() > 2) {
            String head = messageBody.substring(0, 2);
            if (head.endsWith("$")) {
                try {
                    return Integer.parseInt(head.substring(0, 1));
                } catch (NumberFormatException e) {
                    log.error("message head is illeagl format type$");
                    throw new IllegalArgumentException("message format is illegal");
                }
            } else {
                log.error("message head is illeagl format type$");
                throw new IllegalArgumentException("message format is illegal");
            }
        } else {
            log.error("message body is illegal:{}", messageBody);
            throw new IllegalArgumentException("message format is illegal");
        }

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, ConsultMessageConsumeService> services = context.getBeansOfType(ConsultMessageConsumeService.class);
        messageConsumeServiceMap = new HashMap<>();
        for (ConsultMessageConsumeService service : services.values()) {
            messageConsumeServiceMap.put(service.getConsultType().getValue(), service);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

}
