package com.baijia.tianxiao.biz.consult.enums;

import java.util.HashMap;
import java.util.Map;

public enum SortOperation {
	
    DEL(0),

    ADD_LEFT(1),
    
    ADD_RIGHT(2);

    private static Map<Integer, SortOperation> map = new HashMap<>();

    static {
        for (SortOperation type : SortOperation.values()) {
            map.put(type.code, type);
        }
    }

    private int code;

    private SortOperation(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SortOperation getUserType(int code) {
        return map.get(code);
    }
}