package com.baijia.tianxiao.biz.consult.enums;

import java.util.HashMap;
import java.util.Map;

public enum CallUserType {
    Student(0),

    Parent(1);

    private static Map<Integer, CallUserType> map = new HashMap<>();

    static {
        for (CallUserType type : CallUserType.values()) {
            map.put(type.code, type);
        }
    }

    private int code;

    private CallUserType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CallUserType getUserType(int code) {
        return map.get(code);
    }
}