package com.baijia.tianxiao.biz.consult.dto.response;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/5/21.
 */
@Data
@Slf4j
public class ActivityInfo {
    private long id;
    private String name;
    private String thumb;
    private int type;
    private String url;
    private String content;

    public static ActivityInfo getInstance(Activity activity, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(activity.getId());
        info.setName(activity.getTitle());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.COMMON_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(DrawInfo drawInfo, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(drawInfo.getActivityId());
        info.setName(drawInfo.getName());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.DRAW_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(VoteInfo vote, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(vote.getActivityId());
        info.setName(vote.getName());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.VOTE_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(ReferralInfo referralInfo, Template template) {
        log.info("[Activity] template=" + ToStringBuilder.reflectionToString(template));
        ActivityInfo info = new ActivityInfo();
        info.setId(referralInfo.getActivityId());
        info.setName(referralInfo.getTitle());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.REFERRAL_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(TxActivityCommon common, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(common.getActivityId());
        info.setName(common.getTitle());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        TemplateTypeCategory category = TemplateTypeCategory.getTemplateTypeCategoryByTypeId(template.getTypeId());
        info.setType(category.getType());
        return info;
    }
}
