/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.dto;

import java.util.List;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年5月19日
 * @desc
 */
@Data
@Slf4j
public class MessageRecordDto {
    private String name; // 员工姓名
    private Integer userId; // 机构number
    private String avatarUrl; // 员工头像url
    private Integer userRole; // 身份 MsgUserRole
    private int userType = MsgUserType.ORG.getValue();
    private String userTypeString; // 身份类型对应字符描述
    private Boolean hasMore; // 是否显示更多数据

    private List<ConsultUserDetailDto> list;

    public static MessageRecordDto buildInstanceByOrg(OrgInfo orgInfo, Integer orgNumber, Integer orgType) {
        MessageRecordDto messageRecordDto = new MessageRecordDto();
        String name = orgInfo.getContacts();
        String avatarUrl = AvatarConstants.STUFF_AVATAR_URL;

        messageRecordDto.setUserId(orgNumber);
        messageRecordDto.setAvatarUrl(avatarUrl);
        messageRecordDto.setName(name == null ? "" : name);
        messageRecordDto.setUserRole(orgType);
        messageRecordDto.setUserTypeString(MsgUserRole.getByCode(orgType).getDesc());
        return messageRecordDto;

    }

    public void setList(List<ConsultUserDetailDto> list) {
        this.list = list;
    }

    public List<ConsultUserDetailDto> getList() {
        return list;
    }

}
