/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import com.baijia.tianxiao.biz.consult.enums.ConsulterOutLineType;
import com.baijia.tianxiao.biz.consult.enums.GenderStatus;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.query.ConsultUserQuery;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.field.FieldOption;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.display.dto.response.crm.DefaultClueField;
import com.baijia.tianxiao.sal.display.service.FieldShowInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueServiceImpl
implements ClueService {
    private static final Logger log = LoggerFactory.getLogger(ClueServiceImpl.class);
    private static final String CASCADE_ID_STR = "cascadeIdStr";
    private static final String CONSULT_SOURCES_TR = "consultSourceStr";
    private static final String TAGS_STR = "tagsStr";
    @Resource
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private ConsultUserService consultUserService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;
    @Autowired
    private OrgStudentTagService orgStudentTagService;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private ConsultUserQuery consultUserQuery;
    @Autowired
    private ConsultMessageService consultMessageService;
    @Autowired
    private FieldShowInfoService fieldShowInfoService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private StudentUserService studentUserService;
    @Autowired
    private TXStudentCommentAPIService commentAPIService;

    @Override
    public ConsultInfoResponseDto getBaseInfo(Long orgId, Long consulterId) throws Exception {
        if (null == orgId || orgId <= 0L || null == consulterId || consulterId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, consulterId);
        if (null == consulter) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        ConsultInfoResponseDto baseInfoDto = new ConsultInfoResponseDto();
        this.cluePo2Dto(consulter, baseInfoDto);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile((String)baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile((String)baseInfoDto.getParentMobile()));
        }
        log.info("getBaseInfo---------baseInfoDto={}", (Object)baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        return this.addClueInfo(orgId, clueInfo, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, boolean updateRepeat, boolean sendNotice) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = null;
        Long preOnwerCascadeId = null;
        if (updateRepeat) {
            List consulters = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)consulters)) {
                consulter = (TxConsultUser)consulters.get(0);
                preOnwerCascadeId = consulter.getCascadeId();
                clueInfo.setId(consulter.getId());
            } else {
                consulter = new TxConsultUser();
            }
        } else {
            this.vaildateConsult(orgId, clueInfo);
            consulter = new TxConsultUser();
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        log.debug("txSaleClueRule={}", (Object)txSaleClueRule);
        consulter.setIsConsulter(Integer.valueOf(Flag.TRUE.getInt()));
        this.clueDto2Po(clueInfo, consulter, orgId);
        if (consulter.getId() != null && consulter.getId() > 0L) {
            this.txConsultUserDao.updateWithDefaultVal((Object)consulter, new String[0]);
        } else {
            this.txConsultUserDao.save((Object)consulter, Boolean.valueOf(false), new String[0]);
            log.info("addClueInfo---------consulter={}", (Object)consulter.toString());
            this.commentAPIService.saveByConsultUserManualAdd(consulter);
        }
        Date now = new Date();
        if (clueInfo.getCascadeId() >= 0L && (preOnwerCascadeId == null || preOnwerCascadeId.equals(-1L))) {
            consulter.setFinallyHoldTime(DateUtil.getDiffDateTime((Date)now, (int)txSaleClueRule.getMaxClueDelay()));
            consulter.setLastPullTime(now);
            consulter.setLastRemindTime(now);
            consulter.setUpdateTime(now);
            this.txConsultUserDao.update((Object)consulter, new String[0]);
            TxConsulterOperationLog colog = new TxConsulterOperationLog(consulter.getId(), consulter.getCascadeId(), consulter.getCascadeId(), ConsulterOperation.PULL);
            this.txConsulterOperationLogDao.save((Object)colog, new String[0]);
            this.commentAPIService.saveByConsultUserPull(consulter, this.getAccountName(orgId, consulter.getCascadeId()));
        }
        this.setUserTags(orgId, consulter.getId(), clueInfo.getTagsStr());
        this.updateSolr(consulter);
        if (sendNotice && consulter.getCascadeId().intValue() == Flag.NULL.getInt()) {
            String content = NoticeType.getTips((String)consulter.getName());
            this.consultMessageService.sendNotice(orgId, Integer.valueOf(-1), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)consulter.getId()), (String)content));
        }
        return consulter.getId();
    }

    private void setUserTags(Long orgId, Long consulterId, String tags) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            log.debug("save tags :{} into db", (Object)tags);
            try {
                this.orgStudentTagService.delTagsByConsulterId(consulterId, orgId);
                List tagDtos = JacksonUtil.str2List((String)tags, TagInfoDto.class);
                if (!CollectionUtils.isEmpty((Collection)tagDtos)) {
                    this.orgStudentTagService.addStudentTag(tagDtos, Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId);
                }
            }
            catch (Exception e) {
                log.error("save tags:{} catch error:{}", (Object)tags, (Object)e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void editClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo || null == clueInfo.getId() || clueInfo.getId() <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, clueInfo.getId());
        if (null == consulter) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        this.vaildateConsult(orgId, clueInfo);
        if (clueInfo.getMobile().contains("****")) {
            clueInfo.setMobile(consulter.getMobile());
        }
        if (clueInfo.getParentMobile().contains("****")) {
            clueInfo.setParentMobile(consulter.getParentMobile());
        }
        this.clueDto2Po(clueInfo, consulter, orgId);
        this.txConsultUserDao.updateWithDefaultVal((Object)consulter, new String[0]);
        log.info("editClueInfo---------consulter={}", (Object)consulter.toString());
        this.commentAPIService.saveByConsultUserUpdate(consulter);
        this.updateSolr(consulter);
    }

    private void cluePo2Dto(TxConsultUser po, ConsultInfoResponseDto dto) throws IllegalAccessException, InvocationTargetException {
        log.info("cluePo2Dto---------po={}", (Object)po);
        BeanUtils.copyProperties((Object)dto, (Object)po);
        dto.setConsultSourceStr(MessageSource.getByType((Integer)po.getConsultSource()).getDesc());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }
        dto.setConsultSourceStr(this.consultSourceService.getConsultSourceStr(Long.valueOf(Long.parseLong(dto.getConsultSource() + ""))));
        dto.setConsultStatusStr(ConsultUserStatus.getLabel((int)dto.getConsultStatus()));
        dto.setRelativesStr(Relatives.getLabel((Integer)dto.getRelatives()));
        dto.setId(dto.getId());
        dto.setCascadeIdStr(dto.getCascadeId() + "");
        dto.setSexStr(GenderStatus.getGenderStr(dto.getSex()));
        dto.setIntensionLevelStr(IntentionLevel.getLabel((Integer)dto.getIntensionLevel()));
        if (null != dto.getAreaId() && dto.getAreaId() > 0L) {
            Map areaMap = AreaUtils.getAreaNameByCode((Long)dto.getAreaId());
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
        if (dto.getCascadeId() == -1L) {
            dto.setCascadeIdStr("\u516c\u5171\u6c60");
        } else {
            Map casCadeMaps = this.txCascadeCredentialService.getByTxCasCadeIds(po.getOrgId());
            log.debug("cluePo2Dto casCadeMaps={},caid={}", (Object)casCadeMaps, (Object)dto.getCascadeId());
            dto.setCascadeIdStr((String)casCadeMaps.get(dto.getCascadeId()));
        }
    }

    private void clueDto2Po(ConsultListResponseDto dto, TxConsultUser po, Long orgId) throws IllegalAccessException, InvocationTargetException {
        log.info("clueDto2Po---------dto={}", (Object)dto);
        BeanUtils.copyProperties((Object)po, (Object)dto);
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0L) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }
        if (null == po.getId() || 0L == po.getId()) {
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
        }
        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        if (dto.getCascadeId() != 0L) {
            po.setCascadeId(Long.valueOf(dto.getCascadeId()));
        }
        po.setUpdateTime(new Date());
        if (po.getCascadeId() != null && po.getCascadeId() >= 0L) {
            po.setLastRemindTime(new Date());
        }
    }

    @Override
    public void vaildateConsult(Long orgId, ConsultListResponseDto clueInfo) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{clueInfo.getMobile()}) && !clueInfo.getMobile().contains("****")) {
            List targets = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            log.info("doSaveBefore---------clueInfo={},targets={}", (Object)clueInfo, (Object)targets);
            if (targets != null && !targets.isEmpty()) {
                if (clueInfo.getId() != null && clueInfo.getId() > 0L) {
                    if (targets.size() > 1 || ((TxConsultUser)targets.get(0)).getId().longValue() != clueInfo.getId().longValue()) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u7ebf\u7d22");
                    }
                } else {
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u7ebf\u7d22");
                }
            }
        }
    }

    @Override
    public List<ConsultListResponseDto> getClueList(long orgId, CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        Integer cascadeId = request.getCascadeId();
        ConsulterListQueryParam consulterListQueryParam = new ConsulterListQueryParam();
        consulterListQueryParam.setKeyFieldName(request.getName());
        consulterListQueryParam.setKeyword(request.getQuery());
        consulterListQueryParam.setConsulterType(Integer.valueOf(request.getStatus()));
        consulterListQueryParam.setOrgId(Long.valueOf(orgId));
        consulterListQueryParam.setPropName(request.getOrderName());
        consulterListQueryParam.setSortType(Integer.valueOf(request.getOrderType()));
        Long cascadeId_ = cascadeId == null ? 0L : cascadeId.longValue();
        List<ConsulterListDto> solrList = this.consultUserService.listConsulter(orgId, cascadeId_, consulterListQueryParam, pageDto);
        Map casCadeMaps = this.txCascadeCredentialService.getByTxCasCadeIds(Long.valueOf(orgId));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(Long.valueOf(orgId), cascadeId);
        log.info("needShowMobile : {} ", (Object)isShowMobile);
        ArrayList result = Lists.newArrayList();
        Map sourceMap = this.consultSourceService.mapConsultSourceDto(Long.valueOf(orgId), null);
        ConsultCustomSourceDto sourceDto = null;
        log.info("[Consult] solrList:{}", solrList);
        Iterator<ConsulterListDto> iterator = solrList.iterator();
        while (iterator.hasNext()) {
            ConsulterListDto consultUser;
            sourceDto = (ConsultCustomSourceDto)sourceMap.get(Long.parseLong((consultUser = iterator.next()).getConsultSource() + ""));
            ConsultListResponseDto dto = ConsultListResponseDto.convertToDto(consultUser, sourceDto != null ? sourceDto.getLabel() : "");
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
            }
            if (consultUser.getCascadeId() == -1) {
                dto.setCascadeIdStr("\u516c\u5171\u6c60");
            } else {
                dto.setCascadeIdStr((String)casCadeMaps.get(consultUser.getCascadeId().longValue()));
            }
            if (request.getStatus() == ConsulterOutLineType.INVALID.getValue()) {
                dto.setCascadeIdStr("");
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public void delClueInfo(Long clueInfoId) throws Exception {
        TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)clueInfoId, new String[0]);
        consultUser.setDelStatus(Integer.valueOf(DataStatus.DELETE.getValue()));
        this.txConsultUserDao.update((Object)consultUser, new String[0]);
        String contentFmt = "\u5220\u9664\u7ebf\u7d22 %s";
        contentFmt = String.format(contentFmt, consultUser.getName());
        this.commentAPIService.saveByConsultUserDel(consultUser);
        this.updateSolr(consultUser);
    }

    @Override
    public void delClueInfo(List<Long> clueInfoIds) throws Exception {
        List consultUsers = this.txConsultUserDao.getByIds(clueInfoIds, new String[0]);
        for (TxConsultUser txConsultUser : consultUsers) {
            txConsultUser.setDelStatus(Integer.valueOf(DataStatus.DELETE.getValue()));
            this.txConsultUserDao.update((Object)txConsultUser, new String[0]);
            String contentFmt = "\u5220\u9664\u7ebf\u7d22 %s";
            contentFmt = String.format(contentFmt, txConsultUser.getName());
            this.commentAPIService.saveByConsultUserManualAdd(txConsultUser);
            this.updateSolr(txConsultUser);
        }
    }

    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "\u672a\u77e5";
        if (cascadeId > 0L) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)txCascadeAccount.getCredentialId(), new String[0]);
            shortName = credential.getName();
        } else {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    public static void main(String[] args) {
        Date startOfDay = DateUtil.getStartOfDay((Date)DateUtil.getDayDiff((int)-6));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(format.format(startOfDay));
    }

    void updateSolr(TxConsultUser txConsultUser) {
        try {
            txConsultUser.toSolrMap();
            log.info("solr - consult user - update - end - txConsultUser:{}", (Object)txConsultUser);
        }
        catch (Exception e) {
            log.error("solr - consult user - update - exception", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getPcClueList(Long orgId, CommonSearchRequestDto request, PageDto pageDto) {
        if (orgId == null || orgId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u673a\u6784id\u9519\u8bef");
        }
        List header = this.fieldShowInfoService.getHeader(orgId, DataProcType.CONSULT, null);
        if (CollectionUtils.isEmpty((Collection)header)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u5217\u8868\u663e\u793a\u5c5e\u6027\u5931\u8d25");
        }
        Integer cascadeId = request.getCascadeId();
        ConsulterListQueryParam consulterListQueryParam = new ConsulterListQueryParam();
        consulterListQueryParam.setKeyFieldName(request.getName());
        consulterListQueryParam.setKeyword(request.getQuery());
        consulterListQueryParam.setConsulterType(Integer.valueOf(request.getStatus()));
        consulterListQueryParam.setOrgId(orgId);
        consulterListQueryParam.setConsultStatus(request.getConsultStatus());
        consulterListQueryParam.setDateFieldKey(request.getDateFieldKey());
        if (request.getStart() != null) {
            consulterListQueryParam.setStart(new Date(request.getStart()));
        }
        if (request.getEnd() != null) {
            consulterListQueryParam.setEnd(new Date(request.getEnd()));
        }
        consulterListQueryParam.setPropName(request.getOrderName());
        consulterListQueryParam.setSortType(Integer.valueOf(request.getOrderType()));
        if (request.getStatus() == 0) {
            consulterListQueryParam.setIsInvalid(null);
        }
        Long cascadeId_ = cascadeId == null ? 0L : cascadeId.longValue();
        List<ConsulterListDto> solrList = this.consultUserService.listConsulter(orgId, cascadeId_, consulterListQueryParam, pageDto);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("header", header);
        data.put("result", result);
        if (CollectionUtils.isEmpty(solrList)) {
            return data;
        }
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        Set clueIds = BaseUtils.getPropertiesList(solrList, (String)"id");
        Map casCadeMaps = new HashMap();
        Map sourceMap = new HashMap();
        Map tagsMap = new HashMap();
        Map clueFieldsMap = new HashMap();
        HashSet<String> sysNames = new HashSet<String>();
        HashSet<Long> customIds = new HashSet<Long>();
        for (FieldOption option : header) {
            if (option.getCustomId() != null && option.getCustomId() > 0L) {
                customIds.add(option.getCustomId());
                continue;
            }
            sysNames.add(option.getName());
        }
        if (sysNames.contains(CASCADE_ID_STR)) {
            casCadeMaps = this.txCascadeCredentialService.getByTxCasCadeIds(orgId);
        }
        if (sysNames.contains(CONSULT_SOURCES_TR)) {
            sourceMap = this.consultSourceService.mapConsultSourceDto(orgId, null);
        }
        if (sysNames.contains(TAGS_STR)) {
            tagsMap = this.orgStudentTagService.getTagsMap(orgId, (Collection)clueIds, StudentType.CONSULT_USER);
        }
        if (CollectionUtils.isNotEmpty(customIds)) {
            clueFieldsMap = this.customFieldValueService.batchGetFieldValue(orgId, false, (Collection)clueIds, customIds);
        }
        for (ConsulterListDto consultUser : solrList) {
            DefaultClueField dto = this.getFromConsultUser(consultUser);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
            }
            if (consultUser.getCascadeId() == -1) {
                dto.setCascadeIdStr("\u516c\u5171\u6c60");
            } else {
                dto.setCascadeIdStr((String)casCadeMaps.get(consultUser.getCascadeId().longValue()));
            }
            if (consultUser.getIsInvalid() == 1) {
                dto.setCascadeIdStr("");
            }
            if (tagsMap.containsKey(dto.getId())) {
                dto.setTagsStr((String)tagsMap.get(dto.getId()));
            } else {
                dto.setTagsStr("");
            }
            if (sourceMap.containsKey(consultUser.getConsultSource().longValue())) {
                ConsultCustomSourceDto sourceDto = (ConsultCustomSourceDto)sourceMap.get(consultUser.getConsultSource().longValue());
                dto.setConsultSourceStr(sourceDto != null ? sourceDto.getLabel() : "");
            }
            Map<String, Object> item = this.getItemMap(header, dto, (Map)clueFieldsMap.get(dto.getId()));
            item.put("isValid", consultUser.getIsInvalid());
            if (consultUser.getIsInvalid() == 1) {
                item.put("status", ConsulterOutLineType.INVALID.getValue());
            } else {
                item.put("status", this.getStatus(cascadeId_.intValue(), consultUser.getCascadeId()));
            }
            result.add(item);
        }
        return data;
    }

    private int getStatus(int loginCascadeId, int clueCascadeId) {
        if (clueCascadeId == -1) {
            return ConsulterOutLineType.PUBLISH.getValue();
        }
        if (clueCascadeId == loginCascadeId) {
            return ConsulterOutLineType.MINE.getValue();
        }
        return ConsulterOutLineType.SUBORDINATE.getValue();
    }

    private DefaultClueField getFromConsultUser(ConsulterListDto consultUser) {
        DefaultClueField dto = new DefaultClueField();
        try {
            BeanUtils.copyProperties((Object)dto, (Object)consultUser);
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "copy properties failed!");
        }
        if (consultUser.getBirthday() != null) {
            dto.setBirthdayStr(DateUtil.getStrByDate((Date)consultUser.getBirthday()));
        }
        dto.setConsultStatusStr(ConsultUserStatus.getLabel((int)consultUser.getConsultStatus()));
        dto.setRelativesStr(Relatives.getLabel((Integer)consultUser.getRelatives()));
        dto.setSexStr(GenderStatus.getGenderStr(consultUser.getSex()));
        dto.setIntensionLevelStr(IntentionLevel.getLabel((Integer)consultUser.getIntensionLevel()));
        dto.setCreateTimeStr(DateUtil.getStrByDate((Date)consultUser.getCreateTime()));
        if (consultUser.getLastRemindTime() != null) {
            dto.setLastRemindTimeStr(DateUtil.getStrByDate((Date)consultUser.getLastRemindTime()));
        }
        return dto;
    }

    private <T> Map<String, Object> getItemMap(List<FieldOption> header, T t, Map<Long, String> customMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object[] fields = t.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Map sysFieldMap = BaseUtils.listToMap((List)Lists.newArrayList((Object[])fields), (String)"name");
            for (FieldOption option : header) {
                if (option.getCustomId() != null && option.getCustomId() > 0L) {
                    if (customMap == null || !customMap.containsKey(option.getCustomId())) continue;
                    map.put(option.getName(), customMap.get(option.getCustomId()));
                    continue;
                }
                Field field = (Field)sysFieldMap.get(option.getName());
                if (field == null) continue;
                Object ret = null;
                try {
                    field.setAccessible(true);
                    ret = field.get(t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
                }
                map.put(option.getName(), ret);
            }
        }
        return map;
    }

    @Override
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, List<CustomFieldValue> valueList, boolean updateRepeat, boolean sendNotice) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = null;
        Long preOnwerCascadeId = null;
        if (updateRepeat) {
            List consulters = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)consulters)) {
                consulter = (TxConsultUser)consulters.get(0);
                preOnwerCascadeId = consulter.getCascadeId();
                clueInfo.setId(consulter.getId());
            } else {
                consulter = new TxConsultUser();
            }
        } else {
            this.vaildateConsult(orgId, clueInfo);
            consulter = new TxConsultUser();
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        log.debug("txSaleClueRule={}", (Object)txSaleClueRule);
        consulter.setIsConsulter(Integer.valueOf(Flag.TRUE.getInt()));
        this.clueDto2Po(clueInfo, consulter, orgId);
        if (consulter.getId() != null && consulter.getId() > 0L) {
            this.txConsultUserDao.updateWithDefaultVal((Object)consulter, new String[0]);
        } else {
            this.txConsultUserDao.save((Object)consulter, Boolean.valueOf(false), new String[0]);
            log.info("addClueInfo---------consulter={}", (Object)consulter.toString());
            this.commentAPIService.saveByConsultUserManualAdd(consulter);
        }
        Date now = new Date();
        if (clueInfo.getCascadeId() >= 0L && (preOnwerCascadeId == null || preOnwerCascadeId.equals(-1L))) {
            consulter.setFinallyHoldTime(DateUtil.getDiffDateTime((Date)now, (int)txSaleClueRule.getMaxClueDelay()));
            consulter.setLastPullTime(now);
            consulter.setLastRemindTime(now);
            consulter.setUpdateTime(now);
            this.txConsultUserDao.update((Object)consulter, new String[0]);
            TxConsulterOperationLog colog = new TxConsulterOperationLog(consulter.getId(), consulter.getCascadeId(), consulter.getCascadeId(), ConsulterOperation.PULL);
            this.txConsulterOperationLogDao.save((Object)colog, new String[0]);
            this.commentAPIService.saveByConsultUserPull(consulter, this.getAccountName(orgId, consulter.getCascadeId()));
        }
        this.setUserTags(orgId, consulter.getId(), clueInfo.getTagsStr());
        Long consulterId = consulter.getId();
        String customSearchValue = this.studentUserService.buildCustomSearchValue(valueList, true, true, orgId, consulterId, Boolean.valueOf(false));
        TxConsultUser user = new TxConsultUser();
        user.setId(consulterId);
        if (StringUtils.isBlank((CharSequence)customSearchValue)) {
            customSearchValue = null;
        }
        user.setCustomSearchValue(customSearchValue);
        this.txConsultUserDao.update((Object)user, Boolean.valueOf(true), new String[]{"customSearchValue"});
        if (sendNotice && consulter.getCascadeId().intValue() == Flag.NULL.getInt()) {
            String content = NoticeType.getTips((String)consulter.getName());
            NoticeMsgContent notice = NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)consulter.getId()), (String)content);
            notice.setTip(PushTipFactory.getNewClueTip((String)consulter.getName(), (String)consulter.getMobile()));
            notice.setPushTitle("\u7ebf\u7d22\u5f85\u9886");
            this.consultMessageService.sendNotice(orgId, Integer.valueOf(-1), notice);
        }
        return consulterId;
    }
}

