/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXKefuRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.DBOperation;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="advisoryMsgConsumeService")
public class StudentAdvisoryMsgServiceImpl
extends AbstractConsultService<AdvisoryInfoDto> {
    private static final Logger log = LoggerFactory.getLogger(StudentAdvisoryMsgServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TXKefuRuleDao kefuRuleDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    public MessageSource getConsultType() {
        return MessageSource.APPOINTMENT;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(AdvisoryInfoDto msg, Long consultUserId) {
        CardMsgContent content = CardContentFactory.createAppointCard((String)msg.getStudentName(), (String)msg.getStudentMobile(), (String)msg.getWords());
        content.setAction(ActionUtil.getTelephoneAction((long)consultUserId, (String)msg.getStudentMobile()));
        ConsultMessage pushMsg = new ConsultMessage();
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson((Object)content));
        pushMsg.setConsultType(MessageSource.APPOINTMENT.getValue());
        pushMsg.setCreateTime(msg.getCreateTime());
        pushMsg.setMsgType(MsgType.CARD.getValue());
        return pushMsg;
    }

    private MsgUser builderSender(AdvisoryInfoDto msg, int isClue) {
        log.info("AdvisoryInfoDto.msg:{},isClue={}", (Object)msg, (Object)isClue);
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(msg.getOrgId());
        consultUser.setMobile(msg.getStudentMobile());
        consultUser.setName(msg.getStudentName());
        consultUser.setConsultSource(Integer.valueOf(MessageSource.APPOINTMENT.getValue()));
        consultUser.setIsConsulter(Integer.valueOf(isClue));
        if (msg.getUserNumber() != null) {
            consultUser.setUserNumber(msg.getUserNumber());
        }
        if (msg.getStudentId() == null) {
            consultUser.setUserId(Long.valueOf(0L));
        } else {
            consultUser.setUserId(msg.getStudentId());
        }
        DBResultDto dto = this.consulterAPIService.saveOrUpdateByMobile(consultUser);
        TxConsultUser result = (TxConsultUser)dto.getData();
        this.txStudentCommentAPIService.saveByAdvisory(result, consultUser.getUserId(), msg.getWords(), dto.getOperation() == DBOperation.INSERT);
        return ConsulterDto.convertToDto(result);
    }

    private MsgUser buildOrgMsgUser(AdvisoryInfoDto msg) {
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setOrgId(Integer.valueOf(msg.getOrgId().intValue()));
        return this.buildReceiver(orgInfo, msg.getOrgNumber());
    }

    @Override
    public boolean consume(AdvisoryInfoDto message) {
        log.info("consume advisory get msg:{}", (Object)message);
        if (message == null || message.getOrgId() == null) {
            throw new IllegalArgumentException(" advisory record is illegal");
        }
        String tip = PushTipFactory.getNewAppointmentTep((String)message.getStudentName(), (String)message.getStudentMobile());
        boolean result = false;
        TXKefuRule rule = this.kefuRuleDao.getByOrgId(Integer.valueOf(message.getOrgId().intValue()));
        if (rule != null && rule.getBespeakRule() != null && rule.getBespeakRule() == 1) {
            log.info("[Notice] Appointment notice!");
            MsgUser user = this.builderSender(message, 1);
            String content = NoticeType.getTips((String)message.getStudentName());
            OrgStudent orgStudent = null;
            if (message.getOrgId() != null && message.getStudentMobile() != null) {
                orgStudent = this.orgStudentDao.getStudentByMobileAndOrgId(message.getOrgId(), message.getStudentMobile(), new String[0]);
            }
            if (orgStudent == null) {
                NoticeMsgContent notice = NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)user.getUserId()), (String)content);
                notice.setTip(tip);
                notice.setPushTitle("\u9884\u7ea6\u8bd5\u542c");
                result = this.consultMessageService.sendNotice(message.getOrgId(), Integer.valueOf(-1), notice);
            } else {
                result = true;
            }
        } else {
            MsgUser receiver = this.buildOrgMsgUser(message);
            MsgUser sender = this.builderSender(message, 0);
            if (sender == null || receiver == null) {
                log.warn("sender :{} or receiver:{} is null,skip advisory  msg:{},skip", new Object[]{sender, receiver, message});
                return false;
            }
            ConsultMessage msgContent = this.buildPushMessageContent(message, sender.getUserId());
            msgContent.setTip(tip);
            msgContent.setPushTitle("\u9884\u7ea6\u8bd5\u542c");
            log.info("consume advisory msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
            result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
            log.info("push student advisory msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        }
        return result;
    }

    @Override
    public AdvisoryInfoDto transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (AdvisoryInfoDto)JacksonUtil.str2Obj((String)body, AdvisoryInfoDto.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }

    private void buildComment(TxConsultUser consultUser, AdvisoryInfoDto msg, boolean isNewStudent) {
        log.info("buildComment--------consultUser={}", (Object)consultUser.toString());
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(consultUser.getId());
        User user = null;
        if (msg.getStudentId() != null) {
            user = (User)this.userDao.getById((Serializable)msg.getStudentId(), new String[0]);
        }
        if (user != null && msg.getStudentMobile().equals(user.getMobile())) {
            comment.setUserId(consultUser.getUserId());
        } else {
            comment.setUserId(Long.valueOf(0L));
        }
        comment.setOrgId(consultUser.getOrgId());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        StringBuffer content = new StringBuffer();
        if (isNewStudent) {
            content.append("\u7cfb\u7edf\u6dfb\u52a0\u4e86\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consultUser.getName()) ? consultUser.getName() : "\u5728\u7ebf\u7559\u5355\u5b66\u751f") + "\n");
        }
        content.append("\u7559\u5355\u5185\u5bb9: " + (StringUtils.isNotBlank((CharSequence)msg.getWords()) ? msg.getWords() : "\u65e0"));
        comment.setContent(content.toString());
        comment.setOrigin(this.getConsultType().getValue());
        log.info("buildComment.comment:{}", (Object)comment);
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
    }
}

