/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXKefuRuleDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityResultDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.utils.PushTipFactory;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgLotteryDrawServiceImpl
extends AbstractConsultService<DrawActivityResultDto> {
    private static final Logger log = LoggerFactory.getLogger(OrgLotteryDrawServiceImpl.class);
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TXKefuRuleDao kefuRuleDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    public MessageSource getConsultType() {
        return MessageSource.SIGNUP;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(DrawActivityResultDto msg, Long consulterUserId) {
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(MessageSource.SIGNUP.getValue());
        pushMsg.setCreateTime((Date)new Timestamp(msg.getCreateTime()));
        pushMsg.setMsgType(MsgType.CARD.getValue());
        CardMsgContent content = CardContentFactory.createActivityCard((String)msg.getUserName(), (String)msg.getMobile(), (String)msg.getName());
        content.setAction(ActionUtil.getTelephoneAction((long)consulterUserId, (String)msg.getMobile()));
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson((Object)content));
        return pushMsg;
    }

    @Override
    public boolean consume(DrawActivityResultDto message) {
        TXKefuRule rule;
        if (message == null || message.getId() < 0L || message.getOrgId() == null) {
            throw new IllegalArgumentException(" activity sign up record is illegal");
        }
        boolean result = true;
        String tip = PushTipFactory.getNewDrawWinnerTip();
        String pushTitle = "\u62bd\u5956\u6d3b\u52a8";
        if (StringUtils.isBlank((CharSequence)message.getAward())) {
            tip = PushTipFactory.getNewActivitySignTip((String)message.getUserName(), (String)message.getMobile());
            pushTitle = "\u6d3b\u52a8\u62a5\u540d";
        }
        if ((rule = this.kefuRuleDao.getByOrgId(Integer.valueOf(message.getOrgId().intValue()))) != null && rule.getBespeakRule() != null && rule.getBespeakRule() == 1) {
            log.info("[Notice] Draw notice!");
            MsgUser user = this.builderSender(message, 1);
            String content = NoticeType.getTips((String)message.getUserName());
            NoticeMsgContent notice = NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)user.getUserId()), (String)content);
            notice.setTip(tip);
            notice.setPushTitle(pushTitle);
            result = this.consultMessageService.sendNotice(message.getOrgId(), Integer.valueOf(-1), notice);
        } else {
            MsgUser receiver = this.buildOrgMsgUser(message);
            MsgUser sender = this.builderSender(message, 0);
            if (sender == null || receiver == null) {
                log.warn("sender :{} or receiver:{} is null,skip activity sign up  msg:{},skip", new Object[]{sender, receiver, message});
                return false;
            }
            ConsultMessage msgContent = this.buildPushMessageContent(message, sender.getUserId());
            msgContent.setTip(tip);
            msgContent.setPushTitle(pushTitle);
            log.info("consume activity sign up msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
            result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
            log.info("push student activity sign up msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        }
        return result;
    }

    private MsgUser builderSender(DrawActivityResultDto msg, int isClue) {
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(msg.getOrgId());
        consultUser.setMobile(msg.getMobile());
        consultUser.setName(msg.getUserName());
        consultUser.setConsultSource(Integer.valueOf(MessageSource.SIGNUP.getValue()));
        consultUser.setIsConsulter(Integer.valueOf(isClue));
        TxConsultUser result = (TxConsultUser)this.consulterAPIService.saveOrUpdateByMobile(consultUser).getData();
        this.txStudentCommentAPIService.saveByOrgActivitySignUp(result, msg.getName(), msg.getUserName(), msg.getMobile(), msg.getAward());
        return ConsulterDto.convertToDto(result);
    }

    private MsgUser buildOrgMsgUser(DrawActivityResultDto message) {
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setOrgId(Integer.valueOf(message.getOrgId().intValue()));
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)message.getOrgId(), new String[0]);
        Integer orgNumber = null;
        if (account == null) {
            return null;
        }
        orgNumber = account.getNumber();
        message.setOrgNumber(Long.valueOf(orgNumber.longValue()));
        return this.buildReceiver(orgInfo, orgNumber.longValue());
    }

    @Override
    public DrawActivityResultDto transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (DrawActivityResultDto)JacksonUtil.str2Obj((String)body, DrawActivityResultDto.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }
}

