/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.dto.response.ActivityInfo;
import com.baijia.tianxiao.biz.consult.msg.service.BizActivityService;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="consutBizActivityServiceImpl")
public class BizActivityServiceImpl
implements BizActivityService {
    private static final Logger log = LoggerFactory.getLogger(BizActivityServiceImpl.class);
    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private TxActivityCommonDao activityCommonDao;

    @Override
    public List<ActivityInfo> getAllActivities(long orgId) {
        ArrayList<ActivityInfo> ret = new ArrayList<ActivityInfo>();
        List list = this.activityCommonDao.selectUnEndedActivityList(orgId);
        if (list != null) {
            for (TxActivityCommon activity : list) {
                ActivityInfo instance = ActivityInfo.getInstance(activity, (Template)TemplateConstant.getMap().get((int)activity.getTemplateId()));
                instance.setUrl(this.getUrl(activity.getTemplateId().intValue(), activity.getActivityId()));
                ret.add(instance);
            }
        }
        log.info("find all marketing activityList : {} ", ret);
        return ret;
    }

    private String getWechatUrl(long activityId, int templateId) {
        log.info("[param] activityId=" + activityId + ";templateId=" + templateId);
        CustomActivityDto dto = this.customActivityService.getCustomActivity((int)activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        }
        return "";
    }

    private String getUrl(long templateId, long activityId) {
        StringBuilder sb = new StringBuilder();
        String url = TemplateConstant.getTemplateUrl((Integer)((int)templateId));
        sb.append(Config.DOMAIN);
        sb.append(url).append("&activityId=").append(activityId).append("#!/");
        return sb.toString();
    }
}

