/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import com.baijia.tianxiao.biz.consult.user.dto.ConsulterPullLogDto;
import com.baijia.tianxiao.biz.consult.user.service.ConsulterOperationLogService;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsulterOperationLogServiceImpl
implements ConsulterOperationLogService {
    private static final Logger log = LoggerFactory.getLogger(ConsulterOperationLogServiceImpl.class);
    @Autowired
    private TxConsulterOperationLogDao operationLogDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Override
    public List<ConsulterPullLogDto> listLogs(Long orgId, Long consulterId) {
        ArrayList<ConsulterPullLogDto> dtoList = new ArrayList<ConsulterPullLogDto>();
        HashSet<Integer> operationTypeList = new HashSet<Integer>();
        operationTypeList.add(ConsulterOperation.PUSH_AUTO.getValue());
        operationTypeList.add(ConsulterOperation.PUSH_MANUAL.getValue());
        operationTypeList.add(ConsulterOperation.PASSTO.getValue());
        operationTypeList.add(ConsulterOperation.PULL.getValue());
        operationTypeList.add(ConsulterOperation.ASSIGN.getValue());
        List dbList = this.operationLogDao.listByConsultUserId(consulterId, operationTypeList);
        HashSet<Integer> ownerCascadeIds = null;
        if (!CollectionUtils.isEmpty((Collection)dbList)) {
            ownerCascadeIds = new HashSet<Integer>();
            TxConsulterOperationLog log = null;
            TxConsulterOperationLog preLog = null;
            ConsulterPullLogDto dto = null;
            block0: for (int i = 0; i < dbList.size(); ++i) {
                log = (TxConsulterOperationLog)dbList.get(i);
                if (log.getOperationType().intValue() != ConsulterOperation.PUSH_AUTO.getValue() && log.getOperationType().intValue() != ConsulterOperation.PUSH_MANUAL.getValue()) continue;
                dto = new ConsulterPullLogDto();
                dto.setBacktime(log.getCreateTime().getTime());
                dto.setBackType(log.getOperationType());
                for (int j = i + 1; j < dbList.size(); ++j) {
                    preLog = (TxConsulterOperationLog)dbList.get(j);
                    if (preLog.getOperationType().intValue() == ConsulterOperation.PASSTO.getValue() || preLog.getOperationType().intValue() == ConsulterOperation.PULL.getValue() || preLog.getOperationType().intValue() == ConsulterOperation.ASSIGN.getValue()) {
                        ownerCascadeIds.add(preLog.getTargetCascadeId().intValue());
                        dto.setOwnerCascadeId(preLog.getTargetCascadeId());
                        dto.setPulltime(preLog.getCreateTime().getTime());
                        dtoList.add(dto);
                        i = j;
                        continue block0;
                    }
                    if (log.getOperationType().intValue() != ConsulterOperation.PUSH_AUTO.getValue() && log.getOperationType().intValue() != ConsulterOperation.PUSH_MANUAL.getValue()) continue;
                    i = j - 1;
                    continue block0;
                }
            }
        }
        if (!CollectionUtils.isEmpty(dtoList)) {
            Map nameMap = this.txCascadeCredentialDao.getTxCascadCredentialNameByCascdeIds(ownerCascadeIds);
            OrgInfo orgInfo = null;
            for (ConsulterPullLogDto dto : dtoList) {
                if (dto.getOwnerCascadeId() < 0L) {
                    dto.setOwnerName("\u65e0");
                    continue;
                }
                if (dto.getOwnerCascadeId() == 0L) {
                    if (orgInfo == null) {
                        orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
                    }
                    dto.setOwnerName(orgInfo.getShowName());
                    continue;
                }
                dto.setOwnerName((String)nameMap.get((long)dto.getOwnerCascadeId()));
            }
        }
        return dtoList;
    }
}

