/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.dal.callservice.constant.OrgCallStatus;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.DBOperation;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgCallConsultService")
public class OrgCallConsultServiceImpl
extends AbstractConsultService<OrgPushCallInfo> {
    private static final Logger log = LoggerFactory.getLogger(OrgCallConsultServiceImpl.class);
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private OrgStorageDao storageDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TX400PhoneDao tx400PhoneDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    private MsgUser builderSender(Long orgId, OrgPushCallInfo callInfo) {
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(orgId);
        consultUser.setMobile(callInfo.getCustomerNumber());
        consultUser.setName("\u8bbf\u5ba2");
        consultUser.setConsultSource(Integer.valueOf(MessageSource.TELEPHONE.getValue()));
        consultUser.setIsConsulter(null);
        DBResultDto dto = this.consulterAPIService.saveOrUpdateByMobile(consultUser);
        TxConsultUser result = (TxConsultUser)dto.getData();
        this.txStudentCommentAPIService.saveByOrgCall400(result, callInfo, dto.getOperation() == DBOperation.INSERT);
        return ConsulterDto.convertToDto(result);
    }

    private void studentToConsult(TxConsultUser consultUser, OrgStudent orgStudent, User user) {
        Fans fans;
        if (user != null) {
            consultUser.setUserNumber(user.getNumber());
        }
        consultUser.setAddress(orgStudent.getAddress());
        consultUser.setConsultStatus(Integer.valueOf(ConsultUserStatus.HAS.getValue()));
        consultUser.setCreateTime(new Date());
        consultUser.setDegreeClass(orgStudent.getDegreeClass());
        consultUser.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        consultUser.setFatherOccupation(orgStudent.getFatherOccupation());
        consultUser.setMail(orgStudent.getMail());
        consultUser.setManually(0);
        consultUser.setMatherOccupation(orgStudent.getMatherOccupation());
        consultUser.setName(orgStudent.getName());
        consultUser.setNextRemindTime(orgStudent.getNextRemindTime());
        consultUser.setNickName(orgStudent.getNickName());
        consultUser.setParentMobile(orgStudent.getParentMobile());
        consultUser.setParentName(orgStudent.getParentName());
        consultUser.setQq(orgStudent.getQq());
        consultUser.setSchool(orgStudent.getSchool());
        consultUser.setStudentId(orgStudent.getId());
        consultUser.setUserId(orgStudent.getUserId());
        consultUser.setWeixinOpenId(orgStudent.getWeixin());
        if (StringUtils.isNotBlank((CharSequence)orgStudent.getWeixin()) && !orgStudent.getWeixin().equals("0") && (fans = this.fansDao.getByOpenId(orgStudent.getWeixin())) != null) {
            consultUser.setWeixinAppId(fans.getAuthorizerAppId());
        }
    }

    private void userToConsult(TxConsultUser consultUser, String mobile) {
        User user = this.userDao.getByMobile(mobile, new String[]{"id", "number", "mobile"});
        if (user != null) {
            Student student = this.studentDao.getByUserId(user.getId(), new String[]{"userId", "realName", "nickName"});
            consultUser.setName(this.getNameFromStudent(student));
            consultUser.setUserId(user.getId());
            consultUser.setUserNumber(user.getNumber());
        }
    }

    private MsgUser buildOrgMsgUser(String extension) {
        MsgUser msgUser = this.own400(extension);
        if (msgUser != null) {
            return msgUser;
        }
        OrgInfo orgInfo = this.orgInfoDao.getByExtension(extension, new String[]{"orgId", "name", "shortName", "extension"});
        if (orgInfo == null) {
            log.warn("can not get org info by extension:{}", (Object)extension);
            return null;
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgInfo.getOrgId().intValue(), new String[]{"number"});
        return this.buildReceiver(orgInfo, orgAccount.getNumber().longValue());
    }

    private MsgUser own400(String extension) {
        if (StringUtils.isNotBlank((CharSequence)extension) && extension.length() > 6) {
            TX400Phone tx400Phone = null;
            tx400Phone = extension.startsWith("400") ? this.tx400PhoneDao.getBy400Phone(extension) : this.tx400PhoneDao.getByTransPhone(extension);
            if (tx400Phone == null) {
                log.warn("can not get TX400Phone info by extension:{}", (Object)extension);
                return null;
            }
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(tx400Phone.getOrgId().intValue(), new String[0]);
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(tx400Phone.getOrgId(), new String[0]);
            return this.buildReceiver(orgInfo, orgAccount.getNumber().longValue());
        }
        return null;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(OrgPushCallInfo msg, Long consultUserId) {
        log.info("[OrgPushCallInfo] callInfo=" + msg);
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(MessageSource.TELEPHONE.getValue());
        pushMsg.setCreateTime(msg.getStartTime());
        String url = "";
        int len = 0;
        CardMsgContent content = null;
        if (msg.getStatus().equals(OrgCallStatus.CONNECTED.getCode())) {
            if (msg.getStorageId() != null && msg.getStorageId() > 0L) {
                OrgStorage storage = (OrgStorage)this.storageDao.getById((Serializable)msg.getStorageId(), new String[0]);
                url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
            }
            len = msg.getDuringTime();
            content = CardContentFactory.createTelephoneCard((String)"\u5df2\u63a5\u542c", (String)url, (Integer)len, (Long)msg.getStorageId(), (Long)msg.getId());
        } else {
            content = CardContentFactory.createTelephoneCard((String)"\u672a\u63a5\u542c", (String)"", (Integer)0, null, null);
        }
        content.setAction(ActionUtil.getTelephoneAction((long)consultUserId, (String)msg.getCustomerNumber()));
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson((Object)content));
        pushMsg.setMsgType(MsgType.CARD.getValue());
        return pushMsg;
    }

    @Override
    public MessageSource getConsultType() {
        return MessageSource.TELEPHONE;
    }

    @Override
    public boolean consume(OrgPushCallInfo callInfo) {
        if (callInfo == null) {
            throw new IllegalArgumentException(" call info is illegal");
        }
        if (StringUtils.isBlank((CharSequence)callInfo.getExtention())) {
            log.warn("No Extention.callInfo={}", (Object)callInfo);
            return true;
        }
        MsgUser receiver = this.buildOrgMsgUser(callInfo.getExtention());
        if (receiver == null) {
            return false;
        }
        MsgUser sender = this.builderSender(receiver.getUserId(), callInfo);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip org 400 call msg:{},skip", new Object[]{sender, receiver, callInfo});
            return false;
        }
        ConsultMessage msgContent = this.buildPushMessageContent(callInfo, sender.getUserId());
        log.info("consume org call msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
        Integer cascadeId = null;
        TXCascadeCredential credential = this.credentialDao.getByMobile(callInfo.getConnectedNumber());
        if (credential != null) {
            TXCascadeAccount cascadeAccount = this.cascadeAccountDao.getByCredentialIdAndOrgId(Integer.valueOf(receiver.getUserId().intValue()), credential.getId());
            if (cascadeAccount != null) {
                cascadeId = cascadeAccount.getId();
            }
        } else {
            OrgAccount account = this.orgAccountDao.getAccountByMobile(callInfo.getConnectedNumber());
            if (account != null) {
                cascadeId = 0;
            }
        }
        boolean result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent, cascadeId);
        log.info("push org 400 call msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        return result;
    }

    @Override
    public OrgPushCallInfo transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (OrgPushCallInfo)JacksonUtil.str2Obj((String)body, OrgPushCallInfo.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }

    private void buildComment(TxConsultUser consultUser, OrgPushCallInfo callInfo, boolean isNewStudent) {
        log.info("buildComment--------consultUser={},callInfo={}", (Object)consultUser.toString(), (Object)callInfo);
        TxStudentComment comment = new TxStudentComment();
        if (callInfo.getStatus().intValue() == OrgCallStatus.CONNECTED.getCode()) {
            if (null != callInfo.getStorageId() && callInfo.getStorageId() > 0L) {
                comment.setSoundId(callInfo.getStorageId());
                comment.setDownStatus(Integer.valueOf(DownLoadStatus.FINISH.getCode()));
            } else {
                comment.setSoundId(callInfo.getId());
                comment.setDownStatus(Integer.valueOf(DownLoadStatus.UNFINISH.getCode()));
            }
            comment.setSeconds(Integer.valueOf(callInfo.getDuringTime()));
        }
        comment.setCallStatus(callInfo.getStatus());
        comment.setIsMobile(Integer.valueOf(MobileStatus.IS_400_CALL.getCode()));
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        comment.setConsultUserId(consultUser.getId());
        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setOrigin(this.getConsultType().getValue());
        if (isNewStudent) {
            comment.setContent("\u7cfb\u7edf\u6dfb\u52a0\u4e86\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consultUser.getName()) ? consultUser.getName() : "\u8bbf\u5ba2") + "\n");
        } else {
            comment.setContent("");
        }
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
    }
}

