/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.biz.consult.dto.response.MapResponseDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.base.Preconditions;

/**
 * @title WebResponseBuilder
 * @desc TODO
 * @author cxm
 * @date 2015年12月9日
 * @version 1.0
 */
public class MapResponseBuilder {

    private PageDto pageDto;

    private Map<String, Object> data;

    private UniverseErrorCode errorCode;

    private String errorMsg;

    private MapResponseBuilder() {
    }

    public static MapResponseBuilder create() {
        return new MapResponseBuilder();
    }

    public static MapResponseBuilder create(UniverseErrorCode errorCode) {
        MapResponseBuilder builder = new MapResponseBuilder();
        builder.setErrorCode(errorCode);
        return builder;
    }

    public static MapResponseBuilder create(UniverseErrorCode errorCode, String errorMsg) {
        MapResponseBuilder builder = new MapResponseBuilder();
        builder.setErrorCode(errorCode, errorMsg);
        return builder;
    }

    public static MapResponseBuilder create(Map<String, Object> data, PageDto pageDto) {
        MapResponseBuilder builder = new MapResponseBuilder();
        builder.setData(data);
        builder.setPageDto(pageDto);
        return builder;
    }

    public MapResponseBuilder setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
        return this;
    }

    public MapResponseBuilder setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public MapResponseBuilder addData(String key, Object value) {
        Preconditions.checkArgument(StringUtils.isNoneBlank(key), "data key can not be empty");
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
        return this;
    }

    public MapResponseBuilder setErrorCode(UniverseErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public MapResponseBuilder setErrorCode(UniverseErrorCode errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        return this;
    }

    public MapResponseDto build() {
        MapResponseDto result = null;
        if (this.errorCode != null) {
            result = new MapResponseDto(errorCode);
        } else {
            result = new MapResponseDto();
        }
        result.setData(data);
        result.setPageDto(pageDto);
        if (StringUtils.isNoneBlank(errorMsg)) {
            result.setMsg(errorMsg);
        }
        return result;
    }

}
