/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import com.baijia.tianxiao.biz.consult.dto.request.MergeConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.dto.response.ConsultCallRecordDto;
import com.baijia.tianxiao.biz.consult.dto.response.OrgMsgUser;
import com.baijia.tianxiao.biz.consult.enums.CallUserType;
import com.baijia.tianxiao.biz.consult.enums.ConsulterOutLineType;
import com.baijia.tianxiao.biz.consult.user.dto.ConsultUserInfo;
import com.baijia.tianxiao.biz.consult.user.dto.ConsultUserResponse;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ListConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.CallStudentInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.CampusDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.GetConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.OutLineDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.OwnerDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.SimpleConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.exception.NoAvailableMobileException;
import com.baijia.tianxiao.biz.consult.user.exception.NonConsultUserException;
import com.baijia.tianxiao.biz.consult.user.service.ConsultCustomSourceService;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.callservice.constant.ConsultCallRecordManner;
import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.callservice.po.ConsultCallRecord;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.query.ConsultUserQuery;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.callservice.dto.BidirectionalCallResponse;
import com.baijia.tianxiao.sal.callservice.dto.MakeCallDto;
import com.baijia.tianxiao.sal.callservice.service.CallService;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.SingleChoiceFieldType;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sal.student.enums.ConsultFieldEnum;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @author cxm
 * @version 1.0
 * @title ConsultUserServiceImpl
 * @desc TODO
 * @date 2015年12月8日
 */
@Service
@Slf4j
public class ConsultUserServiceImpl implements ConsultUserService {

    @Resource
    private TxConsultUserDao consultUserDao;

    @Resource
    private OrgStudentService orgStudentService;

    @Resource
    private OrgStudentTagService orgStudentTagService;

    @Resource
    private OrgStudentCommentService orgStudentCommentService;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgCallRecorderDao orgCallRecorderDao;

    @Resource
    private CallService callService;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private UserDao userDao;

    @Resource
    private FansDao fansDao;

    @Autowired
    protected ConsultMessageService consultMessageService;

    @Autowired
    private TxBacklogDao txBacklogDao;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private ConsultUserQuery consultUserQuery;
    @Autowired
    private ConsultCallRecordDao consultCallRecordDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;

    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TxCascadeCredentialService credentialService;
    @Autowired
    private ConsultCustomSourceService consultSourceService;
    @Autowired
    private CustomFieldValueService customFieldValueService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ConsultCustomSourceService consultCustomSourceService;

    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;
    
    @Autowired
    private CustomFieldDao customFieldDao;
    
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;
    
    @Autowired
    private StudentUserService studentUserService;

    @Autowired
    private TxConsultUserDao txConsultUserDao;

    @Autowired
    private ConsulterAPIService consulterAPIService;
    
    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long saveConsultUser(Long orgId, ConsulterRequestDto consulterParam, Boolean keepConsultSource)
        throws BussinessException {
        // 参数检查
        if (StringUtils.isBlank(consulterParam.getMobile())) {
            throw new ParameterException(CommonErrorCode.PARAM_ERROR, "学员手机号不能为空");
        }

        if (StringUtils.isBlank(consulterParam.getName())) {
            throw new ParameterException(CommonErrorCode.PARAM_ERROR, "学员名称不能为空");
        }

        if (consulterParam.getNextRemindTime() != null) {
            if (consulterParam.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
                throw new ParameterException(CommonErrorCode.PARAM_ERROR, "下次提醒时间超过最大范围(2037-1-1)了");
            }
        }

        if (consulterParam.getBirthday() != null && consulterParam.getBirthday() > System.currentTimeMillis()) {
            throw new ParameterException(CommonErrorCode.PARAM_ERROR, "未来的您还未出生吧");
        }

        // 参数处理
        consulterParam.setOrgId(orgId);
        consulterParam.setCampusOrgId(-1);// 校区字段 暂未使用
        consulterParam.setIsConsulter(Flag.TRUE.getInt());// 默认是线索

        // 会出现183-9288-1285这样的手机号，需要将手机格式换一下18392881285
        if (StringUtils.isNoneBlank(consulterParam.getMobile())) {
            String mobile = consulterParam.getMobile();
            mobile = mobile.replaceAll("-", "");
            consulterParam.setMobile(mobile);
        }

        if (StringUtils.isNoneBlank(consulterParam.getParentMobile())) {
            String parentMobile = consulterParam.getParentMobile();
            parentMobile = parentMobile.replaceAll("-", "");
            consulterParam.setParentMobile(parentMobile);
        }

        // 兼容旧版本
        if (consulterParam.getIntensionLevel() > IntentionLevel.LEVEL_3.getValue()) {
            if (consulterParam.getIntensionLevel() == 3) {
                consulterParam.setIntensionLevel(IntentionLevel.LEVEL_2.getValue());
            } else {
                consulterParam.setIntensionLevel(IntentionLevel.LEVEL_3.getValue());
            }
        }


        if (consulterParam.getCascadeId() != null && consulterParam.getCascadeId() > 0) {
            TXCascadeAccount account = txCascadeAccountDao.getByIdAndOrgId(consulterParam.getCascadeId().intValue(), orgId.intValue());
            if (account == null) {
                consulterParam.setCascadeId(0L);
            }
        }

        Boolean isNewConsultUser = true;
        TxConsultUser consultUser = null;
        if (consulterParam.getConsulterId() != null && consulterParam.getConsulterId() > 0) {
            isNewConsultUser = false;
        }

        // 前置检查 检查手机号手否已存在
        if (isNewConsultUser) {
            List<TxConsultUser> targets = this.consultUserDao.lookByMobile(orgId, consulterParam.getMobile());

            log.info("doSaveBefore---------consulter={},targets={}", consulterParam, targets);

            if (!CollectionUtils.isEmpty(targets)) {// 手机号存在
                if (targets.size() > 1) {// 存在多条记录 - 禁止
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "手机号已对应多条记录，操作失败");
                } else {
                    TxConsultUser dbConsultUser = targets.get(0);
                    if (Flag.getBoolean(dbConsultUser.getIsConsulter())) {
                        throw new BussinessException(CommonErrorCode.PARAM_ERROR, "手机号码对应的线索已存在");
                    }

                    if (dbConsultUser.getStudentId() != null && dbConsultUser.getStudentId() > 0) {
                        OrgStudent student = orgStudentDao.getById(dbConsultUser.getStudentId());
                        if (student != null && student.getDelStatus().intValue() == Flag.FALSE.getInt()) {
                            throw new PermissionException("该记录已转为正式学员,不允许在此处操作。");
                        }
                    }
                    consulterParam.setConsulterId(dbConsultUser.getId());
                    isNewConsultUser = false;
                }
            }
        }
        
        if(!isNewConsultUser){
        	consultUser = this.consultUserDao.getById(consulterParam.getConsulterId());
        	if( !consulterParam.getMobile().equals(consultUser.getMobile()) ){
        		List<TxConsultUser> targets = this.consultUserDao.lookByMobile(orgId, consulterParam.getMobile());
                if (CollectionUtils.isNotEmpty(targets)) {
                	throw new PermissionException("操作失败，手机号已存在。");
                }
        	}
        }

        
        if (isNewConsultUser) {
            // 添加新线索
            consultUser = ConsulterDto.convertToConsultUser(consulterParam);
            consultUser.setManually(Flag.TRUE.getInt());
            consultUser.setCascadeId(Flag.NULL.getLong());
            consultUserDao.save(consultUser);

            // 添加跟进记录
            txStudentCommentAPIService.saveByConsultUserManualAdd(consultUser);

            // 领取线索
            if (consulterParam.getCascadeId() != null
                && consulterParam.getCascadeId().intValue() != Flag.NULL.getInt()) {
                consultUser = pull(orgId, consulterParam.getCascadeId(), consultUser.getId(), false);
            }

        } else {
            String oldMobile = consultUser.getMobile();
            String oldName = consultUser.getName();

            // 前置检查
            boolean needManualAddComment = false;
            boolean needPull = false;

            if (!Flag.getBoolean(consultUser.getIsConsulter())) {
                // 说明 本次操作是 咨询转线索
                needManualAddComment = true;
                // 所属人发生变更
                if (consulterParam.getCascadeId() != null
                    && !consultUser.getCascadeId().equals(consulterParam.getCascadeId())) {
                    needPull = true;
                    consultUser.setCascadeId(Flag.NULL.getLong());
                }
            } else {
                // 说明 本次操作是 线索更新

                // 所属人发生变更
                if (!consultUser.getCascadeId().equals(consulterParam.getCascadeId())) {
                    throw new PermissionException("不允许直接修改线索所属人");
                }
            }

            // 处理*号
            if (StringUtils.isNotBlank(consulterParam.getMobile()) && consulterParam.getMobile().contains("*")) {
                consulterParam.setMobile(consultUser.getMobile());
            }
            if (StringUtils.isNotBlank(consulterParam.getParentMobile())
                && consulterParam.getParentMobile().contains("*")) {
                consulterParam.setParentMobile(consultUser.getParentMobile());
            }

            // 兼容
            if (keepConsultSource != null && keepConsultSource) {
                Integer oldSource = consultUser.getConsultSource();
                this.copyFrom(consultUser, consulterParam);
                consultUser.setConsultSource(oldSource);
            } else {
                this.copyFrom(consultUser, consulterParam);
            }

            // 更新线索
            consultUser.setUpdateTime(new Date());
            this.consultUserDao.updateWithDefaultVal(consultUser);

            // 添加跟进记录
            if (needManualAddComment) {// 咨询转线索
                txStudentCommentAPIService.saveByConsultUserManualAdd(consultUser);

            } else {// 修改已有线索
                txStudentCommentAPIService.saveByMobileChange(consultUser, oldMobile, consultUser.getMobile());
                txStudentCommentAPIService.saveByNameChange(consultUser, oldName, consultUser.getName());
            }

            // 领取线索
            if (needPull) {
                consultUser = pull(orgId, consulterParam.getCascadeId(), consultUser.getId(), false);
            }
        }

        // 添加线索今日代办
        this.orgStudentService.updateSysBacklogForConsulter(orgId, consultUser);

        // 保存标签
        setUserTags(orgId, consultUser.getId(), consulterParam.getTags());

        // 更新solr
        updateSolr(consultUser);

        // 公海线索 推送通知
        if (consultUser.getCascadeId().intValue() == Flag.NULL.getInt()) {
            String content = NoticeType.getTips(consulterParam.getName());
            consultMessageService.sendNotice(orgId, -1, NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE,
                ActionUtil.getClueDetailAction(consultUser.getId()), content));
        }

        log.info("success save consulter :{} into db,return id:{}", consulterParam.getName(), consultUser.getId());

        return consultUser.getId();
    }

    /**
     * 属性值拷贝
     *
     * @param user
     * @param dto
     */
    private void copyFrom(TxConsultUser user, ConsulterDto dto) {
        if (consultSourceService.getConsultSourceStr(Long.parseLong(dto.getConsultSource() + "")) == null) {
            throw new PermissionException("线索来源不合法");
        }

        user.setAddress(dto.getAddress());
        user.setBirthday((dto.getBirthday() != null && dto.getBirthday() > 0) ? new Date(dto.getBirthday()) : null);
        user.setConsultSource(dto.getConsultSource());
        user.setConsultStatus(dto.getConsultStatus());
        user.setDegreeClass(dto.getDegreeClass());
        user.setMail(dto.getMail());
        user.setIntensionLevel(dto.getIntensionLevel());
        user.setMobile(dto.getMobile());
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0) {
            user.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            user.setNextRemindTime(null);
        }
        user.setNickName(dto.getNickName());
        user.setParentMobile(dto.getParentMobile());
        user.setParentName(dto.getParentName());
        user.setQq(dto.getQq());
        user.setSchool(dto.getSchool());
        user.setName(dto.getStudentName());
        // user.setWeixin(dto.getWeixin());
        // user.setWeixinNickName(dto.getWeixinNickName());
        // user.setWeixinOpenId(dto.getWeixinOpenId());

        user.setPortrait(dto.getPortrait());
        user.setRelatives(dto.getRelatives());
        if (dto.getSex() != null) {
            user.setSex(dto.getSex());
        }
        user.setLatitude(dto.getLatitude());
        user.setLongitude(dto.getLongitude());
        user.setCampusOrgId(dto.getCampusOrgId());
        // user.setCascadeId(dto.getCascadeId()); 所属人不允许直接修改
        user.setIsConsulter(dto.getIsConsulter());
        user.setAreaId(dto.getAreaId());
    }

    /**
     * 发送卡片消息
     *
     * @param consulterUser
     * @param orgId
     */
    @SuppressWarnings("unused")
    private void sendConsultMessage(TxConsultUser consulterUser, Long orgId) {
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue(), "number");
        ConsultMessage message = new ConsultMessage();
        message.setConsultType(MessageSource.INPUT.getValue());
        message.setMsgType(MsgType.TEXT.getValue());
        message.setContent("提醒时间:" + TianXiaoConstant.DAY_TIME_FORMAT.format(consulterUser.getNextRemindTime()));
        log.info("send to add consulter msg");
        consultMessageService.sendConsultMessage(ConsulterDto.convertToDto(consulterUser),
            new OrgMsgUser(orgId, orgAccount.getNumber().longValue()), message);
    }

    private OrgStudentAddresponseDto saveStudent(TxConsultUser consulterUser, Integer confirm, Long orgId,
        Long cascadeId) {
        log.info("save consulter user:{} into org student", consulterUser);
        StudentInfoDto dto = buildStudentInfoDto(consulterUser, confirm);
        dto.setAddCascadeId(cascadeId == null ? 0 : cascadeId.intValue());
        OrgStudentAddresponseDto result = orgStudentService.addStudent(dto, null, null, orgId);
        return result;
    }

    private void setUserTags(Long orgId, Long consulterId, String tags) {
        if (StringUtils.isNotBlank(tags)) {
            log.debug("save tags :{} into db", tags);
            try {
                orgStudentTagService.delTagsByConsulterId(consulterId, orgId);
                List<TagInfoDto> tagDtos = JacksonUtil.str2List(tags, TagInfoDto.class);
                if (!CollectionUtils.isEmpty(tagDtos)) {
                    orgStudentTagService.addStudentTag(tagDtos, StudentType.CONSULT_USER.getCode(), consulterId, orgId);
                }
            } catch (Exception e) {
                log.error("save tags:{} catch error:{}", tags, e);
            }
        } else {
            // 没有传，说明需要把所有便签给删除
            orgStudentTagService.delTagsByConsulterId(consulterId, orgId);
        }
    }

    private StudentInfoDto buildStudentInfoDto(TxConsultUser user, Integer confirm) {
        StudentInfoDto dto = new StudentInfoDto();
        dto.setAddress(user.getAddress());
        dto.setBirthdayDate(user.getBirthday());
        dto.setDegreeClass(user.getDegreeClass());
        dto.setFatherOccupation(user.getFatherOccupation());
        dto.setMail(user.getMail());
        dto.setMatherOccupation(user.getMatherOccupation());
        dto.setMobile(user.getMobile());
        dto.setName(user.getName());
        dto.setNextRemindTimeDate(user.getNextRemindTime());
        dto.setParentMobile(user.getParentMobile());
        dto.setParentName(user.getParentName());
        dto.setQq(user.getQq());
        dto.setSchool(user.getSchool());
        dto.setStudentId(user.getStudentId());
        dto.setWeixin(user.getWeixinOpenId());
        dto.setConsultUserId(user.getId());
        dto.setStudentNumber(user.getUserNumber());
        dto.setGender(user.getSex());
        // if (user.getManually() != 1 && MessageSource.getNoEditConsultType().contains(user.getConsultSource())) {
        // dto.setSource(1);
        // }
        dto.setSource(user.getConsultSource());

        dto.setConfirm(confirm);

        dto.setGender(user.getSex());
        dto.setBranchId(user.getCampusOrgId().longValue());
        dto.setRelationship(user.getRelatives());
        dto.setAreaId(user.getAreaId());
        if (StringUtils.isNotBlank(user.getLatitude())) {
            dto.setLatitude(Double.parseDouble(user.getLatitude()));
        }
        if (StringUtils.isNotBlank(user.getLongitude())) {
            dto.setLongitude(Double.parseDouble(user.getLongitude()));
        }
        if (StringUtils.isNotBlank(user.getPortrait())) {
            String portrait = user.getPortrait();
            String fid = OrgStorage.parseFid(portrait);
            String sn = OrgStorage.parseSn(portrait);
            Integer mimeType = OrgStorage.parseMimetype(portrait);
            if (StringUtils.isNotBlank(fid) && StringUtils.isNotBlank(sn) && mimeType != null) {
                List<OrgStorage> list = orgStorageDao.list(fid, sn, mimeType);
                if (CollectionUtils.isNotEmpty(list)) {
                    dto.setStorageId(list.get(0).getId().longValue());
                }
            }
        }
        return dto;
    }

    @Override
    public ConsulterResponseDto getConsultUser(Long orgId, Long cascadeId, Long consulterId, Integer showComments)
        throws NonConsultUserException {
        Preconditions.checkNotNull(orgId, "org id can not be null");
        Preconditions.checkNotNull(consulterId, "consult user id can not be null");

        TxConsultUser consultUser = consultUserDao.getById(consulterId);
        if (consultUser == null || !consultUser.getOrgId().equals(orgId)) {
            throw new PermissionException(CrmErrorCode.CONSULTER_INFO_NO_PERMISSON);
        }

        if (consultUser.getDelStatus() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException(CrmErrorCode.CONSULTER_INFO_NO_PERMISSON);
        }

        if (consultUser.getStudentId()!=null && consultUser.getStudentId()>0) {
            throw new PermissionException(CrmErrorCode.CONSULTER_INFO_IS_STUDENT);
        }

        ConsulterResponseDto dto = ConsulterDto.convertToDto(consultUser);

        if (StringUtils.isBlank(dto.getName())) {
            dto.setStudentName(TianXiaoConstant.APPOINTMENT_STUDENT_NAME);
        } else {
            dto.setStudentName(dto.getName());
        }

        if (consultUser.getStudentId() != null && consultUser.getStudentId() > 0) {
            this.setOrigin(consultUser.getStudentId(), dto);
        } else {
            if (consultUser.getConsultSource().intValue() == MessageSource.ONLINE_IM.getValue()) {
                dto.setOrigin(0);
            } else {
                dto.setOrigin(1);
            }
        }

        // 封装查询tags的请求
        OrgTagListResopnseDto tagDto =
            orgStudentTagService.getTags(StudentType.CONSULT_USER.getCode(), consulterId, orgId);
        if (tagDto != null) {
            List<TagInfoDto> tags = tagDto.getTags();
            // if (tags != null && !tags.isEmpty()) {
            // if (tags.size() > 5) {
            // tags = tags.subList(0, 5);
            // }
            // }
            dto.setTags(tags);
        }
        
        if( Flag.getBoolean(showComments) ){
	        OrgCommentsListReponse commentsDto = orgStudentCommentService.getComments(StudentType.CONSULT_USER.getCode(), consulterId, orgId, null);
	        if (commentsDto != null) {
	            dto.setComments(commentsDto.getComments());
	        }
        }

        // 校区
        if (consultUser.getCampusOrgId() != null && consultUser.getCampusOrgId() != Flag.NULL.getInt()) {
            Integer campusOrgId = Integer.parseInt(consultUser.getCampusOrgId() + "");
            OrgAccount orgAccount = orgAccountDao.getAccountById(campusOrgId);
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(campusOrgId);
            CampusDto campusDto = new CampusDto();
            campusDto.setOrgNumber(orgAccount.getNumber());
            campusDto.setShortName(orgInfo.getShortName());
            dto.setCampus(campusDto);
        }

        // 所属人
        if (consultUser.getCascadeId() != null && consultUser.getCascadeId() != Flag.NULL.getInt()) {
//            if (cascadeId > 0 && consultUser.getCascadeId().intValue() != cascadeId.intValue()) {
//                TXCascadeAccount loginer = txCascadeAccountDao.getById(cascadeId);
//                if (CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.STAFF) {
//                    throw new PermissionException(CrmErrorCode.CONSULTER_INFO_NO_PERMISSON);
//                }
//            }

            OwnerDto ownerDto = new OwnerDto();
            if (consultUser.getCascadeId().intValue() == 0) {// 主账号
                OrgSubAccount orgSubAccount = orgSubAccountDao.getByOrgId(orgId.intValue());
                OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
                ownerDto.setName(orgInfo.getShowName());
                ownerDto.setCascadeId(Integer.parseInt(consultUser.getCascadeId() + ""));
                if (orgSubAccount == null) {
                    ownerDto.setUserType(CampusAccountType.MASTER_PRINCIPAL.getCode());
                } else {
                    ownerDto.setUserType(orgSubAccount.getPid().equals(0) ? CampusAccountType.MASTER_PRINCIPAL.getCode()
                        : CampusAccountType.SLAVE_PRINCIPAL.getCode());
                }
            } else {// 子账号
                TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(consultUser.getCascadeId());
                TXCascadeCredential txCascadeCredential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
                ownerDto.setName(txCascadeCredential.getName());
                ownerDto.setCascadeId(Integer.parseInt(consultUser.getCascadeId() + ""));
                ownerDto.setUserType(txCascadeAccount.getAccountType());
            }
            dto.setOwner(ownerDto);
        }

        // 线索状态
        if (consultUser.getIsInvalid().intValue() == Flag.TRUE.getInt()) {
            dto.setConsulterType(ConsulterOutLineType.INVALID.getValue());
        } else {
            if (consultUser.getCascadeId().intValue() == Flag.NULL.getInt()) {
                dto.setConsulterType(ConsulterOutLineType.PUBLISH.getValue());
            } else {
                if (consultUser.getCascadeId().intValue() == cascadeId.intValue()) {
                    dto.setConsulterType(ConsulterOutLineType.MINE.getValue());
                } else {
                    dto.setConsulterType(ConsulterOutLineType.SUBORDINATE.getValue());
                }
            }
        }

        // 机构是否可以与学生微信聊天 手机号隐藏
        this.fillByRule(dto, cascadeId);

        boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (!isShow) {
            dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
        }

        // 设置头像
        consulterAPIService.batchSetConsultAvatarUrl(Arrays.asList(consultUser));
        dto.setPortrait(consultUser.getPortrait());

        // 设置省市区
        if (null != dto.getAreaId() && dto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(dto.getAreaId());
            log.info("区域信息areaMap {}", areaMap);
            dto.setProvince(areaMap.get("province"));
            dto.setCity(areaMap.get("city"));
            dto.setCounty(areaMap.get("county"));
        }
        return dto;
    }

    private void setOrigin(Long studentId, ConsulterResponseDto dto) {
        OrgStudent student = this.orgStudentDao.getById(studentId);
        if (student != null) {
            dto.setOrigin(student.getOrigin());
        }
    }

    /**
     * 机构是否可以与学生微信聊天 手机号隐藏
     *
     * @param dto
     */
    private void fillByRule(ConsulterResponseDto dto, Long cascadeId) {

        // 微信聊天
        Long orgId = dto.getOrgId();
        AuthorizationInfo authorizationInfo = authorizationInfoDao.getByOrgId(orgId.intValue());
        OrgWechatOpenIdRecord record = null;
        if (authorizationInfo == null
            || authorizationInfo.getAuthorizerAppId().equals(WechatProperties.getWechatAppidForFreeVersion())) {
            // 免费版 或 普通版但没绑定公众号
            record = orgWechatOpenIdRecordDao.getBy(WechatProperties.getWechatAppidForFreeVersion(), orgId,
                dto.getConsulterId(), WechatOpenIdEntityType.CONSULT);
        } else {
            // 普通版绑定了公众号
            record = orgWechatOpenIdRecordDao.getBy(authorizationInfo.getAuthorizerAppId(), orgId, dto.getConsulterId(),
                WechatOpenIdEntityType.CONSULT);
        }
        dto.setChat(BizConf.FALSE.intValue());
        if (record != null) {
            Fans fans = fansDao.getByOpenId(record.getOpenId());
            if (fans != null && fans.isSubscribed()) {
                dto.setChat(BizConf.TRUE.intValue());
            }
        }

        // 公共池线索 对员工 手机号加* 不可微信聊天
        if (dto.getConsulterType().intValue() == ConsulterOutLineType.PUBLISH.getValue() && cascadeId != 0) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            if (CampusAccountType.STAFF.getCode() == txCascadeAccount.getAccountType().intValue()) {
                //
                if (StringUtils.isNotBlank(dto.getMobile())) {
                    String fmt = "%s****%s";
                    dto.setMobile(
                        String.format(fmt, dto.getMobile().substring(0, 3), dto.getMobile().substring(7, 11)));
                }

                dto.setChat(BizConf.FALSE.intValue());
            }
        }
        
        
        // 规则判断 
        Integer consulterType = dto.getConsulterType();
        Integer allowToPull = Flag.FALSE.getInt();
        Integer allowToSms = Flag.FALSE.getInt();
        TXCascadeAccount loginer = null;
        if (cascadeId!=null && cascadeId>0){
        	loginer = txCascadeAccountDao.getById(cascadeId);
        }
        
        //线索是否可以领取
        if( consulterType!=null && consulterType.intValue()!= ConsulterOutLineType.PUBLISH.getValue()){
        	allowToPull = Flag.FALSE.getInt();
        }else{
        	allowToPull = Flag.TRUE.getInt();
        	
        	boolean permission = false;
        	if(cascadeId!=null && cascadeId>0){
        		permission = txAccountPermissionService.checkPermission(orgId, cascadeId.intValue(), DeviceType.APP, TXPermissionConst.PERSONAL_CLUES_MANAGEMENT.getpCode());
        	}else{
        		permission = txAccountPermissionService.checkPermission(orgId, null, DeviceType.APP, TXPermissionConst.PERSONAL_CLUES_MANAGEMENT.getpCode());
        	}
    				
			if( !permission ){
				//账号权限判断
				 allowToPull = Flag.FALSE.getInt();
				 
			}else {
				if(loginer!=null && CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.STAFF){
					//规则权限判断
            		TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
                    if(txSaleClueRule.getClueAllot().intValue() != 0) {
                    	allowToPull = Flag.FALSE.getInt();
                    }
				}
			}
        }
        dto.setAllowToPull(allowToPull);
        
        
        //是否可以发短信
        if(consulterType!=null 
        		&& 
         (  consulterType.intValue() == ConsulterOutLineType.PUBLISH.getValue() 
         || consulterType.intValue() == ConsulterOutLineType.INVALID.getValue()) ){
        	
        	allowToSms = Flag.FALSE.getInt();
        }else{
        	allowToSms = Flag.TRUE.getInt();
        	
	        if (loginer!=null
	        		&& 
	        	( CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.DIRECTOR
	        	||CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.STAFF)){
	        	
	        	TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId.intValue());
	        	if(txCommonRule.getStudentMobileRule().intValue() == 1) {
	        		allowToSms = Flag.FALSE.getInt();
	        	}
	        }
    	}
        dto.setAllowToSms(allowToSms);
        
    }

    @Override
    @Transactional(readOnly = true)
    public GetConsulterInfoResponseDto getExistStudentId(Long orgId, Long consulterId, Long userNumber)
        throws NonConsultUserException {
        Preconditions.checkNotNull(orgId, "org id can not be null");
        Preconditions.checkArgument(consulterId != null || userNumber != null, "user number");
        GetConsulterInfoResponseDto result = new GetConsulterInfoResponseDto();
        if (consulterId != null) {
            TxConsultUser consultUser = consultUserDao.getById(consulterId, "orgId", "userId", "mobile", "delStatus",
                "studentId", "isConsulter");
            log.debug("consultUser:{}", consultUser);
            if (consultUser != null && consultUser.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
                if (null != consultUser.getStudentId() && consultUser.getStudentId() > 0) {
                    result.setStudentId(consultUser.getStudentId());
                } else {
                    Long userId = consultUser.getUserId();
                    // 根据userId查询学员studentId
                    if (userId != null && userId > 0) {
                        OrgStudent orgStudent =
                            orgStudentDao.getStudentByUserId(orgId, userId, "id", "userId", "delStatus");
                        log.info("getExistStudentId-----orgStudent={}", orgStudent);
                        if (null != orgStudent) {
                            if (orgStudent.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
                                result.setStudentId(orgStudent.getId());
                                consultUser.setStudentId(orgStudent.getId());
                            }
                        }
                    }
                }
                result.setConsultUserId(consulterId);
                result.setUserRole(getUserRole(consultUser));
            } else {
                throw new NonConsultUserException(consulterId);
            }
        } else if (userNumber != null) {
            User user = userDao.getByNumber(userNumber, "id", "mobile");
            if (user != null) {
                List<TxConsultUser> list = consultUserDao.lookByUserId(orgId, user.getId(), "id", "studentId");
                log.info("getExistStudentId------List<TxConsultUser> list={}", list);
                if (CollectionUtils.isNotEmpty(list)) {
                    TxConsultUser consulter = list.get(0);
                    if (null != consulter.getStudentId() && consulter.getStudentId() > 0) {
                        result.setStudentId(consulter.getStudentId());
                    }
                    result.setConsultUserId(consulter.getId());
                } else {
                    OrgStudent orgStudent = orgStudentDao.getStudent(orgId, user.getId(),
                        DeleteStatus.NORMAL.getValue(), "id", "userId", "delStatus");
                    log.info("getExistStudentId-----orgStudent={}", orgStudent);
                    if (null != orgStudent) {
                        result.setStudentId(orgStudent.getId());
                        result.setUserRole(MsgUserRole.STUDENT.getValue());
                    }
                }
            } else {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "无法查询到平台用户,用户表示:" + userNumber);
            }
        }
        return result;
    }

    public Integer getUserRole(TxConsultUser user) {
        MsgUserRole userType = null;
        if (user.getStudentId() != null && user.getStudentId() > 0) {
            userType = MsgUserRole.STUDENT;
        } else {
            if (user.getUserId() != null && user.getUserId() > 0) {
                OrgStudent orgStudent =
                    orgStudentDao.getStudent(user.getOrgId(), user.getUserId(), DeleteStatus.NORMAL.getValue());
                if (orgStudent != null) {
                    userType = MsgUserRole.STUDENT;
                    user.setStudentId(orgStudent.getId());
                }
            }
        }

        if (userType == null) {
            if (user.getIsConsulter() == 1) {
                userType = MsgUserRole.CLUE;
            } else {
                userType = MsgUserRole.CONSULT;
            }
        }

        return userType.getValue();
    }

    @Override
    @Transactional(readOnly = true)
    public List<SimpleConsulterInfoResponseDto> searchConsulterInfos(Integer type, Long orgId,
        ListConsulterRequestDto request, PageDto pageDto) {
        Preconditions.checkNotNull(orgId, "org id can not be null");
        if (request == null) {
            request = new ListConsulterRequestDto();
        }
        boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());

        // 获取查询结果
        List<TxConsultUser> users = queryResult(type, orgId, request, pageDto);

        // 填充结果信息
        if (CollectionUtils.isNotEmpty(users)) {
            List<SimpleConsulterInfoResponseDto> result = Lists.newArrayList();
            Set<Long> studentIds = new HashSet<>();
            for (TxConsultUser user : users) {
                if (user.getStudentId() != null && user.getStudentId() > 0) {
                    studentIds.add(user.getStudentId());
                }
                result.add(buildSimpleConsultInfo(user));
            }

            if (null == type || (null != type && 1 == type)) {
                Map<Long, OrgStudent> cache = getAndCacheStudents(studentIds);
                for (SimpleConsulterInfoResponseDto dto : result) {
                    Long studentId = dto.getStudentId();
                    if (studentId != null && studentId > 0) {
                        OrgStudent stu = cache.get(studentId);
                        if (stu != null) {
                            dto.setStudentId(stu.getId());
                            if (StringUtils.isBlank(stu.getName())) {
                                if (StringUtils.isNotEmpty(stu.getNickName())) {
                                    dto.setName(stu.getNickName());
                                } else {
                                    dto.setName(MaskUtil.maskMobile(stu.getMobile()));
                                }
                            } else {
                                dto.setStudentName(stu.getName());
                            }
                            // 历史咨询记录手机号码显示花名册用户手机号
                            // String showMobile = stu.getShowMobile();
                            String mobile = stu.getMobile();
                            // dto.setMobile(StringUtils.isNotBlank(showMobile) ? showMobile :
                            // (StringUtils.isNotBlank(mobile) ? mobile : ""));
                            if (!isShow) {
                                dto.setMobile(MaskUtil.maskMobile(mobile));
                            } else {
                                dto.setMobile(mobile);
                            }
                        }
                    }
                }
            }

            return result;
        } else {
            return Collections.emptyList();
        }
    }

    /**
     * 获取查询结果
     */
    @DataAuthority(resourceTypes = { RequestSourceDesc.CONSULT_LIST })
    private List<TxConsultUser> queryResult(Integer type, Long orgId, ListConsulterRequestDto request,
        PageDto pageDto) {
        log.info("ListConsulterRequestDto is : {} ", request);
        Set<Integer> consultSources = Sets.newHashSet();
        if (StringUtils.isNoneBlank(request.getConsultSources())) {
            for (String consultSource : StringUtils.splitByWholeSeparator(request.getConsultSources(), ",")) {
                if (!StringUtils.isNumeric(consultSource)) {
                    log.warn("error consult course :{},ignore condition", consultSource);
                    continue;
                }
                consultSources.add(Integer.parseInt(consultSource));
            }
        } else if (request.getConsultSource() != null) {
            consultSources.add(request.getConsultSource());
        }

        // 控制访问账号的数据权限 ,普通员工只能查看属于自己的线索，主管及以上等同主账号
        Integer txCascadeId = TianxiaoMContext.getTXCascadeId();
        if (RequestSourceDesc.CONSULT_LIST.canAccess("queryResult", this.getClass(),
            new Class<?>[] { Integer.class, Long.class, ListConsulterRequestDto.class, PageDto.class })) {
            txCascadeId = null;
        }
        List<TxConsultUser> users = consultUserDao.search(type, request.getKey(), orgId, txCascadeId,
            request.getIntensionLevel(), consultSources, request.getStartTime(), request.getEndTime(), pageDto);
        log.info("query size is : {} ", users.size());
        return users;
    }

    /**
     * 历史咨询客户列表名字、手机号码显示其对应的花名册用户的showMobile和name，其他一概不管
     *
     * @param studentIds
     * @return
     */
    private Map<Long, OrgStudent> getAndCacheStudents(Set<Long> studentIds) {
        Map<Long, OrgStudent> studentMap = Maps.newHashMap();
        if (studentIds != null && !studentIds.isEmpty()) {
            List<OrgStudent> students =
                orgStudentDao.getByIds(studentIds, "id", "name", "nickName", "mobile", "showMobile");
            if (students != null && !students.isEmpty()) {
                studentMap = CollectorUtil.collectMap(students, new Function<OrgStudent, Long>() {
                    @Override
                    public Long apply(OrgStudent input) {
                        return input.getId();
                    }
                });
            }
        }
        return studentMap;
    }

    private SimpleConsulterInfoResponseDto buildSimpleConsultInfo(TxConsultUser user) {
        SimpleConsulterInfoResponseDto dto = new SimpleConsulterInfoResponseDto();
        if (user.getConsultSource() == MessageSource.MARKING.getValue()) {
            dto.setConsultType(MessageSource.ONLINE_IM);
        } else {
            dto.setConsultType(MessageSource.getByType(user.getConsultSource()));
        }
        dto.setConsultUserId(user.getId());
        dto.setIntensionLevel(user.getIntensionLevel());
        dto.setMobile(user.getMobile());

        dto.setName(
            StringUtils.isNotBlank(user.getName()) ? user.getName() : TianXiaoConstant.APPOINTMENT_STUDENT_NAME);
        dto.setNumber(user.getUserNumber());
        dto.setStudentId(user.getStudentId());
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public CallStudentInfoResponseDto getCallStudentInfoByMobile(Long consulterId, String mobile, Long orgId)
        throws NonConsultUserException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(mobile), "mobile is illegal");
        Preconditions.checkArgument(orgId != null && orgId > 0, "org id is illegal");
        Preconditions.checkArgument(consulterId != null && consulterId > 0, "consulter id is illegal");
        CallStudentInfoResponseDto result = new CallStudentInfoResponseDto();
        result.setMobile(mobile);
        // 如果手机号打码,需要重新查询手机号
        TxConsultUser user = consultUserDao.getById(consulterId, "id", "name", "weixinNickName", "mobile", "orgId");
        if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
            throw new NonConsultUserException(consulterId);
        }
        result.setConsulterId(user.getId());
        mobile = user.getMobile();
        result.setStudentName(user.getName());
        // if (StringUtils.isNoneBlank(user.getName())) {
        // result.setStudentName(user.getName());
        // } else if (StringUtils.isNoneBlank(user.getWeixinNickName())) {
        // result.setStudentName(user.getWeixinNickName());
        // }

        OrgInfo info = orgInfoDao.getOrgInfo(orgId.intValue(), "extension");
        Preconditions.checkArgument(info != null && StringUtils.isNoneBlank(info.getExtension()), "机构分机号未分配");

        OrgCommentsListReponse commentResp = null;

        Map<String, Object> callInfo = orgCallRecorderDao.queryCallCountAndTime(mobile, info.getExtension());
        log.debug("query call info by mobile:{},orgId:{},result:{}", mobile, orgId, callInfo);
        if (callInfo != null) {
            String cntKey = "CNT_id";
            Number count = (Number) callInfo.get(cntKey);
            if (count != null) {
                result.setCallCount(count.intValue());
            }
            result.setLastCallTime((Date) callInfo.get("MAX_TIME"));
        }

        OrgStudent orgStudent = null;
        // OrgStudent orgStudent =
        // orgStudentDao.getStudentByMobileAndOrgId(orgId, mobile, "name", "nickName", "mobile", "id");
        if (user.getStudentId() != null && user.getStudentId() > 0) {
            orgStudent = this.orgStudentDao.getById(user.getStudentId());
            if (orgStudent == null || orgStudent.getOrgId() != orgId.longValue()
                && orgStudent.getDelStatus() == DeleteStatus.DELETED.getValue()) {
                orgStudent = null;
            }
        }
        if (orgStudent != null) {
            result.setStudentId(orgStudent.getId());
            if (StringUtils.isNoneBlank(orgStudent.getName())) {
                result.setStudentName(orgStudent.getName());
            } else if (StringUtils.isNoneBlank(orgStudent.getNickName())) {
                result.setStudentName(orgStudent.getNickName());
            }
            commentResp = orgStudentCommentService.getComments(StudentType.ORG_STUDENTS.getCode(), orgStudent.getId(),
                orgId, Flag.FALSE.getInt());
            if (commentResp != null && CollectionUtils.isNotEmpty(commentResp.getComments())) {
                log.debug("student comment info:{}", commentResp);
                result.setComments(commentResp.getComments());
            }
        } else {
            commentResp = orgStudentCommentService.getComments(StudentType.CONSULT_USER.getCode(), consulterId, orgId,
                Flag.FALSE.getInt());
            if (commentResp != null && CollectionUtils.isNotEmpty(commentResp.getComments())) {
                log.debug("consulter comment info:{}", commentResp);
                result.setComments(commentResp.getComments());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public BidirectionalCallResponse callStudent(Long consulterId, Long studentId, String subscriberTel,
        CallUserType userType, Long orgId) throws NonConsultUserException {
        Preconditions.checkArgument((consulterId != null && consulterId > 0) || (studentId != null && studentId > 0),
            "consulter user id or student id at least have one value");
        Preconditions.checkArgument(userType != null, "user type is illegal");
        Preconditions.checkArgument(orgId != null && orgId > 0, "org id is illegal.");
        MakeCallDto makeCall = new MakeCallDto();
        if (consulterId != null) {
            TxConsultUser user = consultUserDao.getById(consulterId, "userId", "id", "orgId", "mobile", "parentMobile");

            if (user == null || !user.getOrgId().equals(orgId)) {
                throw new NonConsultUserException(consulterId);
            }
            if (StringUtils.isBlank(user.getMobile()) && user.getUserId() == 0) {
                log.warn("no cdb user exist and no consulter mobile:{}", user);
                throw new NoAvailableMobileException(consulterId);
            }
            if (user.getUserId() != null && user.getUserId() > 0) {
                makeCall.setCalledUserId(user.getUserId());
            } else {
                makeCall.setCalledUserId(CallService.ANONYMOUS_USER_ID);
            }
            if (userType.equals(CallUserType.Parent)) {
                if (StringUtils.isBlank(user.getParentMobile())) {
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "未设置咨询客户家长联系电话");
                }
                makeCall.setCalledUserMobile(user.getParentMobile());
            } else {
                if (StringUtils.isNoneBlank(user.getMobile())) {
                    makeCall.setCalledUserMobile(user.getMobile());
                }
            }
        } else {
            OrgStudent orgStudent = orgStudentDao.getById(studentId, "userId", "orgId", "mobile", "parentMobile");
            if (orgStudent == null || !orgStudent.getOrgId().equals(orgId)) {
                throw new NonConsultUserException(studentId);
            }
            makeCall.setCalledUserId(orgStudent.getUserId());
            if (userType.equals(CallUserType.Parent)) {
                if (StringUtils.isBlank(orgStudent.getParentMobile())) {
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "未设置花名册学生家长联系电话");
                }
                makeCall.setCalledUserMobile(orgStudent.getParentMobile());
            } else {
                String mobile = orgStudent.getStudentMobile();
                if (StringUtils.isNoneBlank(mobile)) {
                    makeCall.setCalledUserMobile(mobile);
                }
            }
        }

        makeCall.setSubscriberUserId(orgId);

        if (StringUtils.isNoneBlank(subscriberTel)) {
            makeCall.setSubscriberMobile(subscriberTel);
        }
        log.info("submit call student request:{}", makeCall);
        BidirectionalCallResponse res = callService.bidirectionalCall(makeCall);
        return res;
        // return callService.callParty(makeCall);
    }

    @Override
    @Transactional(readOnly = true)
    public ConsulterDto getConsultUserBaseInfo(Long orgId, Long consulterId) throws NonConsultUserException {
        Preconditions.checkNotNull(orgId, "org id can not be null");
        Preconditions.checkNotNull(consulterId, "consult user id can not be null");

        TxConsultUser consultUser = consultUserDao.getById(consulterId);
        if (consultUser == null || !consultUser.getOrgId().equals(orgId)) {
            throw new NonConsultUserException(consulterId);
        }
        ConsulterDto dto = ConsulterDto.convertToDto(consultUser);
        if (StringUtils.isBlank(dto.getName())) {
            dto.setStudentName(TianXiaoConstant.APPOINTMENT_STUDENT_NAME);
        } else {
            dto.setStudentName(dto.getName());
        }
        boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (!isShow) {
            dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
        }

        return dto;
    }

    /**
     * 咨询合并步骤： 1.校验源咨询用户、目标咨询用户是否是机构的咨询学院 2.将source、dest两个咨询用户的标签进行合并
     * 3.将source咨询用户的跟进记录update为dest用户，更新consult_user_id、user_id、update_time,合并完成后插入一条合并记录 4.将source咨询用户置为删除状态
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void mergeCosulter(MergeConsulterRequestDto param, Long orgId, Long cascadeId) throws BussinessException {
        if (cascadeId == null) {
            cascadeId = 0L;
        }
        Preconditions.checkNotNull(orgId, "org id can not be null");
        paramValidator(param);
        TxConsultUser sourceConsultUser = this.consultUserDao.getOrgConsultUser(orgId, param.getSourceConsulter());
        log.info("ConsultUserServiceImpl:mergeCosulter-------sourceConsultUser={}", sourceConsultUser);
        if (sourceConsultUser == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "原始咨询用户不存在");
        }
        TxConsultUser destConsultUser = this.consultUserDao.getOrgConsultUser(orgId, param.getDestConsulter());
        log.info("ConsultUserServiceImpl:mergeCosulter-------destConsultUser={}", destConsultUser);
        if (destConsultUser == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "目标咨询用户不存在");
        }

        // 如果是正式学员，set userId到destConsultUser
        OrgStudent student = getAndSetStudentId(param, orgId, destConsultUser);
        log.info("ConsultUserServiceImpl:mergeCosulter-------student={}", student);
        // 合并标签
        this.orgStudentTagService.mergeTags(sourceConsultUser, destConsultUser, orgId);
        // 合并跟进记录
        this.orgStudentCommentService.mergeCommentRecord(sourceConsultUser, destConsultUser, orgId);
        // 删除源咨询用户
        this.deleteSourceConsult(sourceConsultUser);
        // 更新咨询来源
        updateConsultSouce(sourceConsultUser, destConsultUser);
        // 合并学员基本信息
        mergeStudentInfo(param, sourceConsultUser, destConsultUser, orgId, student, cascadeId);

        updateSolr(sourceConsultUser);
        updateSolr(destConsultUser);
    }

    /**
     * 获取正式学员信息
     *
     * @param param
     * @param orgId
     * @return
     */
    private OrgStudent getAndSetStudentId(MergeConsulterRequestDto param, Long orgId, TxConsultUser destConsultUser)
        throws BussinessException {
        OrgStudent student = null;
        Long studentId = param.getStudentId();
        if (param.getStudentId() != null && param.getStudentId() > 0) {
            if (studentId != null && studentId != 0) {
                student = this.orgStudentDao.getById(studentId);
                if (student != null && student.getOrgId().longValue() == orgId.longValue()) {
                    destConsultUser.setUserId(student.getUserId());
                    destConsultUser.setStudentId(student.getId());
                } else {
                    throw new BussinessException(CommonErrorCode.UNKNOW, "学生不存在");
                }
            } else {
                throw new BussinessException(CommonErrorCode.PERMISSION_DENY, "无权合并该学生");
            }
        }
        return student;
    }

    /**
     * 合并花名册用户信息
     */
    private void mergeStudentInfo(MergeConsulterRequestDto param, TxConsultUser sourceConsultUser,
        TxConsultUser destConsultUser, Long orgId, OrgStudent student, Long cascadeId) {
        if (param.getStudentId() != null && param.getStudentId() > 0) {// 正式学员
            getAndSetStudent(param, orgId, destConsultUser.getUserId(), student, sourceConsultUser,
                destConsultUser.getConsultSource());
        }

        // 合并 系统字段
        updateDestConsultUser(destConsultUser, param, sourceConsultUser, cascadeId);
        // 合并 自定义字段
        updateDestConsultUserCustomFiled(orgId, destConsultUser, sourceConsultUser);
    }

    /**
     * 更新正式学员信息
     *
     * @param param
     * @param orgId
     * @param userId
     */
    private void getAndSetStudent(MergeConsulterRequestDto param, Long orgId, Long userId, OrgStudent student,
        TxConsultUser sourceConsultUser, Integer consultSource) {
        if (student != null) {
            log.debug("from student:{}", student);
            student.setAddress(mergeProperties(sourceConsultUser.getAddress(), student.getAddress()));
            student.setDegreeClass(mergeProperties(sourceConsultUser.getDegreeClass(), student.getDegreeClass()));
            student.setFatherOccupation(
                mergeProperties(sourceConsultUser.getFatherOccupation(), student.getFatherOccupation()));
            student.setMatherOccupation(
                mergeProperties(sourceConsultUser.getMatherOccupation(), student.getMatherOccupation()));
            student.setName(mergeProperties(sourceConsultUser.getName(), student.getName()));
            student
                .setNextRemindTime(mergeProperties(sourceConsultUser.getNextRemindTime(), student.getNextRemindTime()));

            student.setParentName(mergeProperties(sourceConsultUser.getParentName(), student.getParentName()));
            student.setParentMobile(mergeProperties(sourceConsultUser.getParentMobile(), student.getParentMobile()));
            student.setBirthday(mergeProperties(sourceConsultUser.getBirthday(), student.getBirthday()));

            student.setSchool(mergeProperties(sourceConsultUser.getSchool(), student.getSchool()));
            student.setShowMobile(mergeProperties(sourceConsultUser.getMobile(), student.getMobile()));

            if ((student.getGender() == null || student.getGender() < 0) && sourceConsultUser.getSex() != null) {
                student.setGender(sourceConsultUser.getSex());
            }
            student.setQq(mergeProperties(sourceConsultUser.getQq(), student.getQq()));

            if ((student.getRelationship() == null || student.getRelationship() < 0)
                && sourceConsultUser.getRelatives() != null) {
                student.setRelationship(sourceConsultUser.getRelatives());
            }

            student.setMail(mergeProperties(sourceConsultUser.getMail(), student.getMail()));

            if ((student.getBranchId() == null || student.getBranchId() == 0)
                && (sourceConsultUser.getCampusOrgId() != null && sourceConsultUser.getCampusOrgId() > 0)) {
                student.setBranchId(sourceConsultUser.getCampusOrgId().longValue());
            }

            if ((student.getAvatar() == null || student.getAvatar() == 0)
                && StringUtils.isNotBlank(sourceConsultUser.getPortrait())) {
                if (StringUtils.isNotBlank(sourceConsultUser.getPortrait())) {
                    String portrait = sourceConsultUser.getPortrait();
                    String fid = OrgStorage.parseFid(portrait);
                    String sn = OrgStorage.parseSn(portrait);
                    Integer mimeType = OrgStorage.parseMimetype(portrait);
                    if (StringUtils.isNotBlank(fid) && StringUtils.isNotBlank(sn) && mimeType != null) {
                        List<OrgStorage> list = orgStorageDao.list(fid, sn, mimeType);
                        if (CollectionUtils.isNotEmpty(list)) {
                            student.setAvatar(list.get(0).getId().longValue());
                        }
                    }
                }
            }

            if (StringUtils.isBlank(student.getWeixin())
                && StringUtils.isNotBlank(sourceConsultUser.getWeixinOpenId())) {
                student.setWeixin(sourceConsultUser.getWeixinOpenId());
            }
            log.debug("to student:{}", student);
            // if (StringUtils.isNotBlank(sourceConsultUser.getStudentName())) {
            // student.setPinyin(HanZiPinYinUtils.getLowerCasePinYin(param.getStudentName()));
            // } else {
            // student.setPinyin("");
            // }

            // 学生来源：0=跟谁学，1=非跟谁学
            if (consultSource != null) {
                student.setSource(consultSource);
                if (consultSource == MessageSource.ONLINE_IM.getValue()) {
                    student.setOrigin(0);
                } else {
                    student.setOrigin(1);
                }
            } else {
                student.setOrigin(1);
            }
            this.orgStudentDao.update(student, false);
        }
    }

    /**
     * 获取咨询来源
     *
     * @param sourceConsultUser
     * @param destConsultUser
     * @return
     */
    private void updateConsultSouce(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser) {
        if (sourceConsultUser.getCreateTime().before(destConsultUser.getCreateTime())) {
            destConsultUser.setConsultSource(sourceConsultUser.getConsultSource());
        }
    }

    /**
     * 更新信息
     *
     * @param destConsultUser
     * @param param
     */
    void updateDestConsultUser(TxConsultUser destConsultUser, MergeConsulterRequestDto param,
        TxConsultUser sourceConsultUser, Long cascadeId) {
        // 合并系统字段
        destConsultUser.setAddress(mergeProperties(sourceConsultUser.getAddress(), destConsultUser.getAddress()));
        if (destConsultUser.getBirthday() == null && sourceConsultUser.getBirthday() != null) {
            destConsultUser.setBirthday(sourceConsultUser.getBirthday());
        }

        if ((destConsultUser.getConsultStatus() == null || destConsultUser.getConsultStatus() < 0)
            && sourceConsultUser.getConsultStatus() != null) {
            destConsultUser.setConsultStatus(sourceConsultUser.getConsultStatus());
        }

        destConsultUser
            .setDegreeClass(mergeProperties(sourceConsultUser.getDegreeClass(), destConsultUser.getDegreeClass()));
        destConsultUser.setFatherOccupation(
            mergeProperties(sourceConsultUser.getFatherOccupation(), destConsultUser.getFatherOccupation()));

        if ((destConsultUser.getIntensionLevel() == null || destConsultUser.getIntensionLevel() < 0)
            && sourceConsultUser.getSex() != null) {
            destConsultUser.setIntensionLevel(sourceConsultUser.getIntensionLevel());
        }

        destConsultUser.setMatherOccupation(
            mergeProperties(sourceConsultUser.getMatherOccupation(), destConsultUser.getMatherOccupation()));
        destConsultUser.setMobile(mergeProperties(sourceConsultUser.getMobile(), destConsultUser.getMobile()));
        destConsultUser.setNextRemindTime(
            mergeProperties(sourceConsultUser.getNextRemindTime(), destConsultUser.getNextRemindTime()));
        destConsultUser
            .setParentName(mergeProperties(sourceConsultUser.getParentName(), destConsultUser.getParentName()));
        destConsultUser
            .setParentMobile(mergeProperties(sourceConsultUser.getParentMobile(), destConsultUser.getParentMobile()));
        destConsultUser.setSchool(mergeProperties(sourceConsultUser.getSchool(), destConsultUser.getSchool()));
        destConsultUser.setName(mergeProperties(sourceConsultUser.getName(), destConsultUser.getName()));

        destConsultUser.setWeixin(mergeProperties(sourceConsultUser.getWeixin(), destConsultUser.getWeixin()));
        destConsultUser
            .setWeixinAppId(mergeProperties(sourceConsultUser.getWeixinAppId(), destConsultUser.getWeixinAppId()));
        destConsultUser.setWeixinNickName(
            mergeProperties(sourceConsultUser.getWeixinNickName(), destConsultUser.getWeixinNickName()));
        destConsultUser
            .setWeixinOpenId(mergeProperties(sourceConsultUser.getWeixinOpenId(), destConsultUser.getWeixinOpenId()));

        destConsultUser.setPortrait(mergeProperties(sourceConsultUser.getPortrait(), destConsultUser.getPortrait()));
        if ((destConsultUser.getSex() == null || destConsultUser.getSex() < 0) && sourceConsultUser.getSex() != null) {
            destConsultUser.setSex(sourceConsultUser.getSex());
        }

        destConsultUser.setIsInvalid(Flag.FALSE.getInt());
        destConsultUser.setReasonForInvalid("");
        destConsultUser.setFinallyHoldTime(
            mergeProperties(sourceConsultUser.getFinallyHoldTime(), destConsultUser.getFinallyHoldTime()));
        destConsultUser
            .setLastPullTime(mergeProperties(sourceConsultUser.getLastPullTime(), destConsultUser.getLastPullTime()));
        destConsultUser
            .setLastPushTime(mergeProperties(sourceConsultUser.getLastPushTime(), destConsultUser.getLastPushTime()));
        destConsultUser.setLastInvalidTime(
            mergeProperties(sourceConsultUser.getLastInvalidTime(), destConsultUser.getLastInvalidTime()));
        destConsultUser.setLastBrowseTime(
            mergeProperties(sourceConsultUser.getLastBrowseTime(), destConsultUser.getLastBrowseTime()));
        destConsultUser.setLastRemindTime(
            mergeProperties(sourceConsultUser.getLastRemindTime(), destConsultUser.getLastRemindTime()));

        destConsultUser.setQq(mergeProperties(sourceConsultUser.getQq(), destConsultUser.getQq()));

        if ((destConsultUser.getRelatives() == null || destConsultUser.getRelatives() < 0)
            && sourceConsultUser.getRelatives() != null) {
            destConsultUser.setRelatives(sourceConsultUser.getRelatives());
        }
        if ((destConsultUser.getConsultSource() == null || destConsultUser.getConsultSource() < 0)
            && sourceConsultUser.getConsultSource() != null) {
            destConsultUser.setConsultSource(sourceConsultUser.getConsultSource());
        }

        destConsultUser.setMail(mergeProperties(sourceConsultUser.getMail(), destConsultUser.getMail()));

        destConsultUser.setCascadeId(cascadeId);

        this.consultUserDao.update(destConsultUser);
    }

    void updateDestConsultUserCustomFiled(Long orgId, TxConsultUser destConsultUser, TxConsultUser sourceConsultUser) {

        Date now = new Date();
        Map<Long, CustomFieldValue> destMap =
            customFieldValueService.mapFieldValues(orgId, false, destConsultUser.getId());
        Map<Long, CustomFieldValue> sourceMap =
            customFieldValueService.mapFieldValues(orgId, false, sourceConsultUser.getId());

        if (MapUtils.isNotEmpty(sourceMap)) {
            List<CustomFieldValue> listAdd = new ArrayList<CustomFieldValue>();

            CustomFieldValue destValue = null;
            CustomFieldValue sourceValue = null;
            for (Long fieldId : sourceMap.keySet()) {
                destValue = destMap.get(fieldId.longValue());
                sourceValue = sourceMap.get(fieldId.longValue());

                if (destValue == null && sourceValue != null) {
                    destValue = new CustomFieldValue();
                    destValue.setId(null);
                    destValue.setCreateTime(now);
                    destValue.setUpdateTime(now);
                    destValue.setConsultUserId(destConsultUser.getId());
                    destValue.setStudentId(destConsultUser.getStudentId());
                    destValue.setOrgId(orgId);
                    destValue.setFieldId(fieldId);
                    destValue.setFieldType(sourceValue.getFieldType());
                    destValue.setValue(sourceValue.getValue());

                    listAdd.add(destValue);
                }
            }

            if (CollectionUtils.isNotEmpty(listAdd)) {
                customFieldValueDao.saveAll(listAdd);
            }
        }
    }

    /**
     * 1.A与B合并, A与B的属性只有一方存在，合并后的数据取该方的数据 2.A与B的属性都不存在，合并后的数据为空 3.A与B的属性都存在，则按上图将冲突属性排列在卡片中显示
     *
     * @param source
     * @param dest
     * @return
     */
    private String mergeProperties(String source, String dest) {
        if (StringUtils.isNotBlank(source) && StringUtils.isNotBlank(dest)) {
            return dest;
        } else if (StringUtils.isNotBlank(source) && StringUtils.isBlank(dest)) {
            return source;
        } else if (StringUtils.isBlank(source) && StringUtils.isNotBlank(dest)) {
            return dest;
        }
        return "";
    }

    // private Integer mergeProperties(Integer source, Integer dest) {
    // boolean sourceFlag = false;
    // boolean destFlag = false;
    // if (source != null && source > 0)
    // sourceFlag = true;
    // if (dest != null && dest > 0)
    // destFlag = true;
    //
    // if (sourceFlag && destFlag) {
    // return dest;
    // } else if (sourceFlag && !destFlag) {
    // return source;
    // } else if (!sourceFlag && destFlag) {
    // return dest;
    // }
    // return null;
    // }

    private Date mergeProperties(Date source, Date dest) {
        if (source != null && dest != null) {
            return source.getTime() > dest.getTime() ? source : dest;
        }
        if (dest != null) {
            return dest;
        }
        if (source != null) {
            return source;
        }
        return null;
    }

    /**
     * 将源咨询用户置为删除状态
     *
     * @param sourceConsultUser
     */
    void deleteSourceConsult(TxConsultUser sourceConsultUser) {
        sourceConsultUser.setDelStatus(DeleteStatus.DELETED.getValue());
        sourceConsultUser.setUpdateTime(new Date());
        this.delSysBacklog(sourceConsultUser.getOrgId(), sourceConsultUser);
        log.info("deleteSourceConsult.sourceConsultUser:{}", sourceConsultUser);
        this.consultUserDao.update(sourceConsultUser, new String[] { "delStatus", "updateTime" });
    }

    /**
     * 参数校验
     *
     * @param param
     */
    private void paramValidator(MergeConsulterRequestDto param) {
        Preconditions.checkNotNull(param.getSourceConsulter(), "source consulter id can not be null");
        Preconditions.checkNotNull(param.getDestConsulter(), "destination consulter id can not be null");
    }

    @Override
    @Transactional(readOnly = true)
    public List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        List<TxConsultUser> consulters = this.consultUserDao.searchHasMobileConsulter(pageDto, format, value);
        log.debug("consulters:{}", consulters);
        return consulters;
    }

    /**
     * 微信用户浅注册咨询用户
     */
    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long regConsulter(Long orgId, String openId, String showName, Long studentId) {
        List<TxConsultUser> consulters = null;
        if (StringUtils.isNotBlank(openId) && !openId.equals("0")) {
            consulters = this.consultUserDao.lookByParams(orgId, openId);
        } else {
            openId = "";
        }

        OrgStudent student = null;
        if (studentId != null && studentId > 0) {
            student = this.orgStudentDao.getById(studentId);
            if (student == null || student.getOrgId() != orgId.longValue()) {
                student = null;
            }
        }

        if (student == null) {
            List<OrgStudent> orgStudents = orgStudentDao.getStudentByOpenIdAndOrgId(orgId, openId);
            if (orgStudents != null && orgStudents.size() > 0) {
                student = orgStudents.get(0);
                studentId = student.getId();
            }
        }

        if (consulters != null && !consulters.isEmpty()) {
            TxConsultUser consulter = consulters.get(0);
            if (student != null && !studentId.equals(consulter.getStudentId())) {
                consulter.setStudentId(studentId);
                consulter.setUpdateTime(new Date());
                consulter.setMobile(student.getMobile());
                consulter.setUserId(student.getUserId());
                this.consultUserDao.update(consulter, "studentId", "updateTime", "userId");
            }
            return consulters.get(0).getId();
        } else {
            return saveAndReturnId(orgId, openId, showName, student);
        }
    }

    /**
     * 浅注册
     *
     * @param openId
     * @param showName
     * @return
     */
    private Long saveAndReturnId(Long orgId, String openId, String showName, OrgStudent student) {
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setWeixinOpenId(openId);

        if (StringUtils.isNotBlank(openId) && !"0".equals(openId)) {
            Fans fans = fansDao.getByOpenId(openId);
            if (fans != null) {
                consultUser.setWeixinAppId(fans.getAuthorizerAppId());
            }
        }
        consultUser.setName(showName);
        consultUser.setNickName(showName);
        consultUser.setOrgId(orgId);
        if (student != null) {
            consultUser.setStudentId(student.getId());
            consultUser.setUserId(student.getUserId());

            consultUser.setMobile(student.getMobile());
            consultUser.setNextRemindTime(student.getNextRemindTime());
            consultUser.setConsultSource(student.getSource());
        } else {
            // consultUser.setNextRemindTime(DateUtil.getOffSetDate(5));
            consultUser.setConsultSource(MessageSource.WECHAT.getValue());
        }

        this.consultUserDao.save(consultUser);
        if (consultUser.getNextRemindTime() != null) {
            this.addSysBacklog(orgId, consultUser.getId());
        }
        return consultUser.getId();
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void delConsulter(Long consulterId, Long orgId) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        Preconditions.checkArgument(consulterId != null && consulterId > 0, "consulterId is illegal");

        TxConsultUser consultUser = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
        log.info("delConsulter---------consulterId={},orgId={},consultUser={}", consulterId, orgId, consultUser);

        if (null != consultUser) {
            this.delSysBacklog(orgId, consultUser);

            consultUser.setDelStatus(DeleteStatus.DELETED.getValue());
            consultUser.setUpdateTime(new Date());
            this.consultUserDao.update(consultUser, "delStatus", "updateTime");
        } else {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "咨询用户不存在或已被删除");
        }

        updateSolr(consultUser);
    }

    /**
     * 创建咨询用户(IM、微信咨询、来电咨询、预约留单、来访咨询)的同时创建系统待办事项
     *
     * @param orgId 机构id
     * @param consulterId 咨询用户id
     * @return
     */
    @Override
    @Transactional(rollbackFor = { Exception.class })
    public void addSysBacklog(Long orgId, Long consulterId) {
        if (null != consulterId && consulterId > 0) {
            TxConsultUser consulter = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
            if (null != consulter && consulter.getNextRemindTime() != null) {
                log.info("addSysBacklog-------orgId={},consulter={}", orgId, consulter);
                List<TxBacklog> list =
                    this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulter.getId(), orgId, false, "id");
                if (CollectionUtils.isEmpty(list)) {
                    TxBacklog txBacklog = new TxBacklog();
                    if (null != consulter.getStudentId() && consulter.getStudentId() > 0) {
                        txBacklog.setStudentId(consulter.getStudentId());
                    }
                    txBacklog.setOrgId(orgId);
                    txBacklog.setConsultUserId(consulter.getId());
                    txBacklog.setContent("跟进客户: " + (StringUtils.isNotBlank(consulter.getName()) ? consulter.getName()
                        : TianXiaoConstant.APPOINTMENT_STUDENT_NAME));
                    txBacklog.setIsSys(BizConf.TRUE.intValue());
                    txBacklog.setCascadeId(consulter.getCascadeId().intValue());
                    txBacklog.setEndTime(consulter.getNextRemindTime());
                    txBacklog.setRemindTime(consulter.getNextRemindTime());
                    txBacklog.setCreateTime(new Date());
                    txBacklog.setUpdateTime(new Date());
                    txBacklogDao.save(txBacklog, false);
                    log.info("addSysBacklog:save--------txBacklog={}", txBacklog);
                }
            }
        }
    }

    /**
     * 编辑咨询学员的同时更新系统待办事项: 若仅是咨询学员且下次跟进时间改变时才更新 若仅是咨询学员且只有已过期系统待办事项，则需新建
     *
     * @param orgId 机构id
     * @return
     */
    @Override
    @Transactional(rollbackFor = { Exception.class })
    public void updateSysBacklog(Long orgId, Long consulterId) {
        if (null != consulterId && consulterId > 0) {
            TxConsultUser consulter = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
            log.info("updateSysBacklog------orgId={},consulter={}", orgId, consulter);
            if (null != consulter && (null == consulter.getStudentId() || consulter.getStudentId() <= 0)) {
                // 仅是咨询学员
                List<TxBacklog> list =
                    this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulter.getId(), orgId, false);
                if (CollectionUtils.isNotEmpty(list)) {
                    TxBacklog txBacklog = list.get(0);
                    if (consulter.getNextRemindTime().getTime() != txBacklog.getEndTime().getTime()) {
                        txBacklog.setEndTime(consulter.getNextRemindTime());
                        txBacklog.setRemindTime(consulter.getNextRemindTime());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, "endTime", "remindTime", "updateTime");
                    }
                } else {
                    // 系统待办消息已过期或已删除，需新建
                    this.addSysBacklog(orgId, consulter.getId());
                }
            }
        }
    }

    /**
     * 删除系统待办事项: 若同时还是正式学员，则重置consultUserId为0; 若仅是咨询学员，则直接删除
     *
     * @param orgId 机构id
     * @param consultUser 咨询学员
     * @return
     */
    private void delSysBacklog(Long orgId, TxConsultUser consultUser) {
        log.info("delSysBacklog-------orgId={}, consultUser={}", orgId, consultUser);
        List<TxBacklog> list = null;
        if (null != consultUser.getStudentId() && consultUser.getStudentId() > 0) {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(consultUser.getStudentId(), consultUser.getOrgId(),
                null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog
                        && txBacklog.getConsultUserId().longValue() == consultUser.getId().longValue()) {
                        txBacklog.setConsultUserId(0l);
                        txBacklog.setUpdateTime(new Date());
                        txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        } else {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consultUser.getId(), consultUser.getOrgId(), null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog) {
                        txBacklog.setConsultUserId(0l);
                        txBacklog.setDelStatus(DeleteStatus.DELETED.getValue());
                        txBacklog.setUpdateTime(new Date());
                        txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void assign(Long orgId, Long cascadeId, Long consulterId) {
        // TODO 权限判断
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);
        log.info("consult-assign id= ={},txconsultuser={}", consulterId, txConsultUser);
        // 数据操作权限 判断
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException(CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (!Flag.getBoolean(txConsultUser.getIsConsulter())) {
            throw new PermissionException("线索已转为学员或已失效，禁止操作。");
        }
        if (!txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException("线索机构 id不匹配");
        }

        // 数据状态 判断
        if (txConsultUser.getCascadeId().intValue() > 0 && !txConsultUser.getCascadeId().equals(cascadeId)) {// 线索微信已被它人领取
            throw new PermissionException(CrmErrorCode.CONSULTER_PULL_BY_OTHER);
        }

        // 规则判断
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
        log.debug("txSaleClueRule={}", txSaleClueRule);

        if (txSaleClueRule.getClueAllot().intValue() == 2) {
            throw new BussinessException(CrmErrorCode.CONSULTER_ASSIGN_FAIL_BY_SETTING_CLUE_ALLOT);
        }

        Date now = new Date();
        // 规则控制
        txConsultUser.setFinallyHoldTime(DateUtil.getDiffDateTime(now, txSaleClueRule.getMaxClueDelay()));
        txConsultUser.setCascadeId(cascadeId);
        txConsultUser.setLastPullTime(now);
        txConsultUser.setUpdateTime(now);
        consultUserDao.update(txConsultUser);

        // 添加 操作记录-领取线索
        TxConsulterOperationLog txlog =
            new TxConsulterOperationLog(consulterId, cascadeId, cascadeId, ConsulterOperation.ASSIGN);
        txConsulterOperationLogDao.save(txlog);

        // 添加跟进记录
        txStudentCommentAPIService.saveByConsultUserAssign(txConsultUser, getAccountName(orgId, cascadeId));
        updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public TxConsultUser pull(Long orgId, Long cascadeId, Long consulterId, boolean checkRule) {
        // TODO 权限判断
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);
        log.info("consult-pull id= ={},txconsultuser={}", consulterId, txConsultUser);

        // 数据操作权限 判断
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException(CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (!Flag.getBoolean(txConsultUser.getIsConsulter())) {
            throw new PermissionException("线索已转为学员或已失效，禁止操作。");
        }
        if (!txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException("线索机构 id不匹配");
        }

        // 数据状态 判断
        if (txConsultUser.getCascadeId().intValue() != Flag.NULL.getInt()
            && !txConsultUser.getCascadeId().equals(cascadeId)) {
        	// 线索微信已被它人领取
            throw new PermissionException(CrmErrorCode.CONSULTER_PULL_BY_OTHER);
        }

        // 规则判断
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
        log.debug("txSaleClueRule={}", txSaleClueRule);
        if (checkRule) {
            Integer holdNum = consultUserDao.countConsulter(orgId, cascadeId);
            TXCascadeAccount loginer = txCascadeAccountDao.getById(cascadeId);
            if (cascadeId!=null && cascadeId>0 
            	&& CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.STAFF
            	&& txSaleClueRule.getClueAllot().intValue() != 0) {
                throw new BussinessException(CrmErrorCode.CONSULTER_PUSH_FAIL_BY_SETTING_CLUE_ALLOT);
            }
            if (holdNum + 1 > txSaleClueRule.getMaxClueCount()) {
                String msg = "线索数已达上限(最多%s条), 无法领取";
                msg = String.format(msg, txSaleClueRule.getMaxClueCount());
                throw new BussinessException(CrmErrorCode.CONSULTER_PULL_FAIL_BY_SETTING_MAX_CLUE_COUNT, msg);
            }
        }

        Date now = new Date();
        // 规则控制
        txConsultUser.setFinallyHoldTime(DateUtil.getDiffDateTime(now, txSaleClueRule.getMaxClueDelay()));
        txConsultUser.setCascadeId(cascadeId);
        txConsultUser.setLastPullTime(now);
        txConsultUser.setLastRemindTime(now);
        txConsultUser.setUpdateTime(now);
        consultUserDao.update(txConsultUser);
        // 添加 操作记录-领取线索
        TxConsulterOperationLog colog = new TxConsulterOperationLog(consulterId, cascadeId, cascadeId, ConsulterOperation.PULL);
        txConsulterOperationLogDao.save(colog);

        // 添加跟进记录
        txStudentCommentAPIService.saveByConsultUserPull(txConsultUser, getAccountName(orgId, cascadeId));

        // 更新solr
        updateSolr(txConsultUser);

        return txConsultUser;
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void push(Long orgId, Long cascadeId, Long consulterId) {
        // TODO 权限判断
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);

        // 数据操作权限 判断
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException(CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (txConsultUser.getIsConsulter().intValue() != Flag.TRUE.getInt()
            || !txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException();
        }
        // 数据状态 判断
        if (txConsultUser.getCascadeId().intValue() == Flag.NULL.getInt()) {// 线索未被领取
            throw new PermissionException();
        }

        // 规则判断
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
        if (txSaleClueRule.getReturnClue().intValue() == Flag.TRUE.getInt()) {
            throw new BussinessException(CrmErrorCode.CONSULTER_PUSH_FAIL_BY_SETTING_RETURN_CLUE);
        }

        Date now = new Date();
        txConsultUser.setCascadeId(Flag.NULL.getLong());
        txConsultUser.setLastPushTime(now);
        txConsultUser.setUpdateTime(now);
        consultUserDao.update(txConsultUser);

        // 公海线索 推送通知
        String content = NoticeType.getTips(txConsultUser.getName());
        consultMessageService.sendNotice(txConsultUser.getOrgId(), -1, NoticeMsgContent.createNoticeContent(
            NoticeType.PUBLIC_CLUE, ActionUtil.getClueDetailAction(txConsultUser.getId()), content));

        // 添加 操作记录-手动释放线索
        TxConsulterOperationLog log =
            new TxConsulterOperationLog(consulterId, cascadeId, Flag.NULL.getLong(), ConsulterOperation.PUSH_MANUAL);
        txConsulterOperationLogDao.save(log);

        // 添加跟进记录
        txStudentCommentAPIService.saveByConsultUserPush(txConsultUser, getAccountName(orgId, cascadeId));

        // 更新solr
        updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void passto(Long orgId, Long cascadeIdFrom, Long cascadeIdTo, Long consulterId) {
        // TODO 权限判断
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);

        // 数据操作权限 判断
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException(CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (txConsultUser.getIsConsulter().intValue() != Flag.TRUE.getInt()
            || !txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException();
        }

        if (cascadeIdTo.intValue() == 0) {
            if (orgId.intValue() != txConsultUser.getOrgId().intValue()) {
                throw new PermissionException();
            }
        } else {
            TXCascadeAccount cascadeTo = txCascadeAccountDao.getById(cascadeIdTo);
            if (cascadeTo == null || !cascadeTo.getOrgId().equals(orgId.intValue())) {
                throw new PermissionException();
            }
        }

        // 规则判断
        TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());

        Date now = new Date();
        // 规则控制
        txConsultUser.setFinallyHoldTime(DateUtil.getDiffDateTime(now, txSaleClueRule.getMaxClueDelay()));
        txConsultUser.setCascadeId(cascadeIdTo);
        txConsultUser.setLastPullTime(now);
        txConsultUser.setLastRemindTime(now);
        txConsultUser.setUpdateTime(now);
        consultUserDao.update(txConsultUser);

        // 添加 操作记录-转交线索
        TxConsulterOperationLog operationLog =
            new TxConsulterOperationLog(consulterId, cascadeIdFrom, cascadeIdTo, ConsulterOperation.PASSTO);
        txConsulterOperationLogDao.save(operationLog);

        // 添加跟进记录
        txStudentCommentAPIService.saveByConsultUserPassTo(txConsultUser, getAccountName(orgId, cascadeIdFrom),
            getAccountName(orgId, cascadeIdTo));

        // 发送通知
        this.log.info("[Notice] Pass to notice");
        Map<String, Object> param = new HashMap<>();
        param.put("clue_id", txConsultUser.getId());
        consultMessageService.sendNotice(orgId, txConsultUser.getCascadeId().intValue(),
            NoticeMsgContent.createNoticeContent(NoticeType.RECEIVE_CLUE,
                ActionUtil.getAction(ActionUtil.ACTION_TO_CRM_CLUE_DETAIL, param)));

        updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long convertToStudent(Long orgId, Long cascadeId, Long consulterId, Integer confirm) {
        log.info("--------orgId:{}, cascadeId:{}, confirm:{}, consulterId:{}", orgId, cascadeId, consulterId, confirm);
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);
        if (txConsultUser.getStudentId() != null && txConsultUser.getStudentId() > 0) {
            throw new PermissionException("该线索已对应正式学员记录");
        }
        if (txConsultUser.getIsConsulter() < 0) {
            throw new PermissionException("指定对象不是线索");
        }
        if (StringUtils.isBlank(txConsultUser.getMobile())) {
            throw new ParameterException("线索的手机号为空,不可转成学员");
        }
        if (StringUtils.isBlank(txConsultUser.getName())) {
            throw new ParameterException("线索的名称为空,不可转成学员");
        }

        Long studentId = null;
        OrgStudentAddresponseDto orgStudentAddresponseDto = this.saveStudent(txConsultUser, confirm, orgId, cascadeId);
        if (orgStudentAddresponseDto != null && orgStudentAddresponseDto.getStudentId() > 0) {
            studentId = orgStudentAddresponseDto.getStudentId();
            OrgStudent student = this.orgStudentDao.getById(studentId);
            if (student != null && student.getOrgId() == orgId.longValue()
                && student.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
                if (student.getUserId() != null && student.getUserId() > 0) {
                    User user = this.userDao.getById(student.getUserId());
                    txConsultUser.setUserId(user.getId());
                    txConsultUser.setUserNumber(user.getNumber());
                }
            }
            txConsultUser.setStudentId(studentId);
            consultUserDao.update(txConsultUser, "studentId");
            customFieldValueService.updateStudentId(orgId, txConsultUser.getId(), studentId);
            

            //处理今日待办
            txBacklogDao.consultConvertToStu(consulterId, studentId);
        }
        

        updateSolr(txConsultUser);

        return studentId;
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void changeStatus(Long orgId, Long cascadeId, Long consulterId, Integer status, String reason) {
        Date now = new Date();

        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);

        if (status.intValue() == Flag.FALSE.getInt()) {// 置为有效
            Long ownerCascadeId = cascadeId;
            // 规则判断
            TXSaleClueRule txSaleClueRule = txSaleClueRuleService.getByOrgId(orgId.intValue());
            if (txSaleClueRule.getClueTransValid() == 0) {// 转入私海
                txConsultUser = pull(orgId, ownerCascadeId, consulterId, true);
            } else {// 转入公海
                txConsultUser.setCascadeId(Flag.NULL.getLong());
            }

            // 修改线索状态 为 有效
            txConsultUser.setIsInvalid(status);
            txConsultUser.setReasonForInvalid("");
            txConsultUser.setUpdateTime(now);
            consultUserDao.update(txConsultUser);

            String content = NoticeType.getTips(txConsultUser.getName());
            consultMessageService.sendNotice(orgId, -1, NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE,
                ActionUtil.getClueDetailAction(txConsultUser.getId()), content));

            // 添加跟进记录
            txStudentCommentAPIService.saveByConsultUserChangeStatus(txConsultUser, getAccountName(orgId, cascadeId),
                reason);
        } else {// 置为无效
            if (StringUtils.isBlank(reason)) {
                throw new ParameterException("请填写标记无效原因。");
            }

            if (txConsultUser.getCascadeId().intValue() != Flag.NULL.getInt()) {
                // 添加 操作记录-释放线索
                TxConsulterOperationLog log = new TxConsulterOperationLog(consulterId, cascadeId, Flag.NULL.getLong(),
                    ConsulterOperation.PUSH_AUTO);
                txConsulterOperationLogDao.save(log);
            }

            // 修改线索状态 为 无效
            txConsultUser.setIsInvalid(status);
            txConsultUser.setReasonForInvalid(reason);
            txConsultUser.setCascadeId(Flag.NULL.getLong());// 置为无效 线索回归公海
            txConsultUser.setLastPushTime(now);
            txConsultUser.setUpdateTime(now);
            txConsultUser.setLastInvalidTime(now);
            consultUserDao.update(txConsultUser);

            // 添加跟进记录
            txStudentCommentAPIService.saveByConsultUserChangeStatus(txConsultUser, getAccountName(orgId, cascadeId),
                reason);
        }
        updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void changeSource(Long orgId, Long cascadeId, Long consulterId, Integer source) {
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);
        txConsultUser.setConsultSource(source);
        txConsultUser.setUpdateTime(new Date());
        consultUserDao.update(txConsultUser);
    }

    
    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void changeConsultStatus(Long orgId, Long cascadeId, Long consulterId, Integer consultStatus) {
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);
        txConsultUser.setConsultStatus(consultStatus);
        txConsultUser.setUpdateTime(new Date());
        consultUserDao.update(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void changeNextRemindTime(Long orgId, Long cascadeId, Long consulterId, Long nextRemindTime) {
        boolean isValidate = DateUtil.validateTimestamp(nextRemindTime);
        if (!isValidate) {
            throw new ParameterException(CommonErrorCode.PARAM_ERROR, "下次提醒时间超过最大范围(2038-1-1)了");
        }
        TxConsultUser txConsultUser = consultUserDao.getById(consulterId);
        txConsultUser.setUpdateTime(new Date());
        if (nextRemindTime != null && nextRemindTime > 0) {
            txConsultUser.setNextRemindTime(new Date(nextRemindTime));
        } else {
            // 这里用户如果清空nextRemindTime，app端传null，需要
            txConsultUser.setNextRemindTime(null);
        }
        this.consultUserDao.updateWithDefaultVal(txConsultUser);
        // 更新今日代办
        this.orgStudentService.updateSysBacklogForConsulter(orgId, txConsultUser);
    }

    @Override
    public List<OutLineDto> getOutLine(Long orgId, Long cascadeId) {
        List<OutLineDto> list = new ArrayList<OutLineDto>();

        // 查询 账号所属角色
        CampusAccountType accountType = null;
        if (cascadeId == 0) {
            // 主区、分区 校长逻辑一直 这里统一用分区校长表示
            accountType = CampusAccountType.SLAVE_PRINCIPAL;
        } else {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            accountType = CampusAccountType.getTypeByCode(txCascadeAccount.getAccountType());
        }

        // 角色 数据权限
        Collection<ConsulterOutLineType> typeList = getConsulterOutLineMap(cascadeId, accountType).values();

        if (!CollectionUtils.isEmpty(typeList)) {
            OutLineDto dto = null;
            Set<Integer> cascadeIds = null;
            ConsulterListQueryParam param = null;
            for (ConsulterOutLineType type : typeList) {
                if (type == ConsulterOutLineType.ALL) {
                    continue;
                }
                dto = new OutLineDto();

                param = new ConsulterListQueryParam();
                param.setConsulterType(type.getValue());
                param.setOrgId(orgId);
                cascadeIds = listCascadeIdsByOutLineType(orgId, cascadeId, type, accountType);
                fillParamByOutLineType(type, param);
                int count = 0;
                try {
                    count = consultUserQuery.countConsulter(cascadeIds, param);
                } catch (Exception e) {
                    log.error("[GetOutLine] {}", e);
                    log.info("error to get the data with solr server and will replace with db ,requestParam is : {} ",
                        orgId + ":" + cascadeId);
                    count = this.consultUserDao.countOutLine(cascadeIds, orgId, param.getConsulterType(),
                        param.getIsConsulter(), param.getIsInvalid());
                }

                dto.setName(type.getLabel());
                dto.setType(type.getValue());
                dto.setCount(count);
                list.add(dto);
            }
        }

        return list;
    }

    @Override
    public List<ConsulterListDto> listConsulter(Long orgId, Long cascadeId, ConsulterListQueryParam param,
        PageDto pageDto) {
        // 来自线索合并页面的 查询请求 需单独处理
        if (param.getFromMerge() != null && param.getFromMerge().intValue() == Flag.TRUE.getInt()) {
            List<OutLineDto> outLine = getOutLine(orgId, cascadeId);
            
            //默认只能看到 自己的线索
            param.setConsulterType(ConsulterOutLineType.MINE.getValue());
            
            for(OutLineDto dto : outLine){
            	if(dto.getType().intValue() == ConsulterOutLineType.SUBORDINATE.getValue()){
            		param.setConsulterType(ConsulterOutLineType.SUBORDINATE.getValue());
            	}
            }
        }

        // 查询 账号所属角色
        CampusAccountType accountType = null;
        if (cascadeId == 0) {
            // 主区、分区 校长逻辑一直 这里统一用分区校长表示
            accountType = CampusAccountType.SLAVE_PRINCIPAL;
        } else {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            accountType = CampusAccountType.getTypeByCode(txCascadeAccount.getAccountType());
        }

        Collection<ConsulterOutLineType> typeList = getConsulterOutLineMap(cascadeId, accountType).values();
        ConsulterOutLineType outLineType = ConsulterOutLineType.getEnum(param.getConsulterType());

        // 数据访问权限判断
        if (param.getConsulterType().intValue() != ConsulterOutLineType.ALL.getValue()
            && !typeList.contains(ConsulterOutLineType.getEnum(param.getConsulterType()))) {
            log.info(" has no permission for resource with accountType: {} , orgId {} , cascadeId : {} ", accountType, orgId, cascadeId);
            // throw new PermissionException();
            return Collections.emptyList();
        }

        Set<Integer> cascadeIds = null;
        Set<Integer> cascadeIdsByOutLine = listCascadeIdsByOutLineType(orgId, cascadeId, outLineType, accountType);
        if (StringUtils.isNotBlank(param.getCascadeIds())) {// 按所属人搜索
            String[] cascadeIdArray = param.getCascadeIds().split(ConsulterListQueryParam.CASCADEIDS_SPERATOR);
            cascadeIds = new HashSet<Integer>();
            Integer cid = null;
            for (String cascadeIdStr : cascadeIdArray) {
                cid = Integer.parseInt(cascadeIdStr);
                if (!cascadeIdsByOutLine.contains(cid)) {
                    throw new ParameterException("您指定的账号不在可查询范围内。");
                }
                cascadeIds.add(cid);
            }
        } else {
            cascadeIds = cascadeIdsByOutLine;
        }

        fillParamByOutLineType(outLineType, param);
        param.setOrgId(orgId);
        
        if(StringUtils.isNotBlank(param.getKeyFieldName())&&param.getKeyFieldName().startsWith("customField")){
            
            String idStr = param.getKeyFieldName().replace("customField", "");
            Long fieldId = Long.parseLong(idStr);
            CustomField field = this.customFieldDao.getCustomFieldById(orgId, fieldId);
            String queryValue = "";
            if(field!=null){
                
                if(field.getType()==1){
                    if(StringUtils.isNotBlank(param.getKeyword())){
                        queryValue = idStr+"#*"+param.getKeyword()+"*";
                    }
                }else if(field.getType()==4){
                    queryValue = idStr+"#"+param.getKeyword()+"*";
                }else if(field.getType()==2 ||field.getType()==3){
                    List<TXCustomOption> customOptionList = txCustomOptionDao.getTXCustomOptionList(fieldId);
                    if (customOptionList != null && customOptionList.size() > 0) {
                        Long optionId = null;
                        for (TXCustomOption customOption : customOptionList) {
                            if(StringUtils.equals(customOption.getLabel(),param.getKeyword())){
                                optionId = customOption.getId();
                                break;
                            }
                        }
                        if(optionId!=null&&optionId>0L){
                            queryValue = idStr+"#"+optionId;
                        }
                    }
                }
                
            }
            //自定义属性查询不匹配直接返回空集合
            if(StringUtils.isNotBlank(queryValue)){
                param.setKeyFieldName("customSearchValue");
                param.setKeyword(queryValue);
            }else{
                return Lists.newArrayList();
            }
           
        }
        
        log.info("call queryConsulter cascadeIds:{}, param:{}, pageDto:{}", cascadeIds, param, pageDto);
        List<ConsulterListDto> list = null;
        if (param.needFilter()) {
            log.info("query with solr");
            list = consultUserQuery.queryConsulter(cascadeIds, param, pageDto);
        } else {
            log.info("query with db");
            List<TxConsultUser> txConsultUsers = this.consultUserDao.queryConsulters(cascadeIds, param.getOrgId(), param.getConsulterType(), param.getIsConsulter(), param.getIsInvalid(), pageDto);
            list = buildConsultUserDto(txConsultUsers, param.getConsulterType());
        }

        boolean isShowMobile = true;
        // 公共池线索 对员工 手机号加*
        if (outLineType == ConsulterOutLineType.PUBLISH && cascadeId > 0) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            if (CampusAccountType.STAFF.getCode() == txCascadeAccount.getAccountType().intValue()) {
                isShowMobile = false;
            }
        }
        if (isShowMobile) {
            isShowMobile = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        }

        List<Long> ids = new ArrayList<Long>();
        List<TxConsultUser> consultUsers = new ArrayList<>();
        for (ConsulterListDto dto : list) {
            if (param.getConsulterType().intValue() != ConsulterOutLineType.ALL.getValue()) {
                dto.setConsulterType(param.getConsulterType());
            } else {

                if (dto.getIsInvalid().intValue() == Flag.TRUE.getInt()) {
                    dto.setConsulterType(ConsulterOutLineType.INVALID.getValue());

                } else if (dto.getCascadeId().intValue() == Flag.NULL.getInt()) {
                    dto.setConsulterType(ConsulterOutLineType.PUBLISH.getValue());

                } else if (dto.getCascadeId().intValue() == cascadeId) {
                    dto.setConsulterType(ConsulterOutLineType.MINE.getValue());

                } else {
                    dto.setConsulterType(ConsulterOutLineType.SUBORDINATE.getValue());
                }
            }
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            }

            TxConsultUser consultUser = new TxConsultUser();
            consultUser.setId(dto.getId());
            consultUser.setPortrait(dto.getPortrait());
            consultUser.setStudentId(dto.getStudentId());
            consultUser.setWeixinOpenId(dto.getWenxinOpenId());
            consultUsers.add(consultUser);
        }

        if (CollectionUtils.isNotEmpty(consultUsers)) {
            consulterAPIService.batchSetConsultAvatarUrl(consultUsers);
            Map<Long,TxConsultUser> consultUserMap = CollectionHelper.toIdMap(consultUsers);

            for (ConsulterListDto dto : list) {
                if (consultUserMap.get(dto.getId()) != null) {
                    dto.setPortrait(consultUserMap.get(dto.getId()).getPortrait());
                }
            }
        }
        if (GenericsUtils.isNullOrEmpty(list)) {
            return Collections.emptyList();
        }
        return list;
    }

    private static final Long ONE_DAY_TIME = 86400000L;

    /**
     * @param txConsultUsers
     * @return
     */
    private List<ConsulterListDto> buildConsultUserDto(List<TxConsultUser> txConsultUsers, Integer consulterType) {

        if (GenericsUtils.isNullOrEmpty(txConsultUsers)) {
            return GenericsUtils.emptyList();
        }
        List<ConsulterListDto> dtos = Lists.newArrayList();
        Date now = new Date();
        for (TxConsultUser txConsulter : txConsultUsers) {
            ConsulterListDto dto = new ConsulterListDto();
            dto.setName(txConsulter.getName());
            dto.setMobile(txConsulter.getMobile());
            dto.setPortrait(txConsulter.getPortrait());
            dto.setId(txConsulter.getId());
            dto.setStudentId(txConsulter.getStudentId());
            dto.setWenxinOpenId(txConsulter.getWeixinOpenId());
            Date finallyHoldTime = txConsulter.getFinallyHoldTime();
            Integer lessDayNum = 0;
            if (finallyHoldTime != null && finallyHoldTime.after(now)) {
                if (DateUtil.getStartOfDayAccurateToMillSeconde(finallyHoldTime)
                    .equals(DateUtil.getStartOfDayAccurateToMillSeconde(now))) {
                    lessDayNum = 1;
                } else {
                    lessDayNum = (int) ((DateUtil.getStartOfDayAccurateToMillSeconde(finallyHoldTime).getTime()
                        - DateUtil.getStartOfDayAccurateToMillSeconde(now).getTime()) / ONE_DAY_TIME);
                }
                if (lessDayNum == 0) {
                    lessDayNum = 1;
                }
            }
            log.info("lessDayNum is : {} for finallyHoldTime : {} ", lessDayNum, finallyHoldTime);
            dto.setTimeRemaining(lessDayNum);
            String inital = txConsulter.getPinyin();
            if (GenericsUtils.notNullAndEmpty(inital)) {
                inital = inital.substring(0, 1).toUpperCase();
                if (inital.equals("~")) {
                    inital = "#";
                }
            } else {
                inital = "#";
            }
            dto.setInitial(inital);
            dto.setIsInvalid(txConsulter.getIsInvalid());
            dto.setCascadeId(txConsulter.getCascadeId() == null ? null : txConsulter.getCascadeId().intValue());
            dto.setConsulterType(consulterType);
            dto.setBirthday(txConsulter.getBirthday());
            dto.setConsultSource(txConsulter.getConsultSource());
            dto.setConsultStatus(txConsulter.getConsultStatus());
            dto.setDegreeClass(txConsulter.getDegreeClass());
            dto.setIntensionLevel(txConsulter.getIntensionLevel());
            dto.setMail(txConsulter.getMail());
            dto.setQq(txConsulter.getQq());
            dto.setAddress(txConsulter.getAddress());
            dto.setRelatives(txConsulter.getRelatives());
            dto.setSchool(txConsulter.getSchool());
            dto.setSex(txConsulter.getSex());
            dto.setParentName(txConsulter.getParentName());
            dto.setParentMobile(txConsulter.getParentMobile());
            dto.setNextRemindTime(txConsulter.getNextRemindTime());
            dtos.add(dto);
        }
        return dtos;
    }

    public Set<Integer> listCascadeIdsByOutLineType(Long orgId, Long cascadeId, ConsulterOutLineType type,
        CampusAccountType accountType) {
        Set<Integer> cascadeIds = new HashSet<Integer>();
        boolean publish = false; // 公海的线索
        boolean director = false;// 主管的线索
        boolean staff = false;// 员工的线索
        boolean self = false;// 自己的线索
        boolean principal = false;// 校长的线索

        switch (type) {
            case ALL:
                publish = true;
                self = true;
                if (CampusAccountType.SLAVE_PRINCIPAL == accountType
                    || CampusAccountType.MASTER_PRINCIPAL == accountType) {// 校长
                    director = true;
                    staff = true;
                } else if (CampusAccountType.DIRECTOR == accountType) {// 主管
                    principal = true;// 需求变更 20161014
                    director = true;// 需求变更 20161014
                    staff = true;
                }

                break;

            case MINE:
                self = true;
                break;

            case PUBLISH:
                publish = true;
                break;

            case NOT_FOLLOW_UP:
                self = true;
                break;

            case SUBORDINATE:
                principal = true;
                director = true;
                staff = true;

                // self = true;
                //
                // if (CampusAccountType.SLAVE_PRINCIPAL == accountType
                // || CampusAccountType.MASTER_PRINCIPAL == accountType) {// 校长
                // director = true;
                // staff = true;
                // } else if (CampusAccountType.DIRECTOR == accountType) {// 主管
                // staff = true;
                // }
                break;

            case INVALID:
                publish = true;
                break;

            default:
                break;
        }

        if (publish) {
            cascadeIds.add(Flag.NULL.getInt());
        }

        if (director) {
            cascadeIds.addAll(
                txCascadeAccountDao.listIdByAccountType(orgId.intValue(), CampusAccountType.DIRECTOR.getCode()));
        }

        if (staff) {
            cascadeIds
                .addAll(txCascadeAccountDao.listIdByAccountType(orgId.intValue(), CampusAccountType.STAFF.getCode()));
        }

        if (self) {
            cascadeIds.add(cascadeId.intValue());
        }

        if (principal) {
            cascadeIds.add(0);
        }

        return cascadeIds;
    }

    public void fillParamByOutLineType(ConsulterOutLineType type, ConsulterListQueryParam param) {
        switch (type) {
            case MINE:
                break;
            case PUBLISH:
                break;
            case NOT_FOLLOW_UP:
                param.setUnRemindDayNum(ConsulterOutLineType.getDayNumForNotFollowUp());
                break;
            case SUBORDINATE:
                break;
            case INVALID:
                param.setIsInvalid(Flag.TRUE.getInt());
                break;
            default:
                break;
        }
    }

    public Map<Integer, ConsulterOutLineType> getConsulterOutLineMap(Long cascadeId, CampusAccountType accountType) {
        Map<Integer, ConsulterOutLineType> typeMap = new HashMap<Integer, ConsulterOutLineType>();
        Set<ConsulterOutLineType> typeList = new HashSet<ConsulterOutLineType>();

        // 角色权限
        if (CampusAccountType.SLAVE_PRINCIPAL == accountType || CampusAccountType.MASTER_PRINCIPAL == accountType) {// 主账号
            // 校长
            typeList.add(ConsulterOutLineType.MINE);
            typeList.add(ConsulterOutLineType.PUBLISH);
            typeList.add(ConsulterOutLineType.SUBORDINATE);
            typeList.add(ConsulterOutLineType.INVALID);
        } else {
            if (CampusAccountType.DIRECTOR == accountType) {
                // 主管
                typeList.add(ConsulterOutLineType.MINE);
                typeList.add(ConsulterOutLineType.PUBLISH);
                typeList.add(ConsulterOutLineType.INVALID);
                // 账号权限配置判断
                if (txAccountPermissionService.hasPermission(cascadeId, ApplicationType.APP,
                    TXPermissionConst.SEE_ALL_CLUES)) {
                    typeList.add(ConsulterOutLineType.SUBORDINATE);
                }
            } else if (CampusAccountType.STAFF == accountType) {
                // 员工
                typeList.add(ConsulterOutLineType.MINE);
                typeList.add(ConsulterOutLineType.PUBLISH);
                typeList.add(ConsulterOutLineType.INVALID);
            }
        }
        for (ConsulterOutLineType type : typeList) {
            typeMap.put(type.getValue(), type);
        }

        return typeMap;
    }

    public void addSysConsulterCom1ment(Long orgId, Long consulterId, String content) {
        TxStudentComment po = new TxStudentComment();
        po.setOrgId(orgId);
        po.setConsultUserId(consulterId);
        po.setIsSystem(Flag.TRUE.getInt());
        po.setContent(content);
        txStudentCommentDao.save(po);
    }

    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "未知";
        if (cascadeId > 0) {// 子账号
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            TXCascadeCredential credential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
            shortName = credential.getName();
        } else {// 主账号
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    @Override
    public List<ConsultCallRecordDto> listConsultCallRecord(Long orgId, Long cascadeId, Long studentId,
        Long consulterId) {
        List<ConsultCallRecordDto> dtoList = new ArrayList<ConsultCallRecordDto>();
        List<ConsultCallRecord> list = consultCallRecordDao.listBy(orgId, studentId, consulterId);

        if (!CollectionUtils.isEmpty(list)) {
            ConsultCallRecordDto dto = null;
            for (ConsultCallRecord record : list) {
                dto = new ConsultCallRecordDto();
                dto.setCallStatus(record.getCallStatus());
                dto.setCreateTime(record.getCreateTime().getTime());
                dto.setId(record.getId());
                dto.setSeconds(record.getDuringTime());

                if (record.getIsCallByOrg().intValue() == Flag.TRUE.getInt()) {
                    dto.setCallManner(ConsultCallRecordManner.CALL.getCode());
                } else {
                    dto.setCallManner(ConsultCallRecordManner.ANSWER.getCode());
                }

                if (record.getStorageId() != null && record.getStorageId() > 0) {
                    dto.setSoundId(record.getStorageId());
                    OrgStorage orgStorage = orgStorageDao.getById(record.getStorageId());
                    dto.setSoundUrl(StorageUtil.constructUrl(orgStorage));
                }

                dtoList.add(dto);
            }
        }

        return dtoList;
    }

    @Override
    public TxConsultUser getConsultUserByStudetnId(Long orgId, Long studentId) {
        List<TxConsultUser> userList = consultUserDao.lookByStudentId(orgId, studentId);
        if (!CollectionUtils.isEmpty(userList)) {
            TxConsultUser user = userList.get(0);
            boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
            if (!isShow) {
                user.setMobile(MaskUtil.maskMobile(user.getMobile()));
                user.setParentMobile(MaskUtil.maskMobile(user.getParentMobile()));
            }
            return user;
        }
        return null;
    }

    @Override
    public TxConsultUser getConsultUser(Long consulterId) {
        return consultUserDao.getById(consulterId);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public boolean changeLastBrowseTime(Long consulterId, Date time) {
        TxConsultUser consultUser = consultUserDao.getById(consulterId);
        if (consultUser == null) {
            return false;
        }
        if (time == null) {
            time = new Date();
        }
        consultUser.setLastBrowseTime(time);
        consultUser.setUpdateTime(time);
        consultUserDao.update(consultUser);
        return true;
    }

    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    @Override
    public int release() {

        int rows = 0;
        Date now = new Date();
        List<Long> consulterIds = null;
        String lock = "consulter.release.lock";
        RedisConnection connection = redisTemplate.getConnectionFactory().getConnection();

        try {
            connection.select(WechatProperties.getRedisDB());
            if (connection.setNX(lock.getBytes(), (now.getTime() + "").getBytes())) {
                // 加锁
                connection.expire(lock.getBytes(), 60 * 4);// 锁的有效期 4分钟

                consulterIds = consultUserDao.listConsulterUserIdsNeedToRelease(now);
                log.info("consulter - Release - consulterIds:{}, size:{},time:{}", consulterIds, consulterIds.size(),
                    now.getTime());

                if (CollectionUtils.isNotEmpty(consulterIds)) {
                    // 释放线索
                    rows = consultUserDao.release(consulterIds, now);

                    List<TxConsultUser> userList = consultUserDao.getByIds(consulterIds, "id","orgId", "name");
                    // 公海线索 推送通知
                    for (TxConsultUser consultUser : userList) {
                        String content = NoticeType.getTips(consultUser.getName());
                        consultMessageService.sendNotice(consultUser.getOrgId(), -1,
                            NoticeMsgContent.createNoticeContent(NoticeType.PUBLIC_CLUE,
                                ActionUtil.getClueDetailAction(consultUser.getId()), content));
                    }

                    // 添加跟进记录
                    txStudentCommentAPIService.batchSaveByRelease(consulterIds);

                    // 添加释放记录
                    List<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
                    TxConsulterOperationLog log;
                    for (int i = 0; i > consulterIds.size(); i++) {
                        log = new TxConsulterOperationLog(consulterIds.get(i), Flag.NULL.getLong(), Flag.NULL.getLong(),
                            ConsulterOperation.PUSH_MANUAL);
                        manualLogs.add(log);
                        if (i % 100 == 0 || i == consulterIds.size() - 1) {// 每100条 批量插入
                            txConsulterOperationLogDao.saveAll(manualLogs, false);
                        }
                    }
                }
            }
            return rows;
        } catch (Exception e) {
            // throw e;
            log.error("consulter - Release - consulterIds:{},time:{}", consulterIds, now.getTime());
            log.error("consulter - Release - Exception - e", e);
        } finally {
            // 解锁
            connection.del(lock.getBytes());
            RedisConnectionUtils.releaseConnection(connection, redisTemplate.getConnectionFactory());
        }
        return 0;
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public int syncStudentId(PageDto pageDto) {
        List<TxConsultUser> users = consultUserDao.getUsersByPage(pageDto);
        if (users != null) {
            for (TxConsultUser user : users) {
                OrgStudent student = orgStudentDao.getStudentByMobileAndOrgId(user.getOrgId(), user.getMobile());
                if (student != null) {
                    user.setStudentId(student.getId());
                    consultUserDao.update(user, false);
                }
            }
            return users.size();
        }
        return 0;
    }

    @Override
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public TxConsultUser testTransaction(Integer vaule, Integer throwsException) {
        if (vaule == null) {
            return null;
        }

        TxConsultUser user = consultUserDao.getById(1);
        if (vaule.equals(1)) {
            user.setName("name1");
            consultUserDao.update(user);
        } else if (vaule.equals(2)) {
            user.setName("name2");
            consultUserDao.update(user);
        } else if (vaule.equals(3)) {
            user.setName("name3");
            consultUserDao.update(user);
            throw new RuntimeException();
        }
        if (throwsException != null && throwsException.equals(1)) {
            throw new RuntimeException();
        }
        return user;
    }

    @Override
    public ConsultUserResponse getConsultUserInfo(Long consultId, Long cascadeId, Long orgId, Integer showComments) {
    	ConsulterResponseDto consultDto = null; 
        ConsultUserInfo consultInfo = new ConsultUserInfo();
        consultInfo.setIsStudent(false);
        consultInfo.setConsulterId(consultId);
        if (consultId > 0) {
            try {
                consultDto = this.getConsultUser(orgId, cascadeId, consultId, showComments);
                consultInfo = buildConsultUserInfo(consultDto);
            } catch (NonConsultUserException e) {
                log.error("[Consulter] NonConsultUserException param:{}", e);
            }
        }

        customFieldValueService.setCustomFieldValues(consultInfo, orgId, false, consultId);

        Collections.sort(consultInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });

        // 添加线索四个字段 跟进状态，来源，意向，课程顾问
        if (consultId > 0) {
            consultInfo.getFields()
                .addAll(getFourConsultFieldValueResponses(orgId, consultInfo, consultInfo.getCascadeId()));
        } else {
            consultInfo.getFields().addAll(getFourConsultFieldValueResponses(orgId, consultInfo, cascadeId));
        }

        ConsultUserResponse reponse = buildConsultUserResponse(consultInfo);
        
        
        return reponse;
    }

    private ConsultUserResponse buildConsultUserResponse(ConsultUserInfo consultUserInfo) {
        ConsultUserResponse response = new ConsultUserResponse();
        BeanUtils.copyProperties(consultUserInfo, response);
        return response;
    }

    private ConsultUserInfo buildConsultUserInfo(ConsulterResponseDto consultDto) {
        ConsultUserInfo consultUserInfo = new ConsultUserInfo();
        BeanUtils.copyProperties(consultDto, consultUserInfo);
        consultUserInfo.setTagsResp(consultDto.getTags());
        consultUserInfo.setName(consultDto.getStudentName());
        consultUserInfo.setAvatarUrl(consultDto.getPortrait());
        consultUserInfo.setRelationship(consultDto.getRelatives());
        consultUserInfo.setAllowToPull(consultDto.getAllowToPull());
        consultUserInfo.setAllowToSms(consultDto.getAllowToSms());

        if (null != consultDto.getAreaId() && consultDto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(consultDto.getAreaId());
            consultUserInfo.setProvince(areaMap.get("province"));
            consultUserInfo.setCity(areaMap.get("city"));
            consultUserInfo.setCounty(areaMap.get("county"));
        }

        return consultUserInfo;
    }

    @Override
    @Transactional
    public Long saveConsultUserInfoAndCustomFieldValues(ConsultUserInfo consultUserInfo, Long orgId,
        Boolean keepConsultSource) {

        // 保存自定义字段
        consultUserInfo.setIsStudent(false);
        log.info("consultId param:{}", consultUserInfo.getConsulterId());
        List<Long> fieldValueIds = customFieldValueService.saveOrUpdateCustomFieldValues(consultUserInfo,
            consultUserInfo.getConsulterId(), orgId);
        setFourConsultFieldValue(consultUserInfo.getFields(), consultUserInfo);
        ConsulterRequestDto consulter = buildConsulterRequestDto(consultUserInfo);

        Long consultId = null;
        // 前置性判断 手机号校验
        preConsulterValid(consulter);
        if (keepConsultSource) {
            consultId = saveConsultUser(orgId, consulter, true);
        } else {
            consultId = saveConsultUser(orgId, consulter, false);
        }

        
        // 当首次保存学员时，自定义字段中studentId需要修改
        if (GenericsUtils.notNullAndEmpty(fieldValueIds)) {
            List<CustomFieldValue> customFieldValues = customFieldValueDao.getByIds(fieldValueIds);
            for (CustomFieldValue fieldValue : customFieldValues) {
                fieldValue.setConsultUserId(consultId);
                customFieldValueDao.update(fieldValue, "consultUserId");
            }
        }
        List<CustomFieldValue> allCustomFieldValues = customFieldValueDao.searchValuesByConfig(orgId, false, consultId, null);
        String customSearchValue = studentUserService.buildCustomSearchValue(allCustomFieldValues, false, false, null, null, null);
        TxConsultUser user = new TxConsultUser();
        user.setId(consultId);
        if(StringUtils.isBlank(customSearchValue)){
            customSearchValue = null;
        }
        user.setCustomSearchValue(customSearchValue);
        this.txConsultUserDao.update(user, true,"customSearchValue");
        

        return consultId;
    }

    private void setFourConsultFieldValue(List<CustomFieldDto> fields, ConsultUserInfo consultUserInfo) {
        for (CustomFieldDto dto : fields) {
            CustomFieldValueRequest request = (CustomFieldValueRequest) dto;
            ConsultFieldEnum consultFieldEnum = ConsultFieldEnum.getConsultFieldEnum(request.getKey());
            if (consultFieldEnum != null) {
                setFourConsultFieldValueByKey(consultFieldEnum, request.getValues(), consultUserInfo);
            }
        }
    }

    private void setFourConsultFieldValueByKey(ConsultFieldEnum consultFieldEnum, Map<String, Object> values,
        ConsultUserInfo consultUserInfo) {
        log.info("[CustomField] Map<String, Object> values param:{}", values);
        switch (consultFieldEnum) {
            case CONSULT_STATUS:
                if (values != null && values.get("id") != null) {
                    consultUserInfo.setConsultStatus((Integer) values.get("id"));
                }
                break;
            case CONSULT_SOURCE:
                if (values != null && values.get("id") != null) {
                    consultUserInfo.setConsultSource((Integer) values.get("id"));
                }
                break;
            case INTENSION_LEVEL:
                if (values != null && values.get("id") != null) {
                    consultUserInfo.setIntensionLevel((Integer) values.get("id"));
                }
                break;
            case CASCADE_ID:
                if (values != null && values.get("id") != null) {
                    consultUserInfo.setCascadeId((Long.parseLong(values.get("id").toString())));
                }
                break;
            default:
                return;
        }
        return;
    }

    private ConsulterRequestDto buildConsulterRequestDto(ConsultUserInfo consultUserInfo) {
        ConsulterRequestDto dto = new ConsulterRequestDto();
        BeanUtils.copyProperties(consultUserInfo, dto);
        if (GenericsUtils.notNullAndEmpty(consultUserInfo.getTagsResp())) {
            Gson gson = new Gson();
            String tagsStr = gson.toJson(consultUserInfo.getTagsResp());
            dto.setTags(tagsStr);
        }
        if (consultUserInfo.getLatitude() != null) {
            dto.setLatitude(consultUserInfo.getLatitude().toString());
        }
        if (consultUserInfo.getLongitude() != null) {
            dto.setLongitude(consultUserInfo.getLongitude().toString());
        }
        dto.setStudentName(consultUserInfo.getName());
        dto.setPortrait(consultUserInfo.getAvatarUrl());
        dto.setRelatives(consultUserInfo.getRelationship());
        return dto;
    }

    private List<CustomFieldValueResponse> getFourConsultFieldValueResponses(Long orgId,
        ConsultUserInfo consultUserInfo, Long cascadeId) {
        List<CustomFieldValueResponse> reponseList = new ArrayList<>();

        CustomFieldValueResponse consultStatusReponse =
            getCustomFieldValueResponse(ConsultFieldEnum.CONSULT_STATUS, orgId, consultUserInfo, cascadeId);

        CustomFieldValueResponse consultSourceReponse =
            getCustomFieldValueResponse(ConsultFieldEnum.CONSULT_SOURCE, orgId, consultUserInfo, cascadeId);

        CustomFieldValueResponse intensionLevelReponse =
            getCustomFieldValueResponse(ConsultFieldEnum.INTENSION_LEVEL, orgId, consultUserInfo, cascadeId);

        CustomFieldValueResponse cascadeReponse =
            getCustomFieldValueResponse(ConsultFieldEnum.CASCADE_ID, orgId, consultUserInfo, cascadeId);

        reponseList.add(consultStatusReponse);
        reponseList.add(consultSourceReponse);
        reponseList.add(intensionLevelReponse);
        reponseList.add(cascadeReponse);
        return reponseList;
    }

    private CustomFieldValueResponse getCustomFieldValueResponse(ConsultFieldEnum consultFieldEnum, Long orgId,
        ConsultUserInfo consultUserInfo, Long cascadeId) {
        List<FieldOption> optionList = new ArrayList<>();
        CustomFieldValueResponse reponse = null;
        switch (consultFieldEnum) {
            case CONSULT_STATUS:
                Integer consultStatus = consultUserInfo.getConsultStatus();
                ConsultUserStatus status = ConsultUserStatus.getConsultUserStatus(consultStatus);
                SingleChoiceFieldType consultStatusSingle =
                    new SingleChoiceFieldType(status.getValue(), status.getLabel());
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(),
                    consultFieldEnum.getSectionId(), consultStatusSingle, RequireStatus.NOT_REQUIRE.getStatus(),
                    CustomFieldType.SINGLE_CHOICE.getType());
                ConsultUserStatus[] enums = ConsultUserStatus.values();
                for (ConsultUserStatus consultStatusEnum : enums) {
                    if (!consultStatusEnum.equals(ConsultUserStatus.WUXIAO)) {
                        optionList
                            .add(new FieldOption((long) consultStatusEnum.getValue(), consultStatusEnum.getLabel()));
                    }
                }
                reponse.setOptions(optionList);
                break;
            case CONSULT_SOURCE:
                Long sectionSourceId = Long.parseLong(consultUserInfo.getConsultSource() + "");
                FieldOption sectionOption =
                    new FieldOption(sectionSourceId, consultCustomSourceService.getConsultSourceStr(sectionSourceId));
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(),
                    consultFieldEnum.getSectionId(), sectionOption, RequireStatus.NOT_REQUIRE.getStatus(),
                    CustomFieldType.SINGLE_CHOICE.getType());
                List<ConsultCustomSourceDto> consultCustomSourceDtos =
                    consultCustomSourceService.selection(orgId, null, PauseStatus.NOT_PAUSE.getStatus());
                if (consultCustomSourceDtos != null && consultCustomSourceDtos.size() > 0) {
                    for (ConsultCustomSourceDto consultCustomSourceDto : consultCustomSourceDtos) {
                        FieldOption option =
                            new FieldOption(consultCustomSourceDto.getId(), consultCustomSourceDto.getLabel());
                        optionList.add(option);
                    }
                }
                reponse.setOptions(optionList);
                break;
            case INTENSION_LEVEL:
                IntentionLevel intentionEnum = IntentionLevel.getIntentionLevel(consultUserInfo.getIntensionLevel());
                SingleChoiceFieldType intentionSingle =
                    new SingleChoiceFieldType(intentionEnum.getValue(), intentionEnum.getLabel());
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(),
                    consultFieldEnum.getSectionId(), intentionSingle, RequireStatus.NOT_REQUIRE.getStatus(),
                    CustomFieldType.SINGLE_CHOICE.getType());

                IntentionLevel[] intentionEnums = IntentionLevel.values();
                for (IntentionLevel intensionEnum : intentionEnums) {
                    optionList.add(new FieldOption((long) intensionEnum.getValue(), intensionEnum.getLabel()));
                }
                reponse.setOptions(optionList);
                break;
            case CASCADE_ID:
                String accountName = getAccountName(orgId, cascadeId);
                SingleChoiceFieldType cascadeSingle = new SingleChoiceFieldType();
                if (cascadeId != null && cascadeId != -1l) {
                    // 当consultId==-1时，为新建请求，所属人显示"自己"
                    if (consultUserInfo.getConsulterId() == -1l) {
                        cascadeSingle = new SingleChoiceFieldType(cascadeId.intValue(), "自己");
                    } else {
                        cascadeSingle = new SingleChoiceFieldType(cascadeId.intValue(), accountName);
                    }
                } else {
                    cascadeSingle = new SingleChoiceFieldType(-1, "公海");
                }
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(),
                    consultFieldEnum.getSectionId(), cascadeSingle, RequireStatus.NOT_REQUIRE.getStatus(),
                    CustomFieldType.SINGLE_CHOICE.getType());
                cascadeId = (cascadeId == null ? 0l : cascadeId);
                log.info("consultUserInfo.getConsulterId() param:{}", consultUserInfo.getConsulterId());
                if (consultUserInfo.getConsulterId() == -1l) {
                    optionList.add(new FieldOption(-1l, "公海"));
                    optionList.add(new FieldOption(cascadeId, "自己"));
                }
                reponse.setOptions(optionList);
                break;
            default:
                return reponse;
        }
        return reponse;
    }

    private void preConsulterValid(ConsulterRequestDto consulter) {

        // 添加手机号强校验
        if (StringUtils.isBlank(consulter.getMobile())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生手机号不能为空");
        }
        if (StringUtils.isBlank(consulter.getMobile()) && StringUtils.isBlank(consulter.getWeixinOpenId())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生手机号和微信OPENID不能同时为空");
        }
        if (StringUtils.isNoneBlank(consulter.getMobile()) && !consulter.getMobile().contains("****")
            && !ParamValidateUtils.validateMobile(consulter.getMobile())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "手机号格式不正确:" + consulter.getMobile());
        }
        if (StringUtils.isNoneBlank(consulter.getParentMobile()) && !consulter.getParentMobile().contains("****")
            && !ParamValidateUtils.validateMobile(consulter.getParentMobile())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "家长手机号格式不正确:" + consulter.getParentMobile());
        }

    }

    void updateSolr(TxConsultUser txConsultUser) {
        try {
            txConsultUser.toSolrMap();
            //consultUserQuery.updateOldRow(txConsultUser.toSolrMap());
            log.info("solr - consult user - update - end - txConsultUser:{}", txConsultUser);
        } catch (Exception e) {
            log.error("solr - consult user - update - exception", e);
        }
    }

}