/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.service;

import java.util.List;

import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;





/**   
 * @title       : ConsultCustomSourceService 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年7月23日 下午5:26:46 
 */
public interface ConsultCustomSourceService {

	ConsultCustomSourceDto add(Long orgId, String label);
	
	void del(Long orgId, Long id);
	
	ConsultCustomSourceDto edit(Long orgId, Long id, String label);
	
	ConsultCustomSourceDto pause(Long orgId, Long id, Integer isPaused);
	
	void sort(Long orgId, String sort);
	
	/**
	 * @Description  : scope      0-自定义的选项 1-返回系统内置的选项 其它- 返回全部
	 *                 isPaused   0- 启用中的选项 1-停用的选项 其它- 返回全部
	 * @Author       : zhenyujian
	 * @Date         : 2016年8月6日 下午4:36:29 
	 *
	 * @Return       : List<ConsultCustomSourceDto>
	 */
	List<ConsultCustomSourceDto> selection(Long orgId, Integer scope, Integer isPaused);
	
	String getConsultSourceStr(Long id);
}

