
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.consult.user.dto.response.pc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

import org.apache.commons.beanutils.BeanUtils;

import com.baijia.tianxiao.annotation.Option;
import com.baijia.tianxiao.biz.consult.enums.GenderStatus;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.enums.PropertiesType;
import com.baijia.tianxiao.enums.QueryPolicy;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.Data;

/**
 * 线索详情response
 *
 * @author zhangbing
 * @version 1.0
 * @title ConsultListResponseDto
 * @desc TODO
 * @date 2016年3月15日
 */
@Data
public class ConsultListResponseDto {

    //咨询用户ID
    @Option(hidden = true, name = "id", showName = "id", defaultProp = true, type = PropertiesType.DIGITAL)
    private Long id;

    @Option(lock = true, name = "name", showName = "姓名", defaultProp = true, type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String name;

    //学员手机号码
    @Option(lock = true, name = "mobile", showName = "手机号", defaultProp = true, type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String mobile;

    @Option(hidden = true, name = "sex", showName = "性别", type = PropertiesType.DIGITAL)
    private Integer sex;

    @Option(name = "sexStr", showName = "性别", defaultProp = true, type = PropertiesType.STRING, queryProp = "sex")
    private String sexStr;

    @Option(hidden = true, name = "consultStatus", showName = "跟进状态", type = PropertiesType.DIGITAL)
    private int consultStatus;

    //咨询状态
    @Option(name = "consultStatusStr", showName = "跟进状态", defaultProp = true, type = PropertiesType.STRING, queryProp = "consultStatus")
    private String consultStatusStr;

    //家长姓名
    @Option(name = "parentName", showName = "家长姓名", type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String parentName;

    //家长手机
    @Option(name = "parentMobile", showName = "家长手机号", type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String parentMobile;

    //咨询来源
    @Option(hidden = true, name = "consultSource", showName = "线索来源", type = PropertiesType.DIGITAL)
    private int consultSource;

    //咨询来源
    @Option(name = "consultSourceStr", showName = "线索来源", defaultProp = true, type = PropertiesType.DIGITAL, queryProp = "consultSource")
    private String consultSourceStr;

    @Option(hidden = true, name = "createTime", showName = "咨询时间", type = PropertiesType.DATE, policy = QueryPolicy.BETWEEN)
    private Long createTime;

    @Option(hidden = true, name = "createTimeStr", showName = "咨询时间", type = PropertiesType.DATE, policy = QueryPolicy.BETWEEN)
    private Date createTimeStr;


    //意向级别,默认级别1  中级别
    @Option(hidden = true, name = "intensionLevel", showName = "意向级别", type = PropertiesType.DIGITAL)
    private int intensionLevel = 1;

    //意向级别,默认级别1  中级别
    @Option(name = "intensionLevelStr", showName = "意向级别", defaultProp = true, type = PropertiesType.STRING, queryProp = "intensionLevel")
    private String intensionLevelStr = "中";

    @Option(hidden = true, name = "cascadeId", showName = "所属人", type = PropertiesType.DIGITAL)
    private long cascadeId;

    @Option(name = "cascadeIdStr", showName = "所属人", defaultProp = true, type = PropertiesType.STRING, queryProp = "cascadeId")
    private String cascadeIdStr;


    //下次跟进时间提醒
    @Option(hidden = true, name = "nextRemindTime", showName = "下次跟进时间", type = PropertiesType.DIGITAL)
    private Long nextRemindTime;

    @Option(name = "nextRemindTimeStr", showName = "下次跟进时间", defaultProp = true, type = PropertiesType.DATETIME, queryProp = "nextRemindTime")
    private Date nextRemindTimeStr;

    //学校
    @Option(name = "school", showName = "公立学校", type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String school;

    //生日
    @Option(hidden = true, name = "birthday", showName = "生日", type = PropertiesType.DIGITAL)
    private Long birthday;

    @Option(name = "birthdayStr", showName = "生日", type = PropertiesType.DATE)
    private Date birthdayStr;
    
    @Option(hidden = true,name = "birthdayString", showName = "生日", type = PropertiesType.STRING)
    private String birthdayString;

    //班级
    @Option(name = "degreeClass", showName = "年级", type = PropertiesType.STRING)
    private String degreeClass;

    @Option(hidden = true, name = "relatives", showName = "亲属关系", type = PropertiesType.DIGITAL)
    private Integer relatives;

    @Option(name = "relativesStr", showName = "亲属关系", type = PropertiesType.DIGITAL, queryProp = "relatives")
    private String relativesStr;

    //居住地址
    @Option(name = "address", showName = "详细地址", type = PropertiesType.STRING)
    private String address;

    //父亲职业
    @Option(hidden = true, name = "fatherOccupation", showName = "父亲职业", type = PropertiesType.STRING)
    private String fatherOccupation;

    //母亲职业
    @Option(hidden = true, name = "matherOccupation", showName = "母亲职业", type = PropertiesType.STRING)
    private String matherOccupation;

    //花名册用户来源，只有当studentId不为空的时候有效
    //0:跟谁学用户、1:非跟谁学用户
    @Option(hidden = true, name = "origin", showName = "学员来源渠道", type = PropertiesType.DIGITAL)
    private Integer origin;

    @Option(hidden = true, name = "latitude", showName = "纬度", type = PropertiesType.DIGITAL, sort = 0)
    private Double latitude;

    @Option(hidden = true, name = "longitude", showName = "经度", type = PropertiesType.DIGITAL, sort = 0)
    private Double longitude;

    @Option(hidden = true, name = "areaId", showName = "地域id", type = PropertiesType.DIGITAL, sort = 0)
    private Long areaId;

    @Option(hidden = true, name = "province", showName = "省", type = PropertiesType.STRING, sort = 0)
    private String province;

    @Option(hidden = true, name = "city", showName = "市", type = PropertiesType.STRING, sort = 0)
    private String city;

    @Option(hidden = true, name = "county", showName = "区", type = PropertiesType.STRING, sort = 0)
    private String county;

    @Option(name = "qq", showName = "QQ", type = PropertiesType.STRING)
    private String qq;

    @Option(name = "mail", showName = "邮箱", type = PropertiesType.STRING)
    private String mail;
    
    @Option(hidden = true,name = "tagsStr", showName = "标签", type = PropertiesType.STRING)
    private String tagsStr;

    public static ConsultListResponseDto convertToDto(ConsulterListDto consultUser, String consultSourceStr) throws IllegalAccessException, InvocationTargetException {
        ConsultListResponseDto dto = new ConsultListResponseDto();
        BeanUtils.copyProperties(dto, consultUser);
        if (consultUser.getNextRemindTime() != null) {
            dto.setNextRemindTime(consultUser.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(consultUser.getNextRemindTime());
        }
        if (consultUser.getBirthday() != null) {
            dto.setBirthday(consultUser.getBirthday().getTime());
            dto.setBirthdayStr(consultUser.getBirthday());
        }

        dto.setCreateTimeStr(consultUser.getCreateTime());
        dto.setConsultSourceStr( consultSourceStr );
        dto.setConsultStatusStr(ConsultUserStatus.getLabel(consultUser.getConsultStatus()));
        dto.setRelativesStr(Relatives.getLabel(consultUser.getRelatives()));
        dto.setId(consultUser.getId());
        dto.setSexStr(GenderStatus.getGenderStr(dto.getSex()));
        dto.setIntensionLevelStr(IntentionLevel.getLabel(dto.getIntensionLevel()));

        return dto;
    }

    public static void main(String args[]) {
        Field fields[] = ConsultListResponseDto.class.getDeclaredFields();
        for (Field field : fields) {
            Option option = field.getAnnotation(Option.class);
            if (option != null) {
                System.out.println(option.name() + "---" + option.showName() + "---" + option.hidden() + "---" + option.lock() + "---" + option.type() + "---" + option.defaultProp());
            }
        }
    }
}

    