/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.dto.request;

import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @title ConsulterRequestDto
 * @desc TODO
 * @author cxm
 * @date 2015年12月7日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ConsulterRequestDto extends ConsulterDto {

    private String tags;

    private Integer saveStudent;

    private Integer confirm;

    public Integer getSaveStudent(){
        if(this.saveStudent==null){
            return Flag.FALSE.getInt();
        }
        return this.saveStudent;
    }

    public static ConsulterRequestDto convertToRequestParam(TxConsultUser user) {
        ConsulterRequestDto dto = new ConsulterRequestDto();
        if (user != null) {
            dto.setOrgId(user.getOrgId());
            dto.setConsulterId(user.getId());
            dto.setAddress(user.getAddress());
            dto.setBirthday(user.getBirthday() != null ? user.getBirthday().getTime() : 0l);
            dto.setConsultSource(user.getConsultSource());
            dto.setConsultStatus(user.getConsultStatus());
            dto.setDegreeClass(user.getDegreeClass());
            dto.setMail(user.getMail());
            dto.setIntensionLevel(user.getIntensionLevel());
            dto.setCanEditMobile(true);
            dto.setMobile(user.getMobile());
            dto.setNextRemindTime(user.getNextRemindTime() != null ? user.getNextRemindTime().getTime() : 0l);
            dto.setNickName(user.getNickName());
            dto.setParentMobile(user.getParentMobile());
            dto.setParentName(user.getParentName());
            dto.setQq(user.getQq());
            dto.setSchool(user.getSchool());
            dto.setStudentName(user.getName());
            dto.setUserNumber(user.getUserNumber());
            dto.setWeixin(user.getWeixin());
            dto.setWeixinNickName(user.getWeixinNickName());
            dto.setWeixinOpenId(user.getWeixinOpenId());

            dto.setPortrait(user.getPortrait());
            dto.setRelatives(user.getRelatives());
            dto.setSex(user.getSex());
            dto.setLatitude(user.getLatitude());
            dto.setLongitude(user.getLongitude());
            dto.setCampusOrgId(user.getCampusOrgId());
            dto.setIsConsulter(user.getIsConsulter());
            dto.setCascadeId(user.getCascadeId());
            dto.setIsInvalid(user.getIsInvalid());
            dto.setReasonForInvalid(user.getReasonForInvalid());
            if (user.getLastRemindTime() != null) {
                dto.setLastRemindTime(user.getLastRemindTime().getTime());
            }

            if (user.getFinallyHoldTime() != null) {
                dto.setFinallyHoldTime(user.getFinallyHoldTime().getTime());
            }
            if(user.getStudentId()!=null && user.getStudentId()>0){
                dto.setMsgUserRole(MsgUserRole.STUDENT);
            }else {
                dto.setMsgUserRole(MsgUserRole.getUserRole(user.getIsConsulter()==null?0:user.getIsConsulter()));
            }
            dto.setAreaId(user.getAreaId());
        }
        return dto;
    }
}