/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.dto;

import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;

import lombok.Data;

/**   
 * @title       : ConsulterPullLogDto 
 * @description : 线索 领取记录
 * @author      : zhenyujian
 * @date        : 2016年5月30日 下午1:47:27 
 */
@Data
public class ConsulterPullLogDto {
	
	private Long ownerCascadeId;
	private String ownerName; //所属人
	private Long pulltime;    //领取时间
	private Long backtime;  //回归公海时间
	private Integer backType; //回归公海方式
	
	public String getBackTypeStr(){
		if(backType.intValue() == ConsulterOperation.PUSH_AUTO.getValue()){
			return "自动回归";
		}else if(backType.intValue() == ConsulterOperation.PUSH_MANUAL.getValue()){
			return "手动释放";
		}
		return "";
	}
}

