/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.dto;

import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constant.Sex;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonProperty;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;

/**
 * @title ConsulterDto
 * @desc 客户信息
 * @author cxm
 * @date 2015年12月7日
 * @version 1.0
 */
@EqualsAndHashCode
@ToString(callSuper = true)
@Slf4j
@Data
public class ConsulterDto implements MsgUser {

    /**
     * 咨询用户ID
     */
    private Long consulterId;

    private Long orgId;

    private Long userNumber;

    private String studentName;

    private Long subAccountId;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 学生手机号
     */
    private String mobile;

    /**
     * 意向级别,默认级别3
     */
    private int intensionLevel = IntentionLevel.LEVEL_1.getValue();

    /**
     * 咨询来源
     */
    private int consultSource;

    /**
     * 微信
     */
    private String weixin;

    private String weixinNickName;

    private String weixinOpenId;

    // 机构是否可以与学员进行微信聊天
    private int chat = 0;

    private String parentName;

    private String parentMobile;

    /**
     * 下次跟进时间
     */
    private Long nextRemindTime;

    private String school;

    private String qq;

    @JsonProperty("mail")
    private String mail;

    private Long birthday;

    /**
     * 年级班级
     */
    private String degreeClass;

    private boolean canEditMobile;

    // 花名册用户来源，只有当studentId不为空的时候有效
    // 0:跟谁学用户、1:非跟谁学用户
    private Integer origin;

    // 头像
    private String portrait;
    // 跟进状态
    private Integer consultStatus;
    // 亲属关系
    private Integer relatives;  //对应的系统字段为 relationship;
    // 性别
    private Integer sex;
    // 地址
    private String address;
    // 地址 - 纬度
    private String latitude;
    // 地址 - 经度
    private String longitude;
    // 校区org_number
    private Integer campusOrgNumber;
    // 校区org_id
    private Integer campusOrgId;
    // 是否是线索
    private Integer isConsulter;
    // 线索所属人 子账号id
    private Long cascadeId;
    // 有效、无效
    private Integer isInvalid;
    // 标志为无效的原因
    private String reasonForInvalid;

    private Integer consulterType;

    private Long lastRemindTime;

    private Long finallyHoldTime;
    
    private Long areaId;  //地域id

    private String intensionLevelStr;
    private String consultSourceStr;
    private String consultStatusStr;
    private String relativesStr;
    private String sexStr;
    private Integer remainingDayNum;
    
    private String province;   //省份

    private String city;  //市

    private String county;   //区
    
    private Integer allowToPull;
    private Integer allowToSms;

    private MsgUserRole msgUserRole = MsgUserRole.STUDENT;

    public String getIntensionLevelStr() {
        return IntentionLevel.getLabel(this.intensionLevel);
    }

    public String getConsultSourceStr() {
        return MessageSource.getDesc(this.consultSource);
    }

    public String getConsultStatusStr() {
        return ConsultUserStatus.getLabel(this.consultStatus);
    }

    public String getRelativesStr() {
        return Relatives.getLabel(this.relatives);
    }

    public String getSexStr() {
        return Sex.getLabel(this.sex);
    }

    private static final Long ONE_DAY_TIME = 86400000L;

    public Integer getRemainingDayNum() {
    	int dayNum = 0;
        if (cascadeId != null && this.cascadeId.intValue() != Flag.NULL.getInt() && this.finallyHoldTime != null) {
            // Long diff = this.finallyHoldTime - now;
            // if(diff<0){
            // return 0;
            // }else{
            // diff = diff/1000;
            // return (int) (diff/(60*60*24));
            // }
            Date now = new Date();
            Date findllyHoldDate = new Date(this.finallyHoldTime);
            if (findllyHoldDate.after(now)) {
                if (DateUtil.getStartOfDayAccurateToMillSeconde(findllyHoldDate)
                    .equals(DateUtil.getStartOfDayAccurateToMillSeconde(now))) {
                	dayNum = 1;
                } else {
                	dayNum = (int) ((DateUtil.getStartOfDayAccurateToMillSeconde(new Date(finallyHoldTime)).getTime()
                        - DateUtil.getStartOfDayAccurateToMillSeconde(new Date()).getTime()) / ONE_DAY_TIME);
                }
            }
            
            if(dayNum==0){
            	dayNum = 1;
            }
        }
        return dayNum;
    }

    @Override
    public Long getUserId() {
        return consulterId;
    }

    @Override
    public String getName() {
        if (StringUtils.isNoneBlank(studentName)) {
            return studentName;
        } else if (StringUtils.isNoneBlank(weixinNickName)) {
            return weixinNickName;
        } else {
            return TianXiaoConstant.APPOINTMENT_STUDENT_NAME;
        }
    }

    @Override
    public Long getNumber() {
        return userNumber;
    }

    @Override
    public UserRoleEnum getRole() {
        return UserRoleEnum.STUDENT;
    }

    @Override
    public MsgUserRole getMsgUserRole() {
        return msgUserRole;
    }

    public void setMsgUserRole(MsgUserRole msgUserRole){
        this.msgUserRole = msgUserRole;
    }

    @Override
    public int getIntentLevel() {
        return this.intensionLevel;
    }

    public static ConsulterResponseDto convertToDto(TxConsultUser user) {
        ConsulterResponseDto dto = new ConsulterResponseDto();
        if (user != null) {
            dto.setOrgId(user.getOrgId());
            dto.setConsulterId(user.getId());
            dto.setAddress(user.getAddress());
            dto.setBirthday(user.getBirthday() != null ? user.getBirthday().getTime() : 0l);
            dto.setConsultSource(user.getConsultSource());
            dto.setConsultStatus(user.getConsultStatus());
            dto.setDegreeClass(user.getDegreeClass());
            dto.setMail(user.getMail());
            dto.setIntensionLevel(user.getIntensionLevel());
            // FIXME 手动添加并且非400电话咨询的才能修改,拍脑袋...
            // dto.setCanEditMobile(
            // user.getManually() == 1 || !MessageSource.getNoEditConsultType().contains(user.getConsultSource()));
            // if (dto.isCanEditMobile()) {
            // dto.setMobile(user.getMobile());
            // } else {
            // dto.setMobile(MaskUtil.maskMobile(user.getMobile()));
            // }
            // 手机号码不区分咨询来源，全部可更改，并且完整显示
            dto.setCanEditMobile(true);
            dto.setMobile(user.getMobile());

            dto.setNextRemindTime(user.getNextRemindTime() != null ? user.getNextRemindTime().getTime() : 0l);
            dto.setNickName(user.getNickName());
            dto.setParentMobile(user.getParentMobile());
            dto.setParentName(user.getParentName());
            dto.setQq(user.getQq());
            dto.setSchool(user.getSchool());
            dto.setStudentName(user.getName());
            dto.setUserNumber(user.getUserNumber());
            dto.setWeixin(user.getWeixin());
            dto.setWeixinNickName(user.getWeixinNickName());
            dto.setWeixinOpenId(user.getWeixinOpenId());

            dto.setPortrait(user.getPortrait());
            dto.setRelatives(user.getRelatives());
            dto.setSex(user.getSex());
            dto.setLatitude(user.getLatitude());
            dto.setLongitude(user.getLongitude());
            dto.setCampusOrgId(user.getCampusOrgId());
            dto.setIsConsulter(user.getIsConsulter());
            dto.setCascadeId(user.getCascadeId());
            dto.setIsInvalid(user.getIsInvalid());
            dto.setReasonForInvalid(user.getReasonForInvalid());
            if (user.getLastRemindTime() != null) {
                dto.setLastRemindTime(user.getLastRemindTime().getTime());
            }

            if (user.getFinallyHoldTime() != null) {
                dto.setFinallyHoldTime(user.getFinallyHoldTime().getTime());
            }
            if(user.getStudentId()!=null && user.getStudentId()>0){
                dto.setMsgUserRole(MsgUserRole.STUDENT);
            }else {
                dto.setMsgUserRole(MsgUserRole.getUserRole(user.getIsConsulter()==null?0:user.getIsConsulter()));
            }
            dto.setAreaId(user.getAreaId());
        }
        return dto;
    }

    public static TxConsultUser convertToConsultUser(ConsulterDto dto) {
        if (dto == null) {
            return null;
        }
        TxConsultUser user = new TxConsultUser();
        user.setOrgId(dto.getOrgId());
        user.setAddress(dto.getAddress());
        user.setBirthday((dto.getBirthday() != null && dto.getBirthday() > 0) ? new Date(dto.getBirthday()) : null);
        user.setConsultSource(dto.getConsultSource());
        user.setConsultStatus(dto.getConsultStatus());
        user.setDegreeClass(dto.getDegreeClass());
        user.setMail(dto.getMail());
        user.setIntensionLevel(dto.getIntensionLevel());
        user.setMobile(dto.getMobile());
        if(dto.getNextRemindTime() != null && dto.getNextRemindTime()>0){
            user.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        user.setNickName(dto.getNickName());
        user.setParentMobile(dto.getParentMobile());
        user.setParentName(dto.getParentName());
        user.setQq(dto.getQq());
        user.setSchool(dto.getSchool());
        user.setName(dto.getStudentName());
        user.setUserNumber(dto.getUserNumber());
        user.setWeixin(dto.getWeixin());
        user.setWeixinNickName(dto.getWeixinNickName());
        if (StringUtils.isNotBlank(dto.getWeixinOpenId()) && !"0".equals(dto.getWeixinOpenId())) {
            user.setWeixinOpenId(dto.getWeixinOpenId());
        }

        user.setPortrait(dto.getPortrait());
        user.setRelatives(dto.getRelatives());
        if(dto.getSex() != null){
            user.setSex(dto.getSex());
        }
        user.setLatitude(dto.getLatitude());
        user.setLongitude(dto.getLongitude());
        if (dto.getCampusOrgNumber() != null) {
            user.setCampusOrgId(dto.getCampusOrgId());
        }
        user.setIsConsulter(dto.getIsConsulter());
        user.setCascadeId(dto.getCascadeId());
        user.setIsInvalid(dto.getIsInvalid());
        user.setReasonForInvalid(dto.getReasonForInvalid());
        user.setAreaId(dto.getAreaId());

        return user;
    }

    public void setRemainingDayNum(Integer remainingDayNum) {
        this.remainingDayNum = remainingDayNum;
    }

}
