/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.dto;

import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldSection;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年8月9日
 * @desc 自定义字段，添加学员详情时，只返回前端需要的字段  从ConsultUserInfo抽取而来
 */
@Data
public class ConsultUserResponse {
    private Long consulterId;     //咨询用户ID
    private String weixinOpenId;
    private Integer remainingDayNum;
    private Integer consulterType;  //线索类型 无效 我的线索，公共池线索
    
    private Long areaId;  //地域id
    
    private Integer chat;  //机构能否给线索聊天
    private String province;   //省份

    private String city;  //市

    private String county;   //区
    
    private List<CommentInfoDto> comments;
    private List<CustomFieldSection> sections;
    private Integer allowToPull;
    private Integer allowToSms;
    
    private List<CustomFieldDto> fields = new ArrayList<>();

}
