/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.dto;

import com.baijia.tianxiao.biz.consult.user.dto.response.CampusDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.OwnerDto;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;

import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年7月28日
 * @desc 自定义字段后 线索详情dto
 */
@Data
public class ConsultUserInfo extends OrgUserBaseInfo{
    private Long consulterId;     //咨询用户ID
    
    private String studentName;   //用户姓名  系统字段中name
    
    private Long subAccountId;
    
    private String nickName;
    
    private int intensionLevel = IntentionLevel.LEVEL_2.getValue();
    
    private String weixinNickName;
    
    private String weixinOpenId;
    
    // 机构是否可以与学员进行微信聊天
    private int chat = 0;
    
    private boolean canEditMobile;
    // 头像
    private String portrait;     //头像url
    
    private Long orgId;
    
    // 校区org_number
    private Integer campusOrgNumber;
    // 校区org_id
    private Integer campusOrgId;
    // 是否是线索
    private Integer isConsulter;
    // 有效、无效
    private Integer isInvalid;
    // 标志为无效的原因
    private String reasonForInvalid;

    private Integer consulterType;

    private Long lastRemindTime;

    private Long finallyHoldTime;
    
    private Integer relatives;   //亲属关系

    private int consultStatus;     ///跟进状态

    private int consultSource;     //线索来源

    private String consultSourceStr;  //线索来源描述

    private Long createTime;   //咨询时间

    private Date createTimeStr;   //咨询时间描述

    private String intensionLevelStr = "中";    //意向级别描述

    private long cascadeId;    //所属人

    private String cascadeIdStr;  //所属人描述

    private Date nextRemindTimeStr;    //下次跟进时间 Date

    private Date birthdayStr;   //生日 date

    private String birthdayString;   //生日String

    private String relativesStr;  //亲属关系描述

    private String province;   //省份

    private String city;  //市

    private String county;   //区

    private String sexStr;
    
   private OwnerDto owner;
    
    private CampusDto campus;

    private String tags;

    private List<CommentInfoDto> comments;
    
    private Integer saveStudent;
    
    private Integer confirm;
    
    private Integer remainingDayNum;
    
    private Long areaId;
    
    private Integer allowToPull;
    private Integer allowToSms;
}
