/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.sync.impl;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.annotation.Resource;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.biz.consult.msg.service.impl.MessageConsumeServiceImp;
import com.baijia.tianxiao.biz.consult.sync.SyncService;
import com.baijia.tianxiao.dal.advisory.service.AdvisoryService;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;

/**
 * @title SyncStudentAdvisoryInfoServiceImpl
 * @desc TODO
 * @author cxm
 * @date 2015年12月10日
 * @version 1.0
 */
@Service("syncStudentAdvisoryInfo")
@Slf4j
public class SyncStudentAdvisoryInfoServiceImpl implements SyncService, InitializingBean {

    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private AdvisoryService advisoryService;

    @Autowired(required = false)
    private CloudAccount cloudAccount;

    private Properties queuePropties;

    private AtomicBoolean flag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.ADVISORY);
        log.info("start query msg by syncInfo:{}", syncInfo);
        if (flag.get()) {
            log.warn("last sync is not complete");
            return;
        }
        flag.set(true);
        try {
            syncTask(syncInfo);
        } catch (Exception e) {
            log.error("catch error:", e);
        } finally {
            flag.set(false);
        }
        log.info("send msg end,save syncInfo:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncTask(TxMsgSyncTimestamp syncInfo) {
        List<AdvisoryInfoDto> dtos =
            advisoryService.getAdvisoryInfos(syncInfo.getSyncId(), syncInfo.getSyncTime(), 200);
        if (CollectionUtils.isNotEmpty(dtos)) {
            CloudQueue queue =
                cloudAccount.getMNSClient().getQueueRef(
                    queuePropties.getProperty(MessageConsumeServiceImp.CONSULT_MSG_QUEUE));
            List<Message> messages = Lists.newArrayList();
            for (AdvisoryInfoDto dto : dtos) {
                Message msg = new Message(MessageSource.APPOINTMENT.getValue() + "$" + JacksonUtil.obj2Str(dto));
                messages.add(msg);
                if (dto.getAdvisoryId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(dto.getAdvisoryId());
                }
            }
            log.info("add {} messages into queue", messages.size());
            queue.batchPutMessage(messages);
        }
    }

    /**
     * @param syncType
     * @return
     */
    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        queuePropties = PropertiesReader.getProperties("mns.properties");
        if (cloudAccount == null) {
            String id = queuePropties.getProperty("mns.accesskeyid");
            String secret = queuePropties.getProperty("mns.accesskeysecret");
            String endpoint = queuePropties.getProperty("mns.accountendpoint");
            cloudAccount = new CloudAccount(id, secret, endpoint);
        }
    }

}
