/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.callservice.constant.OrgCallStatus;
import com.baijia.tianxiao.dal.callservice.dao.TX400PhoneDao;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.callservice.po.TX400Phone;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.push.utils.CardContentFactory;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.common.constant.DBOperation;
import com.baijia.tianxiao.sal.common.dto.DBResultDto;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.gson.Gson;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @author cxm
 * @version 1.0
 * @title ReceiveOrgCallService
 * @desc 机构400电话咨询消息消费
 * @date 2015年12月7日
 */
@Service("orgCallConsultService")
@Slf4j
public class OrgCallConsultServiceImpl extends AbstractConsultService<OrgPushCallInfo> {

    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private StudentDao studentDao;

    @Autowired
    private OrgStorageDao storageDao;

    @Autowired
    private OrgStudentDao orgStudentDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Autowired
    private TX400PhoneDao tx400PhoneDao;

    @Autowired
    private TXCascadeCredentialDao credentialDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private FansDao fansDao;
    
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
	private TXStudentCommentAPIService txStudentCommentAPIService;

    private MsgUser builderSender(Long orgId, OrgPushCallInfo callInfo) {
//        List<TxConsultUser> consultUsers = consultUserDao.lookByMobile(orgId, callInfo.getCustomerNumber());
//        TxConsultUser consultUser = null;
//        if (CollectionUtils.isEmpty(consultUsers)) {
//            consultUser = new TxConsultUser();
//            consultUser.setConsultSource(MessageSource.TELEPHONE.getValue());
//            consultUser.setOrgId(orgId);
//            consultUser.setMobile(callInfo.getCustomerNumber());
//
//            String mobile = callInfo.getCustomerNumber();
//            OrgStudent orgStudent = orgStudentDao.getStudentByMobileAndOrgId(orgId, mobile);
//            if (orgStudent != null) {
//                User user = this.userDao.getById(orgStudent.getUserId());
//                this.studentToConsult(consultUser, orgStudent, user);
//            } else {
//                this.userToConsult(consultUser, mobile);
//            }
//            
//            log.info("[Call] consultUser="+consultUser);
//            if(StringUtils.isBlank(consultUser.getName()) || consultUser.getName().equals(TianXiaoConstant.APPOINTMENT_STUDENT_NAME)){
//                consultUser.setName(TianXiaoConstant.ANONYMOUS_CONSULT_USER);
//            }
//            consultUserDao.save(consultUser);
//            buildComment(consultUser, callInfo, true);
//            if(consultUser.getNextRemindTime() != null){
//                this.consultUserService.addSysBacklog(orgId, consultUser.getId());
//            }
//        } else {
//            consultUser = consultUsers.get(0);
//            OrgStudent student = orgStudentDao.getStudentByMobileAndOrgId(orgId, callInfo.getCustomerNumber(), "name", "delStatus");
//            if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
//                consultUser.setName(student.getName());
//            }
//            buildComment(consultUser, callInfo, false);
//        }
//        return ConsulterDto.convertToDto(consultUser);
        
        
        //线索
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(orgId);
        consultUser.setMobile(callInfo.getCustomerNumber());
        consultUser.setName(TianXiaoConstant.ANONYMOUS_CONSULT_USER);
        consultUser.setConsultSource(MessageSource.TELEPHONE.getValue());
        consultUser.setIsConsulter(null);
        DBResultDto<TxConsultUser> dto = consulterAPIService.saveOrUpdateByMobile(consultUser);
        TxConsultUser result = dto.getData(); 
        
        //跟进记录
        txStudentCommentAPIService.saveByOrgCall400(result, callInfo, dto.getOperation()==DBOperation.INSERT ? true:false);
        
        return ConsulterDto.convertToDto(result);
    }



    /**
     * OrgStudent转换为TxConsultUser
     *
     * @param consultUser
     * @param orgStudent
     */
    private void studentToConsult(TxConsultUser consultUser, OrgStudent orgStudent, User user) {

        if (user != null) {
            consultUser.setUserNumber(user.getNumber());
        }

        consultUser.setAddress(orgStudent.getAddress());
        consultUser.setConsultStatus(ConsultUserStatus.HAS.getValue());
        consultUser.setCreateTime(new Date());
        consultUser.setDegreeClass(orgStudent.getDegreeClass());
        consultUser.setDelStatus(DeleteStatus.NORMAL.getValue());
        consultUser.setFatherOccupation(orgStudent.getFatherOccupation());
        consultUser.setMail(orgStudent.getMail());
        consultUser.setManually(0);
        consultUser.setMatherOccupation(orgStudent.getMatherOccupation());
        consultUser.setName(orgStudent.getName());
        consultUser.setNextRemindTime(orgStudent.getNextRemindTime());
        consultUser.setNickName(orgStudent.getNickName());
        consultUser.setParentMobile(orgStudent.getParentMobile());
        consultUser.setParentName(orgStudent.getParentName());
        consultUser.setQq(orgStudent.getQq());
        consultUser.setSchool(orgStudent.getSchool());
        consultUser.setStudentId(orgStudent.getId());
        consultUser.setUserId(orgStudent.getUserId());
        consultUser.setWeixinOpenId(orgStudent.getWeixin());
        if(StringUtils.isNotBlank(orgStudent.getWeixin()) && !orgStudent.getWeixin().equals("0")){
        	Fans fans = fansDao.getByOpenId(orgStudent.getWeixin());
        	if(fans!=null){
        		consultUser.setWeixinAppId(fans.getAuthorizerAppId());
        	}
        }
    }

    /**
     * 根据手机号码构造TxConsultUser
     *
     * @param consultUser
     * @param mobile
     */
    private void userToConsult(TxConsultUser consultUser, String mobile) {
        User user = userDao.getByMobile(mobile, "id", "number", "mobile");
        if (user != null) {
            Student student = studentDao.getByUserId(user.getId(), "userId", "realName", "nickName");
            consultUser.setName(getNameFromStudent(student));
            consultUser.setUserId(user.getId());
            consultUser.setUserNumber(user.getNumber());
        }
    }

    private MsgUser buildOrgMsgUser(String extension) {
        // 独立400用户或者购买中转话机的用户
        MsgUser msgUser = own400(extension);
        if (msgUser != null) {
            return msgUser;
        }
        // 使用分机号的用户
        OrgInfo orgInfo = orgInfoDao.getByExtension(extension, "orgId", "name", "shortName", "extension");
        if (orgInfo == null) {
            log.warn("can not get org info by extension:{}", extension);
            return null;
        }
        OrgAccount orgAccount = orgAccountDao.getAccountById(orgInfo.getOrgId(), "number");
        return buildReceiver(orgInfo, orgAccount.getNumber().longValue());
    }

    /**
     * @param extension
     * @return
     */
    private MsgUser own400(String extension) {
        // 分机号都是6位
        if (StringUtils.isNotBlank(extension) && extension.length() > 6) {
            TX400Phone tx400Phone = null;
            if (extension.startsWith("400")) {
                tx400Phone = tx400PhoneDao.getBy400Phone(extension);
            } else {
                tx400Phone = tx400PhoneDao.getByTransPhone(extension);
            }
            if (tx400Phone == null) {
                log.warn("can not get TX400Phone info by extension:{}", extension);
                return null;
            }
            OrgAccount orgAccount = orgAccountDao.getAccountById(tx400Phone.getOrgId());
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(tx400Phone.getOrgId());
            return buildReceiver(orgInfo, orgAccount.getNumber().longValue());
        }
        return null;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(OrgPushCallInfo msg, Long consultUserId) {
        log.info("[OrgPushCallInfo] callInfo=" + msg);
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(MessageSource.TELEPHONE.getValue());
        pushMsg.setCreateTime(msg.getStartTime());
        String url = "";
        int len = 0;
        CardMsgContent content = null;
        if (msg.getStatus().equals(OrgCallStatus.CONNECTED.getCode())) {
            if (msg.getStorageId() != null && msg.getStorageId() > 0) {
                OrgStorage storage = storageDao.getById(msg.getStorageId());
                url = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
            }
            len = msg.getDuringTime();
            content = CardContentFactory.createTelephoneCard("已接听", url, len, msg.getStorageId(), msg.getId());
        } else {
            content = CardContentFactory.createTelephoneCard("未接听", "", 0, null, null);
        }
        content.setAction(ActionUtil.getTelephoneAction(consultUserId, msg.getCustomerNumber()));
        Gson gson = new Gson();
        pushMsg.setContent(gson.toJson(content));
        pushMsg.setMsgType(MsgType.CARD.getValue());
        return pushMsg;
    }

    @Override
    public MessageSource getConsultType() {
        return MessageSource.TELEPHONE;
    }

    @Override
    public boolean consume(OrgPushCallInfo callInfo) {
        if (callInfo == null) {
            throw new IllegalArgumentException(" call info is illegal");
        }

        if(StringUtils.isBlank(callInfo.getExtention())){
            log.warn("No Extention.callInfo={}",callInfo);
            return true;
        }

        MsgUser receiver = buildOrgMsgUser(callInfo.getExtention());
        if (receiver == null) {
            return false;
        }
        MsgUser sender = builderSender(receiver.getUserId(), callInfo);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip org 400 call msg:{},skip", sender, receiver, callInfo);
            return false;
        }
        ConsultMessage msgContent = buildPushMessageContent(callInfo, sender.getUserId());
        log.info("consume org call msg sender:{},receiver:{},msgContent:{}", sender.getName(), receiver, msgContent);

        Integer cascadeId = null;

        TXCascadeCredential credential = credentialDao.getByMobile(callInfo.getConnectedNumber());
        if (credential != null) {
            TXCascadeAccount cascadeAccount = cascadeAccountDao.getByCredentialIdAndOrgId(receiver.getUserId().intValue(), credential.getId());
            if (cascadeAccount != null) {
                cascadeId = cascadeAccount.getId();
            }
        } else {
            OrgAccount account = orgAccountDao.getAccountByMobile(callInfo.getConnectedNumber());
            if (account != null) {
                cascadeId = 0;
            }
        }

        boolean result = consultMessageService.sendConsultMessage(sender, receiver, msgContent, cascadeId);
        log.info("push org 400 call msg:{},sender:{},receiver:{},result:{}", msgContent, sender, receiver, result);

        return result;
    }

    @Override
    public OrgPushCallInfo transfer(String body) {
        if (StringUtils.isBlank(body)) {
            return null;
        }
        try {
            return JacksonUtil.str2Obj(body, OrgPushCallInfo.class);
        } catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", body, e);
            return null;

        }
    }

    private void buildComment(TxConsultUser consultUser, OrgPushCallInfo callInfo, boolean isNewStudent) {
        log.info("buildComment--------consultUser={},callInfo={}", consultUser.toString(), callInfo);
        TxStudentComment comment = new TxStudentComment();

        if (callInfo.getStatus().intValue() == OrgCallStatus.CONNECTED.getCode()) {
            if (null != callInfo.getStorageId() && callInfo.getStorageId() > 0) {
                comment.setSoundId(callInfo.getStorageId());
                comment.setDownStatus(DownLoadStatus.FINISH.getCode());
            } else {
                comment.setSoundId(callInfo.getId());
                comment.setDownStatus(DownLoadStatus.UNFINISH.getCode());
            }
            comment.setSeconds(callInfo.getDuringTime());
        }
        comment.setCallStatus(callInfo.getStatus());
        comment.setIsMobile(MobileStatus.IS_400_CALL.getCode());
        comment.setIsSystem(AddType.SYSTEM.getCode());
        comment.setConsultUserId(consultUser.getId());
        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setOrigin(this.getConsultType().getValue());
        if (isNewStudent) {
            comment.setContent("系统添加了客户: " + (StringUtils.isNotBlank(consultUser.getName()) ? consultUser.getName()
                    : TianXiaoConstant.ANONYMOUS_CONSULT_USER) + "\n");
        } else {
            comment.setContent("");
        }
        this.txStudentCommentDao.save(comment, false);
    }
}
