package com.baijia.tianxiao.biz.consult.msg.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.consult.dto.response.ActivityInfo;
import com.baijia.tianxiao.biz.consult.msg.service.BizActivityService;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/5/21.
 */
@Service("consutBizActivityServiceImpl")
@Slf4j
public class BizActivityServiceImpl implements BizActivityService {

    @Autowired
    private CustomActivityService customActivityService;
    @Autowired
    private TxActivityCommonDao activityCommonDao;

    @Override
    public List<ActivityInfo> getAllActivities(long orgId) {
        List<ActivityInfo> ret = new ArrayList<>();

        List<TxActivityCommon> list = activityCommonDao.selectUnEndedActivityList(orgId);
        if (list != null) {
            for (TxActivityCommon activity : list) {
                ActivityInfo instance = ActivityInfo.getInstance(activity,
                    TemplateConstant.getMap().get(activity.getTemplateId().intValue()));
                instance.setUrl(getUrl(activity.getTemplateId(), activity.getActivityId()));
                ret.add(instance);
            }
        }
        log.info("find all marketing activityList : {} ", ret);
        return ret;
    }

    private String getWechatUrl(long activityId, int templateId) {
        log.info("[param] activityId=" + activityId + ";templateId=" + templateId);
        CustomActivityDto dto = customActivityService.getCustomActivity((int) activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        } else {
            return "";
        }
    }

    private String getUrl(long templateId, long activityId) {
        StringBuilder sb = new StringBuilder();
        String url = TemplateConstant.getTemplateUrl((int) templateId);
        sb.append(Config.DOMAIN);
        sb.append(url).append("&activityId=").append(activityId).append("#!/");
        return sb.toString();
    }
}
