package com.baijia.tianxiao.biz.consult.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/6/4
 * Time: 下午5:33
 * To change this template use File | Settings | File Templates.
 */
public enum GenderStatus {

    MAN(0, "男"),

    FEMAN(1, "女"),

    NONE(-1, "");

    private Integer code;
    private String name;

    private static Map<Integer, GenderStatus> map = new HashMap<>();

    static {
        for (GenderStatus genderStatus : GenderStatus.values()) {
            map.put(genderStatus.code, genderStatus);
        }
    }

    GenderStatus(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getGenderStr(int code) {
        GenderStatus genderStatus = map.get(code);
        return genderStatus == null ? GenderStatus.MAN.getName() : genderStatus.getName();
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
