/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @title ConsultErrorCode
 * @desc TODO
 * @author cxm
 * @date 2015年12月9日
 * @version 1.0
 */
public enum ConsultErrorCode implements UniverseErrorCode {

    ;

    private int code;
    private String message;

    private ConsultErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    @Override
    public Subsystem getSystem() {
        return Subsystem.CONSULT;
    }

    @Override
    public Platform getPlatform() {
        return Platform.PC;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (ConsultErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommonErrorCode.UNKNOW;
    }

}
