
package com.baijia.tianxiao.biz.consult.dto.response;

import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.sal.push.dto.MsgUser;

import lombok.Setter;

public class OrgMsgUser implements MsgUser {

    private Long orgId;

    private Long orgNumber;

    @Setter
    private MsgUserRole consultType;

    @Setter
    private String mobile;

    @Setter
    private String name;

    @Setter
    private int intensionLevel;

    private Long subAccountId;

    public OrgMsgUser(Long orgId, Long orgNumber) {
        this.orgId = orgId;
        this.orgNumber = orgNumber;
    }

    @Override
    public Long getUserId() {
        return orgId;
    }

    @Override
    public Long getNumber() {
        return orgNumber;
    }

    @Override
    public UserRoleEnum getRole() {
        return UserRoleEnum.ORG;
    }

    @Override
    public MsgUserRole getMsgUserRole() {
        return consultType;
    }

    @Override
    public int getIntentLevel() {
        return intensionLevel;
    }

    @Override
    public String getMobile() {
        return mobile;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Long getCascadeId() {
        return subAccountId;
    }

    public void setSubAccountId(Long subAccountId) {
        this.subAccountId = subAccountId;
    }
}
