/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.dto.response;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import com.google.common.base.Preconditions;

import org.apache.commons.lang3.StringUtils;

import java.util.Map;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * @title ResponseDto
 * @desc TODO
 * @author cxm
 * @date 2015年12月7日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@NoArgsConstructor
public class MapResponseDto extends WebResponse<Map<String, Object>> {
    private static final long serialVersionUID = 289735412752693725L;

    private PageDto pageDto;

    public void addResponseData(String key, Object value) {
        Preconditions.checkArgument(StringUtils.isNoneBlank(key), "key is blank");
    }

    public MapResponseDto(Map<String, Object> data) {
        super(data);
    }

    public MapResponseDto(UniverseErrorCode errorCode, String msg) {
        super(errorCode, msg);
    }

    public MapResponseDto(UniverseErrorCode errorCode) {
        super(errorCode);
    }

}
