/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.dto.response;


import com.baijia.tianxiao.dal.callservice.constant.ConsultCallRecordManner;
import com.baijia.tianxiao.dal.callservice.constant.ConsultCallRecordStatus;

import lombok.Data;

@Data
public class ConsultCallRecordDto {
	private Long id;
	private Integer seconds;
	private Integer callStatus;
	private Integer callManner;//呼叫方向: 1,拨出;2,接听；
	private Long soundId;
	private String soundUrl;
	private Long createTime;
	
	private String callMannerStr;
	private String callStatusStr;
	
	public String getCallMannerStr(){
		ConsultCallRecordManner manner = ConsultCallRecordManner.getTypeByCode(callManner);
		if(manner!=null){
			return manner.getMsg();
		}
		return "";
	}
	
	public String getCallStatusStr(){
		ConsultCallRecordStatus status = ConsultCallRecordStatus.getTypeByCode(callStatus.intValue());
		if(status!=null){
			return status.getMsg();
		}
		return "";
	}
}

