/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import com.baijia.tianxiao.biz.consult.dto.request.MergeConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.dto.response.ConsultCallRecordDto;
import com.baijia.tianxiao.biz.consult.dto.response.OrgMsgUser;
import com.baijia.tianxiao.biz.consult.enums.CallUserType;
import com.baijia.tianxiao.biz.consult.enums.ConsulterOutLineType;
import com.baijia.tianxiao.biz.consult.user.dto.ConsultUserInfo;
import com.baijia.tianxiao.biz.consult.user.dto.ConsultUserResponse;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ListConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.CallStudentInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.CampusDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.GetConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.OutLineDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.OwnerDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.SimpleConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.exception.NoAvailableMobileException;
import com.baijia.tianxiao.biz.consult.user.exception.NonConsultUserException;
import com.baijia.tianxiao.biz.consult.user.service.ConsultCustomSourceService;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.callservice.constant.ConsultCallRecordManner;
import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.callservice.po.ConsultCallRecord;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.dal.solr.query.ConsultUserQuery;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.callservice.dto.BidirectionalCallResponse;
import com.baijia.tianxiao.sal.callservice.dto.MakeCallDto;
import com.baijia.tianxiao.sal.callservice.service.CallService;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.SingleChoiceFieldType;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sal.student.enums.ConsultFieldEnum;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultUserServiceImpl
implements ConsultUserService {
    private static final Logger log = LoggerFactory.getLogger(ConsultUserServiceImpl.class);
    @Resource
    private TxConsultUserDao consultUserDao;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private OrgStudentTagService orgStudentTagService;
    @Resource
    private OrgStudentCommentService orgStudentCommentService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCallRecorderDao orgCallRecorderDao;
    @Resource
    private CallService callService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private UserDao userDao;
    @Resource
    private FansDao fansDao;
    @Autowired
    protected ConsultMessageService consultMessageService;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private ConsultUserQuery consultUserQuery;
    @Autowired
    private ConsultCallRecordDao consultCallRecordDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TxCascadeCredentialService credentialService;
    @Autowired
    private ConsultCustomSourceService consultSourceService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private ConsultCustomSourceService consultCustomSourceService;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;
    @Autowired
    private StudentUserService studentUserService;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    private static final Long ONE_DAY_TIME = 86400000L;

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long saveConsultUser(Long orgId, ConsulterRequestDto consulterParam, Boolean keepConsultSource) throws BussinessException {
        List targets;
        TXCascadeAccount account;
        if (StringUtils.isBlank((CharSequence)consulterParam.getMobile())) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)consulterParam.getName())) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (consulterParam.getNextRemindTime() != null && consulterParam.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2037-1-1)\u4e86");
        }
        if (consulterParam.getBirthday() != null && consulterParam.getBirthday() > System.currentTimeMillis()) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u6765\u7684\u60a8\u8fd8\u672a\u51fa\u751f\u5427");
        }
        consulterParam.setOrgId(orgId);
        consulterParam.setCampusOrgId(-1);
        consulterParam.setIsConsulter(Flag.TRUE.getInt());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulterParam.getMobile()})) {
            String mobile = consulterParam.getMobile();
            mobile = mobile.replaceAll("-", "");
            consulterParam.setMobile(mobile);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulterParam.getParentMobile()})) {
            String parentMobile = consulterParam.getParentMobile();
            parentMobile = parentMobile.replaceAll("-", "");
            consulterParam.setParentMobile(parentMobile);
        }
        if (consulterParam.getIntensionLevel() > IntentionLevel.LEVEL_3.getValue()) {
            if (consulterParam.getIntensionLevel() == 3) {
                consulterParam.setIntensionLevel(IntentionLevel.LEVEL_2.getValue());
            } else {
                consulterParam.setIntensionLevel(IntentionLevel.LEVEL_3.getValue());
            }
        }
        if (consulterParam.getCascadeId() != null && consulterParam.getCascadeId() > 0L && (account = this.txCascadeAccountDao.getByIdAndOrgId(Integer.valueOf(consulterParam.getCascadeId().intValue()), Integer.valueOf(orgId.intValue()), new String[0])) == null) {
            consulterParam.setCascadeId(0L);
        }
        Boolean isNewConsultUser = true;
        TxConsultUser consultUser = null;
        if (consulterParam.getConsulterId() != null && consulterParam.getConsulterId() > 0L) {
            isNewConsultUser = false;
        }
        if (isNewConsultUser.booleanValue()) {
            targets = this.consultUserDao.lookByMobile(orgId, consulterParam.getMobile(), new String[0]);
            log.info("doSaveBefore---------consulter={},targets={}", (Object)consulterParam, (Object)targets);
            if (!CollectionUtils.isEmpty((Collection)targets)) {
                OrgStudent student;
                if (targets.size() > 1) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u591a\u6761\u8bb0\u5f55\uff0c\u64cd\u4f5c\u5931\u8d25");
                }
                TxConsultUser dbConsultUser = (TxConsultUser)targets.get(0);
                if (Flag.getBoolean((Integer)dbConsultUser.getIsConsulter())) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u7801\u5bf9\u5e94\u7684\u7ebf\u7d22\u5df2\u5b58\u5728");
                }
                if (dbConsultUser.getStudentId() != null && dbConsultUser.getStudentId() > 0L && (student = (OrgStudent)this.orgStudentDao.getById((Serializable)dbConsultUser.getStudentId(), new String[0])) != null && student.getDelStatus().intValue() == Flag.FALSE.getInt()) {
                    throw new PermissionException("\u8be5\u8bb0\u5f55\u5df2\u8f6c\u4e3a\u6b63\u5f0f\u5b66\u5458,\u4e0d\u5141\u8bb8\u5728\u6b64\u5904\u64cd\u4f5c\u3002");
                }
                consulterParam.setConsulterId(dbConsultUser.getId());
                isNewConsultUser = false;
            }
        }
        if (!isNewConsultUser.booleanValue()) {
            consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterParam.getConsulterId(), new String[0]);
            if (!consulterParam.getMobile().equals(consultUser.getMobile()) && CollectionUtils.isNotEmpty((Collection)(targets = this.consultUserDao.lookByMobile(orgId, consulterParam.getMobile(), new String[0])))) {
                throw new PermissionException("\u64cd\u4f5c\u5931\u8d25\uff0c\u624b\u673a\u53f7\u5df2\u5b58\u5728\u3002");
            }
        }
        if (isNewConsultUser.booleanValue()) {
            consultUser = ConsulterDto.convertToConsultUser(consulterParam);
            consultUser.setManually(Flag.TRUE.getInt());
            consultUser.setCascadeId(Long.valueOf(Flag.NULL.getLong()));
            this.consultUserDao.save((Object)consultUser, new String[0]);
            this.txStudentCommentAPIService.saveByConsultUserManualAdd(consultUser);
            if (consulterParam.getCascadeId() != null && consulterParam.getCascadeId().intValue() != Flag.NULL.getInt()) {
                consultUser = this.pull(orgId, consulterParam.getCascadeId(), consultUser.getId(), false);
            }
        } else {
            String oldMobile = consultUser.getMobile();
            String oldName = consultUser.getName();
            boolean needManualAddComment = false;
            boolean needPull = false;
            if (!Flag.getBoolean((Integer)consultUser.getIsConsulter())) {
                needManualAddComment = true;
                if (consulterParam.getCascadeId() != null && !consultUser.getCascadeId().equals(consulterParam.getCascadeId())) {
                    needPull = true;
                    consultUser.setCascadeId(Long.valueOf(Flag.NULL.getLong()));
                }
            } else if (!consultUser.getCascadeId().equals(consulterParam.getCascadeId())) {
                throw new PermissionException("\u4e0d\u5141\u8bb8\u76f4\u63a5\u4fee\u6539\u7ebf\u7d22\u6240\u5c5e\u4eba");
            }
            if (StringUtils.isNotBlank((CharSequence)consulterParam.getMobile()) && consulterParam.getMobile().contains("*")) {
                consulterParam.setMobile(consultUser.getMobile());
            }
            if (StringUtils.isNotBlank((CharSequence)consulterParam.getParentMobile()) && consulterParam.getParentMobile().contains("*")) {
                consulterParam.setParentMobile(consultUser.getParentMobile());
            }
            if (keepConsultSource != null && keepConsultSource.booleanValue()) {
                Integer oldSource = consultUser.getConsultSource();
                this.copyFrom(consultUser, consulterParam);
                consultUser.setConsultSource(oldSource);
            } else {
                this.copyFrom(consultUser, consulterParam);
            }
            consultUser.setUpdateTime(new Date());
            this.consultUserDao.updateWithDefaultVal((Object)consultUser, new String[0]);
            if (needManualAddComment) {
                this.txStudentCommentAPIService.saveByConsultUserManualAdd(consultUser);
            } else {
                this.txStudentCommentAPIService.saveByMobileChange(consultUser, oldMobile, consultUser.getMobile());
                this.txStudentCommentAPIService.saveByNameChange(consultUser, oldName, consultUser.getName());
            }
            if (needPull) {
                consultUser = this.pull(orgId, consulterParam.getCascadeId(), consultUser.getId(), false);
            }
        }
        this.orgStudentService.updateSysBacklogForConsulter(orgId, consultUser);
        this.setUserTags(orgId, consultUser.getId(), consulterParam.getTags());
        this.updateSolr(consultUser);
        if (consultUser.getCascadeId().intValue() == Flag.NULL.getInt()) {
            String content = NoticeType.getTips((String)consulterParam.getName());
            this.consultMessageService.sendNotice(orgId, Integer.valueOf(-1), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)consultUser.getId()), (String)content));
        }
        log.info("success save consulter :{} into db,return id:{}", (Object)consulterParam.getName(), (Object)consultUser.getId());
        return consultUser.getId();
    }

    private void copyFrom(TxConsultUser user, ConsulterDto dto) {
        if (this.consultSourceService.getConsultSourceStr(Long.parseLong(dto.getConsultSource() + "")) == null) {
            throw new PermissionException("\u7ebf\u7d22\u6765\u6e90\u4e0d\u5408\u6cd5");
        }
        user.setAddress(dto.getAddress());
        user.setBirthday(dto.getBirthday() != null && dto.getBirthday() > 0L ? new Date(dto.getBirthday()) : null);
        user.setConsultSource(Integer.valueOf(dto.getConsultSource()));
        user.setConsultStatus(dto.getConsultStatus());
        user.setDegreeClass(dto.getDegreeClass());
        user.setMail(dto.getMail());
        user.setIntensionLevel(Integer.valueOf(dto.getIntensionLevel()));
        user.setMobile(dto.getMobile());
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0L) {
            user.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            user.setNextRemindTime(null);
        }
        user.setNickName(dto.getNickName());
        user.setParentMobile(dto.getParentMobile());
        user.setParentName(dto.getParentName());
        user.setQq(dto.getQq());
        user.setSchool(dto.getSchool());
        user.setName(dto.getStudentName());
        user.setPortrait(dto.getPortrait());
        user.setRelatives(dto.getRelatives());
        if (dto.getSex() != null) {
            user.setSex(dto.getSex());
        }
        user.setLatitude(dto.getLatitude());
        user.setLongitude(dto.getLongitude());
        user.setCampusOrgId(dto.getCampusOrgId());
        user.setIsConsulter(dto.getIsConsulter());
        user.setAreaId(dto.getAreaId());
    }

    private void sendConsultMessage(TxConsultUser consulterUser, Long orgId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        ConsultMessage message = new ConsultMessage();
        message.setConsultType(MessageSource.INPUT.getValue());
        message.setMsgType(MsgType.TEXT.getValue());
        message.setContent("\u63d0\u9192\u65f6\u95f4:" + TianXiaoConstant.DAY_TIME_FORMAT.format(consulterUser.getNextRemindTime()));
        log.info("send to add consulter msg");
        this.consultMessageService.sendConsultMessage((MsgUser)ConsulterDto.convertToDto(consulterUser), (MsgUser)new OrgMsgUser(orgId, orgAccount.getNumber().longValue()), message);
    }

    private OrgStudentAddresponseDto saveStudent(TxConsultUser consulterUser, Integer confirm, Long orgId, Long cascadeId) {
        log.info("save consulter user:{} into org student", (Object)consulterUser);
        StudentInfoDto dto = this.buildStudentInfoDto(consulterUser, confirm);
        dto.setAddCascadeId(Integer.valueOf(cascadeId == null ? 0 : cascadeId.intValue()));
        OrgStudentAddresponseDto result = this.orgStudentService.addStudent(dto, null, null, orgId);
        return result;
    }

    private void setUserTags(Long orgId, Long consulterId, String tags) {
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            log.debug("save tags :{} into db", (Object)tags);
            try {
                this.orgStudentTagService.delTagsByConsulterId(consulterId, orgId);
                List tagDtos = JacksonUtil.str2List((String)tags, TagInfoDto.class);
                if (!CollectionUtils.isEmpty((Collection)tagDtos)) {
                    this.orgStudentTagService.addStudentTag(tagDtos, Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId);
                }
            }
            catch (Exception e) {
                log.error("save tags:{} catch error:{}", (Object)tags, (Object)e);
            }
        } else {
            this.orgStudentTagService.delTagsByConsulterId(consulterId, orgId);
        }
    }

    private StudentInfoDto buildStudentInfoDto(TxConsultUser user, Integer confirm) {
        StudentInfoDto dto = new StudentInfoDto();
        dto.setAddress(user.getAddress());
        dto.setBirthdayDate(user.getBirthday());
        dto.setDegreeClass(user.getDegreeClass());
        dto.setFatherOccupation(user.getFatherOccupation());
        dto.setMail(user.getMail());
        dto.setMatherOccupation(user.getMatherOccupation());
        dto.setMobile(user.getMobile());
        dto.setName(user.getName());
        dto.setNextRemindTimeDate(user.getNextRemindTime());
        dto.setParentMobile(user.getParentMobile());
        dto.setParentName(user.getParentName());
        dto.setQq(user.getQq());
        dto.setSchool(user.getSchool());
        dto.setStudentId(user.getStudentId());
        dto.setWeixin(user.getWeixinOpenId());
        dto.setConsultUserId(user.getId());
        dto.setStudentNumber(user.getUserNumber());
        dto.setGender(user.getSex());
        dto.setSource(user.getConsultSource());
        dto.setConfirm(confirm);
        dto.setGender(user.getSex());
        dto.setBranchId(Long.valueOf(user.getCampusOrgId().longValue()));
        dto.setRelationship(user.getRelatives());
        dto.setAreaId(user.getAreaId());
        if (StringUtils.isNotBlank((CharSequence)user.getLatitude())) {
            dto.setLatitude(Double.valueOf(Double.parseDouble(user.getLatitude())));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getLongitude())) {
            dto.setLongitude(Double.valueOf(Double.parseDouble(user.getLongitude())));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getPortrait())) {
            List list;
            String portrait = user.getPortrait();
            String fid = OrgStorage.parseFid((String)portrait);
            String sn = OrgStorage.parseSn((String)portrait);
            Integer mimeType = OrgStorage.parseMimetype((String)portrait);
            if (StringUtils.isNotBlank((CharSequence)fid) && StringUtils.isNotBlank((CharSequence)sn) && mimeType != null && CollectionUtils.isNotEmpty((Collection)(list = this.orgStorageDao.list(fid, sn, mimeType)))) {
                dto.setStorageId(Long.valueOf(((OrgStorage)list.get(0)).getId().longValue()));
            }
        }
        return dto;
    }

    @Override
    public ConsulterResponseDto getConsultUser(Long orgId, Long cascadeId, Long consulterId, Integer showComments) throws NonConsultUserException {
        OrgInfo orgInfo;
        OrgCommentsListReponse commentsDto;
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkNotNull((Object)consulterId, (Object)"consult user id can not be null");
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (consultUser == null || !consultUser.getOrgId().equals(orgId)) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_INFO_NO_PERMISSON);
        }
        if (consultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_INFO_NO_PERMISSON);
        }
        if (consultUser.getStudentId() != null && consultUser.getStudentId() > 0L) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_INFO_IS_STUDENT);
        }
        ConsulterResponseDto dto = ConsulterDto.convertToDto(consultUser);
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setStudentName("\u5728\u7ebf\u7559\u5355\u5b66\u751f");
        } else {
            dto.setStudentName(dto.getName());
        }
        if (consultUser.getStudentId() != null && consultUser.getStudentId() > 0L) {
            this.setOrigin(consultUser.getStudentId(), dto);
        } else if (consultUser.getConsultSource().intValue() == MessageSource.ONLINE_IM.getValue()) {
            dto.setOrigin(0);
        } else {
            dto.setOrigin(1);
        }
        OrgTagListResopnseDto tagDto = this.orgStudentTagService.getTags(Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId);
        if (tagDto != null) {
            List tags = tagDto.getTags();
            dto.setTags(tags);
        }
        if (Flag.getBoolean((Integer)showComments) && (commentsDto = this.orgStudentCommentService.getComments(Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId, null)) != null) {
            dto.setComments(commentsDto.getComments());
        }
        if (consultUser.getCampusOrgId() != null && consultUser.getCampusOrgId().intValue() != Flag.NULL.getInt()) {
            Integer campusOrgId = Integer.parseInt(consultUser.getCampusOrgId() + "");
            OrgAccount orgAccount = this.orgAccountDao.getAccountById(campusOrgId.intValue(), new String[0]);
            orgInfo = this.orgInfoDao.getOrgInfo(campusOrgId, new String[0]);
            CampusDto campusDto = new CampusDto();
            campusDto.setOrgNumber(orgAccount.getNumber());
            campusDto.setShortName(orgInfo.getShortName());
            dto.setCampus(campusDto);
        }
        if (consultUser.getCascadeId() != null && consultUser.getCascadeId() != (long)Flag.NULL.getInt()) {
            OwnerDto ownerDto = new OwnerDto();
            if (consultUser.getCascadeId().intValue() == 0) {
                OrgSubAccount orgSubAccount = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()), new String[0]);
                orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
                ownerDto.setName(orgInfo.getShowName());
                ownerDto.setCascadeId(Integer.parseInt(consultUser.getCascadeId() + ""));
                if (orgSubAccount == null) {
                    ownerDto.setUserType(CampusAccountType.MASTER_PRINCIPAL.getCode());
                } else {
                    ownerDto.setUserType(orgSubAccount.getPid().equals(0) ? CampusAccountType.MASTER_PRINCIPAL.getCode() : CampusAccountType.SLAVE_PRINCIPAL.getCode());
                }
            } else {
                TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)consultUser.getCascadeId(), new String[0]);
                TXCascadeCredential txCascadeCredential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)txCascadeAccount.getCredentialId(), new String[0]);
                ownerDto.setName(txCascadeCredential.getName());
                ownerDto.setCascadeId(Integer.parseInt(consultUser.getCascadeId() + ""));
                ownerDto.setUserType(txCascadeAccount.getAccountType());
            }
            dto.setOwner(ownerDto);
        }
        if (consultUser.getIsInvalid().intValue() == Flag.TRUE.getInt()) {
            dto.setConsulterType(ConsulterOutLineType.INVALID.getValue());
        } else if (consultUser.getCascadeId().intValue() == Flag.NULL.getInt()) {
            dto.setConsulterType(ConsulterOutLineType.PUBLISH.getValue());
        } else if (consultUser.getCascadeId().intValue() == cascadeId.intValue()) {
            dto.setConsulterType(ConsulterOutLineType.MINE.getValue());
        } else {
            dto.setConsulterType(ConsulterOutLineType.SUBORDINATE.getValue());
        }
        this.fillByRule(dto, cascadeId);
        boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (!isShow) {
            dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
        }
        this.consulterAPIService.batchSetConsultAvatarUrl(Arrays.asList(consultUser));
        dto.setPortrait(consultUser.getPortrait());
        if (null != dto.getAreaId() && dto.getAreaId() > 0L) {
            Map areaMap = AreaUtils.getAreaNameByCode((Long)dto.getAreaId());
            log.info("\u533a\u57df\u4fe1\u606fareaMap {}", (Object)areaMap);
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
        return dto;
    }

    private void setOrigin(Long studentId, ConsulterResponseDto dto) {
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student != null) {
            dto.setOrigin(student.getOrigin());
        }
    }

    private void fillByRule(ConsulterResponseDto dto, Long cascadeId) {
        Fans fans;
        Long orgId = dto.getOrgId();
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId.intValue()));
        OrgWechatOpenIdRecord record = null;
        record = authorizationInfo == null || authorizationInfo.getAuthorizerAppId().equals(WechatProperties.getWechatAppidForFreeVersion()) ? this.orgWechatOpenIdRecordDao.getBy(WechatProperties.getWechatAppidForFreeVersion(), orgId, dto.getConsulterId(), WechatOpenIdEntityType.CONSULT) : this.orgWechatOpenIdRecordDao.getBy(authorizationInfo.getAuthorizerAppId(), orgId, dto.getConsulterId(), WechatOpenIdEntityType.CONSULT);
        dto.setChat(BizConf.FALSE);
        if (record != null && (fans = this.fansDao.getByOpenId(record.getOpenId())) != null && fans.isSubscribed()) {
            dto.setChat(BizConf.TRUE);
        }
        if (dto.getConsulterType().intValue() == ConsulterOutLineType.PUBLISH.getValue() && cascadeId != 0L) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (CampusAccountType.STAFF.getCode().intValue() == txCascadeAccount.getAccountType().intValue()) {
                if (StringUtils.isNotBlank((CharSequence)dto.getMobile())) {
                    String fmt = "%s****%s";
                    dto.setMobile(String.format(fmt, dto.getMobile().substring(0, 3), dto.getMobile().substring(7, 11)));
                }
                dto.setChat(BizConf.FALSE);
            }
        }
        Integer consulterType = dto.getConsulterType();
        Integer allowToPull = Flag.FALSE.getInt();
        Integer allowToSms = Flag.FALSE.getInt();
        TXCascadeAccount loginer = null;
        if (cascadeId != null && cascadeId > 0L) {
            loginer = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        }
        if (consulterType != null && consulterType.intValue() != ConsulterOutLineType.PUBLISH.getValue()) {
            allowToPull = Flag.FALSE.getInt();
        } else {
            TXSaleClueRule txSaleClueRule;
            allowToPull = Flag.TRUE.getInt();
            boolean permission = false;
            permission = cascadeId != null && cascadeId > 0L ? this.txAccountPermissionService.checkPermission(orgId, Integer.valueOf(cascadeId.intValue()), DeviceType.APP, TXPermissionConst.PERSONAL_CLUES_MANAGEMENT.getpCode()) : this.txAccountPermissionService.checkPermission(orgId, null, DeviceType.APP, TXPermissionConst.PERSONAL_CLUES_MANAGEMENT.getpCode());
            if (!permission) {
                allowToPull = Flag.FALSE.getInt();
            } else if (loginer != null && CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.STAFF && (txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()))).getClueAllot() != 0) {
                allowToPull = Flag.FALSE.getInt();
            }
        }
        dto.setAllowToPull(allowToPull);
        if (consulterType != null && (consulterType.intValue() == ConsulterOutLineType.PUBLISH.getValue() || consulterType.intValue() == ConsulterOutLineType.INVALID.getValue())) {
            allowToSms = Flag.FALSE.getInt();
        } else {
            TXCommonRule txCommonRule;
            allowToSms = Flag.TRUE.getInt();
            if (loginer != null && (CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.DIRECTOR || CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.STAFF) && (txCommonRule = this.txCommonRuleService.getByOrgId(Integer.valueOf(orgId.intValue()))).getStudentMobileRule() == 1) {
                allowToSms = Flag.FALSE.getInt();
            }
        }
        dto.setAllowToSms(allowToSms);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(readOnly=true)
    public GetConsulterInfoResponseDto getExistStudentId(Long orgId, Long consulterId, Long userNumber) throws NonConsultUserException {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkArgument((consulterId != null || userNumber != null ? 1 : 0) != 0, (Object)"user number");
        GetConsulterInfoResponseDto result = new GetConsulterInfoResponseDto();
        if (consulterId != null) {
            TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[]{"orgId", "userId", "mobile", "delStatus", "studentId", "isConsulter"});
            log.debug("consultUser:{}", (Object)consultUser);
            if (consultUser == null || consultUser.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new NonConsultUserException(consulterId);
            if (null != consultUser.getStudentId() && consultUser.getStudentId() > 0L) {
                result.setStudentId(consultUser.getStudentId());
            } else {
                Long userId = consultUser.getUserId();
                if (userId != null && userId > 0L) {
                    OrgStudent orgStudent = this.orgStudentDao.getStudentByUserId(orgId, userId, new String[]{"id", "userId", "delStatus"});
                    log.info("getExistStudentId-----orgStudent={}", (Object)orgStudent);
                    if (null != orgStudent && orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                        result.setStudentId(orgStudent.getId());
                        consultUser.setStudentId(orgStudent.getId());
                    }
                }
            }
            result.setConsultUserId(consulterId);
            result.setUserRole(this.getUserRole(consultUser));
            return result;
        } else {
            if (userNumber == null) return result;
            User user = this.userDao.getByNumber(userNumber, new String[]{"id", "mobile"});
            if (user == null) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65e0\u6cd5\u67e5\u8be2\u5230\u5e73\u53f0\u7528\u6237,\u7528\u6237\u8868\u793a:" + userNumber);
            List list = this.consultUserDao.lookByUserId(orgId, user.getId(), new String[]{"id", "studentId"});
            log.info("getExistStudentId------List<TxConsultUser> list={}", (Object)list);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxConsultUser consulter = (TxConsultUser)list.get(0);
                if (null != consulter.getStudentId() && consulter.getStudentId() > 0L) {
                    result.setStudentId(consulter.getStudentId());
                }
                result.setConsultUserId(consulter.getId());
                return result;
            } else {
                OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, user.getId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[]{"id", "userId", "delStatus"});
                log.info("getExistStudentId-----orgStudent={}", (Object)orgStudent);
                if (null == orgStudent) return result;
                result.setStudentId(orgStudent.getId());
                result.setUserRole(MsgUserRole.STUDENT.getValue());
            }
        }
        return result;
    }

    public Integer getUserRole(TxConsultUser user) {
        OrgStudent orgStudent;
        MsgUserRole userType = null;
        if (user.getStudentId() != null && user.getStudentId() > 0L) {
            userType = MsgUserRole.STUDENT;
        } else if (user.getUserId() != null && user.getUserId() > 0L && (orgStudent = this.orgStudentDao.getStudent(user.getOrgId(), user.getUserId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0])) != null) {
            userType = MsgUserRole.STUDENT;
            user.setStudentId(orgStudent.getId());
        }
        if (userType == null) {
            userType = user.getIsConsulter() == 1 ? MsgUserRole.CLUE : MsgUserRole.CONSULT;
        }
        return userType.getValue();
    }

    @Override
    @Transactional(readOnly=true)
    public List<SimpleConsulterInfoResponseDto> searchConsulterInfos(Integer type, Long orgId, ListConsulterRequestDto request, PageDto pageDto) {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        if (request == null) {
            request = new ListConsulterRequestDto();
        }
        boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List<TxConsultUser> users = this.queryResult(type, orgId, request, pageDto);
        if (CollectionUtils.isNotEmpty(users)) {
            ArrayList result = Lists.newArrayList();
            HashSet<Long> studentIds = new HashSet<Long>();
            for (TxConsultUser user : users) {
                if (user.getStudentId() != null && user.getStudentId() > 0L) {
                    studentIds.add(user.getStudentId());
                }
                result.add(this.buildSimpleConsultInfo(user));
            }
            if (null == type || null != type && 1 == type) {
                Map<Long, OrgStudent> cache = this.getAndCacheStudents(studentIds);
                for (SimpleConsulterInfoResponseDto dto : result) {
                    OrgStudent stu;
                    Long studentId = dto.getStudentId();
                    if (studentId == null || studentId <= 0L || (stu = cache.get(studentId)) == null) continue;
                    dto.setStudentId(stu.getId());
                    if (StringUtils.isBlank((CharSequence)stu.getName())) {
                        if (StringUtils.isNotEmpty((CharSequence)stu.getNickName())) {
                            dto.setName(stu.getNickName());
                        } else {
                            dto.setName(MaskUtil.maskMobile((String)stu.getMobile()));
                        }
                    } else {
                        dto.setStudentName(stu.getName());
                    }
                    String mobile = stu.getMobile();
                    if (!isShow) {
                        dto.setMobile(MaskUtil.maskMobile((String)mobile));
                        continue;
                    }
                    dto.setMobile(mobile);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    @DataAuthority(resourceTypes={RequestSourceDesc.CONSULT_LIST})
    private List<TxConsultUser> queryResult(Integer type, Long orgId, ListConsulterRequestDto request, PageDto pageDto) {
        log.info("ListConsulterRequestDto is : {} ", (Object)request);
        HashSet consultSources = Sets.newHashSet();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getConsultSources()})) {
            for (String consultSource : StringUtils.splitByWholeSeparator((String)request.getConsultSources(), (String)",")) {
                if (!StringUtils.isNumeric((CharSequence)consultSource)) {
                    log.warn("error consult course :{},ignore condition", (Object)consultSource);
                    continue;
                }
                consultSources.add(Integer.parseInt(consultSource));
            }
        } else if (request.getConsultSource() != null) {
            consultSources.add(request.getConsultSource());
        }
        Integer txCascadeId = TianxiaoMContext.getTXCascadeId();
        if (RequestSourceDesc.CONSULT_LIST.canAccess("queryResult", this.getClass(), new Class[]{Integer.class, Long.class, ListConsulterRequestDto.class, PageDto.class})) {
            txCascadeId = null;
        }
        List users = this.consultUserDao.search(type, request.getKey(), orgId, txCascadeId, request.getIntensionLevel(), (Collection)consultSources, request.getStartTime(), request.getEndTime(), pageDto, new String[0]);
        log.info("query size is : {} ", (Object)users.size());
        return users;
    }

    private Map<Long, OrgStudent> getAndCacheStudents(Set<Long> studentIds) {
        List students;
        Map studentMap = Maps.newHashMap();
        if (studentIds != null && !studentIds.isEmpty() && (students = this.orgStudentDao.getByIds(studentIds, new String[]{"id", "name", "nickName", "mobile", "showMobile"})) != null && !students.isEmpty()) {
            studentMap = CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

                public Long apply(OrgStudent input) {
                    return input.getId();
                }
            });
        }
        return studentMap;
    }

    private SimpleConsulterInfoResponseDto buildSimpleConsultInfo(TxConsultUser user) {
        SimpleConsulterInfoResponseDto dto = new SimpleConsulterInfoResponseDto();
        if (user.getConsultSource().intValue() == MessageSource.MARKING.getValue()) {
            dto.setConsultType(MessageSource.ONLINE_IM);
        } else {
            dto.setConsultType(MessageSource.getByType((Integer)user.getConsultSource()));
        }
        dto.setConsultUserId(user.getId());
        dto.setIntensionLevel(user.getIntensionLevel());
        dto.setMobile(user.getMobile());
        dto.setName(StringUtils.isNotBlank((CharSequence)user.getName()) ? user.getName() : "\u5728\u7ebf\u7559\u5355\u5b66\u751f");
        dto.setNumber(user.getUserNumber());
        dto.setStudentId(user.getStudentId());
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CallStudentInfoResponseDto getCallStudentInfoByMobile(Long consulterId, String mobile, Long orgId) throws NonConsultUserException {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile is illegal");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"org id is illegal");
        Preconditions.checkArgument((consulterId != null && consulterId > 0L ? 1 : 0) != 0, (Object)"consulter id is illegal");
        CallStudentInfoResponseDto result = new CallStudentInfoResponseDto();
        result.setMobile(mobile);
        TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[]{"id", "name", "weixinNickName", "mobile", "orgId"});
        if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
            throw new NonConsultUserException(consulterId);
        }
        result.setConsulterId(user.getId());
        mobile = user.getMobile();
        result.setStudentName(user.getName());
        OrgInfo info = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"extension"});
        Preconditions.checkArgument((info != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.getExtension()}) ? 1 : 0) != 0, (Object)"\u673a\u6784\u5206\u673a\u53f7\u672a\u5206\u914d");
        OrgCommentsListReponse commentResp = null;
        Map callInfo = this.orgCallRecorderDao.queryCallCountAndTime(mobile, info.getExtension());
        log.debug("query call info by mobile:{},orgId:{},result:{}", new Object[]{mobile, orgId, callInfo});
        if (callInfo != null) {
            String cntKey = "CNT_id";
            Number count = (Number)callInfo.get(cntKey);
            if (count != null) {
                result.setCallCount(count.intValue());
            }
            result.setLastCallTime((Date)callInfo.get("MAX_TIME"));
        }
        OrgStudent orgStudent = null;
        if (user.getStudentId() != null && user.getStudentId() > 0L && ((orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)user.getStudentId(), new String[0])) == null || orgStudent.getOrgId().longValue() != orgId.longValue() && orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue())) {
            orgStudent = null;
        }
        if (orgStudent != null) {
            result.setStudentId(orgStudent.getId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgStudent.getName()})) {
                result.setStudentName(orgStudent.getName());
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgStudent.getNickName()})) {
                result.setStudentName(orgStudent.getNickName());
            }
            commentResp = this.orgStudentCommentService.getComments(Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), orgStudent.getId(), orgId, Integer.valueOf(Flag.FALSE.getInt()));
            if (commentResp != null && CollectionUtils.isNotEmpty((Collection)commentResp.getComments())) {
                log.debug("student comment info:{}", (Object)commentResp);
                result.setComments(commentResp.getComments());
            }
        } else {
            commentResp = this.orgStudentCommentService.getComments(Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId, Integer.valueOf(Flag.FALSE.getInt()));
            if (commentResp != null && CollectionUtils.isNotEmpty((Collection)commentResp.getComments())) {
                log.debug("consulter comment info:{}", (Object)commentResp);
                result.setComments(commentResp.getComments());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public BidirectionalCallResponse callStudent(Long consulterId, Long studentId, String subscriberTel, CallUserType userType, Long orgId) throws NonConsultUserException {
        Preconditions.checkArgument((consulterId != null && consulterId > 0L || studentId != null && studentId > 0L ? 1 : 0) != 0, (Object)"consulter user id or student id at least have one value");
        Preconditions.checkArgument((userType != null ? 1 : 0) != 0, (Object)"user type is illegal");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"org id is illegal.");
        MakeCallDto makeCall = new MakeCallDto();
        if (consulterId != null) {
            TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[]{"userId", "id", "orgId", "mobile", "parentMobile"});
            if (user == null || !user.getOrgId().equals(orgId)) {
                throw new NonConsultUserException(consulterId);
            }
            if (StringUtils.isBlank((CharSequence)user.getMobile()) && user.getUserId() == 0L) {
                log.warn("no cdb user exist and no consulter mobile:{}", (Object)user);
                throw new NoAvailableMobileException(consulterId);
            }
            if (user.getUserId() != null && user.getUserId() > 0L) {
                makeCall.setCalledUserId(user.getUserId());
            } else {
                makeCall.setCalledUserId(CallService.ANONYMOUS_USER_ID);
            }
            if (userType.equals((Object)CallUserType.Parent)) {
                if (StringUtils.isBlank((CharSequence)user.getParentMobile())) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u8bbe\u7f6e\u54a8\u8be2\u5ba2\u6237\u5bb6\u957f\u8054\u7cfb\u7535\u8bdd");
                }
                makeCall.setCalledUserMobile(user.getParentMobile());
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{user.getMobile()})) {
                makeCall.setCalledUserMobile(user.getMobile());
            }
        } else {
            OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[]{"userId", "orgId", "mobile", "parentMobile"});
            if (orgStudent == null || !orgStudent.getOrgId().equals(orgId)) {
                throw new NonConsultUserException(studentId);
            }
            makeCall.setCalledUserId(orgStudent.getUserId());
            if (userType.equals((Object)CallUserType.Parent)) {
                if (StringUtils.isBlank((CharSequence)orgStudent.getParentMobile())) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u8bbe\u7f6e\u82b1\u540d\u518c\u5b66\u751f\u5bb6\u957f\u8054\u7cfb\u7535\u8bdd");
                }
                makeCall.setCalledUserMobile(orgStudent.getParentMobile());
            } else {
                String mobile = orgStudent.getStudentMobile();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile})) {
                    makeCall.setCalledUserMobile(mobile);
                }
            }
        }
        makeCall.setSubscriberUserId(orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{subscriberTel})) {
            makeCall.setSubscriberMobile(subscriberTel);
        }
        log.info("submit call student request:{}", (Object)makeCall);
        BidirectionalCallResponse res = this.callService.bidirectionalCall(makeCall);
        return res;
    }

    @Override
    @Transactional(readOnly=true)
    public ConsulterDto getConsultUserBaseInfo(Long orgId, Long consulterId) throws NonConsultUserException {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkNotNull((Object)consulterId, (Object)"consult user id can not be null");
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (consultUser == null || !consultUser.getOrgId().equals(orgId)) {
            throw new NonConsultUserException(consulterId);
        }
        ConsulterResponseDto dto = ConsulterDto.convertToDto(consultUser);
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setStudentName("\u5728\u7ebf\u7559\u5355\u5b66\u751f");
        } else {
            dto.setStudentName(dto.getName());
        }
        boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        if (!isShow) {
            dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeCosulter(MergeConsulterRequestDto param, Long orgId, Long cascadeId) throws BussinessException {
        if (cascadeId == null) {
            cascadeId = 0L;
        }
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        this.paramValidator(param);
        TxConsultUser sourceConsultUser = this.consultUserDao.getOrgConsultUser(orgId, param.getSourceConsulter());
        log.info("ConsultUserServiceImpl:mergeCosulter-------sourceConsultUser={}", (Object)sourceConsultUser);
        if (sourceConsultUser == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u539f\u59cb\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728");
        }
        TxConsultUser destConsultUser = this.consultUserDao.getOrgConsultUser(orgId, param.getDestConsulter());
        log.info("ConsultUserServiceImpl:mergeCosulter-------destConsultUser={}", (Object)destConsultUser);
        if (destConsultUser == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u76ee\u6807\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728");
        }
        OrgStudent student = this.getAndSetStudentId(param, orgId, destConsultUser);
        log.info("ConsultUserServiceImpl:mergeCosulter-------student={}", (Object)student);
        this.orgStudentTagService.mergeTags(sourceConsultUser, destConsultUser, orgId);
        this.orgStudentCommentService.mergeCommentRecord(sourceConsultUser, destConsultUser, orgId);
        this.deleteSourceConsult(sourceConsultUser);
        this.updateConsultSouce(sourceConsultUser, destConsultUser);
        this.mergeStudentInfo(param, sourceConsultUser, destConsultUser, orgId, student, cascadeId);
        this.updateSolr(sourceConsultUser);
        this.updateSolr(destConsultUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OrgStudent getAndSetStudentId(MergeConsulterRequestDto param, Long orgId, TxConsultUser destConsultUser) throws BussinessException {
        OrgStudent student = null;
        Long studentId = param.getStudentId();
        if (param.getStudentId() == null || param.getStudentId() <= 0L) return student;
        if (studentId == null || studentId == 0L) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, "\u65e0\u6743\u5408\u5e76\u8be5\u5b66\u751f");
        student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getOrgId().longValue() != orgId.longValue()) throw new BussinessException((UniverseErrorCode)CommonErrorCode.UNKNOW, "\u5b66\u751f\u4e0d\u5b58\u5728");
        destConsultUser.setUserId(student.getUserId());
        destConsultUser.setStudentId(student.getId());
        return student;
    }

    private void mergeStudentInfo(MergeConsulterRequestDto param, TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId, OrgStudent student, Long cascadeId) {
        if (param.getStudentId() != null && param.getStudentId() > 0L) {
            this.getAndSetStudent(param, orgId, destConsultUser.getUserId(), student, sourceConsultUser, destConsultUser.getConsultSource());
        }
        this.updateDestConsultUser(destConsultUser, param, sourceConsultUser, cascadeId);
        this.updateDestConsultUserCustomFiled(orgId, destConsultUser, sourceConsultUser);
    }

    private void getAndSetStudent(MergeConsulterRequestDto param, Long orgId, Long userId, OrgStudent student, TxConsultUser sourceConsultUser, Integer consultSource) {
        if (student != null) {
            log.debug("from student:{}", (Object)student);
            student.setAddress(this.mergeProperties(sourceConsultUser.getAddress(), student.getAddress()));
            student.setDegreeClass(this.mergeProperties(sourceConsultUser.getDegreeClass(), student.getDegreeClass()));
            student.setFatherOccupation(this.mergeProperties(sourceConsultUser.getFatherOccupation(), student.getFatherOccupation()));
            student.setMatherOccupation(this.mergeProperties(sourceConsultUser.getMatherOccupation(), student.getMatherOccupation()));
            student.setName(this.mergeProperties(sourceConsultUser.getName(), student.getName()));
            student.setNextRemindTime(this.mergeProperties(sourceConsultUser.getNextRemindTime(), student.getNextRemindTime()));
            student.setParentName(this.mergeProperties(sourceConsultUser.getParentName(), student.getParentName()));
            student.setParentMobile(this.mergeProperties(sourceConsultUser.getParentMobile(), student.getParentMobile()));
            student.setBirthday(this.mergeProperties(sourceConsultUser.getBirthday(), student.getBirthday()));
            student.setSchool(this.mergeProperties(sourceConsultUser.getSchool(), student.getSchool()));
            student.setShowMobile(this.mergeProperties(sourceConsultUser.getMobile(), student.getMobile()));
            if ((student.getGender() == null || student.getGender() < 0) && sourceConsultUser.getSex() != null) {
                student.setGender(sourceConsultUser.getSex());
            }
            student.setQq(this.mergeProperties(sourceConsultUser.getQq(), student.getQq()));
            if ((student.getRelationship() == null || student.getRelationship() < 0) && sourceConsultUser.getRelatives() != null) {
                student.setRelationship(sourceConsultUser.getRelatives());
            }
            student.setMail(this.mergeProperties(sourceConsultUser.getMail(), student.getMail()));
            if ((student.getBranchId() == null || student.getBranchId() == 0L) && sourceConsultUser.getCampusOrgId() != null && sourceConsultUser.getCampusOrgId() > 0) {
                student.setBranchId(Long.valueOf(sourceConsultUser.getCampusOrgId().longValue()));
            }
            if ((student.getAvatar() == null || student.getAvatar() == 0L) && StringUtils.isNotBlank((CharSequence)sourceConsultUser.getPortrait()) && StringUtils.isNotBlank((CharSequence)sourceConsultUser.getPortrait())) {
                List list;
                String portrait = sourceConsultUser.getPortrait();
                String fid = OrgStorage.parseFid((String)portrait);
                String sn = OrgStorage.parseSn((String)portrait);
                Integer mimeType = OrgStorage.parseMimetype((String)portrait);
                if (StringUtils.isNotBlank((CharSequence)fid) && StringUtils.isNotBlank((CharSequence)sn) && mimeType != null && CollectionUtils.isNotEmpty((Collection)(list = this.orgStorageDao.list(fid, sn, mimeType)))) {
                    student.setAvatar(Long.valueOf(((OrgStorage)list.get(0)).getId().longValue()));
                }
            }
            if (StringUtils.isBlank((CharSequence)student.getWeixin()) && StringUtils.isNotBlank((CharSequence)sourceConsultUser.getWeixinOpenId())) {
                student.setWeixin(sourceConsultUser.getWeixinOpenId());
            }
            log.debug("to student:{}", (Object)student);
            if (consultSource != null) {
                student.setSource(consultSource);
                if (consultSource.intValue() == MessageSource.ONLINE_IM.getValue()) {
                    student.setOrigin(Integer.valueOf(0));
                } else {
                    student.setOrigin(Integer.valueOf(1));
                }
            } else {
                student.setOrigin(Integer.valueOf(1));
            }
            this.orgStudentDao.update((Object)student, Boolean.valueOf(false), new String[0]);
        }
    }

    private void updateConsultSouce(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser) {
        if (sourceConsultUser.getCreateTime().before(destConsultUser.getCreateTime())) {
            destConsultUser.setConsultSource(sourceConsultUser.getConsultSource());
        }
    }

    void updateDestConsultUser(TxConsultUser destConsultUser, MergeConsulterRequestDto param, TxConsultUser sourceConsultUser, Long cascadeId) {
        destConsultUser.setAddress(this.mergeProperties(sourceConsultUser.getAddress(), destConsultUser.getAddress()));
        if (destConsultUser.getBirthday() == null && sourceConsultUser.getBirthday() != null) {
            destConsultUser.setBirthday(sourceConsultUser.getBirthday());
        }
        if ((destConsultUser.getConsultStatus() == null || destConsultUser.getConsultStatus() < 0) && sourceConsultUser.getConsultStatus() != null) {
            destConsultUser.setConsultStatus(sourceConsultUser.getConsultStatus());
        }
        destConsultUser.setDegreeClass(this.mergeProperties(sourceConsultUser.getDegreeClass(), destConsultUser.getDegreeClass()));
        destConsultUser.setFatherOccupation(this.mergeProperties(sourceConsultUser.getFatherOccupation(), destConsultUser.getFatherOccupation()));
        if ((destConsultUser.getIntensionLevel() == null || destConsultUser.getIntensionLevel() < 0) && sourceConsultUser.getSex() != null) {
            destConsultUser.setIntensionLevel(sourceConsultUser.getIntensionLevel());
        }
        destConsultUser.setMatherOccupation(this.mergeProperties(sourceConsultUser.getMatherOccupation(), destConsultUser.getMatherOccupation()));
        destConsultUser.setMobile(this.mergeProperties(sourceConsultUser.getMobile(), destConsultUser.getMobile()));
        destConsultUser.setNextRemindTime(this.mergeProperties(sourceConsultUser.getNextRemindTime(), destConsultUser.getNextRemindTime()));
        destConsultUser.setParentName(this.mergeProperties(sourceConsultUser.getParentName(), destConsultUser.getParentName()));
        destConsultUser.setParentMobile(this.mergeProperties(sourceConsultUser.getParentMobile(), destConsultUser.getParentMobile()));
        destConsultUser.setSchool(this.mergeProperties(sourceConsultUser.getSchool(), destConsultUser.getSchool()));
        destConsultUser.setName(this.mergeProperties(sourceConsultUser.getName(), destConsultUser.getName()));
        destConsultUser.setWeixin(this.mergeProperties(sourceConsultUser.getWeixin(), destConsultUser.getWeixin()));
        destConsultUser.setWeixinAppId(this.mergeProperties(sourceConsultUser.getWeixinAppId(), destConsultUser.getWeixinAppId()));
        destConsultUser.setWeixinNickName(this.mergeProperties(sourceConsultUser.getWeixinNickName(), destConsultUser.getWeixinNickName()));
        destConsultUser.setWeixinOpenId(this.mergeProperties(sourceConsultUser.getWeixinOpenId(), destConsultUser.getWeixinOpenId()));
        destConsultUser.setPortrait(this.mergeProperties(sourceConsultUser.getPortrait(), destConsultUser.getPortrait()));
        if ((destConsultUser.getSex() == null || destConsultUser.getSex() < 0) && sourceConsultUser.getSex() != null) {
            destConsultUser.setSex(sourceConsultUser.getSex());
        }
        destConsultUser.setIsInvalid(Integer.valueOf(Flag.FALSE.getInt()));
        destConsultUser.setReasonForInvalid("");
        destConsultUser.setFinallyHoldTime(this.mergeProperties(sourceConsultUser.getFinallyHoldTime(), destConsultUser.getFinallyHoldTime()));
        destConsultUser.setLastPullTime(this.mergeProperties(sourceConsultUser.getLastPullTime(), destConsultUser.getLastPullTime()));
        destConsultUser.setLastPushTime(this.mergeProperties(sourceConsultUser.getLastPushTime(), destConsultUser.getLastPushTime()));
        destConsultUser.setLastInvalidTime(this.mergeProperties(sourceConsultUser.getLastInvalidTime(), destConsultUser.getLastInvalidTime()));
        destConsultUser.setLastBrowseTime(this.mergeProperties(sourceConsultUser.getLastBrowseTime(), destConsultUser.getLastBrowseTime()));
        destConsultUser.setLastRemindTime(this.mergeProperties(sourceConsultUser.getLastRemindTime(), destConsultUser.getLastRemindTime()));
        destConsultUser.setQq(this.mergeProperties(sourceConsultUser.getQq(), destConsultUser.getQq()));
        if ((destConsultUser.getRelatives() == null || destConsultUser.getRelatives() < 0) && sourceConsultUser.getRelatives() != null) {
            destConsultUser.setRelatives(sourceConsultUser.getRelatives());
        }
        if ((destConsultUser.getConsultSource() == null || destConsultUser.getConsultSource() < 0) && sourceConsultUser.getConsultSource() != null) {
            destConsultUser.setConsultSource(sourceConsultUser.getConsultSource());
        }
        destConsultUser.setMail(this.mergeProperties(sourceConsultUser.getMail(), destConsultUser.getMail()));
        destConsultUser.setCascadeId(cascadeId);
        this.consultUserDao.update((Object)destConsultUser, new String[0]);
    }

    void updateDestConsultUserCustomFiled(Long orgId, TxConsultUser destConsultUser, TxConsultUser sourceConsultUser) {
        Date now = new Date();
        Map destMap = this.customFieldValueService.mapFieldValues(orgId, false, destConsultUser.getId());
        Map sourceMap = this.customFieldValueService.mapFieldValues(orgId, false, sourceConsultUser.getId());
        if (MapUtils.isNotEmpty((Map)sourceMap)) {
            ArrayList<CustomFieldValue> listAdd = new ArrayList<CustomFieldValue>();
            CustomFieldValue destValue = null;
            CustomFieldValue sourceValue = null;
            for (Long fieldId : sourceMap.keySet()) {
                destValue = (CustomFieldValue)destMap.get((long)fieldId);
                sourceValue = (CustomFieldValue)sourceMap.get((long)fieldId);
                if (destValue != null || sourceValue == null) continue;
                destValue = new CustomFieldValue();
                destValue.setId(null);
                destValue.setCreateTime(now);
                destValue.setUpdateTime(now);
                destValue.setConsultUserId(destConsultUser.getId());
                destValue.setStudentId(destConsultUser.getStudentId());
                destValue.setOrgId(orgId);
                destValue.setFieldId(fieldId);
                destValue.setFieldType(sourceValue.getFieldType());
                destValue.setValue(sourceValue.getValue());
                listAdd.add(destValue);
            }
            if (CollectionUtils.isNotEmpty(listAdd)) {
                this.customFieldValueDao.saveAll(listAdd, new String[0]);
            }
        }
    }

    private String mergeProperties(String source, String dest) {
        if (StringUtils.isNotBlank((CharSequence)source) && StringUtils.isNotBlank((CharSequence)dest)) {
            return dest;
        }
        if (StringUtils.isNotBlank((CharSequence)source) && StringUtils.isBlank((CharSequence)dest)) {
            return source;
        }
        if (StringUtils.isBlank((CharSequence)source) && StringUtils.isNotBlank((CharSequence)dest)) {
            return dest;
        }
        return "";
    }

    private Date mergeProperties(Date source, Date dest) {
        if (source != null && dest != null) {
            return source.getTime() > dest.getTime() ? source : dest;
        }
        if (dest != null) {
            return dest;
        }
        if (source != null) {
            return source;
        }
        return null;
    }

    void deleteSourceConsult(TxConsultUser sourceConsultUser) {
        sourceConsultUser.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        sourceConsultUser.setUpdateTime(new Date());
        this.delSysBacklog(sourceConsultUser.getOrgId(), sourceConsultUser);
        log.info("deleteSourceConsult.sourceConsultUser:{}", (Object)sourceConsultUser);
        this.consultUserDao.update((Object)sourceConsultUser, new String[]{"delStatus", "updateTime"});
    }

    private void paramValidator(MergeConsulterRequestDto param) {
        Preconditions.checkNotNull((Object)param.getSourceConsulter(), (Object)"source consulter id can not be null");
        Preconditions.checkNotNull((Object)param.getDestConsulter(), (Object)"destination consulter id can not be null");
    }

    @Override
    @Transactional(readOnly=true)
    public List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        List consulters = this.consultUserDao.searchHasMobileConsulter(pageDto, format, value);
        log.debug("consulters:{}", (Object)consulters);
        return consulters;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long regConsulter(Long orgId, String openId, String showName, Long studentId) {
        List orgStudents;
        List consulters = null;
        if (StringUtils.isNotBlank((CharSequence)openId) && !openId.equals("0")) {
            consulters = this.consultUserDao.lookByParams(orgId, openId, new String[0]);
        } else {
            openId = "";
        }
        OrgStudent student = null;
        if (studentId != null && studentId > 0L && ((student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0])) == null || student.getOrgId().longValue() != orgId.longValue())) {
            student = null;
        }
        if (student == null && (orgStudents = this.orgStudentDao.getStudentByOpenIdAndOrgId(orgId, openId, new String[0])) != null && orgStudents.size() > 0) {
            student = (OrgStudent)orgStudents.get(0);
            studentId = student.getId();
        }
        if (consulters != null && !consulters.isEmpty()) {
            TxConsultUser consulter = (TxConsultUser)consulters.get(0);
            if (student != null && !studentId.equals(consulter.getStudentId())) {
                consulter.setStudentId(studentId);
                consulter.setUpdateTime(new Date());
                consulter.setMobile(student.getMobile());
                consulter.setUserId(student.getUserId());
                this.consultUserDao.update((Object)consulter, new String[]{"studentId", "updateTime", "userId"});
            }
            return ((TxConsultUser)consulters.get(0)).getId();
        }
        return this.saveAndReturnId(orgId, openId, showName, student);
    }

    private Long saveAndReturnId(Long orgId, String openId, String showName, OrgStudent student) {
        Fans fans;
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setWeixinOpenId(openId);
        if (StringUtils.isNotBlank((CharSequence)openId) && !"0".equals(openId) && (fans = this.fansDao.getByOpenId(openId)) != null) {
            consultUser.setWeixinAppId(fans.getAuthorizerAppId());
        }
        consultUser.setName(showName);
        consultUser.setNickName(showName);
        consultUser.setOrgId(orgId);
        if (student != null) {
            consultUser.setStudentId(student.getId());
            consultUser.setUserId(student.getUserId());
            consultUser.setMobile(student.getMobile());
            consultUser.setNextRemindTime(student.getNextRemindTime());
            consultUser.setConsultSource(student.getSource());
        } else {
            consultUser.setConsultSource(Integer.valueOf(MessageSource.WECHAT.getValue()));
        }
        this.consultUserDao.save((Object)consultUser, new String[0]);
        if (consultUser.getNextRemindTime() != null) {
            this.addSysBacklog(orgId, consultUser.getId());
        }
        return consultUser.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void delConsulter(Long consulterId, Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((consulterId != null && consulterId > 0L ? 1 : 0) != 0, (Object)"consulterId is illegal");
        TxConsultUser consultUser = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
        log.info("delConsulter---------consulterId={},orgId={},consultUser={}", new Object[]{consulterId, orgId, consultUser});
        if (null == consultUser) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.delSysBacklog(orgId, consultUser);
        consultUser.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        consultUser.setUpdateTime(new Date());
        this.consultUserDao.update((Object)consultUser, new String[]{"delStatus", "updateTime"});
        this.updateSolr(consultUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSysBacklog(Long orgId, Long consulterId) {
        TxConsultUser consulter;
        if (null != consulterId && consulterId > 0L && null != (consulter = this.consultUserDao.getOrgConsultUser(orgId, consulterId)) && consulter.getNextRemindTime() != null) {
            log.info("addSysBacklog-------orgId={},consulter={}", (Object)orgId, (Object)consulter);
            List list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulter.getId(), orgId, Boolean.valueOf(false), new String[]{"id"});
            if (CollectionUtils.isEmpty((Collection)list)) {
                TxBacklog txBacklog = new TxBacklog();
                if (null != consulter.getStudentId() && consulter.getStudentId() > 0L) {
                    txBacklog.setStudentId(consulter.getStudentId());
                }
                txBacklog.setOrgId(orgId);
                txBacklog.setConsultUserId(consulter.getId());
                txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consulter.getName()) ? consulter.getName() : "\u5728\u7ebf\u7559\u5355\u5b66\u751f"));
                txBacklog.setIsSys(BizConf.TRUE.intValue());
                txBacklog.setCascadeId(Integer.valueOf(consulter.getCascadeId().intValue()));
                txBacklog.setEndTime(consulter.getNextRemindTime());
                txBacklog.setRemindTime(consulter.getNextRemindTime());
                txBacklog.setCreateTime(new Date());
                txBacklog.setUpdateTime(new Date());
                this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                log.info("addSysBacklog:save--------txBacklog={}", (Object)txBacklog);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSysBacklog(Long orgId, Long consulterId) {
        if (null != consulterId && consulterId > 0L) {
            TxConsultUser consulter = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
            log.info("updateSysBacklog------orgId={},consulter={}", (Object)orgId, (Object)consulter);
            if (null != consulter && (null == consulter.getStudentId() || consulter.getStudentId() <= 0L)) {
                List list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulter.getId(), orgId, Boolean.valueOf(false), new String[0]);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    TxBacklog txBacklog = (TxBacklog)list.get(0);
                    if (consulter.getNextRemindTime().getTime() != txBacklog.getEndTime().getTime()) {
                        txBacklog.setEndTime(consulter.getNextRemindTime());
                        txBacklog.setRemindTime(consulter.getNextRemindTime());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update((Object)txBacklog, new String[]{"endTime", "remindTime", "updateTime"});
                    }
                } else {
                    this.addSysBacklog(orgId, consulter.getId());
                }
            }
        }
    }

    private void delSysBacklog(Long orgId, TxConsultUser consultUser) {
        block4: {
            List list;
            block3: {
                log.info("delSysBacklog-------orgId={}, consultUser={}", (Object)orgId, (Object)consultUser);
                list = null;
                if (null == consultUser.getStudentId() || consultUser.getStudentId() <= 0L) break block3;
                list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(consultUser.getStudentId(), consultUser.getOrgId(), null, new String[0]);
                if (!CollectionUtils.isNotEmpty((Collection)list)) break block4;
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog || txBacklog.getConsultUserId().longValue() != consultUser.getId().longValue()) continue;
                    txBacklog.setConsultUserId(Long.valueOf(0L));
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
                break block4;
            }
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consultUser.getId(), consultUser.getOrgId(), null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog) continue;
                    txBacklog.setConsultUserId(Long.valueOf(0L));
                    txBacklog.setDelStatus(DeleteStatus.DELETED.getValue());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void assign(Long orgId, Long cascadeId, Long consulterId) {
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        log.info("consult-assign id= ={},txconsultuser={}", (Object)consulterId, (Object)txConsultUser);
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (!Flag.getBoolean((Integer)txConsultUser.getIsConsulter())) {
            throw new PermissionException("\u7ebf\u7d22\u5df2\u8f6c\u4e3a\u5b66\u5458\u6216\u5df2\u5931\u6548\uff0c\u7981\u6b62\u64cd\u4f5c\u3002");
        }
        if (!txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException("\u7ebf\u7d22\u673a\u6784 id\u4e0d\u5339\u914d");
        }
        if (txConsultUser.getCascadeId().intValue() > 0 && !txConsultUser.getCascadeId().equals(cascadeId)) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_PULL_BY_OTHER);
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        log.debug("txSaleClueRule={}", (Object)txSaleClueRule);
        if (txSaleClueRule.getClueAllot() == 2) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_ASSIGN_FAIL_BY_SETTING_CLUE_ALLOT);
        }
        Date now = new Date();
        txConsultUser.setFinallyHoldTime(DateUtil.getDiffDateTime((Date)now, (int)txSaleClueRule.getMaxClueDelay()));
        txConsultUser.setCascadeId(cascadeId);
        txConsultUser.setLastPullTime(now);
        txConsultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)txConsultUser, new String[0]);
        TxConsulterOperationLog txlog = new TxConsulterOperationLog(consulterId, cascadeId, cascadeId, ConsulterOperation.ASSIGN);
        this.txConsulterOperationLogDao.save((Object)txlog, new String[0]);
        this.txStudentCommentAPIService.saveByConsultUserAssign(txConsultUser, this.getAccountName(orgId, cascadeId));
        this.updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public TxConsultUser pull(Long orgId, Long cascadeId, Long consulterId, boolean checkRule) {
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        log.info("consult-pull id= ={},txconsultuser={}", (Object)consulterId, (Object)txConsultUser);
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (!Flag.getBoolean((Integer)txConsultUser.getIsConsulter())) {
            throw new PermissionException("\u7ebf\u7d22\u5df2\u8f6c\u4e3a\u5b66\u5458\u6216\u5df2\u5931\u6548\uff0c\u7981\u6b62\u64cd\u4f5c\u3002");
        }
        if (!txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException("\u7ebf\u7d22\u673a\u6784 id\u4e0d\u5339\u914d");
        }
        if (txConsultUser.getCascadeId().intValue() != Flag.NULL.getInt() && !txConsultUser.getCascadeId().equals(cascadeId)) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_PULL_BY_OTHER);
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        log.debug("txSaleClueRule={}", (Object)txSaleClueRule);
        if (checkRule) {
            Integer holdNum = this.consultUserDao.countConsulter(orgId, cascadeId);
            TXCascadeAccount loginer = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (cascadeId != null && cascadeId > 0L && CampusAccountType.getTypeByCode((int)loginer.getAccountType()) == CampusAccountType.STAFF && txSaleClueRule.getClueAllot() != 0) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_PUSH_FAIL_BY_SETTING_CLUE_ALLOT);
            }
            if (holdNum + 1 > txSaleClueRule.getMaxClueCount()) {
                String msg = "\u7ebf\u7d22\u6570\u5df2\u8fbe\u4e0a\u9650(\u6700\u591a%s\u6761), \u65e0\u6cd5\u9886\u53d6";
                msg = String.format(msg, txSaleClueRule.getMaxClueCount());
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_PULL_FAIL_BY_SETTING_MAX_CLUE_COUNT, msg);
            }
        }
        Date now = new Date();
        txConsultUser.setFinallyHoldTime(DateUtil.getDiffDateTime((Date)now, (int)txSaleClueRule.getMaxClueDelay()));
        txConsultUser.setCascadeId(cascadeId);
        txConsultUser.setLastPullTime(now);
        txConsultUser.setLastRemindTime(now);
        txConsultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)txConsultUser, new String[0]);
        TxConsulterOperationLog colog = new TxConsulterOperationLog(consulterId, cascadeId, cascadeId, ConsulterOperation.PULL);
        this.txConsulterOperationLogDao.save((Object)colog, new String[0]);
        this.txStudentCommentAPIService.saveByConsultUserPull(txConsultUser, this.getAccountName(orgId, cascadeId));
        this.updateSolr(txConsultUser);
        return txConsultUser;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void push(Long orgId, Long cascadeId, Long consulterId) {
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (txConsultUser.getIsConsulter().intValue() != Flag.TRUE.getInt() || !txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException();
        }
        if (txConsultUser.getCascadeId().intValue() == Flag.NULL.getInt()) {
            throw new PermissionException();
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        if (txSaleClueRule.getReturnClue().intValue() == Flag.TRUE.getInt()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_PUSH_FAIL_BY_SETTING_RETURN_CLUE);
        }
        Date now = new Date();
        txConsultUser.setCascadeId(Long.valueOf(Flag.NULL.getLong()));
        txConsultUser.setLastPushTime(now);
        txConsultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)txConsultUser, new String[0]);
        String content = NoticeType.getTips((String)txConsultUser.getName());
        this.consultMessageService.sendNotice(txConsultUser.getOrgId(), Integer.valueOf(-1), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)txConsultUser.getId()), (String)content));
        TxConsulterOperationLog log = new TxConsulterOperationLog(consulterId, cascadeId, Long.valueOf(Flag.NULL.getLong()), ConsulterOperation.PUSH_MANUAL);
        this.txConsulterOperationLogDao.save((Object)log, new String[0]);
        this.txStudentCommentAPIService.saveByConsultUserPush(txConsultUser, this.getAccountName(orgId, cascadeId));
        this.updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void passto(Long orgId, Long cascadeIdFrom, Long cascadeIdTo, Long consulterId) {
        TXCascadeAccount cascadeTo;
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (txConsultUser == null || txConsultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new PermissionException((UniverseErrorCode)CrmErrorCode.CONSULTER_IS_DELETED);
        }
        if (txConsultUser.getIsConsulter().intValue() != Flag.TRUE.getInt() || !txConsultUser.getOrgId().equals(orgId)) {
            throw new PermissionException();
        }
        if (cascadeIdTo.intValue() == 0 ? orgId.intValue() != txConsultUser.getOrgId().intValue() : (cascadeTo = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeIdTo, new String[0])) == null || !cascadeTo.getOrgId().equals(orgId.intValue())) {
            throw new PermissionException();
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        Date now = new Date();
        txConsultUser.setFinallyHoldTime(DateUtil.getDiffDateTime((Date)now, (int)txSaleClueRule.getMaxClueDelay()));
        txConsultUser.setCascadeId(cascadeIdTo);
        txConsultUser.setLastPullTime(now);
        txConsultUser.setLastRemindTime(now);
        txConsultUser.setUpdateTime(now);
        this.consultUserDao.update((Object)txConsultUser, new String[0]);
        TxConsulterOperationLog operationLog = new TxConsulterOperationLog(consulterId, cascadeIdFrom, cascadeIdTo, ConsulterOperation.PASSTO);
        this.txConsulterOperationLogDao.save((Object)operationLog, new String[0]);
        this.txStudentCommentAPIService.saveByConsultUserPassTo(txConsultUser, this.getAccountName(orgId, cascadeIdFrom), this.getAccountName(orgId, cascadeIdTo));
        log.info("[Notice] Pass to notice");
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("clue_id", txConsultUser.getId());
        this.consultMessageService.sendNotice(orgId, Integer.valueOf(txConsultUser.getCascadeId().intValue()), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.RECEIVE_CLUE, (String)ActionUtil.getAction((String)"action_to_crm_clue_detail", param)));
        this.updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long convertToStudent(Long orgId, Long cascadeId, Long consulterId, Integer confirm) {
        log.info("--------orgId:{}, cascadeId:{}, confirm:{}, consulterId:{}", new Object[]{orgId, cascadeId, consulterId, confirm});
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (txConsultUser.getStudentId() != null && txConsultUser.getStudentId() > 0L) {
            throw new PermissionException("\u8be5\u7ebf\u7d22\u5df2\u5bf9\u5e94\u6b63\u5f0f\u5b66\u5458\u8bb0\u5f55");
        }
        if (txConsultUser.getIsConsulter() < 0) {
            throw new PermissionException("\u6307\u5b9a\u5bf9\u8c61\u4e0d\u662f\u7ebf\u7d22");
        }
        if (StringUtils.isBlank((CharSequence)txConsultUser.getMobile())) {
            throw new ParameterException("\u7ebf\u7d22\u7684\u624b\u673a\u53f7\u4e3a\u7a7a,\u4e0d\u53ef\u8f6c\u6210\u5b66\u5458");
        }
        if (StringUtils.isBlank((CharSequence)txConsultUser.getName())) {
            throw new ParameterException("\u7ebf\u7d22\u7684\u540d\u79f0\u4e3a\u7a7a,\u4e0d\u53ef\u8f6c\u6210\u5b66\u5458");
        }
        Long studentId = null;
        OrgStudentAddresponseDto orgStudentAddresponseDto = this.saveStudent(txConsultUser, confirm, orgId, cascadeId);
        if (orgStudentAddresponseDto != null && orgStudentAddresponseDto.getStudentId() > 0L) {
            studentId = orgStudentAddresponseDto.getStudentId();
            OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
            if (student != null && student.getOrgId().longValue() == orgId.longValue() && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && student.getUserId() != null && student.getUserId() > 0L) {
                User user = (User)this.userDao.getById((Serializable)student.getUserId(), new String[0]);
                txConsultUser.setUserId(user.getId());
                txConsultUser.setUserNumber(user.getNumber());
            }
            txConsultUser.setStudentId(studentId);
            this.consultUserDao.update((Object)txConsultUser, new String[]{"studentId"});
            this.customFieldValueService.updateStudentId(orgId, txConsultUser.getId(), studentId);
            this.txBacklogDao.consultConvertToStu(consulterId, studentId);
        }
        this.updateSolr(txConsultUser);
        return studentId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void changeStatus(Long orgId, Long cascadeId, Long consulterId, Integer status, String reason) {
        Date now = new Date();
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (status.intValue() == Flag.FALSE.getInt()) {
            Long ownerCascadeId = cascadeId;
            TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
            if (txSaleClueRule.getClueTransValid() == 0) {
                txConsultUser = this.pull(orgId, ownerCascadeId, consulterId, true);
            } else {
                txConsultUser.setCascadeId(Long.valueOf(Flag.NULL.getLong()));
            }
            txConsultUser.setIsInvalid(status);
            txConsultUser.setReasonForInvalid("");
            txConsultUser.setUpdateTime(now);
            this.consultUserDao.update((Object)txConsultUser, new String[0]);
            String content = NoticeType.getTips((String)txConsultUser.getName());
            this.consultMessageService.sendNotice(orgId, Integer.valueOf(-1), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)txConsultUser.getId()), (String)content));
            this.txStudentCommentAPIService.saveByConsultUserChangeStatus(txConsultUser, this.getAccountName(orgId, cascadeId), reason);
        } else {
            if (StringUtils.isBlank((CharSequence)reason)) {
                throw new ParameterException("\u8bf7\u586b\u5199\u6807\u8bb0\u65e0\u6548\u539f\u56e0\u3002");
            }
            if (txConsultUser.getCascadeId().intValue() != Flag.NULL.getInt()) {
                TxConsulterOperationLog log = new TxConsulterOperationLog(consulterId, cascadeId, Long.valueOf(Flag.NULL.getLong()), ConsulterOperation.PUSH_AUTO);
                this.txConsulterOperationLogDao.save((Object)log, new String[0]);
            }
            txConsultUser.setIsInvalid(status);
            txConsultUser.setReasonForInvalid(reason);
            txConsultUser.setCascadeId(Long.valueOf(Flag.NULL.getLong()));
            txConsultUser.setLastPushTime(now);
            txConsultUser.setUpdateTime(now);
            txConsultUser.setLastInvalidTime(now);
            this.consultUserDao.update((Object)txConsultUser, new String[0]);
            this.txStudentCommentAPIService.saveByConsultUserChangeStatus(txConsultUser, this.getAccountName(orgId, cascadeId), reason);
        }
        this.updateSolr(txConsultUser);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void changeSource(Long orgId, Long cascadeId, Long consulterId, Integer source) {
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        txConsultUser.setConsultSource(source);
        txConsultUser.setUpdateTime(new Date());
        this.consultUserDao.update((Object)txConsultUser, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void changeConsultStatus(Long orgId, Long cascadeId, Long consulterId, Integer consultStatus) {
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        txConsultUser.setConsultStatus(consultStatus);
        txConsultUser.setUpdateTime(new Date());
        this.consultUserDao.update((Object)txConsultUser, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void changeNextRemindTime(Long orgId, Long cascadeId, Long consulterId, Long nextRemindTime) {
        boolean isValidate = DateUtil.validateTimestamp((Long)nextRemindTime);
        if (!isValidate) {
            throw new ParameterException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2038-1-1)\u4e86");
        }
        TxConsultUser txConsultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        txConsultUser.setUpdateTime(new Date());
        if (nextRemindTime != null && nextRemindTime > 0L) {
            txConsultUser.setNextRemindTime(new Date(nextRemindTime));
        } else {
            txConsultUser.setNextRemindTime(null);
        }
        this.consultUserDao.updateWithDefaultVal((Object)txConsultUser, new String[0]);
        this.orgStudentService.updateSysBacklogForConsulter(orgId, txConsultUser);
    }

    @Override
    public List<OutLineDto> getOutLine(Long orgId, Long cascadeId) {
        ArrayList<OutLineDto> list = new ArrayList<OutLineDto>();
        CampusAccountType accountType = null;
        if (cascadeId == 0L) {
            accountType = CampusAccountType.SLAVE_PRINCIPAL;
        } else {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            accountType = CampusAccountType.getTypeByCode((int)txCascadeAccount.getAccountType());
        }
        Collection<ConsulterOutLineType> typeList = this.getConsulterOutLineMap(cascadeId, accountType).values();
        if (!CollectionUtils.isEmpty(typeList)) {
            OutLineDto dto = null;
            Set<Integer> cascadeIds = null;
            ConsulterListQueryParam param = null;
            for (ConsulterOutLineType type : typeList) {
                if (type == ConsulterOutLineType.ALL) continue;
                dto = new OutLineDto();
                param = new ConsulterListQueryParam();
                param.setConsulterType(Integer.valueOf(type.getValue()));
                param.setOrgId(orgId);
                cascadeIds = this.listCascadeIdsByOutLineType(orgId, cascadeId, type, accountType);
                this.fillParamByOutLineType(type, param);
                int count = 0;
                try {
                    count = this.consultUserQuery.countConsulter(cascadeIds, param);
                }
                catch (Exception e) {
                    log.error("[GetOutLine] {}", (Throwable)e);
                    log.info("error to get the data with solr server and will replace with db ,requestParam is : {} ", (Object)(orgId + ":" + cascadeId));
                    count = this.consultUserDao.countOutLine(cascadeIds, orgId, param.getConsulterType(), param.getIsConsulter(), param.getIsInvalid());
                }
                dto.setName(type.getLabel());
                dto.setType(type.getValue());
                dto.setCount(count);
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    public List<ConsulterListDto> listConsulter(Long orgId, Long cascadeId, ConsulterListQueryParam param, PageDto pageDto) {
        if (param.getFromMerge() != null && param.getFromMerge().intValue() == Flag.TRUE.getInt()) {
            List<OutLineDto> outLine = this.getOutLine(orgId, cascadeId);
            param.setConsulterType(Integer.valueOf(ConsulterOutLineType.MINE.getValue()));
            for (OutLineDto dto : outLine) {
                if (dto.getType().intValue() != ConsulterOutLineType.SUBORDINATE.getValue()) continue;
                param.setConsulterType(Integer.valueOf(ConsulterOutLineType.SUBORDINATE.getValue()));
            }
        }
        CampusAccountType accountType = null;
        if (cascadeId == 0L) {
            accountType = CampusAccountType.SLAVE_PRINCIPAL;
        } else {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            accountType = CampusAccountType.getTypeByCode((int)txCascadeAccount.getAccountType());
        }
        Collection<ConsulterOutLineType> typeList = this.getConsulterOutLineMap(cascadeId, accountType).values();
        ConsulterOutLineType outLineType = ConsulterOutLineType.getEnum(param.getConsulterType());
        if (param.getConsulterType().intValue() != ConsulterOutLineType.ALL.getValue() && !typeList.contains((Object)ConsulterOutLineType.getEnum(param.getConsulterType()))) {
            log.info(" has no permission for resource with accountType: {} , orgId {} , cascadeId : {} ", new Object[]{accountType, orgId, cascadeId});
            return Collections.emptyList();
        }
        Set<Integer> cascadeIds = null;
        Set<Integer> cascadeIdsByOutLine = this.listCascadeIdsByOutLineType(orgId, cascadeId, outLineType, accountType);
        if (StringUtils.isNotBlank((CharSequence)param.getCascadeIds())) {
            String[] cascadeIdArray = param.getCascadeIds().split(",");
            cascadeIds = new HashSet<Integer>();
            Integer cid = null;
            for (String cascadeIdStr : cascadeIdArray) {
                cid = Integer.parseInt(cascadeIdStr);
                if (!cascadeIdsByOutLine.contains(cid)) {
                    throw new ParameterException("\u60a8\u6307\u5b9a\u7684\u8d26\u53f7\u4e0d\u5728\u53ef\u67e5\u8be2\u8303\u56f4\u5185\u3002");
                }
                cascadeIds.add(cid);
            }
        } else {
            cascadeIds = cascadeIdsByOutLine;
        }
        this.fillParamByOutLineType(outLineType, param);
        param.setOrgId(orgId);
        if (StringUtils.isNotBlank((CharSequence)param.getKeyFieldName()) && param.getKeyFieldName().startsWith("customField")) {
            String idStr = param.getKeyFieldName().replace("customField", "");
            Long fieldId = Long.parseLong(idStr);
            CustomField field = this.customFieldDao.getCustomFieldById(orgId, fieldId);
            String queryValue = "";
            if (field != null) {
                List customOptionList;
                if (field.getType() == 1) {
                    if (StringUtils.isNotBlank((CharSequence)param.getKeyword())) {
                        queryValue = idStr + "#*" + param.getKeyword() + "*";
                    }
                } else if (field.getType() == 4) {
                    queryValue = idStr + "#" + param.getKeyword() + "*";
                } else if ((field.getType() == 2 || field.getType() == 3) && (customOptionList = this.txCustomOptionDao.getTXCustomOptionList(fieldId)) != null && customOptionList.size() > 0) {
                    Long optionId = null;
                    for (TXCustomOption customOption : customOptionList) {
                        if (!StringUtils.equals((CharSequence)customOption.getLabel(), (CharSequence)param.getKeyword())) continue;
                        optionId = customOption.getId();
                        break;
                    }
                    if (optionId != null && optionId > 0L) {
                        queryValue = idStr + "#" + optionId;
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)queryValue)) {
                param.setKeyFieldName("customSearchValue");
                param.setKeyword(queryValue);
            } else {
                return Lists.newArrayList();
            }
        }
        log.info("call queryConsulter cascadeIds:{}, param:{}, pageDto:{}", new Object[]{cascadeIds, param, pageDto});
        List<ConsulterListDto> list = null;
        if (param.needFilter()) {
            log.info("query with solr");
            list = this.consultUserQuery.queryConsulter(cascadeIds, param, pageDto);
        } else {
            log.info("query with db");
            List txConsultUsers = this.consultUserDao.queryConsulters(cascadeIds, param.getOrgId(), param.getConsulterType(), param.getIsConsulter(), param.getIsInvalid(), pageDto);
            list = this.buildConsultUserDto(txConsultUsers, param.getConsulterType());
        }
        boolean isShowMobile = true;
        if (outLineType == ConsulterOutLineType.PUBLISH && cascadeId > 0L) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            if (CampusAccountType.STAFF.getCode().intValue() == txCascadeAccount.getAccountType().intValue()) {
                isShowMobile = false;
            }
        }
        if (isShowMobile) {
            isShowMobile = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        }
        ArrayList ids = new ArrayList();
        ArrayList<TxConsultUser> consultUsers = new ArrayList<TxConsultUser>();
        for (ConsulterListDto dto : list) {
            if (param.getConsulterType().intValue() != ConsulterOutLineType.ALL.getValue()) {
                dto.setConsulterType(param.getConsulterType());
            } else if (dto.getIsInvalid().intValue() == Flag.TRUE.getInt()) {
                dto.setConsulterType(Integer.valueOf(ConsulterOutLineType.INVALID.getValue()));
            } else if (dto.getCascadeId().intValue() == Flag.NULL.getInt()) {
                dto.setConsulterType(Integer.valueOf(ConsulterOutLineType.PUBLISH.getValue()));
            } else if ((long)dto.getCascadeId().intValue() == cascadeId) {
                dto.setConsulterType(Integer.valueOf(ConsulterOutLineType.MINE.getValue()));
            } else {
                dto.setConsulterType(Integer.valueOf(ConsulterOutLineType.SUBORDINATE.getValue()));
            }
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            }
            TxConsultUser consultUser = new TxConsultUser();
            consultUser.setId(dto.getId());
            consultUser.setPortrait(dto.getPortrait());
            consultUser.setStudentId(dto.getStudentId());
            consultUser.setWeixinOpenId(dto.getWenxinOpenId());
            consultUsers.add(consultUser);
        }
        if (CollectionUtils.isNotEmpty(consultUsers)) {
            this.consulterAPIService.batchSetConsultAvatarUrl(consultUsers);
            Map consultUserMap = CollectionHelper.toIdMap(consultUsers);
            for (ConsulterListDto dto : list) {
                if (consultUserMap.get(dto.getId()) == null) continue;
                dto.setPortrait(((TxConsultUser)consultUserMap.get(dto.getId())).getPortrait());
            }
        }
        if (GenericsUtils.isNullOrEmpty(list)) {
            return Collections.emptyList();
        }
        return list;
    }

    private List<ConsulterListDto> buildConsultUserDto(List<TxConsultUser> txConsultUsers, Integer consulterType) {
        if (GenericsUtils.isNullOrEmpty(txConsultUsers)) {
            return GenericsUtils.emptyList();
        }
        ArrayList dtos = Lists.newArrayList();
        Date now = new Date();
        for (TxConsultUser txConsulter : txConsultUsers) {
            ConsulterListDto dto = new ConsulterListDto();
            dto.setName(txConsulter.getName());
            dto.setMobile(txConsulter.getMobile());
            dto.setPortrait(txConsulter.getPortrait());
            dto.setId(txConsulter.getId());
            dto.setStudentId(txConsulter.getStudentId());
            dto.setWenxinOpenId(txConsulter.getWeixinOpenId());
            Date finallyHoldTime = txConsulter.getFinallyHoldTime();
            Integer lessDayNum = 0;
            if (finallyHoldTime != null && finallyHoldTime.after(now) && (lessDayNum = DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).equals(DateUtil.getStartOfDayAccurateToMillSeconde((Date)now)) ? Integer.valueOf(1) : Integer.valueOf((int)((DateUtil.getStartOfDayAccurateToMillSeconde((Date)finallyHoldTime).getTime() - DateUtil.getStartOfDayAccurateToMillSeconde((Date)now).getTime()) / ONE_DAY_TIME))) == 0) {
                lessDayNum = 1;
            }
            log.info("lessDayNum is : {} for finallyHoldTime : {} ", (Object)lessDayNum, (Object)finallyHoldTime);
            dto.setTimeRemaining(lessDayNum);
            String inital = txConsulter.getPinyin();
            if (GenericsUtils.notNullAndEmpty((Object)inital)) {
                if ((inital = inital.substring(0, 1).toUpperCase()).equals("~")) {
                    inital = "#";
                }
            } else {
                inital = "#";
            }
            dto.setInitial(inital);
            dto.setIsInvalid(txConsulter.getIsInvalid());
            dto.setCascadeId(txConsulter.getCascadeId() == null ? null : Integer.valueOf(txConsulter.getCascadeId().intValue()));
            dto.setConsulterType(consulterType);
            dto.setBirthday(txConsulter.getBirthday());
            dto.setConsultSource(txConsulter.getConsultSource());
            dto.setConsultStatus(txConsulter.getConsultStatus());
            dto.setDegreeClass(txConsulter.getDegreeClass());
            dto.setIntensionLevel(txConsulter.getIntensionLevel());
            dto.setMail(txConsulter.getMail());
            dto.setQq(txConsulter.getQq());
            dto.setAddress(txConsulter.getAddress());
            dto.setRelatives(txConsulter.getRelatives());
            dto.setSchool(txConsulter.getSchool());
            dto.setSex(txConsulter.getSex());
            dto.setParentName(txConsulter.getParentName());
            dto.setParentMobile(txConsulter.getParentMobile());
            dto.setNextRemindTime(txConsulter.getNextRemindTime());
            dtos.add(dto);
        }
        return dtos;
    }

    public Set<Integer> listCascadeIdsByOutLineType(Long orgId, Long cascadeId, ConsulterOutLineType type, CampusAccountType accountType) {
        HashSet<Integer> cascadeIds = new HashSet<Integer>();
        boolean publish = false;
        boolean director = false;
        boolean staff = false;
        boolean self = false;
        boolean principal = false;
        switch (type) {
            case ALL: {
                publish = true;
                self = true;
                if (CampusAccountType.SLAVE_PRINCIPAL == accountType || CampusAccountType.MASTER_PRINCIPAL == accountType) {
                    director = true;
                    staff = true;
                    break;
                }
                if (CampusAccountType.DIRECTOR != accountType) break;
                principal = true;
                director = true;
                staff = true;
                break;
            }
            case MINE: {
                self = true;
                break;
            }
            case PUBLISH: {
                publish = true;
                break;
            }
            case NOT_FOLLOW_UP: {
                self = true;
                break;
            }
            case SUBORDINATE: {
                principal = true;
                director = true;
                staff = true;
                break;
            }
            case INVALID: {
                publish = true;
                break;
            }
        }
        if (publish) {
            cascadeIds.add(Flag.NULL.getInt());
        }
        if (director) {
            cascadeIds.addAll(this.txCascadeAccountDao.listIdByAccountType(Integer.valueOf(orgId.intValue()), CampusAccountType.DIRECTOR.getCode()));
        }
        if (staff) {
            cascadeIds.addAll(this.txCascadeAccountDao.listIdByAccountType(Integer.valueOf(orgId.intValue()), CampusAccountType.STAFF.getCode()));
        }
        if (self) {
            cascadeIds.add(cascadeId.intValue());
        }
        if (principal) {
            cascadeIds.add(0);
        }
        return cascadeIds;
    }

    public void fillParamByOutLineType(ConsulterOutLineType type, ConsulterListQueryParam param) {
        switch (type) {
            case MINE: {
                break;
            }
            case PUBLISH: {
                break;
            }
            case NOT_FOLLOW_UP: {
                param.setUnRemindDayNum(Integer.valueOf(ConsulterOutLineType.getDayNumForNotFollowUp()));
                break;
            }
            case SUBORDINATE: {
                break;
            }
            case INVALID: {
                param.setIsInvalid(Integer.valueOf(Flag.TRUE.getInt()));
                break;
            }
        }
    }

    public Map<Integer, ConsulterOutLineType> getConsulterOutLineMap(Long cascadeId, CampusAccountType accountType) {
        HashMap<Integer, ConsulterOutLineType> typeMap = new HashMap<Integer, ConsulterOutLineType>();
        HashSet<ConsulterOutLineType> typeList = new HashSet<ConsulterOutLineType>();
        if (CampusAccountType.SLAVE_PRINCIPAL == accountType || CampusAccountType.MASTER_PRINCIPAL == accountType) {
            typeList.add(ConsulterOutLineType.MINE);
            typeList.add(ConsulterOutLineType.PUBLISH);
            typeList.add(ConsulterOutLineType.SUBORDINATE);
            typeList.add(ConsulterOutLineType.INVALID);
        } else if (CampusAccountType.DIRECTOR == accountType) {
            typeList.add(ConsulterOutLineType.MINE);
            typeList.add(ConsulterOutLineType.PUBLISH);
            typeList.add(ConsulterOutLineType.INVALID);
            if (this.txAccountPermissionService.hasPermission(cascadeId, ApplicationType.APP, TXPermissionConst.SEE_ALL_CLUES)) {
                typeList.add(ConsulterOutLineType.SUBORDINATE);
            }
        } else if (CampusAccountType.STAFF == accountType) {
            typeList.add(ConsulterOutLineType.MINE);
            typeList.add(ConsulterOutLineType.PUBLISH);
            typeList.add(ConsulterOutLineType.INVALID);
        }
        for (ConsulterOutLineType type : typeList) {
            typeMap.put(type.getValue(), type);
        }
        return typeMap;
    }

    public void addSysConsulterCom1ment(Long orgId, Long consulterId, String content) {
        TxStudentComment po = new TxStudentComment();
        po.setOrgId(orgId);
        po.setConsultUserId(consulterId);
        po.setIsSystem(Integer.valueOf(Flag.TRUE.getInt()));
        po.setContent(content);
        this.txStudentCommentDao.save((Object)po, new String[0]);
    }

    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "\u672a\u77e5";
        if (cascadeId > 0L) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
            TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)txCascadeAccount.getCredentialId(), new String[0]);
            shortName = credential.getName();
        } else {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    @Override
    public List<ConsultCallRecordDto> listConsultCallRecord(Long orgId, Long cascadeId, Long studentId, Long consulterId) {
        ArrayList<ConsultCallRecordDto> dtoList = new ArrayList<ConsultCallRecordDto>();
        List list = this.consultCallRecordDao.listBy(orgId, studentId, consulterId);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ConsultCallRecordDto dto = null;
            for (ConsultCallRecord record : list) {
                dto = new ConsultCallRecordDto();
                dto.setCallStatus(record.getCallStatus());
                dto.setCreateTime(record.getCreateTime().getTime());
                dto.setId(record.getId());
                dto.setSeconds(record.getDuringTime());
                if (record.getIsCallByOrg().intValue() == Flag.TRUE.getInt()) {
                    dto.setCallManner(ConsultCallRecordManner.CALL.getCode());
                } else {
                    dto.setCallManner(ConsultCallRecordManner.ANSWER.getCode());
                }
                if (record.getStorageId() != null && record.getStorageId() > 0L) {
                    dto.setSoundId(record.getStorageId());
                    OrgStorage orgStorage = (OrgStorage)this.orgStorageDao.getById((Serializable)record.getStorageId(), new String[0]);
                    dto.setSoundUrl(StorageUtil.constructUrl((OrgStorage)orgStorage));
                }
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    public TxConsultUser getConsultUserByStudetnId(Long orgId, Long studentId) {
        List userList = this.consultUserDao.lookByStudentId(orgId, studentId, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            TxConsultUser user = (TxConsultUser)userList.get(0);
            boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
            if (!isShow) {
                user.setMobile(MaskUtil.maskMobile((String)user.getMobile()));
                user.setParentMobile(MaskUtil.maskMobile((String)user.getParentMobile()));
            }
            return user;
        }
        return null;
    }

    @Override
    public TxConsultUser getConsultUser(Long consulterId) {
        return (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public boolean changeLastBrowseTime(Long consulterId, Date time) {
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (consultUser == null) {
            return false;
        }
        if (time == null) {
            time = new Date();
        }
        consultUser.setLastBrowseTime(time);
        consultUser.setUpdateTime(time);
        this.consultUserDao.update((Object)consultUser, new String[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public int release() {
        int userList222;
        int rows = 0;
        Date now = new Date();
        List consulterIds = null;
        String lock = "consulter.release.lock";
        RedisConnection connection = this.redisTemplate.getConnectionFactory().getConnection();
        try {
            connection.select(WechatProperties.getRedisDB().intValue());
            if (connection.setNX(lock.getBytes(), (now.getTime() + "").getBytes()).booleanValue()) {
                connection.expire(lock.getBytes(), 240L);
                consulterIds = this.consultUserDao.listConsulterUserIdsNeedToRelease(now);
                log.info("consulter - Release - consulterIds:{}, size:{},time:{}", new Object[]{consulterIds, consulterIds.size(), now.getTime()});
                if (CollectionUtils.isNotEmpty((Collection)consulterIds)) {
                    rows = this.consultUserDao.release(consulterIds, now);
                    List userList222 = this.consultUserDao.getByIds((Collection)consulterIds, new String[]{"id", "orgId", "name"});
                    for (TxConsultUser consultUser : userList222) {
                        String content = NoticeType.getTips((String)consultUser.getName());
                        this.consultMessageService.sendNotice(consultUser.getOrgId(), Integer.valueOf(-1), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.PUBLIC_CLUE, (String)ActionUtil.getClueDetailAction((Number)consultUser.getId()), (String)content));
                    }
                    this.txStudentCommentAPIService.batchSaveByRelease(consulterIds);
                    ArrayList<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
                    for (int i = 0; i > consulterIds.size(); ++i) {
                        TxConsulterOperationLog log = new TxConsulterOperationLog((Long)consulterIds.get(i), Long.valueOf(Flag.NULL.getLong()), Long.valueOf(Flag.NULL.getLong()), ConsulterOperation.PUSH_MANUAL);
                        manualLogs.add(log);
                        if (i % 100 != 0 && i != consulterIds.size() - 1) continue;
                        this.txConsulterOperationLogDao.saveAll(manualLogs, false, new String[0]);
                    }
                }
            }
            userList222 = rows;
        }
        catch (Exception e) {
            try {
                log.error("consulter - Release - consulterIds:{},time:{}", consulterIds, (Object)now.getTime());
                log.error("consulter - Release - Exception - e", (Throwable)e);
            }
            catch (Throwable throwable) {
                connection.del((byte[][])new byte[][]{lock.getBytes()});
                RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
                throw throwable;
            }
            connection.del((byte[][])new byte[][]{lock.getBytes()});
            RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
            return 0;
        }
        connection.del((byte[][])new byte[][]{lock.getBytes()});
        RedisConnectionUtils.releaseConnection((RedisConnection)connection, (RedisConnectionFactory)this.redisTemplate.getConnectionFactory());
        return userList222;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public int syncStudentId(PageDto pageDto) {
        List users = this.consultUserDao.getUsersByPage(pageDto);
        if (users != null) {
            for (TxConsultUser user : users) {
                OrgStudent student = this.orgStudentDao.getStudentByMobileAndOrgId(user.getOrgId(), user.getMobile(), new String[0]);
                if (student == null) continue;
                user.setStudentId(student.getId());
                this.consultUserDao.update((Object)user, Boolean.valueOf(false), new String[0]);
            }
            return users.size();
        }
        return 0;
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public TxConsultUser testTransaction(Integer vaule, Integer throwsException) {
        if (vaule == null) {
            return null;
        }
        TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)Integer.valueOf(1), new String[0]);
        if (vaule.equals(1)) {
            user.setName("name1");
            this.consultUserDao.update((Object)user, new String[0]);
        } else if (vaule.equals(2)) {
            user.setName("name2");
            this.consultUserDao.update((Object)user, new String[0]);
        } else if (vaule.equals(3)) {
            user.setName("name3");
            this.consultUserDao.update((Object)user, new String[0]);
            throw new RuntimeException();
        }
        if (throwsException != null && throwsException.equals(1)) {
            throw new RuntimeException();
        }
        return user;
    }

    @Override
    public ConsultUserResponse getConsultUserInfo(Long consultId, Long cascadeId, Long orgId, Integer showComments) {
        ConsulterResponseDto consultDto = null;
        ConsultUserInfo consultInfo = new ConsultUserInfo();
        consultInfo.setIsStudent(false);
        consultInfo.setConsulterId(consultId);
        if (consultId > 0L) {
            try {
                consultDto = this.getConsultUser(orgId, cascadeId, consultId, showComments);
                consultInfo = this.buildConsultUserInfo(consultDto);
            }
            catch (NonConsultUserException e) {
                log.error("[Consulter] NonConsultUserException param:{}", (Throwable)e);
            }
        }
        this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)consultInfo, orgId, false, consultId);
        Collections.sort(consultInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        if (consultId > 0L) {
            consultInfo.getFields().addAll(this.getFourConsultFieldValueResponses(orgId, consultInfo, consultInfo.getCascadeId()));
        } else {
            consultInfo.getFields().addAll(this.getFourConsultFieldValueResponses(orgId, consultInfo, cascadeId));
        }
        ConsultUserResponse reponse = this.buildConsultUserResponse(consultInfo);
        return reponse;
    }

    private ConsultUserResponse buildConsultUserResponse(ConsultUserInfo consultUserInfo) {
        ConsultUserResponse response = new ConsultUserResponse();
        BeanUtils.copyProperties((Object)((Object)consultUserInfo), (Object)response);
        return response;
    }

    private ConsultUserInfo buildConsultUserInfo(ConsulterResponseDto consultDto) {
        ConsultUserInfo consultUserInfo = new ConsultUserInfo();
        BeanUtils.copyProperties((Object)consultDto, (Object)((Object)consultUserInfo));
        consultUserInfo.setTagsResp(consultDto.getTags());
        consultUserInfo.setName(consultDto.getStudentName());
        consultUserInfo.setAvatarUrl(consultDto.getPortrait());
        consultUserInfo.setRelationship(consultDto.getRelatives());
        consultUserInfo.setAllowToPull(consultDto.getAllowToPull());
        consultUserInfo.setAllowToSms(consultDto.getAllowToSms());
        if (null != consultDto.getAreaId() && consultDto.getAreaId() > 0L) {
            Map areaMap = AreaUtils.getAreaNameByCode((Long)consultDto.getAreaId());
            consultUserInfo.setProvince((String)areaMap.get("province"));
            consultUserInfo.setCity((String)areaMap.get("city"));
            consultUserInfo.setCounty((String)areaMap.get("county"));
        }
        return consultUserInfo;
    }

    @Override
    @Transactional
    public Long saveConsultUserInfoAndCustomFieldValues(ConsultUserInfo consultUserInfo, Long orgId, Boolean keepConsultSource) {
        consultUserInfo.setIsStudent(false);
        log.info("consultId param:{}", (Object)consultUserInfo.getConsulterId());
        List fieldValueIds = this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)consultUserInfo, consultUserInfo.getConsulterId(), orgId);
        this.setFourConsultFieldValue(consultUserInfo.getFields(), consultUserInfo);
        ConsulterRequestDto consulter = this.buildConsulterRequestDto(consultUserInfo);
        Long consultId = null;
        this.preConsulterValid(consulter);
        consultId = keepConsultSource != false ? this.saveConsultUser(orgId, consulter, true) : this.saveConsultUser(orgId, consulter, false);
        if (GenericsUtils.notNullAndEmpty((Object)fieldValueIds)) {
            List customFieldValues = this.customFieldValueDao.getByIds((Collection)fieldValueIds, new String[0]);
            for (CustomFieldValue fieldValue : customFieldValues) {
                fieldValue.setConsultUserId(consultId);
                this.customFieldValueDao.update((Object)fieldValue, new String[]{"consultUserId"});
            }
        }
        List allCustomFieldValues = this.customFieldValueDao.searchValuesByConfig(orgId, false, consultId, null);
        String customSearchValue = this.studentUserService.buildCustomSearchValue(allCustomFieldValues, false, false, null, null, null);
        TxConsultUser user = new TxConsultUser();
        user.setId(consultId);
        if (StringUtils.isBlank((CharSequence)customSearchValue)) {
            customSearchValue = null;
        }
        user.setCustomSearchValue(customSearchValue);
        this.txConsultUserDao.update((Object)user, Boolean.valueOf(true), new String[]{"customSearchValue"});
        return consultId;
    }

    private void setFourConsultFieldValue(List<CustomFieldDto> fields, ConsultUserInfo consultUserInfo) {
        for (CustomFieldDto dto : fields) {
            CustomFieldValueRequest request = (CustomFieldValueRequest)dto;
            ConsultFieldEnum consultFieldEnum = ConsultFieldEnum.getConsultFieldEnum((String)request.getKey());
            if (consultFieldEnum == null) continue;
            this.setFourConsultFieldValueByKey(consultFieldEnum, request.getValues(), consultUserInfo);
        }
    }

    private void setFourConsultFieldValueByKey(ConsultFieldEnum consultFieldEnum, Map<String, Object> values, ConsultUserInfo consultUserInfo) {
        log.info("[CustomField] Map<String, Object> values param:{}", values);
        switch (consultFieldEnum) {
            case CONSULT_STATUS: {
                if (values == null || values.get("id") == null) break;
                consultUserInfo.setConsultStatus((Integer)values.get("id"));
                break;
            }
            case CONSULT_SOURCE: {
                if (values == null || values.get("id") == null) break;
                consultUserInfo.setConsultSource((Integer)values.get("id"));
                break;
            }
            case INTENSION_LEVEL: {
                if (values == null || values.get("id") == null) break;
                consultUserInfo.setIntensionLevel((Integer)values.get("id"));
                break;
            }
            case CASCADE_ID: {
                if (values == null || values.get("id") == null) break;
                consultUserInfo.setCascadeId(Long.parseLong(values.get("id").toString()));
                break;
            }
            default: {
                return;
            }
        }
    }

    private ConsulterRequestDto buildConsulterRequestDto(ConsultUserInfo consultUserInfo) {
        ConsulterRequestDto dto = new ConsulterRequestDto();
        BeanUtils.copyProperties((Object)((Object)consultUserInfo), (Object)dto);
        if (GenericsUtils.notNullAndEmpty((Object)consultUserInfo.getTagsResp())) {
            Gson gson = new Gson();
            String tagsStr = gson.toJson((Object)consultUserInfo.getTagsResp());
            dto.setTags(tagsStr);
        }
        if (consultUserInfo.getLatitude() != null) {
            dto.setLatitude(consultUserInfo.getLatitude().toString());
        }
        if (consultUserInfo.getLongitude() != null) {
            dto.setLongitude(consultUserInfo.getLongitude().toString());
        }
        dto.setStudentName(consultUserInfo.getName());
        dto.setPortrait(consultUserInfo.getAvatarUrl());
        dto.setRelatives(consultUserInfo.getRelationship());
        return dto;
    }

    private List<CustomFieldValueResponse> getFourConsultFieldValueResponses(Long orgId, ConsultUserInfo consultUserInfo, Long cascadeId) {
        ArrayList<CustomFieldValueResponse> reponseList = new ArrayList<CustomFieldValueResponse>();
        CustomFieldValueResponse consultStatusReponse = this.getCustomFieldValueResponse(ConsultFieldEnum.CONSULT_STATUS, orgId, consultUserInfo, cascadeId);
        CustomFieldValueResponse consultSourceReponse = this.getCustomFieldValueResponse(ConsultFieldEnum.CONSULT_SOURCE, orgId, consultUserInfo, cascadeId);
        CustomFieldValueResponse intensionLevelReponse = this.getCustomFieldValueResponse(ConsultFieldEnum.INTENSION_LEVEL, orgId, consultUserInfo, cascadeId);
        CustomFieldValueResponse cascadeReponse = this.getCustomFieldValueResponse(ConsultFieldEnum.CASCADE_ID, orgId, consultUserInfo, cascadeId);
        reponseList.add(consultStatusReponse);
        reponseList.add(consultSourceReponse);
        reponseList.add(intensionLevelReponse);
        reponseList.add(cascadeReponse);
        return reponseList;
    }

    private CustomFieldValueResponse getCustomFieldValueResponse(ConsultFieldEnum consultFieldEnum, Long orgId, ConsultUserInfo consultUserInfo, Long cascadeId) {
        ArrayList<FieldOption> optionList = new ArrayList<FieldOption>();
        CustomFieldValueResponse reponse = null;
        switch (consultFieldEnum) {
            case CONSULT_STATUS: {
                ConsultUserStatus[] enums;
                Integer consultStatus = consultUserInfo.getConsultStatus();
                ConsultUserStatus status = ConsultUserStatus.getConsultUserStatus((Integer)consultStatus);
                SingleChoiceFieldType consultStatusSingle = new SingleChoiceFieldType(Integer.valueOf(status.getValue()), status.getLabel());
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(), consultFieldEnum.getSectionId(), (Object)consultStatusSingle, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
                for (ConsultUserStatus consultStatusEnum : enums = ConsultUserStatus.values()) {
                    if (consultStatusEnum.equals((Object)ConsultUserStatus.WUXIAO)) continue;
                    optionList.add(new FieldOption(Long.valueOf(consultStatusEnum.getValue()), consultStatusEnum.getLabel()));
                }
                reponse.setOptions(optionList);
                break;
            }
            case CONSULT_SOURCE: {
                Long sectionSourceId = Long.parseLong(consultUserInfo.getConsultSource() + "");
                FieldOption sectionOption = new FieldOption(sectionSourceId, this.consultCustomSourceService.getConsultSourceStr(sectionSourceId));
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(), consultFieldEnum.getSectionId(), (Object)sectionOption, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
                List<ConsultCustomSourceDto> consultCustomSourceDtos = this.consultCustomSourceService.selection(orgId, null, PauseStatus.NOT_PAUSE.getStatus());
                if (consultCustomSourceDtos != null && consultCustomSourceDtos.size() > 0) {
                    for (ConsultCustomSourceDto consultCustomSourceDto : consultCustomSourceDtos) {
                        FieldOption option = new FieldOption(consultCustomSourceDto.getId(), consultCustomSourceDto.getLabel());
                        optionList.add(option);
                    }
                }
                reponse.setOptions(optionList);
                break;
            }
            case INTENSION_LEVEL: {
                IntentionLevel[] intentionEnums;
                IntentionLevel intentionEnum = IntentionLevel.getIntentionLevel((Integer)consultUserInfo.getIntensionLevel());
                SingleChoiceFieldType intentionSingle = new SingleChoiceFieldType(Integer.valueOf(intentionEnum.getValue()), intentionEnum.getLabel());
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(), consultFieldEnum.getSectionId(), (Object)intentionSingle, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
                for (IntentionLevel intensionEnum : intentionEnums = IntentionLevel.values()) {
                    optionList.add(new FieldOption(Long.valueOf(intensionEnum.getValue()), intensionEnum.getLabel()));
                }
                reponse.setOptions(optionList);
                break;
            }
            case CASCADE_ID: {
                String accountName = this.getAccountName(orgId, cascadeId);
                SingleChoiceFieldType cascadeSingle = new SingleChoiceFieldType();
                cascadeSingle = cascadeId != null && cascadeId != -1L ? (consultUserInfo.getConsulterId() == -1L ? new SingleChoiceFieldType(Integer.valueOf(cascadeId.intValue()), "\u81ea\u5df1") : new SingleChoiceFieldType(Integer.valueOf(cascadeId.intValue()), accountName)) : new SingleChoiceFieldType(Integer.valueOf(-1), "\u516c\u6d77");
                reponse = new CustomFieldValueResponse(consultFieldEnum.getKey(), consultFieldEnum.getLabel(), consultFieldEnum.getSectionId(), (Object)cascadeSingle, Integer.valueOf(RequireStatus.NOT_REQUIRE.getStatus()), CustomFieldType.SINGLE_CHOICE.getType());
                cascadeId = cascadeId == null ? 0L : cascadeId;
                log.info("consultUserInfo.getConsulterId() param:{}", (Object)consultUserInfo.getConsulterId());
                if (consultUserInfo.getConsulterId() == -1L) {
                    optionList.add(new FieldOption(Long.valueOf(-1L), "\u516c\u6d77"));
                    optionList.add(new FieldOption(cascadeId, "\u81ea\u5df1"));
                }
                reponse.setOptions(optionList);
                break;
            }
            default: {
                return reponse;
            }
        }
        return reponse;
    }

    private void preConsulterValid(ConsulterRequestDto consulter) {
        if (StringUtils.isBlank((CharSequence)consulter.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751f\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)consulter.getMobile()) && StringUtils.isBlank((CharSequence)consulter.getWeixinOpenId())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751f\u624b\u673a\u53f7\u548c\u5fae\u4fe1OPENID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulter.getMobile()}) && !consulter.getMobile().contains("****") && !ParamValidateUtils.validateMobile((String)consulter.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e:" + consulter.getMobile());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulter.getParentMobile()}) && !consulter.getParentMobile().contains("****") && !ParamValidateUtils.validateMobile((String)consulter.getParentMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5bb6\u957f\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e:" + consulter.getParentMobile());
        }
    }

    void updateSolr(TxConsultUser txConsultUser) {
        try {
            txConsultUser.toSolrMap();
            log.info("solr - consult user - update - end - txConsultUser:{}", (Object)txConsultUser);
        }
        catch (Exception e) {
            log.error("solr - consult user - update - exception", (Throwable)e);
        }
    }
}

